<?php
function TRD_init() {
	affReq("SELECT id, nom FROM shop_ml_site_categories","CAT","auto");
	affReq("SELECT id, nom FROM shop_options_rubriques","OPT","auto");
	TRD_liste("toutes",-1);
}
function TRD_liste($classement,$id_filtre,$incomplet,$id_langue) {
	global $id_boutique, $superAdmin;
	if($classement=="toutes") {
		affReq(TRD_get_liste("site",$id_filtre,$incomplet,$id_langue),"LIST","auto","debut");
		affReq(TRD_get_liste("option",$id_filtre,$incomplet,$id_langue),"LIST","auto","fin");
		$nbManq = TRD_get_nb_manq("site",$id_filtre,$id_langue);
		$nbManq += TRD_get_nb_manq("option",$id_filtre,$id_langue);
	} else {
		affReq(TRD_get_liste($classement,$id_filtre,$incomplet,$id_langue),"LIST","auto");
		$nbManq = TRD_get_nb_manq($classement,$id_filtre,$id_langue);
	}
	print("&nbManq=$nbManq&");
}
function TRD_get_liste($classement,$id_filtre,$incomplet,$id_langue) {
	global $id_boutique, $superAdmin,$id_langue_defaut;
	if($classement=="site") {
		$req = "SELECT c.*, CONCAT(c.identifiant,'\n' COLLATE utf8_unicode_ci,SUBSTRING(get_traduction(c.id,$id_boutique,$id_langue_defaut),1,50)) AS texte FROM shop_ml_champs c";
		if($incomplet=="true") {
			$req .= " INNER JOIN shop_ml_traductions t ON t.id_champs=c.id";
			if($id_langue!=0) {
				$req .= " AND t.id_langue=$id_langue";
			}
		}
		$req .= " WHERE c.id_boutique=$id_boutique AND c.classement = 'site'";
		if($id_filtre != -1) {
			$req .= " AND id_ensemble=$id_filtre";
		}
		if(!$superAdmin) {
			$req .= " AND id_objet=1";
		}
		if($incomplet=="true") {
			$req .= " AND t.texte='' GROUP BY c.id";
		}
		$req .= " ORDER BY identifiant";
	} else {
		$req = "SELECT chp.*, CONCAT(chp.identifiant,'\n' COLLATE utf8_unicode_ci,SUBSTRING(get_traduction(chp.id,$id_boutique,$id_langue_defaut),1,50)) AS texte FROM shop_ml_champs AS chp
				INNER JOIN shop_options AS opt ON opt.id = chp.id_objet
				INNER JOIN shop_options_valeurs AS val ON val.id_option = chp.id_objet AND val.id_boutique = $id_boutique";
		if($incomplet=="true") {
			$req .= " INNER JOIN shop_ml_traductions t ON t.id_champs=chp.id";
			if($id_langue!=0) {
				$req .= " AND t.id_langue=$id_langue";
			}
		}
		$req .= " WHERE chp.id_boutique = $id_boutique AND classement = 'option'";
		if($id_filtre != -1) {
			$req .= " AND opt.id_rubrique=$id_filtre";
		}
		if(!$superAdmin) {
			$req .= " AND val.visible=1";
		}
		if($incomplet=="true") {
			$req .= " AND t.texte='' GROUP BY chp.id";
		}
		$req .= " ORDER BY chp.identifiant";
	}
	return $req;
}
function TRD_get_nb_manq($classement,$id_filtre,$id_langue) {
	global $id_boutique, $superAdmin;
	if($classement=="site") {
		$reqnb = "SELECT COUNT(DISTINCT c.id) AS nbManq FROM shop_ml_traductions t INNER JOIN shop_ml_champs c ON c.id=t.id_champs 
				  WHERE c.id_boutique=$id_boutique AND c.classement = 'site' AND t.texte=''";
		if($id_langue!=0) {
			$reqnb .= " AND t.id_langue=$id_langue";
		}
		if($id_filtre != -1) {
			$reqnb .= " AND id_ensemble=$id_filtre";
		}
		if(!$superAdmin) {
			$reqnb .= " AND id_objet=1";
		}
	} else {
		$reqnb = "SELECT COUNT(DISTINCT c.id) AS nbManq FROM shop_ml_traductions t INNER JOIN shop_ml_champs c ON c.id=t.id_champs
				  INNER JOIN shop_options AS opt ON opt.id = c.id_objet
				  INNER JOIN shop_options_valeurs AS val ON val.id_option = c.id_objet AND val.id_boutique = $id_boutique
				  WHERE c.id_boutique=$id_boutique AND c.classement = 'option' AND t.texte=''";
		if($id_langue!=0) {
			$reqnb .= " AND t.id_langue=$id_langue";
		}		
		if($id_filtre != -1) {
			$reqnb .= " AND opt.id_rubrique=$id_filtre";
		}
		if(!$superAdmin) {
			$reqnb .= " AND val.visible=1";
		}
	}
	$res = testReq2($reqnb);
	return $res["nbManq"];	
}
function TRD_recup($id_champ,$classement) {
	global $id_boutique;
	$textes = ML_select($id_champ);
	$textes = str_replace("'","''",$textes);
	if($classement=="site") {
		affReqUnique("SELECT *, '$textes' AS textes FROM shop_ml_champs WHERE id=$id_champ","TRAD","auto");
	} else {
		affReqUnique("SELECT chp.*, '$textes' AS textes, opt.id_rubrique, val.visible FROM shop_ml_champs AS chp
					  LEFT JOIN shop_options AS opt ON opt.id = chp.id_objet
					  LEFT JOIN shop_options_valeurs AS val ON val.id_option = chp.id_objet AND val.id_boutique=$id_boutique
					  WHERE chp.id=$id_champ","TRAD","auto");
	}
}
function TRD_ajout($identifiant, $textes, $id_ensemble, $id_objet,$classement, $id_filtre, $html, $nb_lignes, $incomplet,$id_langue) {
	global $id_boutique;
	if(testReq2("SELECT identifiant FROM shop_ml_champs WHERE identifiant='$identifiant' AND id_boutique=$id_boutique")) {
		print("&err=2&txtErr=L'identifiant $identifiant est dj utilis par un autre champ&");
	} else {
		ML_insert_site($textes,"site",$id_boutique,$identifiant, $id_ensemble, $id_objet, $html, $nb_lignes);
		TRD_liste($classement, $id_filtre, $incomplet,$id_langue);
	}
}
function TRD_modif_super_admin($identifiant, $id_champ, $textes, $id_ensemble, $id_objet,$classement, $id_filtre, $incomplet,$id_langue, $html, $nb_lignes) {
	global $id_boutique;
	if(testReq2("SELECT identifiant FROM shop_ml_champs WHERE identifiant='$identifiant' AND id_boutique=$id_boutique AND id!=$id_champ")) {
		print("&err=2&txtErr=L'identifiant $identifiant est dj utilis par un autre champ&");
	} else {
		if($classement=="site") {
			ML_update_site($textes,$id_champ,$id_boutique, $identifiant, $id_ensemble, $id_objet, $html, $nb_lignes);
		} else {
			ML_update($textes,$id_champ,$id_boutique);
		}
		TRD_liste($classement, $id_filtre, $incomplet,$id_langue);
	}
}
function TRD_modif($id_champ, $textes,$classement, $id_filtre, $incomplet,$id_langue) {
	global $id_boutique;
	ML_update($textes,$id_champ,$id_boutique);
	TRD_liste($classement, $id_filtre, $incomplet,$id_langue);
}
function TRD_suppr($id_champ,$classement, $id_filtre, $incomplet,$id_langue) {
	ML_delete($id_champ);
	TRD_liste($classement, $id_filtre, $incomplet,$id_langue);
}
?>