<?php
//ifReq("DROP TABLE shop_listes__listes");
bdd_cree_table("shop_listes__listes"," CREATE TABLE `shop_listes__listes` (
`id` MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`id_boutique` MEDIUMINT NOT NULL ,
`identifiant` VARCHAR(50) NOT NULL, 
`titre` VARCHAR(50) NOT NULL,
`id_type` MEDIUMINT NOT NULL ,
`actif` TINYINT DEFAULT 1 NOT NULL ,
`visible` TINYINT DEFAULT 1 NOT NULL ,
`referencement` TINYINT DEFAULT 1 NOT NULL ,
`id_icone` MEDIUMINT DEFAULT 0 NOT NULL ,
`est_menu` TINYINT DEFAULT 0 NOT NULL ,
INDEX ( `id_boutique`),
INDEX ( `id_type` ), 
UNIQUE ( `identifiant` ),
INDEX ( `actif` ),
INDEX ( `visible` )
) ENGINE = MYISAM ",1);

//ifReq("DROP TABLE shop_listes__types");
bdd_cree_table("shop_listes__types"," CREATE TABLE `shop_listes__types` (
`id` MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`id_boutique` MEDIUMINT NOT NULL ,
`type` ENUM( 'principale', 'annexe' ) NOT NULL ,
`titre` VARCHAR( 255 ) NOT NULL ,
`description` VARCHAR( 1000 ) NOT NULL ,
`profondeur_maxi` TINYINT NOT NULL ,
`actif` TINYINT DEFAULT 1 NOT NULL ,
INDEX ( `id_boutique`),
INDEX ( `type` ),
INDEX ( `actif` )

) ENGINE = MYISAM ");


bdd_cree_table("shop_listes__elements"," CREATE TABLE `shop_listes__elements` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`id_boutique` MEDIUMINT NOT NULL ,
`id_liste` MEDIUMINT NOT NULL ,
`id_parent` INT NULL ,
`profondeur` SMALLINT NOT NULL ,
`position` MEDIUMINT NOT NULL ,
`id_structure` MEDIUMINT NOT NULL ,
`titre` varchar(255) character set utf8 NOT NULL,
`actif` TINYINT DEFAULT 1 NOT NULL ,
`id_icone` MEDIUMINT DEFAULT -1 NOT NULL ,
`est_menu` TINYINT DEFAULT 0 NOT NULL ,
INDEX ( `id_boutique`),
INDEX ( `id_liste`),
INDEX ( `id_parent`),
INDEX ( `profondeur`),
INDEX ( `position`),
INDEX ( `id_structure`),
INDEX ( `actif` )
) ENGINE = MYISAM ");

//ifReq("DROP TABLE shop_listes__structures");
bdd_cree_table("shop_listes__structures"," CREATE TABLE `shop_listes__structures` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`id_boutique` MEDIUMINT NOT NULL ,
`titre` VARCHAR ( 255 ) NOT NULL ,
`description` VARCHAR( 1000 ) NOT NULL,
`id_icone` MEDIUMINT NOT NULL ,
`est_dossier` TINYINT NOT NULL ,
INDEX ( `id_boutique`)
) ENGINE = MYISAM");

//ifReq("DROP TABLE shop_listes__champs");
bdd_cree_table("shop_listes__champs"," CREATE TABLE `shop_listes__champs` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`id_boutique` MEDIUMINT NOT NULL ,
`id_structure` MEDIUMINT NOT NULL,
`titre` VARCHAR ( 255 ) NOT NULL ,
`description` VARCHAR( 1000 ) NOT NULL,
`variable` VARCHAR ( 255 ) NOT NULL ,
`position` TINYINT NOT NULL,
`type` ENUM('booleen','texte','texte multilingue','radio','combo','date','upload','image','couleur','combo a cocher','separateur','etiquette','champ cache','liste') NOT NULL ,
`restrict` ENUM ('tous','num','numvirg','minuscules','majuscules','cyrillique','accents','alpha','alphanum','alpha_accent','alphanum_accents','adresse','email','ville','tel','telfrance','datefr','nom','texte_simple') NOT NULL,
`requis` TINYINT NOT NULL, 
`suggestion` VARCHAR ( 255 ) NOT NULL ,
`defaut` VARCHAR ( 255 ) NOT NULL ,

`nbLignes` TINYINT NOT NULL, 
`miseEnForme` TINYINT NOT NULL, 

`liste_titres` VARCHAR( 1000 ) NOT NULL,
`liste_valeurs` VARCHAR( 1000 ) NOT NULL,

`params` VARCHAR ( 255 ) NOT NULL ,

`visible` TINYINT NOT NULL, 
`modifiable` TINYINT NOT NULL, 
`recuperable` TINYINT NOT NULL, 
`est_titre` TINYINT NOT NULL, 

INDEX ( `id_boutique`),
INDEX ( `id_structure`),
INDEX ( `recuperable`),
INDEX ( `visible`),
INDEX ( `type`),
INDEX ( `position` )
) ENGINE = MYISAM");

//ifReq("DROP TABLE shop_listes__valeurs");
bdd_cree_table("shop_listes__valeurs"," CREATE TABLE `shop_listes__valeurs` (
`id_element` INT NOT NULL AUTO_INCREMENT,
`id_champ` INT,
`valeur` varchar(255) character set utf8 NOT NULL,
`valeur_longue` text character set ucs2,
`id_champ_ML` MEDIUMINT NOT NULL,
INDEX ( `id_champ`),
 PRIMARY KEY ( `id_element` , `id_champ` )
) ENGINE = MYISAM");

//ifReq("DROP TABLE shop_listes__structures_autorisees");
bdd_cree_table("shop_listes__structures_autorisees","CREATE TABLE `shop_listes__structures_autorisees` (
`id` MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`id_boutique` MEDIUMINT NOT NULL ,
`id_structure` MEDIUMINT NOT NULL ,

`id_liste` MEDIUMINT NULL ,
`niveau` SMALLINT NULL ,
`id_structure_parent` MEDIUMINT NULL ,
`id_element_parent` INT  NULL ,
`est_admin` TINYINT NOT NULL,


INDEX ( `id_liste`),
INDEX ( `id_boutique`),
INDEX ( `est_admin`)

) ENGINE = MYISAM");

//ifReq("DROP TABLE shop_listes__icones");
bdd_cree_table("shop_listes__icones"," CREATE TABLE `shop_listes__icones` (
`id` MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`icone` VARCHAR ( 255 ) NOT NULL,
`fichier` VARCHAR ( 255 ) NOT NULL ,
UNIQUE ( `icone`)
) ENGINE = MYISAM");

bdd_cree_table("shop_listes__referencement","CREATE TABLE IF NOT EXISTS `shop_listes__referencement` (
  `id` mediumint(9) NOT NULL auto_increment,
  `id_boutique` mediumint(9) NOT NULL,
  `id_type` mediumint(9) default NULL,
  `id_liste` mediumint(9) default NULL,
  `affichage_menu` enum('non','menu','direct') NOT NULL,
  `titre_menu` int(11) NOT NULL,
  `titre_liste_entete` tinyint(4) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id_type` (`id_type`),
  UNIQUE KEY `id_liste` (`id_liste`),
  KEY `id_boutique` (`id_boutique`)
) ENGINE=MyISAM");

bdd_cree_table("shop_listes__referencement_struct","CREATE TABLE IF NOT EXISTS `shop_listes__referencement_struct` (
  `id` mediumint(9) NOT NULL auto_increment,
  `id_structure` mediumint(9) NOT NULL,
  `est_menu` tinyint(4) NOT NULL,
  `titre_menu` int(11) NOT NULL,
  `est_page_html` tinyint(4) NOT NULL,
  `titre_page` int(11) NOT NULL,
  `description_page` int(11) NOT NULL,
  `mots_cles_page` int(11) NOT NULL,
  `contenu_page` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id_structure` (`id_structure`),
  KEY `est_menu` (`est_menu`),
  KEY `est_page_html` (`est_page_html`)
) ENGINE=MyISAM");


 


function install_icones() {
	/*// liste des icones en BDD
	$liste_icones=array();
	if($query_icones=ifReq("SELECT * FROM shop_listes__icones")) {
		while($res=mysql_fetch_assoc($query_icones)) {
			$liste_icones[]=$res["fichier"];
		}
	}
	// liste des icones dans le répertoire
	$liste_fichiers=array();
	$dir=opendir(CHEMIN_ICONES_LISTES);
	while($f=readdir($dir)) {
		if(!is_dir(CHEMIN_ICONES_LISTES.$f)) {
			$f=utf8_encode($f);
			$liste_fichiers[]=$f;
		}
	}
	//
	foreach($liste_fichiers as $fichier) {
		if(!in_array($fichier,$liste_icones)) {
			$nom_icone=explode(".",($fichier));
			$extension=strtoupper(array_pop($nom_icone));
			$nom_icone=implode(" ",$nom_icone);
			$nom_icone=str_replace(array("_","-")," ",$nom_icone);
			switch($extension) {
				case "PNG":
				case "JPG":
				case "JPEG":
				case "GIF":
					print("ajoute icone $fichier ...");
					
					if(ifReq("INSERT INTO shop_listes__icones SET icone='$nom_icone',fichier='$fichier' ")) 
						print("ok<br>");
					 else 
						print("erreur !!!<br>");
					
				break;
				default:
					print("icone non prise en charge $fichier<br>");
				break;
			}
			
			
		}
	}*/
	//Dossier Fichier.png  	Dossier.png  	Files-Word.png  	Folder Word.png  	Image.png  	Internet 2.png  	Ma musique.png  	Mes images.png  	Mes videos.png  	Musique.png  	Outlook.png  	User.png  	Users.png  	Video.png  	Windows Media Player.png  	WinRar.png  	adler_article.png  	adler_dossier.png  	adler_pays.png  	adler_photo.png  	adler_swf.png  	adler_users.png  	adler_video.png  	article.png  	flash.png  	monde.png
}



//define("CHEMIN_ICONES_LISTES","pages_admin/images/icones_listes/");
//install_icones();

bdd_ajoute_droit_rubrique("listes");
bdd_ajoute_droit_rubrique("admin_listes");	
//bdd_supprime_option("ADM_listes_icones_chemin");

?>