<?php

include_once("includes/paiements/Cpaiement.class.php");
class Cpaiement_SYSTEMPAY extends Cpaiement_base {
	var $url_prod="https://systempay.cyberpluspaiement.com/vads-payment/";
	var $url_test="https://systempay.cyberpluspaiement.com/vads-payment/";

	var $key = "";
	var $site_id = "";


	function Cpaiement_SYSTEMPAY($ref_cde="") {
		$this->url_prod="https://systempay.cyberpluspaiement.com/vads-payment/";
		$this->url_test="https://systempay.cyberpluspaiement.com/vads-payment/";
		include BOUTIQUE_REPERTOIRE."/includes/config_secure.inc.php";
		$this->etat_paiement = $SYSTEMPAY_mode;
		$str_var_key="SYSTEMPAY_key_$SYSTEMPAY_mode";
		$this->key = $$str_var_key;
		$this->site_id = $SYSTEMPAY_site_id;
		parent::Cpaiement_base($ref_cde);
	}
	function extractChiffres($str) {
		return preg_replace("/([^0-9]*)/","",$str);
	}
	function outFlash() {
		global $urlSite;
		$this->recupere_infos_commande();
		//"call_request.php";

		$retour=array();

		/* config */
		$key = $this->key;
		$site_id = $this->site_id;
		$ctx_mode = ($this->etat_paiement=="test"?"TEST":"PRODUCTION");

		/* pré-calcul */
		$amount = ($this->res_cde["total"]*100);
		$capture_delay = "";
		$currency = "978";
		$payment_cards = "VISA;MASTERCARD";
		$payment_config = "SINGLE";

		// Exemple de génération de trans_id basé sur l'horodatage
		$ts = time();
		$trans_date = date("YmdHis", $ts);
		$trans_id = (substr($this->ref_cde,-6));
		$order_id=$this->ref_cde;
		$order_info=md5($this->ref_cde."_codee_")."|".$this->identifiant;// indispensable !!;
		$validation_mode = "";
		$version = "V1";
		$url_return = "http://".$urlSite."/rappel_commande.php";

		/* clé */
		$signature_contents = $version . "+" . $this->site_id . "+" . $ctx_mode . "+"
		. $trans_id . "+" . $trans_date . "+" . $validation_mode . "+"
		. $capture_delay . "+" . $payment_config . "+" . $payment_cards . "+"
		. $amount . "+" . $currency . "+" . $this->key;
		$signature = sha1($signature_contents);

		/*	?><form method="POST" action="https://systempay.cyberpluspaiement.com/vads-payment/">
		 <input type="hidden" name="ctx_mode" value="TEST" />
		 <input type="hidden" name="amount" value="100" />
		 <input type="hidden" name="capture_delay" value="" />
		 <input type="hidden" name="currency" value="978" />
		 <input type="hidden" name="payment_cards" value="VISA;MASTERCARD" />
		 <input type="hidden" name="payment_config" value="SINGLE" />
		 <input type="hidden" name="site_id" value="91485686" />
		 <input type="hidden" name="trans_date" value="20090324122302" />
		 <input type="hidden" name="trans_id" value="122302" />
		 <input type="hidden" name="validation_mode" value="" />
		 <input type="hidden" name="version" value="V1" />
		 <input type="hidden" name="url_return" value="http://url.de.retour/retour.php" />
		 <input type="hidden" name="signature"
		 value="a492d355c3d81012f12cca86beb8698d1e42bf3f" />
		 <input type="submit" name="payer" value="Payer" />
		 </form>
		 <form method="POST" target="_blank" action="https://systempay.cyberpluspaiement.com/vads-payment/">
		 <input type="hidden" name="ctx_mode" value="<?php echo($ctx_mode); ?>" />
		 <input type="hidden" name="amount" value="<?php echo($amount); ?>" />
		 <input type="hidden" name="capture_delay" value="<?php echo($capture_delay); ?>" />
		 <input type="hidden" name="currency" value="<?php echo($currency); ?>" />
		 <input type="hidden" name="payment_cards" value="<?php echo($payment_cards); ?>" />
		 <input type="hidden" name="payment_config" value="<?php echo($payment_config); ?>"/>
		 <input type="hidden" name="site_id" value="<?php echo($site_id); ?>" />
		 <input type="hidden" name="trans_date" value="<?php echo($trans_date); ?>" />
		 <input type="hidden" name="trans_id" value="<?php echo($trans_id); ?>" />
		 <input type="hidden" name="validation_mode" value="<?php echo($validation_mode);?>" />
		 <input type="hidden" name="version" value="<?php echo($version); ?>" />
		 <input type="hidden" name="url_return" value="<?php echo($url_return); ?>" />
		 <input type="hidden" name="signature" value="<?php echo($signature); ?>" />
		 <input type="submit" name="payer" value="Payer" />
		 </form>
		 <?php
		 exit;*/
		/* retour a flash */
		$retour["ctx_mode"] = $ctx_mode;
		$retour["amount"] = $amount;
		$retour["capture_delay"] = $capture_delay;
		$retour["currency"] = $currency;
		$retour["payment_cards"] = $payment_cards;
		$retour["payment_config"] = $payment_config;

		$retour["site_id"] = $site_id;
		$retour["trans_date"] = $trans_date;
		$retour["trans_id"] = $trans_id;
		$retour["order_id"] = $order_id;
		$retour["order_info"] = $order_info;
		$retour["validation_mode"] = $validation_mode;

		$retour["version"] = $version;
		$retour["url_return"] = $url_return;
		$retour["signature"] = $signature;

		$retour["payer"] = "Payer";

		$retour["method"]="POST";
		$retour["maillon"]=$this->{"url_".$this->etat_paiement}; // indispensable, ne sera pas renvoy� en parametre
		return $retour=affResUniqueToString($retour,"","PAIE","auto");
		return $this->arrayToOut($retour);
	}

	function analyse_retour_banque_rappel($print_log=false) {
		// le retour pour le rappel de la copmande
		// sur paypal, j'y arrive pas (probleme d'accents)=>
		return $this->analyse_retour_banque($print_log,"PAYEE"); // mettre l'�tat de la commande
	}

	function calcule_signature_retour($mode_sys_auto=false) {
		if($mode_sys_auto) {
			$fields = array(
			"version", "site_id", "ctx_mode", "trans_id", "trans_date",
			"validation_mode", "capture_delay", "payment_config", "card_brand",
			"card_number", "amount", "currency", "auth_mode", "auth_result",
			"auth_number", "warranty_result", "payment_certificate","result", "hash" );
		} else {
			$fields = array(
			"version", "site_id", "ctx_mode", "trans_id", "trans_date",
			"validation_mode", "capture_delay", "payment_config", "card_brand",
			"card_number", "amount", "currency", "auth_mode", "auth_result",
			"auth_number", "warranty_result", "payment_certificate", "result" );
		}
		$signature_contents="";
		foreach($fields as $field) {
			$signature_contents.=$_REQUEST[$field] . "+";
		}
		$signature_contents.=$this->key;
		$signature = sha1($signature_contents);
		/*print_rr($_REQUEST);
		 print_rr($fields);
		 echo "$signature_contents <br>$signature<br>";*/
		return $signature;
	}

	function get_description_auth($auth) {
		$retour["00"]="transaction approuvée ou traitée avec succès";
		$retour["02"]=" contacter l’émetteur de carte";
		$retour["03"]=" accepteur invalide";
		$retour["04"]=" conserver la carte";
		$retour["05"]=" ne pas honorer";
		$retour["07"]=" conserver la carte, conditions spéciales";
		$retour["08"]=" approuver après identification";
		$retour["12"]=" transaction invalide";
		$retour["13"]=" montant invalide";
		$retour["14"]=" numéro de porteur invalide";
		$retour["30"]=" erreur de format";
		$retour["31"]=" identifiant de l’organisme acquéreur inconnu";
		$retour["33"]=" date de validité de la carte dépassée";
		$retour["34"]=" suspicion de fraude";
		$retour["41"]=" carte perdue";
		$retour["43"]=" carte volée";
		$retour["51"]=" provision insuffisante ou crédit dépassé";
		$retour["54"]=" date de validité de la carte dépassée";
		$retour["56"]=" carte absente du fichier";
		$retour["57"]=" transaction non permise à ce porteur";
		$retour["58"]=" transaction interdite au terminal";
		$retour["59"]=" suspicion de fraude";
		$retour["60"]=" l’accepteur de carte doit contacter l’acquéreur";
		$retour["61"]=" montant de retrait hors limite";
		$retour["63"]=" règles de sécurité non respectées";
		$retour["68"]=" réponse non parvenue ou reçue trop tard";
		$retour["90"]="arrêt momentané du système";
		$retour["91"]=" émetteur de cartes inaccessible";
		$retour["96"]=" mauvais fonctionnement du système";
		$retour["97"]=" échéance de la temporisation de surveillance globale";
		$retour["98"]=" serveur indisponible routage réseau demandé à nouveau";
		$retour["99"]=" incident domaine initiateur";
		return $retour[$auth];
	}

	function analyse_retour_banque($print_log=false,$evite_verif=false,$mode_sys_auto = false) {
		global $id_boutique,$commentaire_admin,$commentaire_client;
		$log="";
		$log.=("-------------------------\n");
		$log.=("-- ".date("d/m/Y H:i:s")." --\n");
		$log.=("-------------------------\n");
		$log2.=("<br><br>-- ".date("d/m/Y H:i:s")." --<br");
		$log2="<form action='/SYS_retour_auto.php' method='POST'>";
		foreach(array_keys($_REQUEST) as $var) {
			$log.=("$var = $_REQUEST[$var]\n");
			$log2.="<input type='hidden' name='$var' value='$_REQUEST[$var]'>";
		}

		//	print_r($_REQUEST);
		$split_info = explode("|",$_REQUEST["order_info"]);
		$ref_cde=$_REQUEST["order_id"];
		$code = $split_info[0];
		$signature=$_REQUEST["signature"];
		$montant_paye=floatval($_REQUEST["amount"])/100;
		$currency=$_REQUEST["currency"];
		$this->Cpaiement($ref_cde); // a faire obligatoirement, pour avoir un mail retour, et un affichage retour !!!

		// etat par défaut
		$etat_transaction = "VERIFIER";
		$commentaire_admin="";
		$commentaire_client="";

		$erreur=false;
		$warning=false;

		$signature_attendue = $this->calcule_signature_retour($mode_sys_auto);
		$auth_result=$_REQUEST["auth_result"];
		if($auth_result=="") $auth_result=$_REQUEST["result"];
		if($signature != $signature_attendue) {
			$commentaire_admin.=("ERREUR : la vérification de la signature a échoué\n");
			$erreur=true;
		} else if(!$this->verifie_code($code)) {
			$commentaire_admin.=("ERREUR : la vérification du code a échoué\n");
			$erreur=true;
		} else if(!$this->recupere_infos_commande()) {
			$commentaire_admin.=("ERREUR : la récupération des informations de la commande a échoué.\n");
			$erreur=true;
		} else {
			if($currency!=978) {
				$warning_texte.=("ATTENTION : la devise du paiement recu est : $currency.");
				$warning=true;
			}
			if($montant_paye!=floatval($this->res_cde["total"])) {
				$warning_texte="ATTENTION : le montant encaissé n'est pas le bon... : ".($montant_paye)." au lieu de ".$this->res_cde["total"];
				$warning=true;
			}
			$log.=("appel certifié de la banque\n");
			$log.=("reponse de la banque : ".($this->get_description_auth($auth_result)."\n"));
			$etat_transaction="PAYEE";
			if($warning) {
				$log.=("WARNING : $warning_texte\n");
				$commentaire_admin.=$warning_texte;
				$etat_transaction="VERIFIER";
			}
		}
		if($erreur) {
			$etat_transaction =  "VERIFIER";
		} else if($warning) {
			$etat_transaction =  "VERIFIER";
		} else {
			// pas d'erreur, pas de warning, on prend le code retour
			$commentaire_admin.="code retour $auth = ".$this->get_description_auth($auth_result)."\n";
			switch($auth_result) {
				case "00":
					$etat_transaction =  "PAYEE";
					break;
			//	case "02":
			//	case "30":
			//	case "96":
			//		$etat_transaction =  "VERIFIER";
			//		break;
			//	case "05":
			//	case "14":
			//	case "17":
				default:
					$etat_transaction = "REFUSEE";
					break;

			}
		}

		if($warning || $erreur) {
			if($warning) Crapports::Add_trace("WARNING<br>$warning_texte");
			if($erreur) Crapports::Add_trace("ERREUR<br>$erreur");
			Crapports::Add_trace($commentaire_admin);
			Crapports::Add_destinataire("raph@e-frogg.com");
			Crapports::Envoie("paiement SYSTEMPAY",false);
		}

		if($print_log=="form") {
			//print(str_replace("\n","<br>",$log));
			$log2.="<input type='submit' value='$ref_cde SYSTEMPAY $etat_transaction'></form>";
			$date_jour=date("Y-m-d");
			$f=fopen(BOUTIQUE_REPERTOIRE."/logs/log_SYSTEMPAY_{$date_jour}.htm","a");
			//			echo $log2;
			fwrite($f,$log2);
			fclose($f);
		} else if($print_log) {
			//print(str_replace("\n","<br>",$log));
			$date_jour=date("Y-m-d");
			$f=fopen(BOUTIQUE_REPERTOIRE."/logs/log_SYSTEMPAY_{$date_jour}.txt","a");
			fwrite($f,$log);
			fclose($f);
		}

		return $etat_transaction;

	}
}

?>
