<?php
include_once('modules/base/classes/COptions.class.php');
include_once('modules/base/classes/CFormulaire.class.php');

class COptionsEditeur
{
	private $form;
	
	function COptionsEditeur()
	{
		$this -> form = new CFormulaire('?action=base.COptionsEditeur.sauver');
	}
	
	function ajouteOption($chemin)
	{
		if ($listeOptions = COptions::get_options_by_chemin($chemin))
		{
			foreach($listeOptions as $option)
			{
				$this -> form ->add_input($option['identifiant'], "identifiants[$option[identifiant]]", $option['valeur'], null, null, null, array('description'=>$option['description']));
			}
		} 
	}
	
	function ajouteOptions($chemins)
	{
		foreach($chemins as $chemin)
		{
			$this -> ajouteOption($chemin);
		}
	}
	
	function out()
	{
		$this -> form -> add_submit('Mettre à jour', 'submit');
		return $this -> form -> out();
	}
	
	static function sauver()
	{
		if (is_array($_POST['identifiants']))
		{
			foreach($_POST['identifiants'] as $identifiant => $option)
			{
				COptions::set_valeur_option($identifiant, $option);
			}
		}
	}
}