var EfroggSlider =  Class.create({

	initialize: function() {
	
		this.pos 			= 0;				// Position actuelle dans le tableau du slide
		this.tabCells 		= new Array();  	// Tableau contenant toute les cellules contenant le slide
		this.container		= null;				// Zone qui contient toute les cellules
		this.subContainer	= new Array();		// Zone qui contient toutes les sous cellules
		this.mask			= null;				// mask
		this.text_content	= new Array();		// Tout le contenu text.
		this.tabVignettes 	= new Array();  	// Tableau des vignettes
		this.tabVignettesPosX = new Array(); 	// Tableau de position de d�part des vignettes
		
		this.parallaxEnCours		= false;
	},
	
	setSlider: function(idMaskContainer, idContainer) {	
		// D�finition des �lements
		this.container		= document.getElementById(idContainer);
		this.mask			= document.getElementById(idMaskContainer);
	},
	
	setCells: function(cells) {
		
		var obj = this;
		
		// On v�rifie que les donn�es envoy� sont bien contenues dans un tableau.
		if(cells.length) {
			this.tabCells = cells;
			// Apr�s avoir modifi� le tableau on remet la position du slide � 0;
			this.goToAncre(0);
		}
		

		  if(window.addEventListener) {
			window.addEventListener( 'resize', function() { 
				var tmp_pos = obj.pos;
				obj.boutons_navig(this);
				obj.setSubContainer(obj.subContainer);
				for(var i =0; i < obj.tabVignettes.length; i ++) 
					obj.scale(i, obj.tabVignettes[i]);
				
			}, false);
			addEventListener('mousemove', function(event){ obj.parallax(event); }, false);	
		  }
		  else {
				window.attachEvent('onresize', function() { 
				
				var tmp_pos = obj.pos;
				obj.boutons_navig(this);
				obj.setSubContainer(obj.subContainer);
				for(var i =0; i < obj.tabVignettes.length; i ++) 
					obj.scale(i, obj.tabVignettes[i]);
					
				
			}, false);
			
			attachEvent('onmousemove', function(event){ obj.parallax(event); }, false);	
			
		}
			
	

	},
	
	setSubContainer: function(sub) {
		
		this.subContainer = sub;
		//alert(this.mask.offsetWidth + 'px');

		for(var i =0; i < sub.length; i++)
			document.getElementById(sub[i]).style.width = this.mask.offsetWidth + 'px';
		
		
	},
	
	precedent : function() {
		// On prend la position actuelle et on la d�cremente de 1 si celle-ci est >= 1 (pour �viter les valeur n�gatives).
		if(this.pos > 0) {

			this.pos--;
			
			// On applique les modification de style (CSS3) pour la transition.
			this.container.style.marginLeft 		= this.pos * (-(this.mask.offsetWidth)) + 'px';
			this.container.style.MozTransition 		= 'margin-left 0.5s ease';
			this.container.style.WebkitTransition 	= 'margin-left 0.5s ease';
			
			var obj = this;
			

			if(this.tabVignettes[this.pos]) {
	
				for(var i = 0; i < this.tabVignettes[this.pos].length; i++) {
					
					this.tabVignettes[this.pos][i].style.left		= this.tabVignettesPosX[this.pos][i][1] + 'px';
		
				}
			}
			
			obj.enCours = false; 
		}

		
	},
	
	suivant : function() {
		// On prend la position actuelle et on l'incr�mente de 1 si celle-ci est < taille max du tableau (pour �viter de d�passer l'offSet).
		if(this.pos < (this.tabCells.length - 1)) {

			this.pos++;
			
			this.container.style.marginLeft 		= this.pos * (-(this.mask.offsetWidth)) + 'px';
			this.container.style.MozTransition 		= 'margin-left 1s linear';
			this.container.style.WebkitTransition 	= 'margin-left 1s linear';
			
		
		}
	},
	
	goToAncre : function(param) {
	
	

		var tmp_pos = this.pos;
		var tmp_pos2;
		// Si le param�tre est un nombre, on concid�re que c'est un index du tableau.
		if(typeof(param) == 'number') {
			// V�rification que le param ne d�passe pas les bornes du tableau.
			if(param >= 0 && param < this.tabCells.length) 
				tmp_pos = param + 1;
			else
				tmp_pos = 1;
		}
		// Sinon cela correspond � la cl� du tableau
		else {
			tmp_pos = this.tabCells.indexOf(param);
			tmp_pos++;
		}

		if(tmp_pos > 0)	{			

			if(this.tabVignettes.length > 0) {
			
				(tmp_pos - 1  < this.pos) ? this.changeVignettes(this.pos, -1)	:	this.changeVignettes(this.pos, 1);
				
			}
			
			this.pos = tmp_pos;
			this.precedent();
			(tmp_pos - 1  < this.pos + 1) ? this.changeVignettes(tmp_pos, -1)	:	this.changeVignettes(tmp_pos, 1);			
		}
	},
	
	scale : function(cell, vignettes) {
		
		this.tabVignettes[cell] = vignettes
		
		var taille = this.mask.offsetWidth;
		var demi_taille = taille / 2;
		var les_vignettes = jQuery(".vignette");
		var nb_vignettes = vignettes.length;
		
		var previousNum0;
		var previousNum1;
		var previousNum2;
		
		var tabScale = new Array();
		var tabScaleTrier = new Array();
		
		var posX = new Array();
		
		var espaceX 	=	200 - ( 200 * (nb_vignettes / 200) );
		var espaceY 	=	80 - ( 80 * (nb_vignettes / 80) );
		
		if(espaceX > 200 || espaceX == 0) espaceX = 1;
		if(espaceY > 80 || espaceY == 0) espaceY = 1;
		
		tabScale[cell] = new Array();
		tabScaleTrier[cell] = new Array();
		
		for(var i = 0; i < nb_vignettes; i++) {
			
			var num0 = Math.random();

			tabScale[cell].push(num0);
			tabScaleTrier[cell].push(num0);
								
			
		}
		
		tabScaleTrier[cell].sort();
		
		
		for(var i = 0; i < nb_vignettes; i++) {
			var vignette_actu	=	vignettes[i];
			var sens = 1;
			var coeffTaille;
			
			for(var o = 0; o < tabScaleTrier[cell].length; o++) {
				if(tabScale[cell][i] == tabScaleTrier[cell][o]) {
					sens = (o % 2) 	?	 1 : -1;
					if (nb_vignettes == 1) coeffTaille = 1;
					else coeffTaille = Math.abs(Math.sin((Math.PI/(nb_vignettes - 1) * o)));// / (o + 1)));
					break;
				}
			}
			
			
			var scale = tabScale[cell][i];
	
			
			var demiTailleZone = demi_taille * coeffTaille;
	
			var num1 = demi_taille+ (coeffTaille * demi_taille/(3 - Math.min(2, ( nb_vignettes) * 0.1))) * sens;// Math.floor(Math.random()*(demiTailleZone)); //)- 95;
			var num2 = Math.floor(scale*31);

			num1 += this.mask.offsetWidth * cell;
		
			
			
			vignette_actu.style.zIndex	= num2;
			vignette_actu.style.top		= num2 + "px";
			vignette_actu.style.width	= ((scale*100)+80) + "px";
			vignette_actu.style.height	= "auto";
			vignette_actu.style.top		= num2*2 + "px";
			num1 = (num1 - ((scale*100)+80)/2 );
			vignette_actu.style.left 	= num1+ "px";

			posX.push(new Array(scale, num1));
		}
		
		
		this.tabVignettesPosX[cell] = posX;
		
	},
	
	ancre : function(chaine){
		var reg = new RegExp("\#[a-zA-Z0-9_-]+","g");
		return reg.exec(chaine);
	},
	
	boutons_navig :	function (event){
			
			var ancre_actuelle ;
			
			ancre_actuelle = (event == null)	?	this.ancre(document.URL) : this.ancre(event);
			if(ancre_actuelle == null) ancre_actuelle = this.tabCells[0];
	

			this.goToAncre(ancre_actuelle.toString());
			

			
			var i = this.pos;
			
			if(this.text_content[i][5] == ancre_actuelle){
					

				document.location = ancre_actuelle;
				
				if(this.text_content[i][2] == null) {
					document.getElementById('bouton_precedent').style.display = 'none';
				}
				else {
					document.getElementById('bouton_precedent').style.display = 'block';
					document.getElementById("prec").href= this.text_content[i][2];
					document.getElementById("btn_prec_gris").innerHTML = this.text_content[i][0];
					document.getElementById("btn_prec_vert").innerHTML = this.text_content[i][1];
				}
				
				if(this.text_content[i][8] == null) {
					document.getElementById('bouton_suivant').style.display = 'none';
				}
				else {
					document.getElementById('bouton_suivant').style.display =  'block';
					document.getElementById("suiv").href =  this.text_content[i][8];
					document.getElementById("btn_suiv_gris").innerHTML = this.text_content[i][6];
					document.getElementById("btn_suiv_vert").innerHTML = this.text_content[i][7];
				}

				document.getElementById("btn_actu_petit").innerHTML = this.text_content[i][3];
				document.getElementById("btn_actu_grand").innerHTML = this.text_content[i][4];

			}
			
	
	},
		
	parallax: function(event) {
		
			var offsetXY = this.findPos(this.mask);
			var sens  = (event.clientX < offsetXY[0] + this.mask.offsetWidth / 2)	?	1 : -1;
		
			for(var i = 0; i < this.tabVignettes[this.pos].length; i++) {
				
				var coeff = this.tabVignettesPosX[this.pos][i][0];

				var endX  = this.tabVignettesPosX[this.pos][i][1] + sens * (1 + (60 * coeff));
				
				this.tabVignettes[this.pos][i].style.left				= endX+'px';
				this.tabVignettes[this.pos][i].style.MozTransition 		= 'left 1s ease';
				this.tabVignettes[this.pos][i].style.WebkitTransition 	= 'left 1s ease';
			}
	
	
	},
	
	findPos : function (obj){
			//position x / y de l'objet
				var x = obj.offsetLeft || 0;
				var y = obj.offsetTop || 0;
			//tant qu'il y a un parent, on ajoute la position de son parent
				while (obj = obj.offsetParent) {
					x += obj.offsetLeft
					y += obj.offsetTop
				}
			//Ici on retour x ou y ( ou les deux dans un tableau ou un hash
				return new Array(x,y);
	},
	
	stopParallax: function() {
	
		this.parallaxEnCours = false;
		
		for(var i = 0; i < this.tabVignettes[this.pos].length; i++) {
			
			var endX  = this.tabVignettesPosX[this.pos][i][1];
			
			this.tabVignettes[this.pos][i].style.left				= endX+'px';
			this.tabVignettes[this.pos][i].style.MozTransition 		= 'left 1s ease';
			this.tabVignettes[this.pos][i].style.WebkitTransition 	= 'left 1s ease';
		}
	
	},
	
	changeVignettes : function(cell, sens) {
		
		var coeffVitesseX = 50;
		var vitesseFinal;
		var secondes;

		var tadNewV	=	new Array();

		
		if(this.tabVignettes[cell]) {
		
			var subC	=	document.getElementById(this.subContainer[cell]);
			var endX;

			for(var i = 0; i < this.tabVignettes[cell].length; i++) {
			
				endX =this.tabVignettesPosX[cell][i][1]; 
				
				if(sens == -1) 
					endX += 300 * this.tabVignettesPosX[cell][i][0];
				else
					endX -= 300 * this.tabVignettesPosX[cell][i][0];

				this.tabVignettes[cell][i].style.left				= endX+'px';
				this.tabVignettes[cell][i].style.MozTransition 		= 'left 1s ease';
				this.tabVignettes[cell][i].style.WebkitTransition 	= 'left 1s ease';
				
			}
		}
		
	}
});