<?php
class Facturations_h extends Model{

	public $id;
	public $num;
	public $date;

	/*
	 *
	*
	* Valeur => 'r' -> relance, 'i'->impayée, 'p' -> payée, 't'->termniée
	*/
	public $etat;
	public $tva;
	public $date_valid;
	public $total;
	public $titre;
	public $id_client;
	public $id_intitule_entete;


	public $duree_valid = 1;

	/*
	 * Calculé
	*/
	public $total_tva;

	/*
	 * Calculé
	*/
	public $total_ttc;

	public $client = array();
	public $relance = array();
	public $hebergements = array();
	public $elems = array();


	public function __construct(){
		parent::__construct('facturations_h');
	}

	public function __toString(){
		return $this->titre;
	}

	public function preSave(){
		if($this->id == "" ) $this->date = date('Y-m-d H:i:s');

		if(isset($_POST['duree_valid']) ){
			$duree = nb_jours_les_prochaines_annees($_POST['duree_valid']);
			$this->duree_valid = $duree;
		}
		else if(isset($this->duree_valid)){
			$duree = nb_jours_les_prochaines_annees($this->duree_valid);
		}
		else{
			$duree = null;
		}

		if(!is_null($duree)){
			$int = time() + (60*60*24*$duree);
			$prochaineFacturation = date('Y-m-d',$int);
			$this->date_valid = $prochaineFacturation;
		}

		if($this->id == ""){
			$cpt = new Cpt_facturations();
			$cpt_mois = $cpt->findOneBy('mois',date('Y-m'));
				
			if(!empty($cpt_mois)){
				$cpt_mois->save();
				$compteur = $cpt_mois->cpt;
			}
			else{
				$cpt->mois = date('Y-m');
				$cpt->cpt = 0;
				$cpt->save();
				$compteur = $cpt->cpt;
			}
				
			$nb = strlen($compteur);
			$num = "";
			for($i = 0; $i < 3-$nb; $i++){
				$num .= '0';
			}
				
			$num = 'H'.date('ym').$num.$compteur;
			$this->num = $num;
		}
	}

	public function getTotaux($elems = null){
		if($elems == null || empty($elems)){
			$elems = $this->getElems();
		}

		$heb = array();


		$this->relance = $this->getRelance();

		//		print_r_html($this->relance);

		if(!is_null($this->relance))
		$heb = $this->relance->getHebergements();
		else
		$heb = null;

		$i = 0;
		$titre = '';
		$total = 0;
		$this->total_tva = 0;
		foreach($elems as $e){
			if($e->qte != 0 && $e->puht != 0){
				if($i != 0) $titre .= ' / ';
				$titre .= $e->designation.' ';
				$i++;
			}
			$total = $total + ($e->puht * $e->qte);
		}
		$this->titre = $titre;

		$this->total = $total;

		$total_tva = $total * ($this->tva / 100);

		$this->total_tva = round($total_tva,2);
		$this->total_ttc = $this->total + $this->total_tva;

		return $this;

		/*
		 $i = 0;
		$titre = "";
		$total = 0;
		foreach($relance->elems as $e){

		}
		*/

		/*
		 $i = 0;
		$titre = '';
		$total_temp = 0;
		$total = 0;
		$total_tva = 0;
		$total_ttc = 0;
		$min_jours_restants = 10000;

		if($heb == null || empty($heb)){
		$heb = $this->getHebergements();
		}

		$elems = $this->getElems();

		foreach($elems as $e){
		$duree = 1;
		$hh = array();
		foreach($heb as $h){
		if($e->designation == $h->designation){
		$hh = $h;
		break;
		}
		}
			
			
		if(!is_null($e->puht) && !is_null($e->qte)){
		$total_temp = $e->puht * $e->qte;
		$total = $total + $total_temp;
		}
		else{
		$total_temp = $hh->montant_ht * $hh->qte;
		$total = $total + $total_temp;
		}

		//La TVA appliquée est différente pour chaque élément
		$total_tva = $total_tva + ($total_temp * ($hh->tva / 100));

		if(isset($e->jours_restants) && $e->jours_restants < $min_jours_restants)
		$min_jours_restants = $e->jours_restants;

		$i++;
		}
		$total_ttc = $total + $total_tva;

		$this->titre = $titre;
		$this->total = $total;

		$relance->jours_restants = $min_jours_restants;

		//		$total_tva = $this->total *( $this->tva / 100);
		//		$total_ttc = $this->total + $total_tva;

		$this->total_tva = $total_tva;
		$this->total_ttc = $total_ttc;

		//		print_r_html($this);

		return $this;
		*/


	}

	public function getClient(){
		if(empty($this->client)){
			$client = new Clients();
			$client = $client->findOneBy('id',$this->id_client);
				
			$this->client = $client;
				
			return $client;
		}
		else{
			return $this->client;
		}
	}

	public function getIntituleEntete(){
		$int_ent = new Intitule_entete();
		$int_ent = $int_ent->findOneBy('id',$this->id_intitule_entete);

		return $int_ent;
	}


	public function getElems(){
		if(empty($this->elems)){
			$elems = new Elems();
			$elems = $elems->findBy('id_facturations_h',$this->id);
				
			$this->elems = $elems;
				
			return $elems;
		}
		else{
			return $this->elems;
		}
	}

	public function majElems($duree = null){
		$maj_elems = array();

		if(is_null($duree))
		$duree = $this->duree_valid;

		foreach($this->getElems() as $e){
			$e->qte = $e->qte + ($duree - 1);
			$e->save();
				
			$maj_elems[] = $e;
		}

		return $this->elems = $maj_elems;

	}

	public function getRelance(){
		if(empty($this->relance)){
			$relances = new Relances();
			$relances = $relances->findOneBy('id_facturations_h',$this->id);
				
			$this->relance = $relances;
		}
		return $this->relance;
	}

	public function getLastRelanceValide(){
		$q = new QueryBuilder('Relances');
		$q ->select('*, (to_days(curdate())-to_days(`date`)) as jours_depuis')
		->from('Relances')
		->where('id_facturations_h = ?', $this->id)
		->orderBy('date','DESC')
		->limit(1);
			
		return $q->executeQuery('object');
	}


	public function JoinWithHebergement($pHebergements = null){
		if(is_array($pHebergements) || $pHebergements == null){
			//Si il est null, on va chercher tous les hébergements
			if($pHebergements == null){
				if(empty($this->hebergements)){
					$client = new Clients();
					$client = $this->getClient();
					//				print_r_html($client);
						
					$hebergements = $client->getHebergements();
					$this->hebergements = $hebergements;
				}
				else{
					$hebergements = $this->hebergements;
				}
			}
			//Si le param est un tableau d'hébergements
			else{
				$hebergements = $pHebergements;
			}
				
			//			print_r_html($hebergements);
				
			foreach($hebergements as $h){
				$join = new Join_Facturations_h_Hebergements();
				$join->id_facturations_h = $this->id;
				$join->id_hebergements = $h->id;
				$join->save();
			}
				
			//			return $hebergements;
		}
		//Si le param est juste un ID
		else if(is_int($pHebergements) && $pHebergements != null){
			$join = new Join_Facturations_h_Hebergements();
			$join->id_facturations_h = $this->id;
			$join->id_hebergements = $pHebergements;
				
			$join->save();
		}
		else{
			exit('Problème de paramètre pour la function JoinWithHebergement : '.$pHebergements);
		}
	}

	public function getHebergements(){
		if(empty($this->hebergements)){
			$q =  new QueryBuilder('Hebergements');
				
			$q->select('H.*')
			->from("hebergements H")
			->join("INNER JOIN join_facturations_h_hebergements J ON J.id_hebergements = H.id")
			->join("INNER JOIN facturations_h F ON F.id = J.id_facturations_h")
			->where('F.id = ? ', $this->id);

			return $q->executeQuery();
		}
		else{
			return $this->hebergements;
		}
	}

	public function getDureeRestante(){
		$q = new QueryBuilder("facturations_h");

		$q->select("(to_days(`date_valid`)-to_days(curdate())) as jours_restants")
		->from("facturations_h F")
		->where("F.id = ? ", $this->id);

		$r = $q->executeQuery('object');

		return $this->merge($r,$this);
		//		return $this;
	}

	public function addElems($elems = null, $duree = null){

		if(!is_null($elems)){
			foreach($elems as $e){
				$e->id_facturations_h = $this->id;
				if(!is_null($duree))
				$e->qte = $e->qte + ($duree - 1);
				$e->save();
			}
		}

		return $this->elems = $elems;



		//		foreach($this->getHebergements() as $h){
		//			$elem = new Elems();
		//			$elem->designation = $h->domaine;
		//		//TODO: prévoir les fractions de paiements pour les regroupements
		//			$elem->qte = 1;
		//			$elem->puht = $h->montant_ht;
		//			$elem->id_facturations_h = $this->id;
		//
		//			$elem->save();
		//
		//			$total = $total + ($elem->puht * $elem->qte);
		//
		//			$this->elems[] = $elem;
		//		}
		//
		//		$this->total = $total;
	}

	public function addNewRelance(){
		$hebergements = $this->getHebergements();

		//		print_r_html($hebergements);

		$total = 0;
		foreach($hebergements as $h){
			echo 'Montant hébergement : '. $h->montant_ht.'<br/>';
				
			$total = $total + $h->montant_ht;
		}

		if($this->total != $total){
			new Alert('Le montant de la facture a évolué depuis la dernière fois');
		}

		$relance = new Relances();
		$relance->titre = "Relance paiement hébergement e-frogg";
		$relance->total = $total;

		return $this->addRelance($relance);
	}

	public function addRelance($pRelance){

		$relance = new Relances();
		$relance->num = $this->num;
		$relance->titre = $pRelance->titre; //Prévoir un compteur dans le titre des relances, par rapport aux ancienne
		$relance->total = $pRelance->total;
		$relance->id_facturations_h = $this->id;

		$relance->save();

		array_push($this->relances,$relance);

		//		TODO: mettre en place la création du PDF
		$pdf = $this->createPDF();

		return $relance;


	}

	public function gestionFacturesHebergements(){
		$clients = new Clients();
		$clients = $clients->findAll();

		$clients_relances = array();
		foreach($clients as $c){
			$c->getHebergementsWithDuree();
			if(!empty($c->hebergements)){
				$clients_relances[] = $c->gestionFactureByClient();
			}
		}

		//		print_r_html($clients_relances);
		//		exit();

		//		echo '<br/>Liste des clients, de leur hébergements et relances-----------------<br/>';
		//		print_r_html($clients_relances);

		$this->sendMailToEfrogg($clients_relances);
	}


	public function sendMailToEfrogg($clients_relances){
		//		echo '<br/><br/><br/>------------Debut du mail-----------<br/><br/><br/>';

		//		print_r_html($clients_relances);

		$html = '';
		$bloc_clients = '';

		if(!empty($clients_relances)){
			foreach($clients_relances as $c){



				if(!empty($c->relances)){
					//				$bloc_clients .= '<tr >';
					//				$bloc_clients .= '<td></td>';
					//				$bloc_clients .= '<td><a href="'.RACINE_WEB.'?module=clients&action=show&id='.$c->id.'">Voir le client</a></td>';
					//				$bloc_clients .= '</tr>';
						
						
					$row = count($c->relances);
					$i = 1;
						
					foreach($c->relances as $r){
						//					if(!empty($h->relances)){
						$jours_restants = 10000;
						foreach($c->hebergements as  $h){
							if($r == $h->designation){
								$jours_restants = $h->jours_restants;
							}

						}


						$bloc_clients .= '<tr>';
						$bloc_clients .= '<td>'.$c->nom.'</td>';
						$bloc_clients .= '<td>'.$r->titre.'</td>';
						$bloc_clients .= '<td>'.$jours_restants.' jours</td>';
						$bloc_clients .= '<td>'.$r->total.' &euro;</td>';
						if($i == 1)
						$bloc_clients .= '<td rowspan="'.$row.'"><a href="'.RACINE_WEB.'?module=clients&action=show&id='.$c->id.'">Relancer</a></td>';
						$bloc_clients .= '</tr>';
							
						foreach($c->messagePerso as $m => $v){
							//Message adressé au client
							if($m == $h->designation){
								$bloc_clients .= '<tr >';
								$bloc_clients .= '<td colspan="5">'.$m.'</td>';
								$bloc_clients .= '</tr>';
							}
						}
						//					}
						$i++;
					}
				}
			}
		}
		else{
			$html = "Aucun client à relancer cette fois-ci";
		}
		include_once RACINE_INCLUDE.'classes/class.phpmailer.php';
		//include_once RACINE_INCLUDE.'classes/class.smtp.php';
		$mail = new PHPmailer();
		$mail->IsHTML(true);
		$mail->CharSet = "utf-8";
		$mail->Subject='[CRON] Système de facturation';

		/*$mail = new Mail();
		 $mail->setSubject("");*/

		$mails = explode(',', DESTINATAIRES_ADMIN);

		foreach($mails as $m){
			$mail->AddAddress($m);
			//$mail->addTo($m);
		}


		$mail->From='admin@e-frogg.com';
		$mail->FromName='facturation e-frogg';
		$mail->AddReplyTo('reply@e-frogg.com');
		//$mail->setFrom('gestion-hebergements@e-frogg.com');

		if($html == ""){
			$html = implode('', file('../tpl/mail/rappelEfrogg.mail.html'));
			$html = str_replace(array('#LISTE_CLIENTS#'),array($bloc_clients),$html);
		}
		echo $html;

		//$mail->setHtmlBody($html);
		$mail->Body=$html;

		$mail->Send();
		//$mail->send();

	}


	public function createPDF(){
		include_once(RACINE_INCLUDE.'includes/gen_facture.inc.php');

		$client = $this->getClient();
// 		if(empty($client->pass)) {
// 			new Alert('le client n\'a pas de mot de passe défini. Génération du PDF impossible');
// 		} else if(empty($client->login)) {
// 			new Alert('le client n\'a pas de login défini. Génération du PDF impossible');
// 		} else {
			$pdf = gen_facture("facturationsh",$this->id,$client->login,$client->pass);

			$pdf->Output(RACINE_INCLUDE.'web/pdf/facturationsh/'.$this->num.'.pdf','F');

			/*header('Content-type: application/pdf');
			readfile(RACINE_INCLUDE.'web/pdf/facturationsh/'.$this->num.'.pdf');
			exit;*/
			return $pdf;
// 		}
// 		return false;
	}

}

?>