<?php
/***************************************************************************************************************************
 *
 * 		BDD.class.php
 *
 *
 * 		Copyright 2009 - Cunéaz Léo
 *
 ****************************************************************************************************************************/
class BDD
{
	public static $dbPDO;

	public static function connectBDD($chaineConnexion, $user, $password)
	{
		try
		{
			@self :: $dbPDO = new PDO($chaineConnexion,$user,$password);
		}
		catch(PDOException $e)
		{
			self :: affErreur($e->getMessage());
		}
	}

	public static function affErreur($message)
	{
		echo '<h1 style="font-size: 3em;">'.$message.'</h1>';
	}
	public static function getInstance()
	{
		return self :: $dbPDO;
	}
	public static function execSimpleReq($req, $param = null)
	{
			
		$r = self :: $dbPDO -> prepare($req);
			
		if(!is_array($param))
		$r -> execute($param);
		else
		$r -> execute($param);

			
		if($r->rowCount() >= 1)
		return $r -> fetch(PDO::FETCH_ASSOC);
		else
		return false;
			
	}

	public static function execReq($req, $param = null)
	{
		$r = self :: $dbPDO -> prepare($req);
			
		if(!is_array($param))
		$r -> execute();
		else
		$r -> execute($param);

		return $r;
	}

	public static function mysqlDateFr($date)
	{
		if(!empty($date))
		{
			$split = explode("-",$date);
			$annee = $split[0];
			$mois = $split[1];
			$jour = $split[2];
			return $jour."/".$mois."/".$annee;
		}
		else
		return '';
	}

	public static function mysqlDateUs($date)
	{
		if(!empty($date))
		{
			$split = explode("/",$date);
			$annee = $split[2];
			$mois = $split[1];
			$jour = $split[0];
			return $annee.'-'.$mois.'-'.$jour;
		}
		else
		return '';
	}

	public static function execIUReq($req, $param = null)
	{
		$r = self :: $dbPDO -> prepare($req);
			
		if(!is_array($param))
		$r -> execute();
		else
		$r -> execute($param);

		return $r->errorInfo();
	}

	public static function getRewritedText($str)
	{
		$purified = '';
		$length = strlen($str);
		if ($utf8_decode)
			$str = utf8_decode($str);
		for ($i = 0; $i < $length; $i++)
		{
			$char = substr($str, $i, 1);
			if (strlen(htmlentities($char)) > 1)
			{
				$entity = htmlentities($char, ENT_COMPAT, 'UTF-8');
				$purified .= $entity{1};
			}
			elseif (preg_match('|[[:alpha:]]{1}|u', $char))
				$purified .= $char;
			elseif (preg_match('<[[:digit:]]|-{1}>', $char))
				$purified .= $char;
			elseif ($char == ' ')
				$purified .= '-';
		}
		return trim(strtolower($purified));
	}
}
?>
