<?php
/**
 *
 * @param $identifiant
 * @param $id_liste
 * @return unknown_type
 */
class CReferencement {

	public $id_modele_html;
	public $identifiant="";
	public $identifiant_liste = "";
	public $identifiant_bloc ="";
	public $balise_liste = "#LISTE_ELEMS#";
	public $balise_lien = "#LIEN_ELEM#";
	public $identifiant_page_liste_html ="";
	public $identifiant_page_element_html ="";
	public $titre_menu = "";
	public $est_liste = true;
	public $is_flash = true;
	
	public $use_cache = "NON";
	public $duree_cache=0;

	public $select = "";
	public $from = "";
	public $where = "";
	public $fn_contenu = "";
	
	public $url_element;
	public $reperage_element;
	public $params_element;
	public $url_liste;
	public $reperage_liste;
	public $balise_liste_pages="#LISTE_PAGES#";
	
	public $nb_par_page=20;
	public $param_num_page="";

	/**
	 *
	 * @param $identifiant
	 * @param $id_liste
	 * @return unknown_type
	 */
	public function CReferencement($identifiant,$id_liste) {
		$this->identifiant = $identifiant;
		$this->identifiant_liste = $id_liste;
	}

	public function set_bloc_html($identifiant,$contenu_html = null,$titre = null, $description= null, $motscles= null, $css= null) {
		if($contenu_html != null) $this->insere_contenu_html($identifiant,$contenu_html,$titre, $description, $motscles,$css);
		$this->identifiant_bloc = $identifiant;
	}

	public function set_page_liste_html($identifiant,$contenu_html = null,$titre = null, $description= null, $motscles= null, $css= null) {
		if($contenu_html != null) $this->insere_contenu_html($identifiant,$contenu_html,$titre, $description, $motscles,$css);
		$this->identifiant_page_liste_html = $identifiant;
	}
	public function set_page_element_html($identifiant,$contenu_html = null,$titre = null, $description= null, $motscles= null, $css= null) {
		// rajouter mots_cles + desc
		if($contenu_html != null) $this->insere_contenu_html($identifiant,$contenu_html,$titre, $description, $motscles,$css);
		$this->identifiant_page_element_html = $identifiant;
	}
	
	public function set_use_cache($type="FICHIER",$duree = 3600) {
		$this->use_cache = $type;
		$this->duree_cache = $duree;
	}
	
	private function insere_contenu_html($identifiant,$contenu_html,$titre= null, $description= null, $motscles= null, $css= null) {
		
		$donnees = array("identifiant"=>$identifiant,"html"=>$contenu_html);
		if ($description != null) $donnees['description'] = $description;
		if ($motscles != null) $donnees['mots_cles'] = $motscles;
		if ($css != null) $donnees['css'] = $css;
		if ($titre != null) $donnees['titre'] = $titre;
		
		CListes::insere_update("site_pages_html",$donnees,"identifiant");
	}
	/**
	 * 
	 * @param $url_element
	 * @param $reperage_element
	 * @param $params_element
	 * @param $champ_element champ qui sert au repérage d'un élément ("id_auto" par défaut)
	 * @return unknown_type
	 */
	public function set_url_element($url_element,$reperage_element = null,$params_element = null,$champ_element="id_auto"){
		$this->url_element=$url_element;
		if ($reperage_element != null)
			$this->reperage_element=$reperage_element;
		if ($params_element != null)
			$this->params_element=$champ_element.",".$params_element;
	}
	
	/**
	 * permet de définir l'url vers la liste, le repérage de la page liste, et les numéros de pages
	 * @param $url_liste = url de la liste premiere ('/actus')
	 * @param $reperage_liste = détection de la liste (et des pages) ('/actus(/page([0-9]+))?')
	 * @param $param_num_page = parametre qui représente le numéro de la page ('$2')
	 * @param $url_page = methode de construction de l'url d'une page ('/actus/page#NUM#')
	 * @param $balise_liste_pages (facultatif = #LISTE_PAGES#) = balise dans la page liste qui permet de poser la liste des pages('#LISTE_PAGES#')
	 * 
	 * @param $nb_par_page (facultatif = 15) = nombre d'elements par page
	 * @return rien
	 */
	public function set_url_liste($url_liste,$reperage_liste,$param_num_page,$url_page,$balise_liste_pages="#LISTE_PAGES#",$nb_par_page=null) {
		$this->url_liste=$url_liste;
		$this->url_page_liste=$url_page;
		$this->reperage_liste=$reperage_liste;
		$this->param_num_page = $param_num_page;
		$this->balise_liste_pages = $balise_liste_pages;
		if($nb_par_page != null) $this->nb_par_page = $nb_par_page;
	}

	public function save() {
		$res_liste = CListes::get_liste($this->identifiant_liste);
	
		include_once 'modules/site/fonctions_site.inc.php';
		$params=$this->identifiant.",".$this->identifiant_liste;
		site_definit_page("ref_liste_".$this->identifiant,$this->reperage_liste,"site","",$this->id_modele_html,"",$params.",".$this->param_num_page,NULL,NULL,NULL,0,NULL,NULL,NULL,1,NULL,NULL,"CPageReferencementListe","index, follow, all",$this->is_flash);
		CListes::update("site_pages",array("identifiant"=>"ref_liste_".$this->identifiant,"use_cache"=>$this->use_cache,"duree_cache"=>$this->duree_cache),"identifiant");
		$id_page_element_html=-1;
		if($res_page = CListes::get_elem_by("site_pages_html","identifiant",$this->identifiant_page_element_html))
			$id_page_element_html = $res_page["id_auto"];
			
		$id_page_liste_html=-1;
		if($res_page = CListes::get_elem_by("site_pages_html","identifiant",$this->identifiant_page_liste_html))
			$id_page_liste_html = $res_page["id_auto"];
			
		$id_bloc_html=-1;
		if($res_page = CListes::get_elem_by("site_pages_html","identifiant",$this->identifiant_bloc))
			$id_bloc_html = $res_page["id_auto"];
		
		site_definit_page("ref_elem_".$this->identifiant,$this->reperage_element,"site","",$this->id_modele_html,"",$params.",".$this->params_element,NULL,NULL,NULL,0,NULL,NULL,NULL,1,NULL,NULL,"CPageReferencementElem","index, follow, all",$this->is_flash);
		CListes::update("site_pages",array("identifiant"=>"ref_elem_".$this->identifiant,"use_cache"=>$this->use_cache,"duree_cache"=>$this->duree_cache),"identifiant");
		
		$donnees=array("identifiant"=>$this->identifiant,
				"id_liste"=>$res_liste["id_auto"],
				"id_page_liste_html"=>$id_page_liste_html,
				"id_bloc_html"=>$id_bloc_html,
				"id_page_element_html"=>$id_page_element_html,
				"est_liste"=>$this->est_liste?"1":"0",
				"select"=>$this->select,				
				"from"=>$this->from,				
				"where"=>$this->where,				
				"fn_contenu"=>$this->fn_contenu,
				"titre_menu"=>$this->titre_menu,
				"balise_liste"=>$this->balise_liste,
				"balise_lien"=>$this->balise_lien,
				"url_element"=>$this->url_element,
				"url_liste"=>$this->url_liste,
				"nb_par_page"=>$this->nb_par_page,
				"balise_liste_pages"=>$this->balise_liste_pages,
				"url_page_liste"=>$this->url_page_liste
		);
		//print_rr($donnees);
		CListes::insere_update("referencement_liste",$donnees,"identifiant");
	}

	public static function __installe() {
		// TODO : finir !!
		CListes::dropListe("site_blocs_html");
//		CListes::add_liste2("site_blocs_html","site__blocs_html","blocs html","Gestion des blocs html du site","contenu HTML","FSE.site");
//		CListes::add_champ_liste("site_blocs_html","identifiant","VARCHAR(255)","identifiant","identifiant","identifiant du bloc HTML","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
//		CListes::add_champ_liste("site_blocs_html","html","TEXT","html","contenu html","contenu HTML du bloc","(.*)",NULL,"NOT NULL","longtext",NULL,"short html");
//		CListes::add_champ_liste("site_blocs_html","titre_menu","VARCHAR(255)","titre_menu","titre_menu","titre du bloc dans le menu","(.*)",NULL,"NOT NULL");
//		CListes::add_cle_unique("site_blocs_html","identifiant");

		//CListes::dropListe("referencement_liste");
		CListes::add_liste2("referencement_liste","site__referencement_liste","référencements","Gestion des pages de référencement","référencement","FSE.site");
		CListes::set_champ_liste_etranger("referencement_liste","id_liste","lis__listes","id_auto","liste #IDENTIFIANT#");
//		CListes::drop_champ_liste("referencement_liste","str_reperage_liste");
		CListes::add_champ_liste_etranger("referencement_liste","id_page_liste_html","site__pages_html","id_auto","#IDENTIFIANT#");
		CListes::add_description_champ("referencement_liste","id_page_liste_html","page liste","page liste","page html de l'affichage par liste");
		CListes::add_champ_liste_etranger("referencement_liste","id_page_element_html","site__pages_html","id_auto","#IDENTIFIANT#");
		CListes::add_description_champ("referencement_liste","id_page_element_html","page elem","page elem","page html de l'affichage d'un élément de la liste");
		CListes::add_champ_liste_etranger("referencement_liste","id_bloc_html","site__pages_html","id_auto","#IDENTIFIANT#",NULL,"NULL");
		CListes::add_description_champ("referencement_liste","id_bloc_html","bloc","bloc","bloc html de chaque élément dans l'affichage par liste");
		CListes::add_champ_liste("referencement_liste","url_element","VARCHAR(255)","url_element","url_element","url_element","(.+)",NULL,"NOT NULL",NULL,NULL,NULL);
		CListes::add_champ_liste("referencement_liste","identifiant","VARCHAR(255)","identifiant","identifiant","identifiant du référencement","(.+)",NULL,"NOT NULL",NULL,NULL,NULL);
		CListes::add_champ_liste("referencement_liste","select","VARCHAR(255)","select","select additionnel","select additionnel du référencement(l.* ', xxx')","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
		CListes::add_champ_liste("referencement_liste","from","VARCHAR(255)","from","from additionnel","from additionnel du référencement(from liste l ', xxx')","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
		CListes::add_champ_liste("referencement_liste","where","VARCHAR(255)","where","where","where du référencement (l = liste)","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
		CListes::add_champ_liste("referencement_liste","fn_contenu","VARCHAR(255)","fn_contenu","fn_contenu","fonction qui transforme le contenu (vide = contenu par défaut)","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
		CListes::add_champ_liste("referencement_liste","titre_menu","VARCHAR(255)","titre_menu","titre_menu","titre du bloc dans le menu","(.*)",NULL,"NOT NULL");
		CListes::add_champ_liste("referencement_liste","balise_liste","VARCHAR(50)","balise_liste","balise_liste","Chaine repérage de la liste dans le contenu HTML de la liste","(.*)",NULL,"NOT NULL");
		CListes::add_champ_liste("referencement_liste","balise_lien","VARCHAR(50)","balise_lien","balise_lien","Chaine repérage du lien vers un element dans le contenu HTML d'un élément de la liste","(.*)",NULL,"NOT NULL");
		CListes::add_champ_liste("referencement_liste","est_liste","TINYINT(1)","est_liste","est_liste","est_liste","(0|1)",NULL,"NOT NULL",NULL,NULL,NULL);
		CListes::add_champ_liste("referencement_liste","nb_par_page","SMALLINT(4)");
		CListes::add_champ_liste("referencement_liste","url_page_liste","VARCHAR(255)");
		CListes::add_champ_liste("referencement_liste","url_liste","VARCHAR(255)");
		CListes::add_champ_liste("referencement_liste","balise_liste_pages","VARCHAR(255)");


	}
}
?>