<?php

class PaiementForm{
	
	protected $formulaire;
	
	public function __construct($obj = null){
		
		$form = new TForm('Paiement');
		$form->setClassCSS('form_edit');
		
		$form->add('Hidden')->name('new')->value('new');
		
		$form->add('Text')->label('Titre')->name('titre')->value($obj->titre);
		
		//Clé étrangére enete
		$int_ent = new Intitule_entete();
		$int_ent = $int_ent->findOneBy('id',4);
		$select = array($int_ent->id => $int_ent->titre);
		
		$form->add('Select')
			->label('Intitulé d\'entête')
			->name('id_intitule_entete')
			->options($select)
			->defaultChoice(4); //FACTURE

		if($obj->duree_valid < 2) 
			$txt = 	$obj->duree_valid.' an';
		else
			$txt = 	$obj->duree_valid.' ans';
			
		$form->add('Select')
			->label('Paiment pour')
			->name('duree_valid')
			->options(array($obj->duree_valid=>$txt))
			->readonly();
		
		$form->add('Text')->label('TVA')->name('tva')->value($obj->tva);
		$form->add('Text')->label('Total HT (1 an)')->name('total')->value($obj->total)->readonly();
		
		$form->add('Text')->label('Total TVA (1 an)')->name('total_tva')->value($obj->total_tva)->readonly();
		$form->add('Text')->label('Total TTC (1 an)')->name('total_ttc')->value($obj->total_ttc)->readonly();
		
		//Liste ou client rataché
		if(isset($_GET['id_client']) && $_GET['id_client']!=""){
			$form->add('Hidden')->name('id_client')->value($_GET['id_client']);
		}
		else{
			//Clé étrangère client
			$clients = new Clients();
			$select = $clients->findAllForForm('id','nom');
			$form->add('Select')->label('Client')->name('id_client')->options($select);
		}
		
		
		$this->formulaire = $form;
	}
	
	public function getForm(){
		return $this->formulaire;
	}
	
	 
	
	
}


?>