<?php
class Rech_Indexeur {
	public static $affiche_phrases = false;
	private static $use_stats = true;

	private $index_mots;
	private $tab_index_specs_page;
	private $tab_index_specs;

	/** mot / metaphone / racine */
	public static $cle_unique_mot = "racine"; // par d�faut

	public function Rech_Indexeur($use_stats = false) {

	}
	/**
	 * ins�re une page dans l'index. Le contenu est calcul� lors de cette �tape, d'apr�s le type et l'id
	 * @param $type_page : nom du type de la page
	 * @param $id_page
	 * @return Boolean : le r�sultat de l'indexation
	 */
	public function indexe_page($id_type_page,$id_page_type) {
		//		MysqlTransaction::begin(100,"My2");
		/*$res_type_page = $this->get_type_page($id_type_page);
		 //$id_type_page = $res_type_page["id_type_page"];
		 include_once $res_type_page["class_path"];
		 $classe_page = $res_type_page["class_name"];

		 $page = new $classe_page($id_page_type);*/
		if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::construction page");
		$page=$this->get_classe_page($id_type_page,$id_page_type);

		$page->init_index();
		//$page = new Rech_Page($id_page);
		if(Rech_Indexeur::$use_stats) CStat::SFinStat();
		$mots_page = $page->get_tableau_mots();

		if(Rech_Indexeur::$affiche_phrases){
			include_once RECH_INCLUDE_PATH.'utils/utils.inc.php';
			print_r_tableau_html_trie($mots_page["mots"],"poids");
		}


		if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::ajoute_page");
		$id_page = $this->ajoute_page($id_type_page,$id_page_type);

		$this->indexe_specs($id_type_page,$id_page,$page);

		if($id_page) {
			$this->indexe_mots($id_page,$mots_page);
			if($this->set_page_indexee($id_page)) {
				if(Rech_Indexeur::$use_stats) CStat::SFinStat();
				//				MysqlTransaction::commit();

				return true;
			}
		}
		if(Rech_Indexeur::$use_stats) CStat::SFinStat();
		//		MysqlTransaction::commit();

		return false;
	}

	public function get_classe_page($id_type_page,$id_page_type) {
		$res_type_page = $this->get_type_page($id_type_page);
		//$id_type_page = $res_type_page["id_type_page"];
		include_once $res_type_page["class_path"];
		$classe_page = $res_type_page["class_name"];

		if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::construction page");
		return new $classe_page($id_page_type);
	}



	public function init_index_specs() {
		if(is_array($this->tab_index_specs_page)) return;

		$this->tab_index_specs_page=array();
		$this->tab_index_specs=array();
		if($query=ifReq("SELECT * FROM ".RECH_BASE.RECH_TABLE_TYPE_SPEC)) {
			while($res=mysql_fetch_assoc($query)) {
				$this->tab_index_specs_page[$res["id_type_page"]] []= $res;
				$this->tab_index_specs[$res["id_type_spec"]] = $res;
				$this->tab_index_specs_nom[$res["identifiant"]][] = $res;
			}
		}
	}

	public function get_specs_par_nom($nom) {
		$this->init_index_specs();
		return $this->tab_index_specs_nom[$nom] ;
	}
	// non, car multiple !
	// a refaire !
	//	public function get_id_spec_par_nom($nom) {
	//		$this->init_index_specs();
	//		return $this->tab_index_specs_nom[$nom]["id_type_spec"] ;
	//	}

	public function indexe_specs($id_type_page,$id_page,&$page) {
		$this->init_index_specs();
		if(is_array($this->tab_index_specs_page[$id_type_page])) {
			foreach($this->tab_index_specs_page[$id_type_page] as $type_spec) {
				$val_spec=$page->get_spec($type_spec["identifiant"]);
				$this->set_spec_val($type_spec["id_type_spec"],$id_page,$val_spec);

			}
		}
	}

	public function set_spec_val($id_type_spec,$id_page,$val_spec) {
		$this->init_index_specs();
		$type_spec=$this->tab_index_specs[$id_type_spec];
		$type_val = $type_spec["type_val"];
		if(!empty($type_spec["frequence"])) $set_validite=" , validite=NOW()+INTERVAL ".$type_spec["frequence"];
		else $set_validite=" , validite=NULL";

		$req = "INSERT INTO ".RECH_BASE.RECH_TABLE_SPEC_VAL."
				SET id_type_spec = $id_type_spec, id_page=$id_page , valeur_$type_val = '$val_spec' $set_validite
				ON DUPLICATE KEY UPDATE valeur_$type_val = '$val_spec' $set_validite";
		ifReq($req);

		if($type_spec["integree"]==1) {
			$req = "UPDATE ".RECH_BASE.RECH_TABLE_PAGE."
				SET $type_spec[identifiant] = '$val_spec' WHERE  id_page=$id_page";
			//			echo $req;
			//			exit;
			ifReq($req);
		}
	}

	/**
	 * ajoute une page au dictionnaire g�n�ral des pages existantes, et renvoie son id;
	 * si la page existe, on renvoie son id;
	 * si l'insertion �choue , ou renvoie false.
	 * @param $id_type_page
	 * @param $id_page_type
	 * @return unknown_type
	 */
	public function ajoute_page($id_type_page,$id_page_type,$set_valide=NULL) {
		$this->init_index_pages();
		$this->init_index_mots();

		// si deja en m�moire dans l'indexeur
		$id_retour=false;
		if(!empty($this->index_pages[$id_type_page.'_'.$id_page_type]))
		$id_retour=$this->index_pages[$id_type_page.'_'.$id_page_type];
		else if($res_page = testReq3("SELECT id_page FROM ".RECH_BASE.RECH_TABLE_PAGE." WHERE id_type_page = $id_type_page AND id_page_type = '$id_page_type'")) {
			// la page existe
			$id_retour= $res_page["id_page"];
			$this->index_pages[$id_type_page.'_'.$id_page_type] = $id_retour;
		} else {
			// page existe pas, on la cr�e
			if(ifReq("INSERT INTO ".RECH_BASE.RECH_TABLE_PAGE." SET id_type_page = '$id_type_page' , id_page_type='$id_page_type'")) {
				$id_retour = mysql_insert_id();
				$this->index_pages[$id_type_page.'_'.$id_page_type] = $id_retour;
			}
		}
		if($id_retour && $set_valide !== NULL)
		ifReq("UPDATE ".RECH_BASE.RECH_TABLE_PAGE." SET index_valide = $set_valide WHERE id_page = $res_page[id_page]");
		return $id_retour;
	}

	public function init_index_pages() {
		if(is_array($this->index_pages)) return;

		if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::init_index_pages()");

		if($query_mots = ifReq("SELECT id_page,id_type_page,id_page_type FROM ".RECH_BASE.RECH_TABLE_PAGE)) {
			while($res_mot = mysql_fetch_array($query_mots,MYSQL_NUM)) {
				$this->index_pages[$res_mot[1].'_'.$res_mot[2]] = $res_mot[0];
			}
		}
		if(Rech_Indexeur::$use_stats) CStat::SFinStat();
	}
	/**
	 * comme ajoute_page , mais avec un nom de type
	 * @see ajoute_page
	 * @param $nom_type_page
	 * @param $id_page_type
	 * @return unknown_type
	 */
	public function ajoute_page_type($nom_type_page,$id_page_type,$set_valide=NULL) {
		$res_type_page = $this->get_type_page($nom_type_page,"identifiant");
		$id_type_page = $res_type_page["id_type_page"];
		return $this->ajoute_page($id_type_page,$id_page_type,$set_valide);
	}

	/**
	 * d�finit la page comme index�e
	 * @param $id_page
	 * @return unknown_type
	 */
	public function set_page_indexee($id_page) {
		return ifReq("UPDATE ".RECH_BASE.RECH_TABLE_PAGE." SET indexee = 1 , index_valide = 1 , date_index = NOW() WHERE id_page = $id_page");
	}


	/**
	 * mise a jour des poids totaux des mots du site
	 * @return unknown_type
	 */
	public function maj_poids_total() {
		Rech_Maintenance::maj_poids_total();
	}


	/**
	 * ins�re une liste de mots cl�s pour une page donn�e;
	 * les mots anciennement pr�sents sont d�sindex�s.
	 * @param $id_page
	 * @param $mots_page
	 * @return unknown_type
	 */
	public function indexe_mots($id_page,&$mots_page) {
		if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::desindexe_mots");
		$this->desindexe_mots($id_page);
		if(Rech_Indexeur::$use_stats) CStat::SFinStat();

		$mots = $mots_page["mots"];
		if(is_array($mots))
		foreach($mots as $un_mot) {
			if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::insere mot");

			$id_mot = $this->insereMot($un_mot,NULL,0,$un_mot["poids"]);
			if($id_mot) {
				if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::insere mot page");

				ifReq("INSERT INTO ".RECH_BASE.RECH_TABLE_MOT_CLE_PAGE." SET id_mot_cle = $id_mot, id_page = $id_page, poids = $un_mot[poids]");
				if(Rech_Indexeur::$use_stats) CStat::SFinStat();

			}
		}
	}

	/**
	 * ins�re un mot non normalis�
	 * @param $un_mot_simple : String
	 * @return d_du_mot ou false
	 */
	public function insereMotSimple($un_mot_simple) {
		Rech_Parseur::init_parseur();
		return $this->insereMot(Rech_Parseur::mot_to_complexe(Rech_Parseur::normalise_chaine($un_mot_simple)));
	}
	/**
	 * ajoute un mot au dictionnaire g�n�ral des mots existants, et renvoie son id;
	 * si le mot existe, on renvoie son id;
	 * si l'insertion �choue , ou renvoie false.
	 * @param $un_mot : un mot complexe
	 * @param $id_parent
	 * @return id_du_mot ou false
	 */
	public function insereMot($un_mot,$id_parent=NULL,$supplementaire=0,$poids_total=0) {
		$valeur_unique_mot = $un_mot[Rech_Indexeur::$cle_unique_mot];
			
		// si deja en m�moire dans l'indexeur
		if(!empty($this->index_mots[$valeur_unique_mot]) && $id_parent === NULL)
		return $this->index_mots[$valeur_unique_mot];

		// si pas encore en m�moire ds l'indexeur
		if($res_mot = testReq3("SELECT id_mot_cle FROM ".RECH_BASE.RECH_TABLE_MOT_CLE." WHERE ".Rech_Indexeur::$cle_unique_mot."='$valeur_unique_mot'")) {
			$this->index_mots[$valeur_unique_mot] = $res_mot["id_mot_cle"];
			if($id_parent !== NULL ) {
				// mise a jour si besoin de modif : $id_parent ou supplementaire
				ifReq("UPDATE ".RECH_BASE.RECH_TABLE_MOT_CLE." SET id_mot_parent=$id_parent,mot_supplementaire=$supplementaire WHERE id_mot_cle = ".$res_mot["id_mot_cle"]);
			}
			return $res_mot["id_mot_cle"];
		}



		$is_numeric = is_numeric($un_mot["mot"])?"1":"0";
		$SET_parent=($id_parent === NULL )?"":", id_mot_parent = $id_parent";
		$SET_supplementaire=($supplementaire === NULL )?"":", mot_supplementaire = $supplementaire";
		if($res=ifReq("INSERT INTO ".RECH_BASE.RECH_TABLE_MOT_CLE." SET
					mot='$un_mot[mot]' ,
					metaphone='$un_mot[metaphone]',
					racine='$un_mot[racine]', 
					phonex='$un_mot[phonex]' $SET_parent $SET_supplementaire , is_numeric=$is_numeric")) 
		{
			$id_insere = mysql_insert_id();
			if(MEMORISE_LEVENSHTEIN === true) $this->mise_a_jour_levenshtein($un_mot,$id_insere,$poids_total);
			$this->index_mots[$valeur_unique_mot] = $id_insere;

			return $id_insere;
		}
		return false;
	}

	public function mise_a_jour_levenshtein($mot_cmplx,$id_nouveau_mot,$poids_total) {
		// ///////////////dd
		$champ_levenshtein = CHAMP_LEVENSHTEIN;
		$lng=strlen($mot_cmplx[$champ_levenshtein]);

		$lng_min=floor($lng*(1-POURCENT_LONGUEUR_LEVENSHTEIN));
		$lng_max=ceil($lng*(1+POURCENT_LONGUEUR_LEVENSHTEIN));
		$req="SELECT l.mot,ratio FROM ".RECH_BASE.RECH_TABLE_LEVENSHTEIN." l
			WHERE est_manuel = 0 AND CHAR_LENGTH(l.mot)>=$lng_min AND CHAR_LENGTH(l.mot)<=$lng_max";
		$liste_levenshtein = mysql_fetch_all(ifReq($req));
		foreach($liste_levenshtein as $un_lev) {
			$ratio_final = Rech_Parseur::calcule_ratio_levenshtein($mot_cmplx[$champ_levenshtein],$un_lev["mot"],$poids_total);
			if($ratio_final > $un_lev["ratio"]) {
				ifReq("UPDATE ".RECH_BASE.RECH_TABLE_LEVENSHTEIN." SET ratio=$ratio_final , id_mot_cle=$id_nouveau_mot WHERE mot='$un_lev[mot]'");
			}
		}
		//exit;
	}

	public function init_index_mots() {
		if(is_array($this->index_mots)) return;

		if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::init_index_mots()");

		$cle_unique_mot = Rech_Indexeur::$cle_unique_mot;
		if($query_mots = ifReq("SELECT id_mot_cle,$cle_unique_mot FROM ".RECH_BASE.RECH_TABLE_MOT_CLE)) {
			while($res_mot = mysql_fetch_array($query_mots,MYSQL_NUM)) {
				$this->index_mots[$res_mot[1]] = $res_mot[0];
			}
		}
		if(Rech_Indexeur::$use_stats) CStat::SFinStat();

	}

	public function desindexe_mots($id_page) {
		return ifReq("DELETE FROM ".RECH_BASE.RECH_TABLE_MOT_CLE_PAGE." WHERE id_page = $id_page");
	}


	/**
	 * retire une page de l'index
	 * @param $id_type_page
	 * @param $id_page_type
	 * @return Boolean : le r�sultat de la d�sindexation
	 */
	public function desindexe_page($id_type_page,$id_page_type) {
		if($res_page = testReq3("SELECT id_page, indexee FROM ".RECH_BASE.RECH_TABLE_PAGE." WHERE id_type_page = $id_type_page AND id_page_type = '$id_page_type'")) {
			$id_page = $res_page["id_page"];
			if($res_page["indexee"]==1){
				if($this->desindexe_mots($id_page)) {
					return ifReq("UPDATE ".RECH_BASE.RECH_TABLE_PAGE." SET indexee = 0 WHERE id_page = $res_page[id_page]");
				}

			}
		}
		return true;
	}
	/**
	 * efface la page , les mots
	 * @param $id_type_page
	 * @param $id_page_type
	 * @return unknown_type
	 */
	public function efface_page($id_type_page,$id_page_type) {
		if($this->desindexe_page($id_type_page,$id_page_type)) {
			return ifReq("DELETE FROM ".RECH_BASE.RECH_TABLE_PAGE." WHERE id_page_type = $id_page_type AND id_type_page = $id_type_page ");
		}
	}

	public function mtn_efface_mots_pages_disparues() {
		return ifReq("DELETE FROM ".RECH_BASE.RECH_TABLE_MOT_CLE_PAGE." WHERE id_page NOT IN(SELECT id_page FROM ".RECH_BASE.RECH_TABLE_PAGE." WHERE indexee = 1)");
	}
	public function mtn_efface_mots_inutilises() {
		return ifReq("DELETE FROM ".RECH_BASE.RECH_TABLE_MOT_CLE." WHERE id_mot_cle NOT IN (SELECT id_mot_cle FROM ".RECH_BASE.RECH_TABLE_MOT_CLE_PAGE.")");
	}


	public function get_type_page($id_type_page,$par="id_type_page") {
		if(Rech_Indexeur::$use_stats) CStat::SDebutStat("Indexeur::get_type_page()");
		// optimisation : mise en m�moire des types de pages
		if(!empty($this->index_types_pages[$id_type_page])) {
			if(Rech_Indexeur::$use_stats) CStat::SFinStat();
			return $this->index_types_pages[$id_type_page];
		}

		$retour = testReq3("SELECT * FROM ".RECH_BASE.RECH_TABLE_TYPE_PAGE." WHERE $par = '$id_type_page'");
		$this->index_types_pages[$retour["id_type_page"]] = $retour;
		$this->index_types_pages[$retour["identifiant"]] = $retour;
		if(Rech_Indexeur::$use_stats) CStat::SFinStat();
		return $retour;
	}

	public function get_stats() {
		$retour=array();
		$retour["index_mots"]=count($this->index_mots);
		return $retour;
	}
}
?>