<?php
define("CLE_IMAGE","sdfsdf");
define("IMAGE_QUALITE_STOCKAGE","BEST");
define("IMAGE_QUALITE_REDIM","BEST");
define("IMAGE_QUALITE_LOW","LOW");
define("IMAGE_QUALITE_VERYLOW","VERYLOW");
//include_once 'modules/listes/classes/CListes.class.php';//auto
//include_once 'modules/base/classes/CFichiers.class.php';//auto
include_once 'includes/general/str_url.inc.php';
include_once 'includes/general/nombres.inc.php';
class CImages{
	static $prefixe="px/";
	static $IMAGE_QUALITE_JPG_VERYLOW=30;
	static $IMAGE_QUALITE_JPG_LOW=50;
	static $IMAGE_QUALITE_JPG_GOOD=80;
	static $IMAGE_QUALITE_JPG_BEST=95;
	static $IMAGE_QUALITE_PNG_VERYLOW=3;
	static $IMAGE_QUALITE_PNG_LOW=5;
	static $IMAGE_QUALITE_PNG_GOOD=8;
	static $IMAGE_QUALITE_PNG_BEST=9;

	public static $IDENTIFIANT_IMAGE_DEFAUT='';

	//TODO !
	public static $no_cache_image = false;

	static function get_image_path_from_id($identifiant_liste,$nom_colonne,$id_auto) {
		if($res_elem=CListes::get_elem_by_id($identifiant_liste,$id_auto)) {
			return CImages::get_image_public_path_from_res($identifiant_liste,$nom_colonne,$res_elem);
		} else {
			trace_erreur("erreur get liste $identifiant_liste");
		}
	}
	//	static function resetRedim($path, $file='',$recursif = true)
	//	{
	//		empty_redim_fichier($path.$file);
	//	}
	static function calcule_md5($fichier,$largeur,$hauteur,$type) {
		$chaine_md5=CLE_IMAGE.".$fichier.-.$hauteur.-.$largeur.-.".strtoupper($type).".".CLE_IMAGE;
		//		echo "$chaine_md5 = $chaine_md5 ".substr(md5($chaine_md5),5,5);
		return substr(md5($chaine_md5),5,5);
	}
	static function get_image_redim_path_from_id($identifiant_liste,$nom_colonne,$id_auto,$largeur,$hauteur,$type) {
		$path = self :: get_image_path_from_id($identifiant_liste,$nom_colonne,$id_auto);

		$detail_fichier = split_fichier($path);

		$md5=CImages::calcule_md5($detail_fichier[fichier],$largeur,$hauteur,$type);
		return "$detail_fichier[chemin]/$detail_fichier[fichier_base]_{$largeur}_{$hauteur}_{$type}_{$md5}.$detail_fichier[extension]".(self::$no_cache_image?"?".genereCode(5):"");
			
	}

	static function get_image_redim_path_from_path($path,$largeur,$hauteur,$type) {
		$detail_fichier = split_fichier($path);

		$md5=CImages::calcule_md5($detail_fichier[fichier],$largeur,$hauteur,$type);
		return "$detail_fichier[chemin]/$detail_fichier[fichier_base]_{$largeur}_{$hauteur}_{$type}_{$md5}.$detail_fichier[extension]".(self::$no_cache_image?"?".genereCode(5):"");
			
	}
	static function get_image_redim_public_path_from_res($identifiant_liste,$nom_colonne,$res_elem,$largeur,$hauteur,$type) {
		if (empty($res_elem[$nom_colonne]) || !ereg("[.](gif|GIF|jpg|JPG|png|PNG)$", $res_elem[$nom_colonne]))
		{
			$id_image = $identifiant_liste;
			if (CImages::$IDENTIFIANT_IMAGE_DEFAUT != '') $id_image = CImages::$IDENTIFIANT_IMAGE_DEFAUT;

			$tab_default_res = CListes::get_elem_by('images_defaut','identifiant', $id_image);
			if ($tab_default_res['image'] == 'no_image') {
				return '';
			}
			//array('identifiant'=>$id_image, 'image'=>$id_image.'.jpg');
			return CImages::get_image_redim_path_from_path(CImages::get_image_public_path_from_res('images_defaut','image',$tab_default_res),$largeur,$hauteur,$type);
		}
		return CImages::get_image_redim_path_from_path(CImages::get_image_public_path_from_res($identifiant_liste,$nom_colonne,$res_elem),$largeur,$hauteur,$type);
	}
	static function get_image_public_path_from_res($identifiant_liste,$nom_colonne,$res_elem,$pfx_racine="/") {
		//include_once 'modules/base/classes/CFichiers.class.php';//auto
		return CFichiers::get_fichier_public_path_from_res($pfx_racine.CImages::$prefixe,$identifiant_liste,$nom_colonne,$res_elem);
	}

	static function readImage($identifiant_liste,$nom_colonne,$valeur,$fichier) {
		if($path=CImages::get_server_image_path($identifiant_liste,$nom_colonne,$valeur,$fichier)) {
			
			ini_set("memory_limit",'128M');
			
			$extension = get_extension($path);
			switch($extension) {
				case "jpg":
				case "jpe":
					$extension="jpeg";
					break;
			}
				
			header("Content-type: image/".strtolower($extension));
			header("Content-Length: " . filesize($path));
			// Cache images
			CFichiers::gereCacheEnFonctionDuType('image');
				
			@readfile($path);
			exit;
		} else {
			//include_once 'modules/site/classes/CSite.class.php';//auto
			CSite::erreur404();
		}
	}
	static function get_server_image_path($identifiant_liste,$nom_colonne,$valeur,$fichier) {
		if(!$liste=CListes::get_liste($identifiant_liste,false)) {
			if (DEBUGGER) echo "liste '$identifiant_liste' non trouvée";
			return false;
		}
		if(!($res_desc_img = CFichiers::getDescUpload($identifiant_liste,$nom_colonne))) {
			if (DEBUGGER) echo "description non trouvée";
			return false;
		}
		$valeur=str_replace("-","_",$valeur);
		$req="SELECT $res_desc_img[serv_colonne_path] FROM `$liste[table]` WHERE $res_desc_img[url_colonne_path] LIKE '$valeur' LIMIT 0,1 ";
		if($res=testReq3($req)) {
			return CImages::get_server_image_path_from_res($liste,$res_desc_img,$res,$fichier);
		}
	}
	static function get_server_image_path_from_res($res_liste,$res_desc_img,$res_elem,$fichier) {
		$fichier  = titreToFichier($fichier);

		if($res_elem) {

			$longueur_chemin=$res_desc_img["serv_longueur_path"];
			if($longueur_chemin == 0) {
				$dossier_serveur = $res_elem[$res_desc_img["serv_colonne_path"]];
			} else {
				$dossier_serveur = toNch($res_elem[$res_desc_img["serv_colonne_path"]],$longueur_chemin);
				if(UPLOAD_LONGUEUR_DECOUPE > 0) {
					// decoupe en "00/00/00/02
					$split=str_split($dossier_serveur,UPLOAD_LONGUEUR_DECOUPE);
					$dossier_serveur = implode("/",$split);
				}
			}
			/// remplace
			$rep_cible=REP_CLIENT."www/__".$res_liste["dossier"];
			$rep_cible.=$dossier_serveur."/";

			return self::getImageRedimensionnee($rep_cible.$fichier);


		} else {
			if (DEBUGGER) echo "fichier non trouvé";
			return false;

		}
	}

	static function getImageRedimensionnee($fichiersrc) {
		
		ini_set("memory_limit",'128M');
		
		$split_fichier = split_fichier($fichiersrc);
		$rep_cible = $split_fichier["chemin"]."/";
		$fichier = $split_fichier["fichier"];
		$est_redim = preg_match("#((.*)_([0-9]{1,4})_([0-9]{1,4})_(MAX|CROPMAX|EXACT|NO)_([0-9a-f]{5}).(JPG|PNG|GIF))#i",$fichier,$detail_redim);
		if($est_redim) {
				
			$fichier_complet = $rep_cible."redim/".$fichier;
			creeRepSiExistePas(RACINE_WWW.$fichier_complet);
		} else {
			$fichier_complet = $rep_cible.$fichier;

		}
		if($est_redim && isset($_REQUEST["recree"])) {
			@unlink($fichier_complet);
		}
		if(file_exists($fichier_complet)) {

			// "ok, trouvé le fichier direct";
			return $fichier_complet;
		} else {
			if($est_redim) {
				$largeur=$detail_redim[3];
				$hauteur=$detail_redim[4];
				$redim=$detail_redim[5];
				$extension=$detail_redim[7];
				$fichier_origine=$detail_redim[2].".".$extension;
				$md5=CImages::calcule_md5($fichier_origine,$largeur,$hauteur,$redim);
				if($md5 == $detail_redim[6]) {
					$fichier_complet_origine = $rep_cible.$fichier_origine;
					CImages::redimensionne_fichier($fichier_complet_origine,$redim,$largeur,$hauteur,$fichier_complet,IMAGE_QUALITE_REDIM);
					return $fichier_complet;

				} else {
					if (DEBUGGER) echo "md5 no match ($detail_redim[6])($md5) ";
					return false;

				}
			} else {
				// pas redim, mais fichier existe pas
				return $fichier_complet;
				if (DEBUGGER) echo "no match preg_match";
				return false;

			}
		}

	}

	static function redimensionne($image_origine,$typ,$largeurFinale,$hauteurFinale,$fichierSortie,$largeurImage,$hauteurImage,$format,$qualite=IMAGE_QUALITE_STOCKAGE) {
		$typ=strtoupper($typ);
		if($typ=="CROPMAXHORIZONTAL") {
			$rappLHimage=$largeurImage/$hauteurImage;
			$rappLHfinal=$largeurFinale/$hauteurFinale;

			if($hauteurImage>$largeurImage) {
				// si img verticale => CROP hauteur x hauteur
				$typ="CROPMAX";
				$largeurFinale=$hauteurFinale;
			} else if ($rappLHimage>$rappLHfinal){
				// si image trop en largeur
				$typ="CROPMAX";
			} else {
				// sinon, juste un MAX
				$typ="MAX";
			}
		} else if($typ=="CROPMAXVERTICAL") {
			$rappLHimage=$largeurImage/$hauteurImage;
			$rappLHfinal=$largeurFinale/$hauteurFinale;

			if($largeurImage>$hauteurImage) {
				// si img horizontale => CROP hauteur x hauteur
				$typ="CROPMAX";
				$hauteurFinale=$largeurFinale;
			} else if($rappLHimage<$rappLHfinal) {
				// si image trop en hauteur
				$typ="CROPMAX";
			} else {
				// sinon, juste un MAX
				$typ="MAX";
			}
		}

		switch($typ) {
			case "CROPMAX":
				$rx=$largeurFinale/$largeurImage;
				$ry=$hauteurFinale/$hauteurImage;
				$rapp=max($rx,$ry);
				// tailles de l'image originale resamplee
				$lf=floor($largeurImage*$rapp);
				$hf=floor($hauteurImage*$rapp);
				// tailles de l'image finale resizee recropee
				$lf2=$largeurFinale;
				$hf2=$hauteurFinale;
				// tailles de l'image originale cropee
				$loc=$largeurFinale/$rapp;
				$hoc=$hauteurFinale/$rapp;
				$im = imagecreatetruecolor  ($lf2, $hf2);
				if($format == "png") {
					imagealphablending($im,false);
					imagesavealpha ($im, true);
				}
				$dx=round(($largeurImage-$loc)/2);
				$dy=round(($hauteurImage-$hoc)/2);
				imagecopyresampled ( $im , $image_origine , 0 , 0 , $dx , $dy , $lf2 , $hf2 , $loc ,$hoc );
				break;
			case "PIXELSMAX":
				$pixelsMax=$largeurFinale*$hauteurFinale;
				$pixelsActu=$largeurImage*$hauteurImage;
				$rapp=min(1,sqrt($pixelsMax/$pixelsActu));
				$lf=floor($largeurImage*$rapp);
				$hf=floor($hauteurImage*$rapp);
				$im = imagecreatetruecolor  ($lf, $hf);
				if($format == "png") {
					imagealphablending($im,false);
					imagesavealpha ($im, true);
				}
				imagecopyresampled ( $im , $image_origine , 0 , 0 , 0 , 0 , $lf , $hf , $largeurImage ,$hauteurImage );
				break;
			case "MAX":
				$rx=$largeurFinale/$largeurImage;
				$ry=$hauteurFinale/$hauteurImage;
				$rapp=min(1,$rx,$ry);
				$lf=floor($largeurImage*$rapp);
				$hf=floor($hauteurImage*$rapp);
				$im = imagecreatetruecolor  ($lf, $hf);
				if($format == "png") {
					imagealphablending($im,false);
					imagesavealpha ($im, true);
				}
				imagecopyresampled ( $im , $image_origine , 0 , 0 , 0 , 0 , $lf , $hf , $largeurImage ,$hauteurImage );
				break;
			case "EXACT":
				$im = imagecreatetruecolor  ($largeurFinale, $hauteurFinale);
				if($format == "png") {
					imagealphablending($im,false);
					imagesavealpha ($im, true);
				}
				imagecopyresampled ( $im , $image_origine , 0 , 0 , 0 , 0 , $largeurFinale , $hauteurFinale , $largeurImage ,$hauteurImage );
				break;
			case "NO":
			case "CONV":
				$im=$image_origine;
				break;
		}
		if($format == "png") {
			$str_qualite="IMAGE_QUALITE_PNG_$qualite";
			imagepng($im,$fichierSortie,CImages::$$str_qualite);
		} else if($format == "gif") {
			imagegif($im,$fichierSortie);
		}else {
			$str_qualite="IMAGE_QUALITE_JPG_$qualite";
			imagejpeg($im,$fichierSortie,CImages::$$str_qualite);
		}
		chmod($fichierSortie, 0777);
	}
	static function createFrom($f,$extension="") {
		if($extension=="") {
			$extension=substr($f,strrpos($f,".")+1,strlen($f));
		}
		switch(strtoupper($extension)) {
			case "JPG":
			case "JPEG":
				return imagecreatefromjpeg($f);
				break;
			case "PNG":
				//				echo file_get_contents($f);
				//				exit;
				//return imagecreatefromjpeg($f);
				return imagecreatefrompng($f);
				break;
			case "GIF":
				return imagecreatefromgif($f);
				break;
		}
	}
	/**
	 *
	 * @param $f
	 * @param $typ
	 * @param $largeurFinale
	 * @param $hauteurFinale
	 * @param $fichierSortie
	 * @param $qualite = IMAGE_QUALITE_STOCKAGE(*) | IMAGE_QUALITE_REDIM
	 * @return unknown_type
	 */
	static function redimensionne_fichier($f,$typ,$largeurFinale,$hauteurFinale,$fichierSortie,$qualite=IMAGE_QUALITE_STOCKAGE,$extension_force="") {
		if($typ == "NO") {
			// l'écrire directement !
		}
		if(!file_exists($f)) {
			//include_once 'modules/site/classes/CSite.class.php';//auto
			CSite::erreur404();
		}
		// 1 : on lit l'image
		$image_origine=CImages::createFrom($f,$extension_force);
		//
		$size = getimagesize($f);
		$largeurImage=$size[0];
		$hauteurImage=$size[1];

		// 2 : on la redimensionne
		$extension=substr($f,strrpos($f,".")+1,strlen($f));
		if($extension=="tmp" || $extension=="xx") $extension=substr($fichierSortie,strrpos($fichierSortie,".")+1,strlen($fichierSortie));
		CImages::redimensionne($image_origine,$typ,$largeurFinale,$hauteurFinale,$fichierSortie,$largeurImage,$hauteurImage,strtolower($extension),$qualite);
	}


}

?>