<?php
require_once 'bdd.class.php';
require_once 'Identification.class.php';



class Hebdo
{

    const ETAT_EN_COURS = "en cours";
    const ETAT_EN_PAUSE = "en pause";

    public $id;

    public $idUser;
    public $idTache;

    public $date_debut;
    public $debut_pause;

    public $commentaire = "";
    public $etat;


    public function __construct($idHebdo = null)
    {
        $this->id = $idHebdo;
        $this->load();
    }

    public function load()
    {
        if (!is_null($this->id)) {
            $hebdo = bdd::getResult("SELECT * FROM wrk_hebdo WHERE id='$this->id'");
            $this->idTache = $hebdo['id_tache'];
            $this->idUser = $hebdo['id_user'];
            $this->date_debut = $hebdo['date_debut'];
            $this->commentaire = $hebdo['commentaire'];
            $this->debut_pause = $hebdo['debut_pause'];
            $this->etat = $hebdo['etat'];
        }

    }

    public static function getTotalTimeJour($date)
    {
        $dateSQL = substr($date,0,4)."-".substr($date,4,2)."-".substr($date,6);
        $starttimestamp = bdd::getResult("SELECT unix_timestamp('$dateSQL') AS ts");
        $starttimestamp = $starttimestamp["ts"];
        $endtimestamp = $starttimestamp + (3600*24);
        $idUser = Identification :: getId();

        $req = "
SELECT SUM(total_time) AS total FROM (
      SELECT SUM(duree) * 3600 AS total_time FROM wrk_travail WHERE date='$dateSQL' AND id_user=$idUser
    UNION
        SELECT SUM(IF(etat = 'en pause',debut_pause,UNIX_TIMESTAMP())-date_debut) AS total_time FROM wrk_hebdo
        WHERE date_debut BETWEEN $starttimestamp AND $endtimestamp AND id_user=$idUser
    UNION
        SELECT -SUM(duree) FROM wrk_pauses p
        INNER JOIN wrk_hebdo h ON h.id = p.id_hebdo
        WHERE h.date_debut BETWEEN $starttimestamp AND $endtimestamp AND id_user=$idUser
) AS t
";
        if($res = bdd::getResult($req)) {
            $seconds= $res["total"];
            $hours = floor($seconds/3600);
            $seconds %= 3600;
            $minutes = floor($seconds/60);
            $seconds %= 60;
            return "$hours:$minutes:$seconds";
        }

        return "00:00:00";
    }


    public static function add_lastuse($id_tache){

        $idUser = Identification::getId();

        $sql = "SELECT t.id AS idtache, l.id AS idlot, c.id AS idclient
               FROM wrk_taches t
               LEFT JOIN wrk_lots l ON t.id_lot = l.id
               LEFT JOIN wrk_clients c ON l.id_client = c.id
               WHERE t.id = '$id_tache'";
        $lastuse = bdd::getResult($sql);

        // Last use du hebdo
        $req = "INSERT INTO wrk_last_use (id_user,id_tache, id_client, date_use, id_lot)
                VALUES ('$idUser', '$id_tache', '".$lastuse['idclient']."', NOW(), '".$lastuse['idlot']."')
				ON DUPLICATE KEY UPDATE date_use = VALUES(date_use)";
        bdd::exec($req);
    }

    /**
     * initialise ....
     * @param $idTache
     */
    public function create($idTache, $dureeMinutes = null)
    {
        $idUser = Identification::getId();
        if (!$idUser) throw new Exception("Not connected ! cannot create hebdo");

        if(empty($dureeMinutes)) $dureeMinutes = 0;

        $diffheuredebutseconds = $dureeMinutes*60;
        $sql = "INSERT INTO `wrk_hebdo`(`id_tache`, `id_user`, `date_debut`, `etat`)
            VALUES ('$idTache', '$idUser', UNIX_TIMESTAMP() - '$diffheuredebutseconds',
             '" . self::ETAT_EN_COURS . "')";

        bdd::exec($sql);

        Hebdo::add_lastuse($idTache);
    }

    public function add_travail($dureeMinutes)
    {
        if(empty($dureeMinutes)) $dureeMinutes = 0;

        $idUser = Identification::getId();
        $id_tache = $this->idTache;
        $date = date('Y-m-d', $this->date_debut);

        $diffsecs = ($dureeMinutes*60);


        if($this -> etat == "en cours" && $diffsecs > 0) {
           Hebdo::create_pause($this->id, $dureeMinutes);
        }



        $datedebut = $this->date_debut;

        $dureepausesseconds = Hebdo::get_dureepause($this->id);

        if($this -> etat == "en cours") {
            $sql = "SELECT UNIX_TIMESTAMP() - '$datedebut' AS duree";
            $dureetravailseconds = bdd::getResult($sql);
        } else if($this -> etat == "en pause") {
            $sql = "SELECT debut_pause - date_debut AS duree FROM wrk_hebdo WHERE id = ".$this -> id;
            $dureetravailseconds = bdd::getResult($sql);
        }

        $dureeheures = ($dureetravailseconds['duree'] - $dureepausesseconds) / 3600;

        $duree = max(round($dureeheures * 2), 1) / 2;

// 		bdd :: exec("INSERT INTO wrk_travail (id_user,id_tache,duree,duree_facture,date,commentaire) VALUES ('$idUser','$id_tache','$duree','$dateF','$date','$comment')");
        $id = Travail::simpleAdd($idUser, $id_tache, $duree, $duree, $date, $this->commentaire);
        Travail::$id_travail = $id;
        $parentsId = Travail::getParentsId($id);
        Tache::sauver($parentsId['idTache']);
        Lot::sauver($parentsId['idLot']);
        Hebdo::delete('hebdo', $this->id);
        // Last use du lot
        $req = "INSERT INTO wrk_last_use (id_user,id_client,date_use)
 VALUES ('$idUser','" . (int)$parentsId['idClient'] . "',NOW()) ON DUPLICATE KEY UPDATE date_use = VALUES(date_use)";
        bdd::exec($req);

        return new Travail(mysql_insert_id());
    }

    public static function edit_comment($idhebdo, $commentaire)
    {
        if (is_null($idhebdo)) throw new Exception("idHebdo non défini");
        $sql = "UPDATE `wrk_hebdo` SET `commentaire` = '".mysql_real_escape_string($commentaire)."' WHERE `id` = '$idhebdo'";
        bdd::exec($sql);
    }

    public static function delete($source, $id)
    {

        if($source == 'hebdo') {
            if (is_null($id)) throw new Exception("id de hebdo non défini");
            $sql = "DELETE FROM wrk_hebdo WHERE id = '$id'";
            bdd::exec($sql);
            $sql = "DELETE FROM wrk_pauses WHERE id_hebdo = '$id'";
            bdd::exec($sql);
        } elseif($source == 'travail') {
            if (is_null($id)) throw new Exception("id du travail non défini");
            $sql = "DELETE FROM wrk_travail WHERE id = '$id'";
            bdd::exec($sql);
        } else {
            throw new Exception("table non définie");
        }
    }

    public static function start_pause($idhebdo, $dureeMinutes, $jour)
    {
        //TODO : utiliser le jour

        if (is_null($idhebdo)) throw new Exception("idHebdo non défini");
        if(empty($dureeMinutes)) $dureeMinutes = 0;

        $diffheuredebutseconds = $dureeMinutes*60;

        if($diffheuredebutseconds > 0) {
            Hebdo::create_pause($idhebdo, $dureeMinutes);
        }

        $sql = "UPDATE wrk_hebdo SET debut_pause = UNIX_TIMESTAMP(), etat='" . self::ETAT_EN_PAUSE . "'
         WHERE id = '$idhebdo'";
        bdd::exec($sql);
    }

    public function stop_pause($dureeMinutes)
    {
        if (is_null($this->id)) throw new Exception("idHebdo non défini");

        if(empty($dureeMinutes)) {
            $dureeMinutes = 0;
        }

        $diffheuredebutseconds = $dureeMinutes*60;

            //Hebdo::create_pause($this->id, $dureeMinutes);
			$sqlPause = "INSERT INTO wrk_pauses (id_hebdo, duree)
			SELECT $this->id,UNIX_TIMESTAMP() - $diffheuredebutseconds - debut_pause
			FROM wrk_hebdo WHERE id = '$this->id'";
			bdd::exec($sqlPause);

        $sql = "UPDATE wrk_hebdo SET debut_pause = '', etat='" . self::ETAT_EN_COURS . "' WHERE id = '$this->id'";
        bdd::exec($sql);
    }

    /**
     * @param $idhebdo
     * @param $dureeMinutes (minutes)
     * @throws Exception
     */
    public static function create_pause($idhebdo, $dureeMinutes)
    {
        if (empty($idhebdo)) throw new Exception("idHebdo non défini");

        if(empty($dureeMinutes)) $dureeMinutes = 0;

        $diffheuredebutseconds = $dureeMinutes*60;

        if($diffheuredebutseconds > 0) {
            $sql = "INSERT INTO wrk_pauses (id_hebdo, duree) VALUES('$idhebdo', '$diffheuredebutseconds')";
            bdd::exec($sql);
        }
    }

    public static function create_pause_duree($idhebdo, $dureemins) {
        if (empty($idhebdo)) throw new Exception("idhebdo non défini");
        if (empty($dureemins)) throw new Exception("duree non définie");

        $dureesecs = $dureemins * 60;
        $sql = "INSERT INTO wrk_pauses (id_hebdo, duree) VALUES('$idhebdo', '$dureesecs')";
        bdd::exec($sql);
    }

    public static function edit_tache($id, $source, $idtache) {
        if($source == 'hebdo') {
            $sql = "UPDATE wrk_hebdo SET id_tache = '$idtache' WHERE id = '$id'";
            bdd::exec($sql);
            } elseif($source == 'travail') {
            $sql = "UPDATE wrk_travail SET id_tache = '$idtache' WHERE id = '$id'";
            bdd::exec($sql);
        } else {
            throw new Exception("Source non défini");
        }
    }



    public static function secondstohour($seconds)
    {
        $h = floor($seconds / 3600);
        $m = floor(($seconds - ($h * 3600)) / 60);
        $s = $seconds - ($h * 3600) - ($m * 60);
        if ($h < 10) {
            $h = '0' . $h;
        }
        if ($m < 10) {
            $m = '0' . $m;
        }
        if ($s < 10) {
            $s = '0' . $s;
        }

        return $hour = $h . ':' . $m . ':' . $s;
    }

    public static function delete_thatpause($idpause)
    {
        if (is_null($idpause)) throw new Exception("pause non définie");
        $sql = "DELETE FROM wrk_pauses WHERE id = '$idpause'";
        bdd::exec($sql);
    }

    public static function delete_pause($idhebdo)
    {
        if (is_null($idhebdo)) throw new Exception("idHebdo non défini");
        $sql = "DELETE FROM wrk_pauses WHERE id_hebdo = '$idhebdo'";
        bdd::exec($sql);
    }

    public static function get_alldureepauses($idhebdo) {
        if (is_null($idhebdo)) throw new Exception("idHebdo non défini");
        $sql = "SELECT id ,duree FROM wrk_pauses WHERE id_hebdo = '$idhebdo'";
        $r = bdd::getResults($sql);
        return $r;
    }

    public static function get_dureepause($idhebdo)
    {
        if (is_null($idhebdo)) throw new Exception("idHebdo non défini");
        $sql = "SELECT SUM(duree) as duree FROM wrk_pauses WHERE id_hebdo = '$idhebdo'";
        $r = bdd::getResult($sql);
        return $r['duree'];
    }

    public static function get_dureehebdo($idhebdo)
    {
        $sql = "SELECT debut_pause FROM wrk_hebdo WHERE id = '$idhebdo'";
        $r = bdd::getResult($sql);
        if (empty($r['debut_pause'])) {
            // on est en cours
            $sql = "SELECT UNIX_TIMESTAMP() - date_debut AS duree
                 FROM wrk_hebdo
                 WHERE id = '$idhebdo'";
            $dureedebut = bdd::getResult($sql);

            $sql = "SELECT SUM(duree) AS duree
             FROM wrk_pauses
              WHERE id_hebdo = '$idhebdo'";
            $dureepauses = bdd::getResult($sql);

            $duree = $dureedebut['duree'] - $dureepauses['duree'];

        } else {
            // on est en pause
            $sql = "SELECT debut_pause - date_debut AS duree
                 FROM wrk_hebdo
                 WHERE id = '$idhebdo'";
            $dureedebut = bdd::getResult($sql);

            $sql = "SELECT SUM(duree) AS duree
             FROM wrk_pauses
              WHERE id_hebdo = '$idhebdo'";
            $dureepauses = bdd::getResult($sql);

            $duree = $dureedebut['duree'] - $dureepauses['duree'];

        }

        return $duree;
    }

    public static function pause_hebdoencours($depuisMinutes)
    {
		if(empty($depuisMinutes)) $depuisMinutes=0;

        $idUser = Identification::getId();
        $sql = "UPDATE wrk_hebdo
              SET   etat = '" . self::ETAT_EN_PAUSE . "',
                    debut_pause = UNIX_TIMESTAMP() - ".($depuisMinutes*60)."
            WHERE etat = '" . self::ETAT_EN_COURS . "'
              AND CURDATE() = FROM_UNIXTIME(date_debut, '%Y-%m-%d')
              AND id_user = '$idUser'";
        bdd::exec($sql);
    }


    public static function get_hebdostravails($userid, $datedebut, $datefin)
    {
        $sql = "SELECT '$datedebut' as datedebutplanning, '$datefin' as datefinplanning,
 h.id as id, 'hebdo' as source, 'non termine' as status,etat,
 DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%Y%m%d') as date, h.commentaire as commentaire,
 DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%H:%i') as heuredebut,
  ta.id as idtache, ta.duree_estimee as dureetache, ta.nom as nomtache, l.id as idlot,
   l.nom as nomlot, l.duree_estimee as dureelot,
   c.id as idclient, c.nom nomclient, c.couleur as couleur
 FROM wrk_hebdo h
 LEFT JOIN wrk_taches ta ON h.id_tache = ta.id
    LEFT JOIN wrk_lots l ON ta.id_lot = l.id
    LEFT JOIN wrk_clients c ON l.id_client = c.id
    WHERE id_user = '$userid'
 AND DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%Y%m%d') != DATE_FORMAT(NOW(), '%Y%m%d')
   UNION
SELECT '$datedebut' as datedebutplanning, '$datefin' as datefinplanning,
 h.id as id, 'hebdo' as source, h.etat as status,etat,
 DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%Y%m%d') as date, h.commentaire as commentaire,
 DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%H:%i') as heuredebut,
  ta.id as idtache, ta.duree_estimee as dureetache, ta.nom as nomtache, l.id as idlot,
   l.nom as nomlot, l.duree_estimee as dureelot,
   c.id as idclient, c.nom nomclient, c.couleur as couleur
 FROM wrk_hebdo h
 LEFT JOIN wrk_taches ta ON h.id_tache = ta.id
    LEFT JOIN wrk_lots l ON ta.id_lot = l.id
    LEFT JOIN wrk_clients c ON l.id_client = c.id
    WHERE id_user = '$userid'
 AND DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%Y%m%d') = DATE_FORMAT(NOW(), '%Y%m%d')
  UNION
SELECT '$datedebut' as datedebutplanning, '$datefin' as datefinplanning,
 t.id as id, 'travail' as source, 'termine' as status,'' AS etat,
DATE_FORMAT(t.date, '%Y%m%d') as date, t.commentaire as commentaire,
DATE_FORMAT(t.date, '%H:%i') as heuredebut,
 ta.id as idtache, ta.duree_estimee as dureetache, ta.nom as nomtache, l.id as idlot, l.nom as nomlot,
  l.duree_estimee as dureelot, c.id as idclient, c.nom nomclient, c.couleur as couleur
 FROM wrk_travail t
 LEFT JOIN wrk_taches ta ON t.id_tache = ta.id
    LEFT JOIN wrk_lots l ON ta.id_lot = l.id
    LEFT JOIN wrk_clients c ON l.id_client = c.id
    WHERE id_user = '$userid'
 AND t.date >= '$datedebut' AND t.date <= '$datefin'
 ORDER BY date ASC, source DESC, id ASC";

        $hebdostravails = bdd::getResults($sql);
        return $hebdostravails;
    }

    public static function get_jourhebdostravails($jour, $userid)
    {
        return self::get_hebdostravails($userid, $_SESSION["datedebutplanning"], $_SESSION["datefinplanning"]);
        $sql = "SELECT h.id as id, 'hebdo' as source, h.etat as status,etat,
 DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%Y%m%d') as date, h.commentaire as commentaire,
 DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%H:%i') as heuredebut,
  ta.id as idtache, ta.duree_estimee as dureetache, ta.nom as nomtache, l.id as idlot,
   l.nom as nomlot, l.duree_estimee as dureelot,
   c.id as idclient, c.nom nomclient, c.couleur as couleur
 FROM wrk_hebdo h
 LEFT JOIN wrk_taches ta ON h.id_tache = ta.id
    LEFT JOIN wrk_lots l ON ta.id_lot = l.id
    LEFT JOIN wrk_clients c ON l.id_client = c.id
    WHERE id_user = '$userid'
 AND DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%Y%m%d') = '$jour'
UNION
SELECT t.id as id, 'travail' as source, 'termine' as status,'' AS etat,
DATE_FORMAT(t.date, '%Y%m%d') as date, t.commentaire as commentaire,
DATE_FORMAT(t.date, '%H:%i') as heuredebut,
 ta.id as idtache, ta.duree_estimee as dureetache, ta.nom as nomtache, l.id as idlot,
  l.nom as nomlot,
  l.duree_estimee as dureelot, c.id as idclient, c.nom nomclient, c.couleur as couleur
 FROM wrk_travail t
 LEFT JOIN wrk_taches ta ON t.id_tache = ta.id
    LEFT JOIN wrk_lots l ON ta.id_lot = l.id
    LEFT JOIN wrk_clients c ON l.id_client = c.id
    WHERE id_user = '$userid'
 AND DATE_FORMAT(t.date, '%Y%m%d') = '$jour'
 ORDER BY date ASC, source DESC, id ASC";

        $hebdostravails = bdd::getResults($sql);
        return $hebdostravails;
    }

    public static function get_otherjourhebdostravails($userid, $datedebutplanning, $datefinplanning)
    {
        return self::get_hebdostravails($userid, $_SESSION["datedebutplanning"], $_SESSION["datefinplanning"]);

        $sql = "SELECT '$datedebut' as datedebutplanning, '$datefin' as datefinplanning,
 h.id as id, 'hebdo' as source, 'non termine' as status,etat,
 DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%Y%m%d') as date, h.commentaire as commentaire,
 DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%H:%i') as heuredebut,
  ta.id as idtache, ta.duree_estimee as dureetache, ta.nom as nomtache, l.id as idlot,
   l.nom as nomlot, l.duree_estimee as dureelot,
   c.id as idclient, c.nom nomclient, c.couleur as couleur
 FROM wrk_hebdo h
 LEFT JOIN wrk_taches ta ON h.id_tache = ta.id
    LEFT JOIN wrk_lots l ON ta.id_lot = l.id
    LEFT JOIN wrk_clients c ON l.id_client = c.id
    WHERE id_user = '$userid'
 AND DATE_FORMAT(FROM_UNIXTIME(h.date_debut), '%Y%m%d') != DATE_FORMAT(NOW(), '%Y%m%d')
UNION
SELECT '$datedebut' as datedebutplanning, '$datefin' as datefinplanning,
 t.id as id, 'travail' as source, 'termine' as status,'' AS etat,
DATE_FORMAT(t.date, '%Y%m%d') as date, t.commentaire as commentaire,
DATE_FORMAT(t.date, '%H:%i') as heuredebut,
 ta.id as idtache, ta.duree_estimee as dureetache, ta.nom as nomtache, l.id as idlot, l.nom as nomlot,
  l.duree_estimee as dureelot, c.id as idclient, c.nom nomclient, c.couleur as couleur
 FROM wrk_travail t
 LEFT JOIN wrk_taches ta ON t.id_tache = ta.id
    LEFT JOIN wrk_lots l ON ta.id_lot = l.id
    LEFT JOIN wrk_clients c ON l.id_client = c.id
    WHERE id_user = '$userid'
 AND t.date >= '$datedebutplanning' AND t.date <= '$datefinplanning' AND t.date != DATE_FORMAT(NOW(), '%Y%m%d')
 ORDER BY date ASC, source DESC, id ASC";

        $hebdostravails = bdd::getResults($sql);
        return $hebdostravails;
    }

    public static function display_selectTache($hebdotravail, $str_clients, $str_lots, $str_taches) {
        require __DIR__ . '/../files/blocs/hebdoSelecttache.tpl.php';
    }

    public static function display_select($lastuse, $str_clients, $str_lots, $str_taches) {
        require __DIR__ . '/../files/blocs/hebdoSelect.tpl.php';
    }

    public static function display_line($hebdotravail, $dateflag = null, $str_clients, $str_lots, $str_taches,$userid)
    {
        require __DIR__ . '/../files/blocs/hebdoJour.tpl.php';
    }

    public static function display_progress($duree, $dureetotale)
    {
        require __DIR__ . '/../files/blocs/hebdoProgress.tpl.php';
    }

    public static function get_selectClients($userid, $preload)
    {
        $sql = "SELECT tt.id as id,tt.nom as nom FROM wrk_clients tt
        LEFT JOIN wrk_last_use lu ON lu.id_user='$userid'
        AND lu.id_client=tt.id ORDER BY lu.date_use DESC";
        $rr = bdd::getResults($sql);
        $str_clients = "";
        foreach ($rr as $r) {
            if ($r['id'] == $preload['idClient']) {
                $s = "selected='selected'";
            } else {
                $s = "";
            }
            $str_clients .= "<option value='" . $r['id'] . "' $s>" . $r['nom'] . "</option>";
        }
        return $str_clients;
    }

    public static function get_selectLots($userid, $preload)
    {
        $sql = "SELECT tt.id as id,tt.nom as nom FROM wrk_lots tt
        LEFT JOIN wrk_last_use lu ON lu.id_user='$userid'
        AND lu.id_lot=tt.id
        WHERE tt.id_client=$preload[idClient]
        AND tt.comptabilise=0
        ORDER BY lu.date_use DESC";
        $rr = bdd::getResults($sql);
        $str_lots = "";
        foreach ($rr as $r) {
            if ($r['id'] == $preload['idLot']) {
                $s = "selected='selected'";
            } else {
                $s = "";
            }
            $str_lots .= "<option value='" . $r['id'] . "' $s>" . $r['nom'] . "</option>";
        }
        return $str_lots;
    }

    public static function get_selectTaches($userid, $preload)
    {
        $sql = "SELECT tt.id as id,tt.nom as nom FROM wrk_taches tt
        LEFT JOIN wrk_last_use lu ON lu.id_user='$userid'
        AND lu.id_tache=tt.id
        WHERE tt.id_lot=$preload[idLot]

        ORDER BY lu.date_use DESC";
        $rr = bdd::getResults($sql);
        $str_taches = "";
        foreach ($rr as $r) {
            if ($r['id'] == $preload['idTache']) {
                $s = "selected='selected'";
            } else {
                $s = "";
            }
            $str_taches .= "<option value='" . $r['id'] . "' $s>" . $r['nom'] . "</option>";
        }
        return $str_taches;
    }


    public static function display_planning($hebdostravails, $userid)
    {
        $today = date('Ymd');
        $dateflag = null;
        $todayflag = true;
        $otherdayflag = false;

            $i = 1;
            echo '<div id="jourencours">';
            foreach ($hebdostravails AS $hebdotravail) {

                if ($hebdotravail['date'] != $today && $dateflag == null) {
                    $otherdayflag = true;
                }

                if ($hebdotravail['date'] == $today && $todayflag == true && $otherdayflag == true) {
                }

                if ($hebdotravail['date'] == $today && $todayflag) {
                    $todayflag = false;
                }

                $hebdoload['idClient'] = $hebdotravail['idclient'];
                $hebdoload['idLot'] = $hebdotravail['idlot'];
                $hebdoload['idTache'] = $hebdotravail['idtache'];

                $sel_clients = Hebdo::get_selectClients($userid, $hebdoload);
                $sel_lots = Hebdo::get_selectLots($userid, $hebdoload);
                $sel_taches = Hebdo::get_selectTaches($userid, $hebdoload);

                Hebdo::display_line($hebdotravail, $dateflag, $sel_clients, $sel_lots, $sel_taches,$userid);

                $dateflag = $hebdotravail['date'];
            }
            $preload = Identification::getLastWorkedData();
            $lastuse = Hebdo::get_lastuse($userid);
            $str_clients = Hebdo::get_selectClients($userid, $preload);
            $str_lots = Hebdo::get_selectLots($userid, $preload);
            $str_taches = Hebdo::get_selectTaches($userid, $preload);

            Hebdo::display_select($lastuse, $str_clients, $str_lots, $str_taches);

            echo '</div>';

    }


    public static function get_lastuse($userid) {
		$req = bdd::getResult("SELECT id_tache FROM
		wrk_last_use WHERE id_tache IS NOT NULL AND id_user='$userid'
			ORDER BY date_use DESC
			LIMIT 0,1");
		if(!$req) return Travail::getParentsId(1);
		return bdd::getResult(
            "SELECT ta.id AS idtache, ta.nom AS nomtache,
              lo.id AS idlot, lo.nom AS nomlot,
               cl.id AS idclient, cl.nom AS nomclient
				FROM wrk_taches ta
				LEFT JOIN wrk_lots lo ON ta.id_lot = lo.id
				LEFT JOIN wrk_clients cl ON lo.id_client = cl.id
				WHERE ta.id=".$req['id_tache']);
    }

    public static function get_idlotidtache_hebdo($idhebdo) {
        $sql = "SELECT h.id AS idhebdo, t.id AS idtache, l.id AS idlot, c.id AS idclient
               FROM wrk_hebdo h
               LEFT JOIN wrk_taches t ON h.id_tache = t.id
               LEFT JOIN wrk_lots l ON t.id_lot = l.id
               LEFT JOIN wrk_clients c ON l.id_client = c.id
               WHERE h.id = '$idhebdo'";
        return bdd::getResult($sql);
    }

    public static function display_jourplanning($hebdostravails, $userid) {

        ob_start(function($s) {
            Response::addMsg('data', $s);
        });
self::display_planning($hebdostravails, $userid);
        ob_end_flush();
        return;


       /* $dateflag = null;

        foreach($hebdostravails AS $hebdotravail) {
            $hebdoload['idClient'] = $hebdotravail['idclient'];
            $hebdoload['idLot'] = $hebdotravail['idlot'];
            $hebdoload['idTache'] = $hebdotravail['idtache'];

            $clients = Hebdo::get_selectClients($userid, $hebdoload);
            $lots = Hebdo::get_selectLots($userid, $hebdoload);
            $taches = Hebdo::get_selectTaches($userid, $hebdoload);
            Hebdo::display_line($hebdotravail, $dateflag, $clients, $lots, $taches);
            $dateflag = $hebdotravail['date'];
        }
//        if($dateflag == date('Ymd')) {
            $preload = Identification::getLastWorkedData();
            $str_clients = Hebdo::get_selectClients($userid, $preload);
            $str_lots = Hebdo::get_selectLots($userid, $preload);
            $str_taches = Hebdo::get_selectTaches($userid, $preload);

            $lastuse = Hebdo::get_lastuse($userid);

                Hebdo::display_select($lastuse, $str_clients, $str_lots, $str_taches);

            ?>
            <script>loadSelects();</script>
            <?php
            ob_end_flush();
//        }*/
    }

    public static function display_otherjourplanning($hebdostravails, $userid) {
        return self::display_jourplanning($hebdostravails, $userid);

        /*
        ob_start(function($s) {
            Response::addMsg('data', $s);
        });
        $dateflag = null;

        foreach($hebdostravails AS $hebdotravail) {
            $hebdoload['idClient'] = $hebdotravail['idclient'];
            $hebdoload['idLot'] = $hebdotravail['idlot'];
            $hebdoload['idTache'] = $hebdotravail['idtache'];
            $clients = Hebdo::get_selectClients($userid, $hebdoload);
            $lots = Hebdo::get_selectLots($userid, $hebdoload);
            $taches = Hebdo::get_selectTaches($userid, $hebdoload);
            Hebdo::display_line($hebdotravail, $dateflag, $clients, $lots, $taches);
            $dateflag = $hebdotravail['date'];
        }
        ob_end_flush();*/
    }

    public static function display_btns($hebdotravail) {

        if($hebdotravail['status'] == 'en cours') {
            echo '<div class="boutons">
        <a class="form-content-pause" data-idhebdo="'.$hebdotravail['id'].'"
         data-jour="'.$hebdotravail['date'].'">
            <img src="hebdo/img/pause.png" alt="Ajouter une pause" title="Ajouter une pause"/>
        </a>
        <a class="form-content-stop" data-idhebdo="'.$hebdotravail['id'].'"
         data-jour="'.$hebdotravail['date'].'">
            <img src="hebdo/img/stop.png" alt="Terminer le travail" title="Terminer le travail" />
        </a>
        <a class="form-content-delete"
         data-nomtache="'.$hebdotravail['nomtache'].'"
          data-id="'.$hebdotravail['id'].'" data-jour="'.$hebdotravail['date'].'" data-source="'.$hebdotravail['source'].'" data-datedebutplanning="'.$hebdotravail['datedebutplanning'].'" data-datefinplanning="'.$hebdotravail['datefinplanning'].'">
            <img src="hebdo/img/delete.png" alt="Supprimer le travail" title="Supprimer le travail" />
        </a>
        </div>';
        } elseif($hebdotravail['status'] == 'en pause') {
            echo '<div class="boutons">
        <a class="form-content-start" data-idhebdo="'.$hebdotravail['id'].'"
         data-jour="'.$hebdotravail['date'].'">
            <img src="hebdo/img/lecture.png" alt="Reprendre le travail" title="Reprendre le travail" />
        </a>
        <a class="form-content-stop" data-idhebdo="'.$hebdotravail['id'].'"
         data-jour="'.$hebdotravail['date'].'">
            <img src="hebdo/img/stop.png" alt="Terminer le travail" title="Terminer le travail" />
        </a>
        <a class="form-content-delete"
         data-nomtache="'.$hebdotravail['nomtache'].'"
          data-id="'.$hebdotravail['id'].'" data-jour="'.$hebdotravail['date'].'" data-source="'.$hebdotravail['source'].'" data-datedebutplanning="'.$hebdotravail['datedebutplanning'].'" data-datefinplanning="'.$hebdotravail['datefinplanning'].'">
            <img src="hebdo/img/delete.png" alt="Supprimer le travail" title="Supprimer le travail" />
        </a>
        </div>';
        } elseif($hebdotravail['status'] == 'termine') {
            echo '<div class="boutons">
        <img src="hebdo/img/termine.png" alt="Le travail est terminé" title="Le travail est terminé" />
        <a class="form-content-editertache">
            <img src="hebdo/img/modifier.png" alt="Modifier la tache" title="Modifier le tache" />
        </a>
        <a class="form-content-delete"
         data-nomtache="'.$hebdotravail['nomtache'].'"
          data-id="'.$hebdotravail['id'].'" data-jour="'.$hebdotravail['date'].'" data-source="'.$hebdotravail['source'].'" data-datedebutplanning="'.$hebdotravail['datedebutplanning'].'" data-datefinplanning="'.$hebdotravail['datefinplanning'].'">
            <img src="hebdo/img/delete.png" alt="Supprimer le travail" title="Supprimer le travail" />
        </a>
        </div>';
        } else {
            echo '<div class="boutons">
        <a class="form-content-pause-unstopped" data-idhebdo="'.$hebdotravail['id'].'"
         data-jour="'.$hebdotravail['date'].'">
            <img src="hebdo/img/pause.png" alt="Ajouter une pause" title="Ajouter une pause"/>
        </a>
        <a class="form-content-unstopped" data-idhebdo="'.$hebdotravail['id'].'"
         data-datedebutplanning="'.$hebdotravail['datedebutplanning'].'"
         data-jour="'.$hebdotravail['date'].'"
         data-heuredebut="'.$hebdotravail['heuredebut'].'"
         data-datefinplanning="'.$hebdotravail['datefinplanning'].'">
            <img src="hebdo/img/stop.png" alt="Terminer le travail" title="Terminer le travail" />
        </a>
        <a class="form-content-delete"
         data-nomtache="'.$hebdotravail['nomtache'].'"
          data-id="'.$hebdotravail['id'].'" data-jour="'.$hebdotravail['date'].'" data-source="'.$hebdotravail['source'].'" data-datedebutplanning="'.$hebdotravail['datedebutplanning'].'" data-datefinplanning="'.$hebdotravail['datefinplanning'].'">
            <img src="hebdo/img/delete.png" alt="Supprimer le travail" title="Supprimer le travail" />
        </a>
        </div>';
        }

    }

    public static function get_duree_travail($idtravail) {
        if (is_null($idtravail)) throw new Exception("idtravail non défini");
        $sql = "SELECT duree AS duree FROM wrk_travail WHERE id = '$idtravail'";
        $dureetravail = bdd::getResult($sql);
        return $dureetravail['duree'];
    }

    /**
     * calcule le temps total passé sur une tâche (incluant travail en cours)
     * */
    public static function get_dureetravailletache($idtache) {
        $sql = "
SELECT SUM(total) AS total FROM (
  SELECT SUM(IF(etat='en cours',unix_timestamp(),debut_pause)-date_debut) AS total FROM wrk_hebdo WHERE id_tache = '$idtache'
UNION
SELECT -SUM(duree) AS total FROM wrk_pauses p
  INNER JOIN wrk_hebdo h ON h.id = p.id_hebdo
  WHERE h.id_tache=$idtache) AS tmp";
        $res = bdd::getResult($sql);
        $dureehebdosurtache = $res["total"];

        $sql = "SELECT SUM(duree)*3600 as dureetravails FROM wrk_travail WHERE id_tache = '$idtache'";
        $dureetravailsurtache = bdd::getResult($sql);

        $dureetotalesurtache = $dureehebdosurtache + $dureetravailsurtache['dureetravails'];

        return $dureetotalesurtache;
    }


    public static function get_dureetravaillelot($idlot) {
		$sql = "
SELECT SUM(total) AS total FROM (
  SELECT SUM(IF(etat='en cours',unix_timestamp(),debut_pause)-date_debut) AS total
  FROM wrk_hebdo h
   INNER JOIN wrk_taches t ON t.id = h.id_tache
  WHERE t.id_lot = '$idlot'
UNION
SELECT -SUM(duree) AS total FROM wrk_pauses p
  INNER JOIN wrk_hebdo h ON h.id = p.id_hebdo
  INNER JOIN wrk_taches t ON t.id = h.id_tache
  WHERE t.id_lot = '$idlot') AS tmp";

//		$sql = "SELECT id FROM wrk_hebdo WHERE id_tache
//                 IN (SELECT id FROM wrk_taches WHERE id_lot = '$idlot')";
        $res = bdd::getResult($sql);
        $dureehebdosurlot = $res["total"];

        $sql = "SELECT SUM(duree)*3600 as dureetravails FROM wrk_travail WHERE id_tache
                 IN (SELECT id FROM wrk_taches WHERE id_lot = '$idlot')";
        $dureetravailsurlot = bdd::getResult($sql);
        $dureetotalesurlot = $dureehebdosurlot + $dureetravailsurlot['dureetravails'];
        return $dureetotalesurlot;
    }


/*
    public static function get_jourssemaine($jour)
    {
//Dates des jours de la semaine
        $t_auj = strtotime($jour);
        $p_auj = date('N', $t_auj);
        if ($p_auj == 1) {
            $deb = $t_auj;
            $fin = strtotime($jour . ' + 4 day');
        } else if ($p_auj == 5) {
            $deb = strtotime($jour . ' - 4 day');
            $fin = $t_auj;
        } else {
            $deb = strtotime($jour . ' - ' . (4 - (5 - $p_auj)) . ' day');
            $fin = strtotime($jour . ' + ' . (5 - $p_auj) . ' day');
        }

        $nomdesjours = array('Lundi', "Mardi", "Mercredi", "Jeudi", "Vendredi");
        $i = 0;
        while ($deb <= $fin) {
            $datesjoursdelasemaine[] = array(
                'libelle' => $nomdesjours[$i] . " " . strftime('%d / %m', $deb),
                'court' => strftime('%Y%m%d', $deb));

            $deb += 86400;
            $i++;
        }

        return $datesjoursdelasemaine;
    }
*/
    public static function get_jourssemaine($jour)
    {
//Dates des jours de la semaine
        $t_auj = strtotime($jour);
        $p_auj = date('N', $t_auj);
        if ($p_auj == 1) {
            $deb = $t_auj;
            $fin = strtotime($jour . ' + 6 day');
        } else if ($p_auj == 7) {
            $deb = strtotime($jour . ' - 6 day');
            $fin = $t_auj;
        } else {
            $deb = strtotime($jour . ' - ' . (6 - (7 - $p_auj)) . ' day');
            $fin = strtotime($jour . ' + ' . (7 - $p_auj) . ' day');
        }

        while ($deb <= $fin) {
            $datesjoursdelasemaine[] = date('Y-m-d', $deb);
                $deb += 86400;
        }
        return $datesjoursdelasemaine;
    }
}