<?php
class CFSGestionDroits
{
	/**
	 * Tableau contenant la liste des droits de l'objet
	 *
	 * @var array(array())
	 */
	private static $listeDroitsEnBase;

	/**
	 * Affiche le bouton permettant d'ouvrir la popup de gestion des droits d'un objet
	 *
	 * @param string $type
	 * @param int $id_objet
	 */
	public static function getBoutonAttributionDroit($type, $id_objet)
	{
		if(Cmodule_fsadmin::usr_a_droit_generique('cGestUtils.attributionDroits')) {
			
			if ($type == 'liste') {
				$infos = usr_get_infos_droit_generique($id_objet);
				$titre = "Droit $infos[identifiant] ($infos[commentaire])";
			} else if ($type == 'fsa.liste') {
				$liste = CListes::get_liste($id_objet,false,'id_auto');
				$titre = "Droit de la liste $liste[identifiant] ($liste[commentaire])";
			}
			else $titre = "Droit $type $id_objet";
			
			$titre = str_replace('"',"'",$titre);
			
			return '<a title="'.$titre.'" href="#" id="btGestDroit" typeD="'.$type.'" id_objet="'.$id_objet.'"><img style="display: inline; height:30px; width: 30px; float: right;"idListe="'.$id_objet.'" src="images/utilisateurs/gestutils.png" /></a>';
		}
		return '';

	}

	public static function getBoutonAttributionDroitListe($identifiantListe)
	{
		if($liste = CListes::get_liste($identifiantListe))
		{
			$id_auto = $liste['id_auto'];
			if(Cmodule_fsadmin::usr_a_droit_generique('cGestUtils.attributionDroits'))
			return '<a href="#" id="btGestDroit" typeD="fsa.liste" id_objet="'.$id_auto.'"><img style="display: inline; height:30px; width: 30px; float: right;"idListe="'.$id_auto.'" src="images/utilisateurs/gestutils.png" /></a>';
		}

			

	}
	/**
	 * Affiche le contenu de la popup de gestion des droits d'un objet
	 *
	 * @param string $type
	 * @param int $id_objet
	 */
	public static function getContenuPopupGestDroits($type = '',$id_objet = '')
	{
		//		CEcho::echo_js(file_get_contents('modules/utilisateurs/www/js/FSgestUtilisateur.js'));
		if(empty($id_objet)) $id_objet = $_REQUEST['id_objet'];
		if(empty($type)) $type = $_REQUEST['type'];
		$content = file_get_contents('modules/utilisateurs/www/html_fichiers/dialog.cfsadmin.htm');
				
		if(Cmodule_fsadmin::usr_a_droit_generique('cGestUtils.attributionDroits'))
		{
				
			if(usr_a_droit($type,$id_objet))
			{
				$content = str_replace('#ID_OBJ#',$id_objet,$content);
				$content = str_replace('#TYPE#',$type,$content);
				$content = str_replace('#UNIK_ID#',uniqid(),$content);
				echo remplace_tous_blocs($content,array('CONTENU_GEST_DROITS' => self :: getListeDroits($type,$id_objet)));
			}
			else
			echo remplace_tous_blocs($content,array('CONTENU_GEST_DROITS' => 'Vous n\'avez pas les droits!'));
		}
		else
			echo remplace_tous_blocs($content,array('CONTENU_GEST_DROITS' => 'Vous n\'avez pas les droits!'));
			
	}
	/**
	 * Initialisation du tableau des droits
	 *
	 * @param string $type
	 * @param int $id_objet
	 */
	public static function initListeDroits($type,$id_objet) {
		if(empty(self :: $listeDroitsEnBase))
		self :: $listeDroitsEnBase = mysql_fetch_all(ifReq("SELECT * FROM `usr__droits_attribues` WHERE type = '$type' AND id_objet = ".$id_objet));
	}
	/**
	 * Affiche un tableau HTML avec la liste des groupes / utilisateurs et leur droits réspéctifs
	 *
	 * @param int $id_objet
	 */
	public static function getListeDroits($type,$id_objet = '')
	{
		if(Cmodule_fsadmin::usr_a_droit_generique('cGestUtils.attributionDroits'))
		{
			if(!is_numeric($id_objet)) return false;

			self :: initListeDroits($type,$id_objet);


			$html = '<style>.ligneGestionGroupe td{text-align:center;}';
			$html .= '.ligneGestionUtilisateur td{text-align:center;}</style>';
			$html .= '<table id="tableauGestionDroitsListeFSA">';
			$html .= '<tr>';
			$html .= '<th> Groupe </th>';
			$html .= '<th>&nbsp;</th>';
			$html .= '<th> Oui </th>';
			$html .= '<th> Non </th>';
			$html .= '<th> Hérite </th>';
			$html .= '<th>&nbsp;</th>';
			$html .= '<th> Ajouter </th>';
			$html .= '<th> Modifier </th>';
			$html .= '<th> Supprimer </th>';
			$html .= '</tr>';

			$resultBaseGroupe = mysql_fetch_all(ifReq("SELECT * FROM `usr__groupes` WHERE id_parent = 1"));
			foreach($resultBaseGroupe as $unGroupe)
			{
				$html .= self :: getHTMLInfosGroupe($unGroupe);
			}

			$html .= '</table>';
			return $html;
		}
	}

	/**
	 * Renvoi une ligne <tr> avec les boutons de gestion des droits pour un groupe
	 *
	 * @param array() $unFetchDeGroupe
	 * @param int $padding
	 */
	public static function getHTMLInfosGroupe($unFetchDeGroupe, $padding = 0)
	{
		if(Cmodule_fsadmin::usr_a_droit_generique('cGestUtils.attributionDroits'))
		{
			$listeDroits = self :: recupDroitGroupe($unFetchDeGroupe['id_auto']);
			$testDroits = self :: testDroitGroupe($unFetchDeGroupe['id_auto']);

			switch($testDroits)
			{
				case 0:
					$sel1 = '';
					$sel2 = 'checked';
					$sel3 = '';
					break;
				case 1:
					$sel1 = 'checked';
					$sel2 = '';
					$sel3 = '';

					$check1 = ($listeDroits['ajouter'])? "checked='checked'" : '';
					$check2 = ($listeDroits['modifier'])? "checked='checked'" : '';
					$check3 = ($listeDroits['supprimer'])? "checked='checked'" : '';
					break;
				case 2:
					$sel1 = '';
					$sel2 = '';
					$sel3 = 'checked';

					$check1 = ($listeDroits['ajouter'])? "checked='checked'" : '';
					$check2 = ($listeDroits['modifier'])? "checked='checked'" : '';
					$check3 = ($listeDroits['supprimer'])? "checked='checked'" : '';
					break;
			}
			$html .= '<tr class="ligneGestionGroupe" padd="'.$padding.'" idParent="'.$unFetchDeGroupe['id_parent'].'" idGroupe="'.$unFetchDeGroupe['id_auto'].'">';
			$html .= '<td style="text-align: left;padding-left: '.$padding.'px;"><h1 style="cursor: pointer; display: inline;" idGroupe="'.$unFetchDeGroupe['id_auto'].'" class="btAfficheUser">+</h1><img src="images/utilisateurs/gestutils.png" style="display:inline; width: 16px; height: 16px" /><h2 style="display:inline;">'.$unFetchDeGroupe['identifiant'].'</h2></td>';
			$html .= '<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>';
			$html .= '<td> ';
			$html .= '<input type="radio" style="width: 80px; height: 20px;" name="droit_'.$unFetchDeGroupe['identifiant'].'" class="attrDroit_oui" value="1" '.$sel1.'/>';
			$html .= '</td>';
			$html .= '<td>';
			$html .= '<input type="radio" style="width: 80px; height: 20px;" name="droit_'.$unFetchDeGroupe['identifiant'].'" class="attrDroit_non" value="2" '.$sel2.'/>';
			$html .= '</td>';
			$html .= '<td>';
			$html .= '<input type="radio" style="width: 80px; height: 20px;" name="droit_'.$unFetchDeGroupe['identifiant'].'"  class="attrDroit_herite" value="3" '.$sel3.'/>';
			$html .= '</td>';
			$html .= '<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>';
			$html .= '<td>';
			$html .= '<input type="checkbox" style="width: 80px; height: 20px;" class="checkDroitAjouter" '.$check1.'/>';
			$html .= '</td><td>';
			$html .= '<input type="checkbox" style="width: 80px; height: 20px;" class="checkDroitModifier" '.$check2.'/>';
			$html .= '</td><td>';
			$html .= '<input type="checkbox" style="width: 80px; height: 20px;" class="checkDroitSupprimer" '.$check3.'/>';
			$html .= '</td>';
			$html .= '</tr>';
			$html .= '<tr class="ligneGestionUtilisateur" idParent="'.$unFetchDeGroupe['id_auto'].'">';
			$html .= '<td colspan="9" style="text-align: left;padding-left: '.$padding.'px;"></td>';
			$html .= '</tr>';
			$resultBaseGroupe = mysql_fetch_all(ifReq("SELECT * FROM `usr__groupes` WHERE id_parent = ".$unFetchDeGroupe['id_auto']));
			foreach($resultBaseGroupe as $unGroupe)
			{
				$html .= self :: getHTMLInfosGroupe($unGroupe, $padding + 30);
			}
			return $html;
		}
	}

	/**
	 * Test le type de droit d'un groupe (oui, non, herite)
	 * @param int $id_groupe
	 */
	public static function testDroitGroupe($id_groupe)
	{
		foreach(self :: $listeDroitsEnBase as $unDroit)
		{
			if($unDroit['id_groupe'] == $id_groupe)
			return $unDroit['autorise'];
		}
		return 2;
	}

	/**
	 * Test le type de droit d'un utilisateur (oui, non, herite)
	 *
	 * @param int $id_util
	 */
	public static function testDroitUtilisateur($id_util)
	{
		//		print_rr(self :: $listeDroitsEnBase);
		foreach(self :: $listeDroitsEnBase as $unDroit)
		{
			if($unDroit['id_utilisateur'] == $id_util)
			return $unDroit['autorise'];
		}
		return 2;
	}

	/**
	 * Récupere les droits d'un utilisateur grace à la propriété membre $listeDroitsEnBase
	 *
	 * @param int $id_util
	 */
	public static function recupDroitUtilisateurs($id_util)
	{
		foreach(self :: $listeDroitsEnBase as $unDroit)
		{
			if($unDroit['id_utilisateur'] == $id_util && $unDroit['autorise'])
			{
				return array(
				'ajouter' => $unDroit['ajouter'],
				'modifier' => $unDroit['modifier'],
				'supprimer' => $unDroit['supprimer'],
				);
			}
		}
		$recup = testReq3("SELECT u2.id_auto as idGroupe FROM `usr__utilisateurs` u1, `usr__groupes` u2 WHERE u1.groupe = u2.identifiant AND u1.id_auto = ".$id_util);
		return self :: recupDroitGroupe($recup['idGroupe']);
	}

	/**
	 * Récupere les droits d'un groupe grace à la propriété membre $listeDroitsEnBase
	 *
	 * @param int $id_groupe
	 */
	public static function recupDroitGroupe($id_groupe)
	{
		foreach(self :: $listeDroitsEnBase as $unDroit)
		{
			if($unDroit['id_groupe'] == $id_groupe && $unDroit['autorise'])
			{
				return array(
				'ajouter' => $unDroit['ajouter'],
				'modifier' => $unDroit['modifier'],
				'supprimer' => $unDroit['supprimer'],
				);
			}
		}
		$recup = testReq3("SELECT id_parent FROM usr__groupes WHERE id_auto = ".$id_groupe);
		if($recup['id_parent'] != null)
		return self :: recupDroitGroupe($recup['id_parent']);
		else
		{
			return array(
				'ajouter' => 0,
				'modifier' => 0,
				'supprimer' => 0,
			);
		}
	}

	/**
	 * Renvoi la liste en HTML (<tr>) d'un groupe
	 *
	 * @param unknown_type $id_groupe
	 */
	public function getListeUtilisateurGroupe($id_groupe = '')
	{
		if(Cmodule_fsadmin::usr_a_droit_generique('cGestUtils.attributionDroits'))
		{
			if(empty($id_groupe)) $id_groupe = $_REQUEST['id_groupe'];
			self :: initListeDroits($_REQUEST['type'],$_REQUEST['idObj']);
			$resultBaseUtils = mysql_fetch_all(ifReq("SELECT u1.id_auto,u2.id_auto as idGroupe, login FROM `usr__utilisateurs` u1, `usr__groupes` u2 WHERE u1.groupe = u2.identifiant AND u2.id_auto = ".$id_groupe));
			foreach($resultBaseUtils as $unGroupe)
			{
				$html .= self :: getHTMLInfosUtils($unGroupe);
			}

			//			$html .= '</table>';
			echo $html;
		}
	}

	/**
	 * Renvoi une ligne <tr> avec les boutons de gestion des droits pour un utilisateur
	 *
	 * @param array() $unUtil
	 */
	public static function getHTMLInfosUtils($unUtil)
	{
		if(Cmodule_fsadmin::usr_a_droit_generique('cGestUtils.attributionDroits'))
		{

			$listeDroits = self :: recupDroitUtilisateurs($unUtil['id_auto']);
			$testDroits = self :: testDroitUtilisateur($unUtil['id_auto']);

			switch($testDroits)
			{
				case 0:
					$sel1 = '';
					$sel2 = 'checked';
					$sel3 = '';
					break;
				case 1:
					$sel1 = 'checked';
					$sel2 = '';
					$sel3 = '';

					$check1 = ($listeDroits['ajouter'])? "checked='checked'" : '';
					$check2 = ($listeDroits['modifier'])? "checked='checked'" : '';
					$check3 = ($listeDroits['supprimer'])? "checked='checked'" : '';
					break;
				case 2:
					$sel1 = '';
					$sel2 = '';
					$sel3 = 'checked';

					$check1 = ($listeDroits['ajouter'])? "checked='checked'" : '';
					$check2 = ($listeDroits['modifier'])? "checked='checked'" : '';
					$check3 = ($listeDroits['supprimer'])? "checked='checked'" : '';
					break;
			}

			$html .= '<tr class="ligneGestionUtilisateur" idUtilisateur="'.$unUtil['id_auto'].'" idParent="'.$unUtil['idGroupe'].'">';
			$html .= '<td class="tdNomUser" style="text-align: left;"><img src="images/utilisateurs/user.png" style="display:inline; width: 16px; height: 16px" /><h3 style="display:inline;">'.$unUtil['login'].'</h3></td>';
			$html .= '<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>';
			$html .= '<td> ';
			$html .= '<input type="radio" style="width: 80px; height: 20px;" name="droit_usr_'.$unUtil['id_auto'].'" class="attrDroit_oui" value="1" '.$sel1.'/>';
			$html .= '</td>';
			$html .= '<td>';
			$html .= '<input type="radio" style="width: 80px; height: 20px;" name="droit_usr_'.$unUtil['id_auto'].'" class="attrDroit_non" value="2" '.$sel2.'/>';
			$html .= '</td>';
			$html .= '<td>';
			$html .= '<input type="radio" style="width: 80px; height: 20px;" name="droit_usr_'.$unUtil['id_auto'].'"  class="attrDroit_herite" value="3" '.$sel3.'/>';
			$html .= '</td>';
			$html .= '<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>';
			$html .= '<td>';
			$html .= '<input type="checkbox" style="width: 80px; height: 20px;" class="checkDroitAjouter" '.$check1.'/>';
			$html .= '</td><td>';
			$html .= '<input type="checkbox" style="width: 80px; height: 20px;" class="checkDroitModifier" '.$check2.'/>';
			$html .= '</td><td>';
			$html .= '<input type="checkbox" style="width: 80px; height: 20px;" class="checkDroitSupprimer" '.$check3.'/>';
			$html .= '</td>';
			$html .= '</tr>';
			return $html;
		}
	}

	public static function sauvegardeDonnees()
	{
		if(Cmodule_fsadmin::usr_a_droit_generique('cGestUtils.attributionDroits'))
		{
			
			$type = $_REQUEST['type'];
			$idObj = $_REQUEST['idObj'];

			foreach($_REQUEST['monTableau'] as $unDroit)
			{
				$autorise = 0;
				if(isset($unDroit['idGroupe'])) {
					$unDroit['idGroupe'] = usr_get_groupe($unDroit['idGroupe'],"id_auto");
					$unDroit['idGroupe'] = $unDroit['idGroupe']["identifiant"];
				}
				$idUtilisateur = isset($unDroit['idUtilisateur'])?$unDroit['idUtilisateur']:NULL;
				$idGroupe = isset($unDroit['idGroupe'])?$unDroit['idGroupe']:NULL;

				$modifier = $unDroit['modifier'] == "true"?1:0;
				$ajouter = $unDroit['ajouter'] == "true"?1:0;
				$supprimer = $unDroit['supprimer'] == "true"?1:0;

				if(usr_a_droit($type,$idObj)){
					switch($unDroit['typeDroit'])
					{
						case 'oui':
							$autorise = 1;
						case 'non':
							usr_set_droit($type,$idObj,$autorise,$idUtilisateur,$idGroupe,NULL,NULL,1,$ajouter,$modifier,$supprimer);
							break;
						case 'herite':
							usr_unset_droit($type, $idObj, 0,$idUtilisateur,$idGroupe);
							break;
					}
				}

			}
			echo CMessages::ajoute_message('Modifications efféctuées avec succés!');
		}
	}
}