<?php
//include_once 'modules/listes/classes/CListes.class.php';//auto

class CTypeAffichage {

	protected $debut=null;
	protected $entete=null;
	protected $fin=null;
	protected $element=null;
	protected $editer=null;
	protected $supprimer=null;
	protected $ajouter=null;
	protected $activer=null;
	protected $ligne_paire="";
	protected $variablesListe=array();
	
	public $layout = '#DEBUT# #ENTETE# #LISTE# #FIN# #BT_AJOUTER#';
	
	public $position_bt_ajouter = 'fin';
	
	const POS_DEBUT = 'debut';
	const POS_FIN = 'fin';
	
	const LAYOUT_AJOUTER_DEBUT = '#BT_AJOUTER# #DEBUT# #ENTETE# #LISTE# #FIN#';
	const LAYOUT_AJOUTER_FIN = '#DEBUT# #ENTETE# #LISTE# #FIN# #BT_AJOUTER#';
	
	protected $editable = false;

	public $old_methode=false;
	protected $liste_champs_aol = array();
	protected $is_aol = false;

	public static $editer_defaut;
	public static $supprimer_defaut;
	public static $ajouter_defaut;

	public function CTypeAffichage() {
		
	}

	public function __toString() {
		return "CTypeAffichage (..";
	}
	public function ajouteVariableListe($var,$val) {
		$this->variablesListe[$var]=$val;
	}
	public function getVariablesListe() {
		return $this->variablesListe;
	}
	public function get_debut() {
		return $this->debut;
	}
	public function get_entete() {
		return $this->entete;
	}
	public function get_fin() {
		return $this->fin;
	}
	public function get_element() {
		return $this->element;
	}
	public function get_editer() {
		if(!$this->old_methode && ! $this->editable) return "";
		if(!empty($this->editer)) return $this->editer;
		return self::get_editer_defaut();
	}
	public function get_supprimer() {
		if(!$this->old_methode && ! $this->editable) return "";
		if(!empty($this->supprimer)) return $this->supprimer;
		return self::get_supprimer_defaut();
	}
	public function get_ajouter() {
		
		if(!$this->old_methode && ! $this->editable) return "";
		if(!empty($this->ajouter)) return $this->ajouter;
		return self::get_ajouter_defaut();
	}
	public function get_activer() {
		if(!$this->old_methode && ! $this->editable) return "";
		if(!empty($this->activer)) return $this->activer;
		
		return 'activer_DEFAUT'; // ON A PAS DE self::get_ajouter_defaut() !! (? ca craint ?)
		
		//return self::get_ajouter_defaut();
	}

	private static function get_editer_defaut() {
		if(empty(self::$editer_defaut)) self::$editer_defaut=CListes::get_bouton_edit_elem("#ID_LISTE#","#ID_AUTO#","#ID_EXT#",NULL,"Visualiser / modifier");
		return self::$editer_defaut;
	}
	private static function get_supprimer_defaut() {
		if(empty(self::$supprimer_defaut)) self::$supprimer_defaut=CListes::get_bouton_efface_elem("#ID_LISTE#","#ID_AUTO#","#ID_EXT#",NULL,"Visualiser / modifier");
		return self::$supprimer_defaut;
	}
	private static function get_ajouter_defaut() {
		if(empty(self::$ajouter_defaut)) self::$ajouter_defaut=CListes::get_bouton_ajout_elem("#ID_LISTE#","#ID_EXT#");
		return self::$ajouter_defaut;
	}

	public function get_ligne_paire() {
		return $this->ligne_paire;
	}

	public function get_element_rempli($data,$i) {
		//		if($this->is_aol) $data["num_aol"]=Cmodule_aol::next_num_aol();
		$elem = $this->get_element();
//		print_rr($data);
//		echo "<br>".htmlentities(remplace_tous_blocs($elem,$this->variablesListe,"#LIS_"));
		return remplace_tous_blocs(remplace_tous_blocs($elem,$this->variablesListe,"#LIS_"),$data);
	}
	/**
	 *
	 * @param $identifiant_liste : String
	 * @param $descriptions : array description des champs (BDD liste)
	 * @param $liste_champs : array = liste des champs qui utilisent l'AOL ( array("titre","texte"))
	 * @return nothing
	 */
	public function init_aol($identifiant_liste,&$descriptions,$liste_champs=NULL) {
		$this->is_aol = true;
		$remplace_aol = array();
		foreach($descriptions as &$desc) {
			// if AOL ?
			if($desc["aol"] && (isNULL($liste_champs) || in_array($desc["nom_colonne"],$liste_champs))) {
				$nom_colonne=$desc["nom_colonne"];
				//				$this->liste_champs_aol[$desc["nom_colonne"]]=$desc;
				$remplace_aol[$nom_colonne]=Cmodule_aol::ajoute_AOL_liste($identifiant_liste,$nom_colonne);
				//				"<div id='aol_$nom_colonne'>#".strtoupper($nom_colonne)."#</div>";
			}
		}
		$this->element = remplace_tous_blocs($this->element,$remplace_aol);
	}

	public function init_images($identifiant_liste,&$descriptions,$res_affichage) {
		return CListes::get_res_images_multiples_for_str($this->element,$identifiant_liste,$descriptions,$res_affichage);
	}

	public function init(&$fetch) {

	}
	public function set_editable_aol($editable) {
		$this->element = affiche_element_multiple_par_balise($this->element,"AOL",$editable);
		$this->ajouter = affiche_element_multiple_par_balise($this->ajouter,"AOL",$editable);
		// ... etc ? au besoin !
	}

	public function toformatHTML() {
		return array(
			"debut"=>$this->get_debut(),
			"entete"=>$this->get_entete(),
			"elem"=>$this->get_element(),
			"fin"=>$this->get_fin(),
			"ajouter"=>$this->get_ajouter(),
			"activer"=>$this->get_activer(),
			"editer"=>$this->get_editer(),
			"supprimer"=>$this->get_supprimer(),
			"ligne_paire"=>$this->get_ligne_paire()
		);
	}

	public function isTypeValide()
	{
		return true;
	}

	public static function ajoute_type($identifiant,$fichier_classe,$classe,$parametres="", $typeSite = 'standard') {
		CListes::insere_update("lis_type_affichage",array("identifiant"=>$identifiant,"fichier"=>$fichier_classe,"classe"=>$classe,"parametres"=>$parametres, 'type_site'=>$typeSite),"identifiant, type_site");
	}

	public static function get_type_by_identifiant($identifiant) {
		
		//"SELECT *, (type_site = '".CSite::get_type_site()."') AS type_site_ok FROM site__pages_modeles WHERE identifiant='$identifiant_modele' ORDER BY type_site_ok DESC"
		if(!$liste=CListes::get_liste('lis_type_affichage')) {
			trace_erreur("CTypeAffichage::get_type_by_identifiant() : liste lis_type_affichage inexistante");
			return false;
		}
		
		$req = "SELECT *, (type_site = '".CSite::get_type_site()."') AS type_site_ok FROM $liste[table] WHERE identifiant='$identifiant' ORDER BY type_site_ok DESC";
		$res_aff = testReq3($req);
		
		//$res_aff = CListes::get_elem_by("lis_type_affichage","identifiant",$identifiant);
		include_once $res_aff["fichier"];
		$classe=$res_aff["classe"];
		
		if(strlen($res_aff["parametres"])>0) {
			$params=explode(",",$res_aff["parametres"]);
			// make a reflection object
			$reflectionObj = new ReflectionClass($classe);

			// use Reflection to create a new instance, using the $args
			return $reflectionObj->newInstanceArgs($params);
		}
		return new $classe();
	}

	// special JQ
	
	private $action_editer = "";
	private $params_editer = "";
	public function setActionEditer($action,$params=null) {
		$this->ajouteVariableListe("action_editer" , '"'.$action.'"');
		$this->ajouteVariableListe("params_editer" , json_encode($params));
	}
	
	private $action_supprimer = "";
	private $params_supprimer = "";
	public function setActionSupprimer($action,$params=null) {
		$this->ajouteVariableListe("action_supprimer" , '"'.$action.'"');
		$this->ajouteVariableListe("params_supprimer" , json_encode($params));
	}
	
	private $action_ajouter = "";
	private $params_ajouter = "";
	public function setActionAjouter($action,$params=null) {
		$this->ajouteVariableListe("action_ajouter" , '"'.$action.'"');
		$this->ajouteVariableListe("params_ajouter" , json_encode($params));
	}
	
	private $action_activer = "";
	private $params_activer = "";
	public function setActionActiver($action,$params=null) {
		$this->ajouteVariableListe("action_activer" , '"'.$action.'"');
		$this->ajouteVariableListe("params_activer" , json_encode($params));
	}

}
?>