<?php
class CAffichageStats
{
	public $titre;
	public $nb_periodes;
	public $resultats;
	
	private $stats; //contient les stats à générer
	private $labels; //contient après création des stats les labels des périodes
	private $date_depart;
	private $duree;
	private $type_calendrier;
	
	private static $first_graph = true;
	private static $numero_graph_actuel = 0;
	
	private static $couleurs = array('#000000', '#FF0000', '#00FF00', '#0000FF', '#FD08BC');
	
	public function CAffichageStats($titre)
	{
		$this->titre = $titre;
		$this->nb_periodes = 3;
		$this->stats = array();
		$this->resultats = array();
		$this->labels = array();
		$this->type_calendrier = '';
	}
	
	/**
	 * @param $nom_stat : un nom pour la stat
	 * @param $requete : la requete pour récupérer la stat, sans les conditions de périodes
	 * @param $champ_date : le nom du champ de date de la table
	 */
	public function ajouteStat($nom_stat, $requete, $champ_date)
	{
		$this->stats[] = array('nom'=>$nom_stat, 'requete'=>$requete, 'champ_date'=>$champ_date);
	}
	
	/**
	 * @param $date_depart : format mysql YYYY-MM-DD
	 * @param $duree : nombre de jours
	 */
	public function setPeriode($date_depart, $duree = 1)
	{
		$this->date_depart = $date_depart;
		$this->duree = $duree;
	}
	
	/**
	 * @param $type : type de période : J = jour, S = semaine, M = mois, A = année
	 * @param $date_depart : format mysql YYYY-MM-DD, seul le nécessaire sera utilisé selon $type, date du jour utilisé si vide
	 */
	public function setPeriodeCalendrier($type = 'M', $date_depart = '')
	{
		
		if ($type == 'S') //if (semaine) on passe en mode setPeriode classique, suffit juste de trouver le lundi, et duree = 7
		{
			if ($date_depart == '') $date_depart = date('Y-m-d');
			$expl = explode('-', $date_depart);
			$num_jour = date('w', mktime(0,0,0,$expl[1],$expl[2], $expl[0]));
			if ($num_jour == 1) $this->setPeriode($date_depart, 7);
			else if ($num_jour > 1) $this->setPeriode(date('Y-m-d', mktime(0,0,0,$expl[1],$expl[2]-($num_jour-1), $expl[0])), 7);
			else $this->setPeriode(date('Y-m-d', mktime(0,0,0,$expl[1],$expl[2]-6, $expl[0])), 7);
			return;
		}
		else if ($type == 'J')
		{
			if ($date_depart == '') $date_depart = date('Y-m-d');
			$this->setPeriode($date_depart, 1);
			return;
		}
		
		$this->type_calendrier = $type;
		
		if ($date_depart == '') $this->date_depart = date('Y-m-d');
		else $this->date_depart = $date_depart;
	}
	
	public function creeStats()
	{
		$this->resultats = array();
		$this->labels = array();
		
		for ($i = 0; $i < count($this->stats); $i++) //pour chaque stat
		{
			
			for ($j = $this->nb_periodes-1; $j >= 0; $j--) //pour chaque période à calculer
			{
				$dates = $this->getDatesPeriode($j);
				$deb = $dates['debut'];
				$fin = $dates['fin'];
				
				//faire la requete
				$q = $this->getRequete($this->stats[$i]['requete'], $this->stats[$i]['champ_date'], $deb, $fin);
				
				$tmp = mysql_fetch_row(ifReq($q));
				$this->resultats[$this->stats[$i]['nom']][-$j + $this->nb_periodes-1]['label'] = $this->getLabelPeriode($deb, $fin);
				$this->resultats[$this->stats[$i]['nom']][-$j + $this->nb_periodes-1]['valeur'] = $tmp[0];
				
				$this->labels[-$j + $this->nb_periodes-1] = $this->getLabelPeriode($deb, $fin);
			}
		}
		//print_rr($this->resultats);
	}
	
	/**
	 * @param $table : balise <table> personnalisée, '' pour normal
	 * @param $tr : balise <tr> personnalisée, '' pour normal
	 * @param $td : balise <td> personnalisée, '' pour normal
	 * @param $tr1 : balise <tr> personnalisée pour la 1ère ligne avec les entêtes de périodes, '' pour normal
	 * @param $td1 : balise <td> personnalisée pour la 1ère ligne avec les entêtes de périodes, '' pour normal
	 * @param $tdL : balise <td> personnalisée pour la 1ère colonne de chaque ligne avec les noms des stats, '' pour normal
	 */
	public function afficheTableau($table = '', $tr = '', $td = '', $tr1 = '', $td1 = '', $tdL = '')
	{
		if ($table == '') $table = '<table>';
		if ($tr == '') $tr = '<tr>';
		if ($td == '') $td = '<td>';
		if ($tr1 == '') $tr1 = '<tr>';
		if ($td1 == '') $td1 = '<td>';
		if ($tdL == '') $tdL = '<td>';
		
		$tableau = $table.$tr1.$td1.'</td>';
		
		for ($i = 0; $i < count($this->labels); $i++) $tableau .= $td1.$this->labels[$i].'</td>';
		$tableau .= '</tr>';
		
		foreach ($this->resultats as $nom_stat => $tab_stat) //pour chaque stat
		{
			$tableau .= $tr.$tdL.$nom_stat.'</td>';
			
			for ($j = 0; $j < count($tab_stat); $j++) //pour chaque période à calculer
			{
				$tableau .= $td.$tab_stat[$j]['valeur'].'</td>';
			}
			$tableau .= '</tr>';
		}
		$tableau .= '</table>';
		
		return $tableau;
	}
	
	public function afficheGraph($type = 'bar')
	{
		$datajson = $this->genereDataGraph($type);
		
		if (self::$first_graph)
		{
			$object = '<script type="text/javascript" src="/js/super_admin/json/json2.js"></script>
						<script type="text/javascript" src="/js/super_admin/swfobject.js"></script>
						
						<script type="text/javascript">

						function ofc_ready()
						{
						 //   alert(\'ofc_ready\');
						}
						
						
						function findSWF(movieName) {
						  if (navigator.appName.indexOf("Microsoft")!= -1) {
						    return window[movieName];
						  } else {
						    return document[movieName];
						  }
						}
						</script>
						';
			self::$first_graph = false;
		}
		else $object = '';
		
		$numero = ++self::$numero_graph_actuel;
		
		$object .= '<script type="text/javascript">
					swfobject.embedSWF("/swf/super_admin/open-flash-chart.swf", "my_chart_'.$numero.'", "100%", "200", "9.0.0", "expressInstall.swf", {"get-data":"get_data_'.$numero.'"});
					
					function get_data_'.$numero.'()
					{
						return JSON.stringify('.$datajson.');
					}
					
					
					</script>
					<div id="my_chart_'.$numero.'"></div>';
		
		return $object;
	}
	
	private function genereDataGraph($type)
	{
		include_once 'modules/super_admin/ofc2/php5-ofc-library/lib/OFC/OFC_Chart.php';
		include_once 'modules/super_admin/ofc2/php5-ofc-library/lib/OFC/JSON_Format.php';
		
		$chart = new OFC_Chart();
		$chart->set_title( $title );
		
		$ind_couleur = 0;
		$max = 0;
		
		foreach ($this->resultats as $nom_stat => $tab_stat) //pour chaque stat
		{
			$tab_data = array();
			for ($j = 0; $j < count($tab_stat); $j++) //pour chaque période à calculer
			{
				if (empty($tab_stat[$j]['valeur'])) $tab_stat[$j]['valeur'] = 0;
				$tab_data[] = floatval($tab_stat[$j]['valeur']);
				if ($tab_stat[$j]['valeur'] > $max) $max = $tab_stat[$j]['valeur'];
			}
			if ($type == 'bar') $line = new OFC_Charts_Bar_Filled();
			else if ($type == 'line') $line = new OFC_Charts_Line();
			$line->set_values($tab_data);
			$line->set_key($nom_stat,10);
			if ($type == 'bar') $line->set_tooltip("$nom_stat : #val#");
			
			$line->set_colour(self::$couleurs[$ind_couleur++  % count(self::$couleurs)]);
			$chart->add_element($line);
		}
		$y = new OFC_Elements_Axis_Y();
		$y->set_range( 0, $max+2, round(($max+2)/4) );
		$chart->set_y_axis( $y );
		
		$x = new OFC_Elements_Axis_X();
		
		$x_axis_labels = new OFC_Elements_Axis_X_Label_Set();
		$x_axis_labels->set_size(8);
		$tab_labels = $this->labels;
		for ($i = 0; $i < count($tab_labels); $i++) $tab_labels[$i] = str_replace(' - ',"\n", $tab_labels[$i]);
		$x_axis_labels->set_labels( $tab_labels );

		$x->labels = $x_axis_labels;
		
		$chart->set_x_axis($x);
		
//		$title = new OFC_Elements_Title( $this->titre );
//		$chart->set_title($title);
		
		return $chart->toPrettyString();
	}
	
	private function getDatesPeriode($indice_periode)
	{
		$expl = explode('-', $this->date_depart);
		
		if ($this->type_calendrier == 'M')
		{
			$depart = date('Y-m-d', mktime(0,0,0, $expl[1]-$indice_periode, 1, $expl[0]));
			$fin = date('Y-m-d', mktime(0,0,0, $expl[1]-$indice_periode+1, 1, $expl[0]));
		}
		else if ($this->type_calendrier == 'A')
		{
			$depart = date('Y-m-d', mktime(0,0,0, 1, 1, $expl[0]-$indice_periode));
			$fin = date('Y-m-d', mktime(0,0,0, 1, 1, $expl[0]-$indice_periode+1));
		}
		else
		{
			$depart = date('Y-m-d', mktime(0,0,0, $expl[1], $expl[2]-($indice_periode*$this->duree), $expl[0]));
			$fin = date('Y-m-d', mktime(0,0,0, $expl[1], $expl[2]-($indice_periode*$this->duree)+$this->duree, $expl[0]));
		}
		return array('debut'=>$depart, 'fin'=>$fin);
	}
	
	private function getRequete($requete, $champ_date, $date_deb, $date_fin)
	{
		//$this->stats[] = array('nom'=>$nom_stat, 'requete'=>$requete, 'champ_date'=>$champ_date);
		$pos1 = strpos($requete, ' where ');
		$pos2 = strpos($requete, ' WHERE ');
		if ($pos1 !== false || $pos2 !== false) $where = ' AND';
		else $where = ' WHERE';
		
		$pos1 = strpos($requete, ' group by ');
		$pos2 = strpos($requete, ' GROUP BY ');
		
		if ($pos1 !== false || $pos2 !== false)
		{
			if ($pos1 !== false) $expl_req = explode(' group by ', $requete);
			else $expl_req = explode(' GROUP BY ', $requete);
			return $expl_req[0].$where." ($champ_date >= '$date_deb' AND $champ_date < '$date_fin') GROUP BY ".$expl_req[1];
		}
		
		return $requete.$where." ($champ_date >= '$date_deb' AND $champ_date < '$date_fin')";
	}
	
	private function getLabelPeriode($date_deb, $date_fin)
	{
		if ($this->type_calendrier == 'A') return substr($date_deb, 0, 4);
		else if ($this->type_calendrier == 'M')
		{
			$expl = explode('-', $date_deb);
			return $expl[1].'/'.$expl[0];
		}
		else
		{
			$explD = explode('-', $date_deb);
			$explF = explode('-', date('Y-m-d', strtotime("$date_fin -1 day")));
			
			if ($this->duree == 1 ) return $explD[2].'/'.$explD[1].'/'.$explD[0];
			
			return $explD[2].'/'.$explD[1].'/'.$explD[0].' - '.$explF[2].'/'.$explF[1].'/'.$explF[0];
		}
	}
}
?>