<?php
/**
 * Permet de gérer des exclusions / inclusions et de tester si une string est valide
 *
 * @author Leo
 *
 *	Si une exclusion est passé dans délimitateur # ils seront auto rajouté.
 *	Tous les caractere (*) seront remplacé par (.*) dans les regex.
 *
 *
 */
class CExclusionManager
{
	private $tab = array();


	public static function removeEmptyItems($item)
	{
		$item = trim($item);
		if (!empty($item) && $item != "\n\r" && $item != "\r\n" && $item != "\n" && $item != "\t"  && $item != "\r" && $item != null) {
			return true;
		}
		return false;
	}

	/**
	 * Construit le validateur et parse la chaine de définition de la validation
	 * @param unknown_type $str
	 */
	public function __construct($str)
	{
		$str = preg_replace('#\/\*(.*)\*\/#is','',$str);
		$str = preg_replace('#-- ([^\n]*)#is','',$str);

		$tabElem = explode("\n",$str);

		$tabElem = array_filter($tabElem, 'CExclusionManager::removeEmptyItems');

		$niv = 0;
		$this->tab[$niv]["mode"]='exclude';
		foreach($tabElem as $unElem)
		{
			$unElem = trim($unElem);
			if(strstr(strtolower($unElem),"[exclude]"))  $this->tab[++$niv]["mode"]='exclude';
			else if(strstr(strtolower($unElem),"[include]"))$this->tab[++$niv]["mode"]='include';
			else $this->tab[$niv]["liste"][]=$unElem;
			
		}
	}

	/**
	 * Renvoie true si la chaine est validée false sinon
	 * @param unknown_type $chaineAtester
	 */
	public function isValid($chaineAtester,&$because="")
	{
		for($i=count($this->tab)-1;$i>=0;$i--) {
			foreach($this->tab[$i]["liste"] as &$exp) {
				if(preg_match("#$exp#", $chaineAtester)) {
					$because = $exp;
					return $this->tab[$i]["mode"]=="include";
				}
			}
		}
		return true;
	}
	/**
	 * Retourne un tableau filtré
	 * @param unknown_type $tab
	 */
	public function arrayFilter($tab)
	{
		$retour = array();
		if(is_array($tab))
		{
			foreach($tab as $unT)
			{
				if($this -> isValid($unT)) $retour[] = $unT;
			}
		}
		return $retour;
	}
}
?>