﻿<?php
define("MIN_ERREUR",E_WARNING); // 0 | E_ERROR | E_WARNING | E_NOTICE
function myErrorHandler($errno, $errstr, $errfile, $errline)
{
	switch ($errno) {
		case E_USER_ERROR :
		case E_ERROR :
			if(MIN_ERREUR >= E_ERROR)
			SQL_admin::trace( "<b>My ERROR</b> [$errno] $errstr<br />\n".
         "  Fatal error on line $errline in file $errfile".
         ", PHP " . PHP_VERSION . " (" . PHP_OS . ")<br />\n".
         "Aborting...<br />\n","error");
			// exit(1);
			break;

		case E_USER_WARNING :
		case E_WARNING :
			if(MIN_ERREUR >= E_WARNING)
			SQL_admin::trace( "<b>WARNING</b> [$errno] $errstr ($errfile at $errline)<br />\n","warning");
			break;

		case E_USER_NOTICE :
		case E_NOTICE :
			if(MIN_ERREUR >= E_NOTICE)
			SQL_admin::trace( "<b>NOTICE</b> [$errno] $errstr ($errfile at $errline)<br />\n","notice");
			break;
		case E_STRICT:
			if(MIN_ERREUR >= E_NOTICE)
			SQL_admin::trace( "<b>strict</b> [$errno] $errstr ($errfile at $errline)<br />\n","estrict");
			break;
		case E_RECOVERABLE_ERROR:
			if(MIN_ERREUR >= E_NOTICE)
			SQL_admin::trace( "<b>recoverable</b> [$errno] $errstr ($errfile at $errline)<br />\n","erecoverable");
			break;

		default:
			SQL_admin::trace( "Unknown error type: [$errno] $errstr ($errfile at $errline)<br />\n","notice");
			break;
	}


}
$old_error_handler = set_error_handler("myErrorHandler");

class SQL_admin {
	const DIFFERE = "DIFFERE";
	const DIRECT = "DIRECT";
	const NONE = "NONE";

	/** mode de 'verbosité' */
	public static $verbose = self::DIFFERE;

	/** format html des traces pour la sortie */
	public static $trace_format = "<div style='border:solid 1px #CCC;background:#EEE'>#MSG</div>";

	/** tableau contenant les traces pour la sortie différée */
	private static $traces = array();

	public static function trace($msg,$couleur=NULL) {
		self::colore_msg($msg,$couleur);

		$msg=str_replace("#MSG",$msg,self::$trace_format);
		switch(self::$verbose) {
			case self::DIFFERE:
				array_push(self::$traces,$msg);
				break;
			case self::DIRECT:
				echo $msg;
				flush();
				ob_flush();
				break;
		}
	}

	private static function colore_msg(&$msg,$couleur=NULL) {
		switch($couleur) {
			case "error":
				$style = "color:#DD0000";
				break;
			case "warning":
				$style = "color:#DD5500";
				break;
			case "notice":
				$style = "color:#AA9900";
				break;
			case "erecoverable":
				$style = "color:#AA9900";
				break;
			case "estrict":
				$style = "color:#99AA00";
				break;
			default:
				return $msg;
		}
		$msg = "<span style='$style'>$msg</span>";
	}

	/**
	 *
	 * @return String : la chaine composant les traces
	 */
	public static function out($return=false) {
		$retour=implode("",self::$traces);
		self::clear();
		if($return) return $retour;
		echo $retour;
		flush();
		ob_flush();
	}

	public static function clear() {
		self::$traces=array();
	}

	/*
	 *
	 * les methodes de modification de BDD
	 *
	 */
	public static function create_table($nom_table,$str_creation) {
		if(!ifReq("ALTER TABLE ".RECH_BASE."`$nom_table`")) {
			// la table n'existe pas
			self::trace("création de la table <b>$nom_table</b>...");
			$str_creation=str_replace("#TABLE",$nom_table,$str_creation);
			if(!ifReq($str_creation)) {
				self::trace("erreur <br>".mysql_error());
				return false;
			} else {
				self::trace("OK.");
				return true;
			}
		}
	}

	public static function efface_table($nom_table) {
		if(ifReq("ALTER TABLE ".RECH_BASE."`$nom_table`")) {
			// la table existe
			self::trace("effacement de la table <b>$nom_table</b>...");
			if(!ifReq("DROP TABLE IF EXISTS ".RECH_BASE."`$nom_table`")) {
				self::trace("erreur <br>".mysql_error());
				return false;
			} else {
				self::trace("OK.");
				return true;
			}
		}
	}

	public static function ajoute_colonne($table,$colonne,$type,$not_null = true,$after = "",$default = "") {
		$not_null=$not_null?"NOT NULL":"";
		$req_insert = "ALTER TABLE ".RECH_BASE."`$table` ADD COLUMN `$colonne` $type $not_null $default $after ";
		if(!ifReq("SELECT `$colonne` FROM ".RECH_BASE."$table LIMIT 0,1")) {
			// vérification une colonne
			// on n'a pas la colonne $colonne
			self::trace("mise a jour table $table ajout colonne : $colonne...");
			if(!ifReq($req_insert)) {
				self::trace("erreur !!<br>".mysql_error());
				return false;
			}
			self::trace("ok");
			return true;
		}

	}

	public static function set_index($table,$champ,$type_index="") {
		//$type : UNIQUE / INDEX / ''
		if(!is_array($champ)) {
			$champ=array($champ);
		}
		$liste_champs=implode(", ",$champ);
		$liste_cles_trouvees=array();
		$query=ifReq("SHOW KEYS FROM ".RECH_BASE."$table ");
		$non_unique_attendu=($type_index=="UNIQUE"?0:1);
		while($res=mysql_fetch_array($query)) {
			$nom_colonne=$res["Column_name"];
			$Key_name=$res["Key_name"];

			if(!isset($liste_cles_trouvees[$Key_name])) {
				$liste_cles_trouvees[$Key_name]=array("nb"=>1,"nb_ok"=>0,"Column_name"=>$res["Column_name"],"Non_unique"=>$res["Non_unique"]);
			} else {
				$liste_cles_trouvees[$Key_name]["nb"]++;
			}
			if(in_array($nom_colonne,$champ)) {
				$liste_cles_trouvees[$Key_name]["nb_ok"]++;
			}
		}
		//print_rr($liste_cles_trouvees);
		//print($non_unique_attendu);
		foreach($liste_cles_trouvees as $Key_name=>$valeur_cle) {
			if(($valeur_cle["nb_ok"]==count($champ)) && ($valeur_cle["nb"]==count($champ))) {
				if($type_index=="") {
					if(ifReq("ALTER TABLE ".RECH_BASE."$table DROP INDEX `$Key_name`")) {
						self::trace("suppression clé $table.$liste_champs ... ok<br>");
						return true;
					}
				} else {
					if($valeur_cle["Non_unique"]!=$non_unique_attendu) {

						if(ifReq("ALTER TABLE ".RECH_BASE."$table DROP INDEX `$Key_name` ,
								ADD $type_index ($liste_champs) ")) 
						{
							self::trace("modification clé $table.$liste_champs : $type_index... ok<br>");
							return true;
						}
						self::trace("modification clé $table.$liste_champs : $type_index... erreur !!<br>");
						return false;
					}
				}
				return true;
			}

		}
		if($type_index!="") {
			// on n'a pas l'index
			self::trace("ajout clé $table.$liste_champs : $type_index...");
			if(ifReq("ALTER TABLE ".RECH_BASE."$table ADD $type_index ($liste_champs)")) {
				self::trace("ok<br>");
				return true;
			}
			self::trace("erreur !!<br>");
			return false;
		}
		// on arrive ici quand on doit retirer une clé, et qu'elle n'y était deja pas
		return true;

	}
	public static function cree_procedure($nom_procedure,$str_creation) {
		self::cree_function($nom_procedure,$str_creation,"PROCEDURE");
	}
	public static function cree_function($nom_function,$str_creation,$type="FUNCTION") {
//		bdd_definit_function($nom_function,"test",$type,$str_creation);
		if(ifReq("DROP $type IF EXISTS ".RECH_BASE."$nom_function","My2")) {
			self::trace("création de la <b>$type $nom_function</b>...");
			if(ifReq($str_creation,"My2")) {
				self::trace("OK.");
				return true;
			} else {
				self::trace("erreur <br>".mysql_error()."<br>$str_creation");
			}
		}
	}

	public static function insert($table,$donnees,$colonne_where,$update=false) {
		$where=calcule_where_not_insere($colonne_where,$donnees);
		if(testReq3("SELECT * FROM ".RECH_BASE."`$table` WHERE $where")) {
			if($update) {
				return self::update($table,$donnees,$colonne_where);
			}
			return false; // pas de maj !
		} else {
			if(mysql_insert(RECH_BASE.$table,"*",$donnees)) {
				self::trace("insertion '$table WHERE $where' ok ");
				return true;
			} else {
				self::trace("SQL_admin::insert erreur <br>".mysql_error());
				return false;
			}
		}
		return false;
	}
	
	public static function insert_update($table,$donnees,$colonne_where) {
		return self::insert($table,$donnees,$colonne_where,true);
	}
	public static function update_insert($table,$donnees,$colonne_where) {
		return self::insert($table,$donnees,$colonne_where,true);
	}


	public static function update($table,$donnees,$colonne_where) {
		if(mysql_update($table,"*",$donnees,$colonne_where)) {
			if(mysql_affected_rows()>0) {
				$where=calcule_where_not_insere($colonne_where,$donnees);
				self::trace("mise a jour '$table WHERE $where ' ok ");
			}
			return true;
		} else {
			self::trace("SQL_admin::update erreur <br>".mysql_error());
			return false;
		}

	}

	public static function delete($table,$donnees,$colonne_where) {
		$where=calcule_where_not_insere($colonne_where,$donnees);
		if(ifReq("DELETE FROM ".RECH_BASE."`$table` WHERE $where")) {
			if(mysql_affected_rows()>0) {
				self::trace("effacement de '$table WHERE $where' ok ");
				return true;
			} else {
				return true;
			}
		} else {
			self::trace("SQL_admin::delete erreur <br>".mysql_error());
			return false;
		}
		return false;
	}
}

/*
 * outils
 */

?>