<?php

// http://www.trirand.com/jqgridwiki/doku.php?id=wiki:jqgriddocs

class CFSAdminGrid
{
	private $requete;

	//paramètres Grid
	private $titres_colonnes = array();
	private $action_ajax = '';
	private $nb_lignes_par_page = '';
	private $autorise_ajout = false;
	private $autorise_modif = false;
	private $autorise_suppr = false;

	private $texte_fin = '';

	private $retour = '';

	public function CFSAdminGrid($requete = '')
	{
		if ($requete != '') $this->requete = $requete;
	}

	public function setTitresColonnes($tab_titres) { $this->titres_colonnes = $tab_titres; }
	public function setActionAjax($action) { $this->action_ajax = $action; }
	public function setNbLignesParPage($nb) { $this->nb_lignes_par_page = $nb; }
	public function setAutoriseAjout($bool) { $this->autorise_ajout = $bool; }
	public function setAutoriseModif($bool) { $this->autorise_modif = $bool; }
	public function setAutoriseSuppr($bool) { $this->autorise_suppr = $bool; }
	public function addTexteFin($str) { $this->texte_fin .= $str; }

	public function buildGrid($id_table, $titre, $affiche_navigation = true)
	{
		$retour = "<table id='$id_table'></table>";
		if ($affiche_navigation) $retour .= "<div id='nav_$id_table'></div>";

		//début Js
		$retour .= "<script type='text/javascript'>$(document).ready(function () {";

		$retour .= "$('#$id_table').jqGrid({
					url:'$this->action_ajax',
					datatype: 'json',
					";

		$row = testReq3($this->requete);

		$nb_colonnes = 0;
		$colonnes_mysql = array();
		foreach ($row as $key => $value)
		{
			++$nb_colonnes;
			$colonnes_mysql[] = $key;
		}
		if (count($this->titres_colonnes) != $nb_colonnes) $this->titres_colonnes = $colonnes_mysql;

		for ($i = 0; $i < count($this->titres_colonnes); $i++)
		$this->titres_colonnes[$i] = "'".str_replace("'","\'",$this->titres_colonnes[$i])."'";

		$retour.= "colNames:[".implode(', ', $this->titres_colonnes)."],";

		$retour.= "colModel:[";

		$tab_colmodel = array();
		$tab_colmodel[] = "{name:'id',index:'".$colonnes_mysql[0]."',hidden:true}";
		$tabRecherche=array("email");

		//TODO : traiter les autres options des colonnes (dont search), utiliser un objet par ligne?
		for ($i = 1; $i < count($colonnes_mysql); $i++) {
//			$str_cherche=(in_array($colonnes_mysql[$i],$tabRecherche)?", search:true":", search:false");
			$tab_colmodel[] = "{name:'".$colonnes_mysql[$i]."',index:'".$colonnes_mysql[$i]."', searchoptions:{sopt:['cn', 'eq', 'bw', 'ew', 'lt', 'le', 'gt', 'ge']}}";
		}

		$retour .= implode(', ', $tab_colmodel)."],";

		if ($affiche_navigation) $retour .= "pager:'#nav_$id_table',";

		if ($this->nb_lignes_par_page != '') $retour .= "rowNum:$this->nb_lignes_par_page,";

		$retour .= "rowList:[10,20,30],
					viewrecords: true, 
					mtype: 'POST', 
					height:'100%',
					width:$('#$id_table').parent().width(),
					caption:'".str_replace("'","\'",$titre)."'";

		$retour .= "});";

		if ($affiche_navigation)
		{
			$a_edit = $this->autorise_modif ? "true" : "false";
			$a_add = $this->autorise_ajout ? "true" : "false";
			$a_del = $this->autorise_suppr ? "true" : "false";
			$retour .= "$('#$id_table').jqGrid('navGrid','#nav_$id_table',{edit:$a_edit,add:$a_add,del:$a_del});";
		}

		$retour .= "$('#$id_table').jqGrid('filterToolbar',{stringResult:true});";

		if ($this->texte_fin != '') $retour .= $this->texte_fin;

		$retour .= ';';

		//fin Js
		$retour .= "});</script>";

		return $retour;
	}

	public function buildService()
	{
		$page = $_POST['page']; // get the requested page
		$limit = $_POST['rows']; // get how many rows we want to have into the grid
		$sidx = $_POST['sidx']; // get index row - i.e. user click to sort
		$sord = $_POST['sord']; // get the direction
		if(!$sidx) $sidx =1;
		
		$start = $limit*$page - $limit; // do not put $limit*($page - 1)

		
		if ($_POST['_search'] == 'true')
		{
			$filter = $this->recupFilters();
			$this->requete .= $filter;
		}
		
		
		$SQL = str_ireplace('select ', 'SELECT SQL_CALC_FOUND_ROWS ', $this->requete)." ORDER BY $sidx $sord LIMIT $start , $limit";
		$result = ifReq( $SQL );

		$res = testReq2("SELECT FOUND_ROWS()");
		$count = $res[0];

		if( $count > 0 ) $total_pages = ceil($count/$limit);
		else $total_pages = 0;

		if ($page > $total_pages) $page=$total_pages;

		$responce->page = $page;
		$responce->total = $total_pages;
		$responce->records = $count;
		$i=0;
		while($row = mysql_fetch_row($result))
		{
			$responce->rows[$i]['id']=$row[0];
			$responce->rows[$i]['cell']=$row;
			$i++;
		}
		return json_encode($responce);
	}

	private function recupFilters()
	{
		/* traiter aussi :
		 *  searchField	email
			searchOper	cn
			searchString	dff
		 */
		$retour = '';
		
		$tab_wheres = array();
		
		if (isset($_POST['searchField']) && $_POST['searchField'] != '')
		{
			$tab_wheres[] = $this->genereFilter($_POST['searchField'], $_POST['searchString'], $_POST['searchOper']);
		}
		if (isset($_POST['filters']))
		{
			$filters = json_decode($_POST['filters']);
			$group_op = $filters->groupOp;
			foreach ($filters->rules as $filtre)
			{
				//TODO: traiter tous les filtres de JqGrid
				$tab_wheres[] = $this->genereFilter($filtre->field, $filtre->data, $filtre->op);
			}
			
		}
		if (count($tab_wheres) > 0)
		{
			if (stripos($this->requete, 'WHERE') !== false) $retour .= ' AND (';
			else $retour .= ' WHERE (';
			
			$retour .= implode(' '.$group_op.' ', $tab_wheres).')';
			return $retour;
		}
	
		return '';
	}
	
	private function genereFilter($field, $data, $op)
	{
		//"$filtre->field LIKE '%$filtre->data%'";
		//['eq','ne','lt','le','gt','ge','bw','bn','in','ni','ew','en','cn','nc'] 
		//['equal','not equal', 'less', 'less or equal','greater','greater or equal', 'begins with',
		//	'does not begin with','is in','is not in','ends with','does not end with','contains','does not contain'] 
		switch($op)
		{
			case 'eq':
				return "$field = '$data'";
			case 'ne':
				return "$field != '$data'";
			case 'lt':
				return "$field < '$data'";
			case 'le':
				return "$field <= '$data'";
			case 'gt':
				return "$field > '$data'";
			case 'ge':
				return "$field >= '$data'";
			case 'bw':
				return "$field LIKE '$data%'";
			case 'bn':
				return "$field NOT LIKE '$data%'";
			case 'in':
				return "'$data' LIKE CONCAT('%', $field, '%')";
			case 'ni':
				return "'$data' NOT LIKE CONCAT('%', $field, '%')";
			case 'ew':
				return "$field LIKE '%$data'";
			case 'en':
				return "$field NOT LIKE '%$data'";
			case 'cn':
				return "$field LIKE '%$data%'";
			case 'nc':
				return "$field NOT LIKE '%$data%'";
		}
	}
}

?>