<?php
class CPageProduits extends CPageHTML {
	public $id_catA , $id_catB;
	public $catA , $catB , $produits;
	const id_catA_defaut = 1;

	private $resCatA;
	private $resCatB;
	private $resProd;

	public function __construct($id_catA=0, $id_catB=0) {
		$this->id_catA =($id_catA>0)? $id_catA : 0;
		$this->id_catB =($id_catB>0)? $id_catB : 0;

		$this -> resCatA = new Liste('categories');
		$this -> resCatA -> select("*",array('id_auto' => $this->id_catA == 0 ? -1 : $this->id_catA));

		$this -> resCatB = new Liste('categories');
		$this -> resCatB -> select("*",array('id_auto' => $this->id_catB == 0 ? -1 : $this->id_catB));

		$this -> check_url_valide();
	}
	public function get_url_attendue() {

		if($this -> resCatA -> isLoaded()) {
			if($this -> resCatB -> isLoaded()) {
				// deuxieme niveau
				return ($this -> resCatA -> render("/produits/#ID_AUTO#-#TITRE,url#/".$this -> resCatB -> render('#ID_AUTO#-#TITRE,url#').".htm"));
			}else {
				// catégorie premier niveau
				return ($this -> resCatA -> render("/produits/#ID_AUTO#-#TITRE,url#.htm"));
			}
		}else {
			return false;
		}
	}
	public function getContenu() {
		$aIds_cat = array();
		$moduleKRUZ = Cmodule::get_module("KRUZ");
		$modele = $moduleKRUZ -> file_get_contents_html('produits.contenu.htm');
		// recup des ids des cat pour select des produits
		if (!empty($this->id_catB)) {
			// recup juste l'Id de la sous-cat (catB)
			$aIds_cat[] = $this->id_catB;
		} else {
			if (empty($this->id_catA))  $this->id_catA = self::id_catA_defaut ;
			$aIds_cat = mysql_fetch_column(ifReq('SELECT id_auto FROM kruz__categories WHERE id_categorie = '.$this->id_catA),"id_auto");
			array_unshift($aIds_cat, $this->id_catA);
		}

		// fait liste des produits

		$resListe = CListes::get_contenu_liste('produits','id_categorie IN('.implode(',',$aIds_cat).') AND elem_actif = 1 ORDER BY elem_position');
		$resListe = mysql_fetch_all($resListe);
		foreach($resListe as $k => $v) {
			$resListe[$k]['description'] = FnKruz::normalizeDescription($v['description']);
		}
		$oListe_produits = CAffichageListe::afficheListeAvecFetch('produits','aff',$resListe);

		$contenu = str_replace('#PRODUITS_LISTE#',$oListe_produits, $modele);

		// recup des infos des cat A & B (A= cat principales, B = sous-cat)
		if ($this->id_catB > 0) {
			$this->catB = testReq3('SELECT * FROM kruz__categories WHERE id_auto = ' . $this->id_catB);
			$this->id_catA = $this->catB['id_categorie'];
		}
		if ($this->id_catA > 0) {
			$this->catA = testReq3('SELECT * FROM kruz__categories WHERE id_auto = ' . $this->id_catA);
		}
		// prepa data
		$aCat_sel_infos = array(
				"a_titre"=>$this->catA['titre'],
				"b_titre"=>((!empty($this->catB['titre']))? '&gt; '.$this->catB['titre'] : ''),
		);

		return remplace_tous_blocs($contenu, $aCat_sel_infos, '#CAT_SEL_');
	}
	public function getTitre() {
		return $this->catA['titre'] . ' - ' . $this->catB['titre']." - ";
	}

	public function getMotsCles() {
	}

	public function getDescription() {
	}

	public function getCSS() {
	}
}