<?php

define("DEBUG_REDIRECT",false);

include_once 'includes/general/str_url.inc.php';

class CSite {

	static function quick_rapport($titre,$msg,$erreur=false) {
		//include_once 'includes/general/Crapports.class.php';//auto
		$rapport=new Crapport();
		$rapport->Add_destinataire(Crapport::$quick_destinataire);
		$rapport->Add_trace("CLIENT : ".CLIENT);
		$rapport->Add_trace("SERVEUR : ".SERVEUR);
		$rapport->Add_trace($msg);
		if(DEBUGGER)
		$rapport->out("site ".CLIENT." ".(SERVEUR!=CLIENT?"(SERVEUR)":"")." : $titre",$erreur,true,false);
		else
		$rapport->Envoie("site ".CLIENT." ".(SERVEUR!=CLIENT?"(SERVEUR)":"")." : $titre",$erreur,false,true);
	}

	static $GENERAL_SECURITY_KEY = '';

	static $site_en_cours = NULL;
	private static $type_site = 'standard';
	static $identifiant_site_en_cours = NULL;
	static $page_en_cours = NULL;
	static $chemin_en_cours = NULL;
	static $metasPage = NULL;

	static $url_page_origine = null;
	static function setUrlPageOrigine($url) {
		if (is_null(self::$url_page_origine))
		self::$url_page_origine = $url;
	}
	static function getUrlPageOrigine() {
		return self::$url_page_origine;
	}

	static function get_page_demandee() {

		$url=$_SERVER["REQUEST_URI"];
		$parse = parse_url($url);
		//		exit($parse["path"]);
		$page_demandee=$parse["path"];

		self::setUrlPageOrigine($page_demandee);

		$query_string=$parse["query"];

		// si rewriting, on recup les params en GET et REQUEST
		if(strcmp($query_string,$_SERVER["QUERY_STRING"])!=0) {
			CSite::parse_query_string($query_string);
		}
		if(strcmp($_SERVER["REDIRECT_QUERY_STRING"],$_SERVER["QUERY_STRING"])!=0) {
			CSite::parse_query_string($_SERVER["REDIRECT_QUERY_STRING"]);
		}
		if(isset($_REQUEST["HTpage"])) {
			$page_demandee=$_REQUEST["HTpage"];
		}

		$page_demandee = CSite::rechercheLangueUrl($page_demandee);

		CSite::$chemin_en_cours=$detailChemin;


		CSite::$page_en_cours = $page_demandee;
		//		print_rr(CMultilingue::$definer);
		return $page_demandee;
	}

	static function rechercheLangueUrl($page_demandee,$temporaire = true) {
		//		echo $_SERVER["REQUEST_URI"].'_';
		if (Cmodule::module_existe("multilingue"))
		{
			$page_demandee=ltrim($page_demandee,"/");
			$detailChemin = explode("/",$page_demandee);
			if(strlen($detailChemin[0]) == 2 && CMultilingue::langueExists($detailChemin[0])) {
				CMultilingue::setLangueFrom("url",array_shift($detailChemin),$temporaire);
				$page_demandee=implode("/",$detailChemin);
				$_SERVER["REQUEST_URI"]="/".$page_demandee.(isNULL($query_string)?"":"?".$query_string);
				//				echo $_SERVER["REQUEST_URI"];
			}
			else if (ML_LANGUE_DEFAUT_INVISIBLE === true)  {
				CMultilingue::setLangueFrom("url",CMultilingue::$langue_defaut,$temporaire);
			}
			$page_demandee="/".$page_demandee;
		}
		return $page_demandee;
	}

	static function verifPageValide($page) {
		$valide =CSite::estPageValide($page);
		if( $valide === false) {
			CLog::logAction("piratage",$page);
			CSitemap::efface_url_sitemap($page);
			CSite::erreur404();
			if(DEBUGGER === true) Crapport::write();
			exit;
		} else if($valide !== true) {
			$page = $valide;
		}

		CSite::verifPageListeRedirection($page);

		return $page;
	}

	static function estPageValide($page) {
		$regsInvalide=array(
				"^/(f|web)?cgi(.*)",
				"^/ows-bin(.*)",
				"^/horde",
				"^/vgn/",
				"^/[.]/",
				"(.*)[.]asp$",
				"(.*)[.]cgi$",
				"(.*)[.]dll$",
				"(.*)[.]pl$",
				"(.*)[.]inc$",
				"(.*)[.]ini$",
				"(.*)[.]exe$",
				"(.*)[.]php3$",
				"(.*)[.]cfm$");
		$caracteres_invalides = array('"',"+","&","?","%","035;","#");
		foreach($regsInvalide as $reg) {
			if(eregi($reg,$page)) {
				return false;
			}
		}
		$change=false;
		foreach($caracteres_invalides as $carac) {
			$pos=strpos($page,$carac);
			if($pos !== false) {
				return false;
				$change= true;
				$page = substr($page,0,$pos);
			}
		}
		if($change) return $page;
		// si correction
		//return corrigee
		//		return "autre";
		return true;
	}


	private static $listeRedirections = array();
	static function addRedirection($mask,$nouvelle,$temporaire = false,$flags="i") {
		//		if(substr($mask,0,1) != substr($mask,-1,1))
		self::$listeRedirections["from"][]=$mask;
		self::$listeRedirections["mask"][]="}$mask}$flags";
		self::$listeRedirections["to"][]=$nouvelle;
		self::$listeRedirections["tempo"][]=$temporaire;
		//		=array(,$nouvelle,$temporaire);
	}
	static function verifPageListeRedirection($page) {

		if (!is_array(self::$listeRedirections["from"]) && !is_array(self::$listeRedirections["to"])) return;

		if(($pos = array_search($page,self::$listeRedirections["from"])) !== false) {
			CSite::redirige(self::$listeRedirections["to"][$pos],self::$listeRedirections["tempo"][$pos]);
		} else {
			foreach(self::$listeRedirections["mask"] as $pos=>$mask) {
				if(preg_match($mask,$page)) {
					CSite::redirige(self::$listeRedirections["to"][$pos],self::$listeRedirections["tempo"][$pos]);
				}
			}
		}
	}

	static function detection_site() {
		if(isNULL(CSite::$site_en_cours) ) {
			$domaine=$_SERVER["HTTP_HOST"];
			$req="SELECT * FROM site__sites WHERE '$domaine' REGEXP detection AND actif=1 ORDER BY priorite ASC LIMIT 0,1";
			//echo $req;
			if($res_site=testReq3($req)) {
				CSite::$site_en_cours = $res_site;
	//print_r($res_site);
				define('MOBILE_VERSION',$res_site["type_site"]!="standard");
				CSite::$type_site = $res_site["type_site"];
				return true;
			}
			define('MOBILE_VERSION',false);
			return false;
		}
		return true;
	}

	static function get_site() {
		if(CSite::detection_site())
		return CSite::$site_en_cours;
	}

	static function get_type_site() {
		CSite::detection_site();
		return CSite::$type_site;
	}


	static function get_contenu_page_active($url_page) {

		//include_once 'modules/site/classes/CSitemap.class.php';//auto
		$ret = CSite::detection_site();
		$or = '';
		if($ret)
		{
			$or = " OR identifiant_site = '".CSite::$site_en_cours['identifiant']."' ";
		}
		$req="SELECT * FROM site__pages_liste WHERE '$url_page' REGEXP concat('^',masque,'$') AND actif=1 AND (identifiant_site IS NULL ".$or.")  ORDER BY priorite ASC,identifiant_site DESC LIMIT 0,1";
// 		exit($req);
		if($res_page=testReq3($req)) {
			//print_rr($res_page);
			//echo '__pos:'.strpos($res_page['robots'], 'index');

			$module=Cmodule::get_module($res_page["id_module"]);
			$useCacheFichier = (USE_CACHE_FICHIER === true && !isset($_SESSION["mode_lofi"]) && $res_page["use_cache"] != "NON");
			$retour=false;

			if($useCacheFichier) {
				//include_once 'modules/site/classes/CGestionnaireCacheFichier.class.php';//auto
				$cacheManager = new CGestionnaireCacheFichier($url_page);
				$cacheManager->duree = $res_page["duree_cache"];
				$retour = $cacheManager->chargeCache();
			}
			if(!$retour) {

				if($res_page["use_stats"] != 1) {
					//include_once 'modules/site/classes/stats/CStat_site.class.php';//auto
					CStat_site::$stat_active = false;


				}
				// on vérifie le droit
				$autorise_page=true; // par défaut
				if(!empty($res_page["identifiant_droit"])) {
					//trace("droit $res_page[identifiant_droit]");
					$droit_page=CSite::get_droit_page($res_page["identifiant_droit"]);
					//Crapport::print_rr($droit_page);
					$autorise_page = usr_a_droit_page($res_page["identifiant_droit"]);
					//echo "$res_page[identifiant_droit] '$autorise_page'";
					//define("NO_REDIRECTION",false)
					if($autorise_page) {
						if(!empty($res_page["redirige_OK"])) {
							if (DEBUG_REDIRECT) trace("autorise_page && $res_page[redirige_OK] ==>redirige page <a href='$res_page[redirige_OK]'>$res_page[redirige_OK]</a>");
							else CSite::redirige($res_page["redirige_OK"]);
						} else if(!empty($droit_page["redirige_OK"])) {
							if (DEBUG_REDIRECT)trace("autorise_page && $droit_page[redirige_OK] ==>redirige droit <a href='$droit_page[redirige_OK]'>$droit_page[redirige_OK]</a>");
							else CSite::redirige($droit_page["redirige_OK"]);
						}
					} else if(!$autorise_page) {
						if(!empty($res_page["redirige_NOK"])) {
							if (DEBUG_REDIRECT) trace("! autorise_page && $res_page[redirige_NOK] ==>redirige page <a href='$res_page[redirige_NOK]'>$res_page[redirige_NOK]</a>");
							else CSite::redirige($res_page["redirige_NOK"]);
						} else if(!empty($droit_page["redirige_NOK"])) {
							if (DEBUG_REDIRECT) trace("! autorise_page && $droit_page[redirige_NOK] ==>redirige droit <a href='$droit_page[redirige_NOK]'>$droit_page[redirige_NOK]</a>");
							else CSite::redirige($droit_page["redirige_NOK"]);
						}
						else {
							return CSite::applique_modele("","Vous n'avez pas le droit.");
						}
					}
				}

				eregi($res_page["masque"],$url_page,$regs);
				define("PATERN_SITE",$res_page["masque"]);
				CSite::init_params_page($regs);

				Crapport::trace("masque repéré : ".$res_page["masque"]);
				Crapport::print_rr($regs);
				$res_page["fichier"]=CSite::remplace_params_page($res_page["fichier"]);
				$res_page["fonction"]=CSite::remplace_params_page($res_page["fonction"]);
				$res_page["parametres"]=CSite::remplace_params_page($res_page["parametres"]);
				$res_page["id_modele"]=CSite::remplace_params_page($res_page["id_modele"]);
				$res_page["classe_php"]=CSite::remplace_params_page($res_page["classe_php"]);
				$res_page["titre"]=CSite::remplace_params_page($res_page["titre"]);
				$res_page["description"]=CSite::remplace_params_page($res_page["description"]);
				$res_page["mots_cles"]=CSite::remplace_params_page($res_page["mots_cles"]);

				$contenu_ok=false;
				// MOBILE VERSION
				//				if(MOBILE_VERSION) $res_page["fichier"] = 'mobile/'.$res_page["fichier"];

				Crapport::print_rr($res_page);
				if(!empty($res_page["classe_php"])) {
					$nom_classe=array_pop(explode(".",$res_page["classe_php"]));
					$str_chemin = $module->get_path()."classes/pages/".$res_page["classe_php"].".class.php";
					Crapport::trace("classe_php : $str_chemin");
					include_once $str_chemin;
					$params="'".str_replace(",","','",$res_page["parametres"])."'";
					eval("\$page = new \$nom_classe($params);");

					$res_page_html = $page->export();
					$contenu=$res_page_html["html"];
					$contenu_ok=true;
				}

				if(!empty($res_page["id_page_html"]) && !$contenu_ok) {

					if($res_page_html=testReq3("SELECT * FROM site__pages_html WHERE id_auto = $res_page[id_page_html]")){
						$contenu=Cmodule::ajoute_blocs_html_modules($res_page_html["html"]);
						$contenu_ok=true;
					}
				}
				if($res_page["fichier"] && !$contenu_ok) {
					//				trace("on a un fichier html");
					$path = '';
//					if(Cmodule::module_existe('mobile'))
//					{
//						$path = Cmodule_mobile::getPathMobile();
//					}
					$contenu=$module->file_get_contents_html($path.$res_page["fichier"]);

					if(!empty($res_page["fonction"])) {
						// on a un fichier ET une fonction
						// on applique alors la fonction sur le résultat du fichier
						$contenu=Cmodule::execute_fonction_module($res_page["fonction"],$contenu);
						//$params=CSite::parse_parametres_fonction_module
					}
					$contenu_ok=true;

				}
				if(!$contenu_ok) {
					//
					$contenu=Cmodule::execute_fonction_module($res_page["fonction"],$res_page["parametres"]);

				}
				$retour= CSite::applique_modele($res_page["id_modele"],$contenu,$res_page_html,$res_page);
				$retour=CSite::remplace_params_page($retour);

				if(Cmodule::module_existe("multilingue"))
				$retour = CMultilingue::remplaceLiensSiteHTML($retour);
				if($useCacheFichier) {
					$cacheManager->sauveCache($retour);
					unset($cacheManager);
				}
			} // fin génération page

			//$retour = CSite::parseWikiNoCache($retour);
			//			$retour=Cmodule::ajoute_blocs_html_modules_no_cache($retour);
			$strpos = strpos($res_page['robots'], 'index');
			if ($strpos !== false && $strpos == 0)
			{
				CSitemap::sauve_sitemap(CSite::getUrlPageOrigine(), md5($retour));
			}



			return $retour;
			//return CSite::compute_page($res_page,$contenu);

		} else {
			//TODO: voir si on a cette url ds la base, si oui la virer
			CSitemap::efface_url_en_cours_sitemap();
			CSite::erreur404();
		}
		Crapport::print_rr($res_page);
		Crapport::write();
		//exit;

	}

	static public function init_params_page($regs) {
		$GLOBALS["SITE_REGS"] = $regs;
		$cherches=array();
		for($i=0;$i<count($regs);$i++)$cherches[]="\$$i";
		$GLOBALS["SITE_REGS_CHERCHE"] = $cherches;

	}
	static public function remplace_params_page($str) {
		if(strpos($str,"\$")>-1) return str_replace($GLOBALS["SITE_REGS_CHERCHE"], $GLOBALS["SITE_REGS"], $str);
		return $str;
	}

	static function applique_modele($id_modele,$contenu,$res_page=NULL,$res_groupe_page=NULL) {

		ifNULL($res_page,array());
		include_once 'modules/site/fonctions_site.inc.php';
		if($modele=site_recupere_modele($id_modele)) {
			$path = '';
//			if(Cmodule::module_existe('mobile'))
//			{
//				$path = Cmodule_mobile::getPathMobile();
//				echo $path.$modele["fichier"];
//			}
			if($modele["fichier"]!="" && $modele["id_module"]!="")
				$contenu_modele=Cmodule::dispatch_fonction_module($modele["id_module"],"file_get_contents_html",$path.$modele["fichier"]);
			else
				$contenu_modele=Cmodule::ajoute_blocs_html_modules($modele["html"]);



			//print_rr($modele);
			$contenu = str_replace("#CONTENU",$contenu,$contenu_modele);
		} else {
			$modele=array();
		}
		$modele["html"]=$contenu;
		$res_page["html"]=$contenu;

		// applique le modele "root"
		return CSite::compute_page($modele,$res_page,$res_groupe_page);
	}

	static function compute_page($res_modele=NULL,$res_page=NULL,$res_groupe_page=NULL) {
		ifNULL($res_page , array());
		ifNULL($res_modele,array());
		// champs ne devant pas être vides
		if(isset(self::$metasPage["description"])) $res_page["description"]= self::$metasPage["description"];
		if(isset(self::$metasPage["mots_cles"])) $res_page["mots_cles"]= self::$metasPage["mots_cles"];
		if(isset(self::$metasPage["titre"])) $res_page["titre"]= self::$metasPage["titre"];

		//		exit(self::$metasPage["description"]);
		$res_page["description"]=$res_page["description"];
		$res_page["mots_cles"]=$res_page["mots_cles"];
		$res_page["titre"]=$res_page["titre"];


		if (Cmodule::module_existe('multilingue') && CMultilingue::$useML)
		$res_page["langue"]= CMultilingue::$langue;
		else
		$res_page["langue"]='fr';

		// css du modele
		if($res_modele["fichier_css"]!="" && $res_modele["id_module"]!="") {
			CSite::ajouteCSS($res_modele["fichier_css"],10);
			//			$res_modele["css"]='<link href="/css/'.$res_modele["fichier_css"].'" rel="stylesheet" type="text/css" />';
		}
		$res_modele["css"]=strlen($res_modele["css"])==0?"":"<style>".$res_modele["css"]."</style>";


		// css de la page
		$res_page["css"]=strlen($res_page["css"])==0?"":"<style>".$res_page["css"]."</style>";

		$res_site=CSite::$site_en_cours;
		$res_site["robots"]=$res_site["robots"];
		$res_site["titre"]=$res_site["titre"];
		$res_site["copyright"]=$res_site["copyright"];

		$res_site["icone"]=$res_site["icone"];
		$res_site["titre_rss"]=$res_site["titre_rss"];
		$res_site["url_rss"]=$res_site["url_rss"];
		$res_site["stats"]=$res_site["stats"];

		// remplacement du contenu
		if(isset($_REQUEST["lofi"])) {
			$_SESSION["mode_lofi"]=1;
		} else if(isset($_REQUEST["hifi"])) {
			unset ($_SESSION["mode_lofi"]);
		}
		if($res_groupe_page["is_flash"] && !isset($_SESSION["mode_lofi"]) && (FORCE_LOFI !== true) && CSite::$site_en_cours['type_site'] == 'standard') {
			$GLOBALS["NO_TRACES_FINALES"] = true;
			$contenu_modele=Cmodule::dispatch_fonction_module("flash","file_get_contents_html","modeles/flash.rootmodele.htm");
		}
		else if(CSite::$site_en_cours['type_site'] == 'mobile')
		{
			$contenu_modele=Cmodule::dispatch_fonction_module("mobile","file_get_contents_html","modeles/mobile.rootmodele.htm");
		}
		else if ($res_modele["rootmodele"] != '' && isset($res_modele["rootmodele"]) && $res_modele["rootmodele"] != NULL){
			if(empty($res_modele['id_module_rootmodele']))
			{
				$contenu_modele=Cmodule::dispatch_fonction_module($res_modele["id_module"],"file_get_contents_html",$res_modele["rootmodele"]);
			}
			else
			{
				$contenu_modele=Cmodule::dispatch_fonction_module($res_modele["id_module_rootmodele"],"file_get_contents_html",$res_modele["rootmodele"]);
			}
		}
		else {
			$contenu_modele=Cmodule::dispatch_fonction_module("base","file_get_contents_html","modeles/html.rootmodele.htm");
		}

		$res_modele['titre'] = notag($res_modele['titre']);
		$res_modele['description'] = notag($res_modele['description']);
		$res_modele['mots_cles'] = notag($res_modele['mots_cles']);

		$res_site['description'] = notag($res_site['description']);
		$res_site['mots_cles'] = notag($res_site['mots_cles']);
		$res_site['titre'] = notag($res_site['titre']);

		$res_groupe_page['description'] = notag($res_groupe_page['description']);
		$res_groupe_page['mots_cles'] = notag($res_groupe_page['mots_cles']);
		$res_groupe_page['titre'] = notag($res_groupe_page['titre']);

		$res_page['description'] = notag($res_page['description']);
		$res_page['mots_cles'] = notag($res_page['mots_cles']);
		$res_page['titre'] = notag($res_page['titre']);

		$contenu_modele = remplace_tous_blocs($contenu_modele,$res_modele,"#MODELE_");
		$contenu_modele = remplace_tous_blocs($contenu_modele,$res_site,"#SITE_");
		$contenu_modele = remplace_tous_blocs($contenu_modele,$res_groupe_page,"#GROUPE_");
		$contenu_modele = remplace_tous_blocs($contenu_modele,$res_page,"#PAGE_");
		//		echo $contenu_modele;
		//		print_rr($res_modele);
		$retour= Cmodule::ajoute_blocs_html_modules($contenu_modele);
		$retour = CWikiSite::parseWikiLangRoot($retour);


		if (Cmodule::module_existe('recherche') && $res_groupe_page['auto_referencable'] == '1' && (!Cmodule::module_existe("aol") || !Cmodule_aol::aol_user())) {
			$detail= parse_url($_SERVER['REQUEST_URI']);
			$path= $detail['path'];
			//			log_requete_ok($res_page["html"]);

			$pageReferencable = new CPageReferencable($path, $res_page["titre"]);
			if($pageReferencable->mustIndex() ) {
				$blocsRecherche = recherche_tous_element_par_balise($retour,"RECHERCHE");
				$contenu_ref = implode(" ",$blocsRecherche);
				$contenu_ref = CStringUtils::strip_tags_content($contenu_ref, '<script>', true);
				//			log_requete_ok(strip_tags($contenu_ref));
				//			log_requete_ok("##############################");
				//
				//			log_requete_ok(html_entity_decode($contenu_ref));

				$pageReferencable->addContenuReferencable(strip_tags($contenu_ref));
				//				exit;
			}
			if (isset($res_page["description"]) && $res_page["description"] != '') $pageReferencable->addContenuReferencable($res_page["description"]);
			if (isset($res_page["mots_cles"]) && $res_page["mots_cles"] != '') $pageReferencable->addContenuReferencable($res_page["mots_cles"]);
			if (isset($res_page["titre"]) && $res_page["titre"] != '') $pageReferencable->addContenuReferencable($res_page["titre"]);


			$pageReferencable->saveContenuReferencable();
		}

		$retour = affiche_element_multiple_par_balise($retour,"RECHERCHE");

		$retour=str_replace("#COMPILE_JS#",CSite::getCompiledJS(),$retour);
		$retour=str_replace("#COMPILE_CSS#",CSite::getCompiledCSS(),$retour);
		$retour=str_replace("#COMPILE_RSS#",CSite::getCompiledRSS(),$retour);
		$retour = remplace_tous_blocs($retour,CEcho::flushEchoDiffere(),"#ECHO_");
		return $retour;

	}


	private static $TOUS_FICHIERS = array();
	public static function ajouteCSS($css,$ordre=5)  {
		self::ajouteFichierType("css",$css,$ordre);

	}
	/**
	 * pas de tableau, un par un !
	 * @param $url
	 * @param $titre
	 * @param $ordre
	 * @return unknown_type
	 */
	public static function ajouteRSS($url,$titre,$ordre=5)  {
		$rss= '<link type="application/rss+xml" rel="alternate" href="'.$url.'" title="'.$titre.'">';
		//		echo $url.' - '.$titre.'<br>';
		self::ajouteFichierType("rss",$rss,$ordre);

	}
	public static function ajouteJS($js,$ordre=5)  {
		self::ajouteFichierType("js",$js,$ordre);

	}
	public static function ajouteFichierType($type,$css,$ordre=5)  {
		if(!isset(self::$TOUS_FICHIERS[$type])) self::$TOUS_FICHIERS[$type]=array();
		if(!isset(self::$TOUS_FICHIERS[$type][$ordre])) self::$TOUS_FICHIERS[$type][$ordre]=array();
		if(is_array($css)) {
			foreach($css as $un_css) {
				self::ajouteFichierType($type,$un_css,$ordre);
			}
		} else {
			if(!in_array($css,self::$TOUS_FICHIERS[$type][$ordre]) && !empty($css)) {
				self::$TOUS_FICHIERS[$type][$ordre][]=$css;
//				echo "_ $css<br/>";
			}
		}

	}

	public static $dont_concat_fichiers = false;

	public static function getCompiledCSS() {
		$concat_css = COptions::recupereValeurOption('site.optimise.concat_css', true);
		if ($concat_css && !self::$dont_concat_fichiers) {
			$domaine_noconcat = explode(' ',COptions::recupereValeurOption('site.optimise.noconcat_css_url', true));
			for ($i=0; $i < count($domaine_noconcat); $i++)
			if (strlen($domaine_noconcat[$i]) > 0)
			if (strpos($_SERVER[REQUEST_URI], $domaine_noconcat[$i]) !== false) return self::getCompiledFichierType("css");
			return self::getConcatFichiers('css');
		}
		else return self::getCompiledFichierType("css");
	}

	public static function getCompiledJS() {

		$concat_js = COptions::recupereValeurOption('site.optimise.concat_js', true);
		if ($concat_js && !self::$dont_concat_fichiers) {
			$domaine_noconcat = explode(' ',COptions::recupereValeurOption('site.optimise.noconcat_js_url',true));
			for ($i=0; $i < count($domaine_noconcat); $i++) {
				if (strlen($domaine_noconcat[$i]) > 0)
				if (strpos($_SERVER[REQUEST_URI], $domaine_noconcat[$i]) !== false) return self::getCompiledFichierType("js");
			}
			return self::getConcatFichiers('js');
		}
		else return self::getCompiledFichierType("js");
	}
	public static function getCompiledRSS() {
		return self::getCompiledFichierType("rss");
	}

	public static function getCompiledFichierType($type) {
		$ajouted=array();
		$retour="";

		//		if (CSite::$site_en_cours['type_site'] == 'mobile') $pathMob = 'mobile/';
		//		else $pathMob = '';

		if(is_array(self::$TOUS_FICHIERS[$type])) {
			ksort(self::$TOUS_FICHIERS[$type],SORT_NUMERIC);
			foreach(self::$TOUS_FICHIERS[$type] as &$un_niv) {
				foreach($un_niv as &$un_css) {
					if(in_array($un_css,$ajouted)) continue;
					$ajouted[]=$un_css;
					//					if($type=="js") $retour.="<script type=\"text/javascript\" src=\"/{$pathMob}js/$un_css\"></script>\n";
					//					else if($type=="css") $retour.='<link href="/'.$pathMob.'css/'.$un_css.'" rel="stylesheet" type="text/css" />'."\n";
					//					else if($type=="rss") $retour.=$un_css."\n";
					if($type=="js") $retour.="<script type=\"text/javascript\" src=\"/js/$un_css\"></script>\n";
					else if($type=="css") $retour.='<link href="/css/'.$un_css.'" rel="stylesheet" type="text/css" />'."\n";
					else if($type=="rss") $retour.=$un_css."\n";
				}
			}
		}
		return $retour;
	}

	public static function getConcatFichiers($type) {
		$ajouted_concat=array();
		$ajouted_noconcat=array();
		$path_js_concatenables=array();
		$retour="";
		$tmp_liste_js_nc = COptions::recupereValeurOption('site.optimise.noconcat_'.$type.'_liste', true);
		$js_no_concatenables = explode(' ', $tmp_liste_js_nc);
		$nom_concat_js = '';
		if(is_array(self::$TOUS_FICHIERS[$type])) {
			ksort(self::$TOUS_FICHIERS[$type],SORT_NUMERIC);

			foreach(self::$TOUS_FICHIERS[$type] as &$un_niv) {
				foreach($un_niv as &$un_js) {
					if(in_array($un_js,$ajouted_concat)) continue;
					if(in_array($un_js,$ajouted_noconcat)) continue;
					if(! in_array($un_js, $js_no_concatenables)) {
						$expl = explode('/', $un_js);
						if ($expl[0] == CLIENT)
						$jspath = REP_CLIENT.'www/'.$type.'/'.$expl[count($expl)-1];
						else {
							$jspath = 'modules/'.array_shift($expl).'/www/'.$type.'/';
							$jspath .= implode('/', $expl);
						}
						$path_js_concatenables[] = $jspath;
						$ajouted_concat[] = $un_js;
					} else {
						$ajouted_noconcat[] = $un_js;

						if ($type == 'js') $retour .= "<script type=\"text/javascript\" src=\"/js/$un_js\"></script>\n";
						else if ($type == 'css') $retour .= '<link href="/css/'.$un_js.'" rel="stylesheet" type="text/css" />'."\n";
					}
				}
			}
		}
		if (count($ajouted_concat) > 0) {

			$CONCATFILE_NUMVERSION = CONCATFILE_NUMVERSION;

			//TODO : voir quand vider la table des fichiers a générer
			if (isset($_GET['reset_liste_fichiers']) && EST_EFROGG === true) {
				ifReq('TRUNCATE TABLE site__fichiers_todo');
			}

			if (isset($_GET['reset_fichiers']) && EST_EFROGG === true) {
				include_once 'includes/general/ini_set.inc.php';
				$CONCATFILE_NUMVERSION ++;
				ini_set_client("CONCATFILE_NUMVERSION", $CONCATFILE_NUMVERSION);
				vide_dossier(RACINE_WWW.REP_CLIENT.'www/'.$type.'/compiled/');
			}

			if ((isset($_GET['maj_all']) || isset($_GET['reset_fichiers']) || isset($_GET['maj_fichiers'])) && EST_EFROGG === true ) {
				self::generateConcatFiles($CONCATFILE_NUMVERSION);
			}

			$md5js_extension = '.'.$type;
			$md5js_name = self::getMD5Name($ajouted_concat,$CONCATFILE_NUMVERSION,$md5js_extension);
			$md5js_path = RACINE_WWW.REP_CLIENT.'www/'.$type.'/compiled/'.$md5js_name;

			if (!file_exists($md5js_path)) {
				self::addToConcatFilesToGenerate($type, $ajouted_concat, $path_js_concatenables);
				return self::getCompiledFichierType($type);
			}

			if ($type == 'js') $retour = '<script type="text/javascript" src="/'.$type.'/'.CLIENT.'/compiled/'.$md5js_name.'"></script>'.$retour;
			else if ($type == 'css') $retour = '<link href="/'.$type.'/'.CLIENT.'/compiled/'.$md5js_name.'" rel="stylesheet" type="text/css" />'.$retour;
		}
		return $retour;
	}

	public static function getMD5Name($ajouted_concat,$CONCATFILE_NUMVERSION,$md5js_extension) {
		return md5(implode('', $ajouted_concat).$CONCATFILE_NUMVERSION).$md5js_extension;
	}

	static function get_droit_page($identifiant) {
		return testReq3("SELECT * FROM site__pages_droits WHERE identifiant='$identifiant'");
	}

	private static function addToConcatFilesToGenerate($type, $tab_nom_fic, $tab_src_fic) {
		$impl_nom = implode(' ', $tab_nom_fic);
		if (!testReq3("SELECT * FROM site__fichiers_todo WHERE liste_fichiers_pour_nom = '$impl_nom' AND type = '$type'")) {
			$impl_src = implode(' ', $tab_src_fic);
			CListes::insere('site_fichiers_todo', array('type'=>$type, 'liste_fichiers_pour_nom'=>$impl_nom, 'liste_fichiers_pour_src'=>$impl_src));
		}
	}

	private static function generateConcatFiles($numV = null) {
		$todos = mysql_fetch_all(ifReq('SELECT * FROM site__fichiers_todo'));
		include_once 'includes/general/ini_set.inc.php';

		if(is_null($numV)) $numV = CONCATFILE_NUMVERSION;

		for ($i=0; $i < count($todos); $i++) {
			$tab_files_nom = explode(' ', $todos[$i]['liste_fichiers_pour_nom']);
			$tab_files_src = explode(' ', $todos[$i]['liste_fichiers_pour_src']);
			$type = $todos[$i]['type'];

			$md5js_extension = '.'.$type;
			$md5js_name = self::getMD5Name($tab_files_nom,$numV,$md5js_extension);
			$md5js_path = RACINE_WWW.REP_CLIENT.'www/'.$type.'/compiled/'.$md5js_name;

			if (file_exists($md5js_path)) continue;

			$compiled_js = '';
			for ($j = 0; $j < count($tab_files_src); $j++) {
				$compiled_js .= file_get_contents($tab_files_src[$j])."\n";
			}
			if ($type == 'js') CFichiers::file_force_contents($md5js_path, $compiled_js);
			else if ($type == 'css') CFichiers::file_force_contents($md5js_path, CSSMin::minify($compiled_js));
		}
	}


	/**
	 * permet de récupérer les paramètres de l'url dans le REQUEST.
	 * En effet, en cas de rewriting, ces paramètres sont perdus
	 * @param $str toto=1&titi=2
	 */
	static function parse_query_string($str) {
		$params=explode("&",$str);
		foreach($params as $p) {
			if(($pos=strpos($p,"="))>0) {
				$var=(substr($p,0,$pos));
				$val=urldecode(substr($p,$pos+1));
				$_REQUEST[$var]=$_GET[$var]=$val;
			} else if(strlen($p)>0){
				$_REQUEST[$p]=$_GET[$p]="";
			}
		}
	}

	/**
	 * si temporaire, le navigateur ressoumet les donnees POST
	 * @param $url
	 * @param $temporaire
	 * @return unknown_type
	 */
	static function redirige($url,$temporaire=true) {
		if (DEBUG_REDIRECT === true) {

			Crapport::trace("ATTENTION, REDIRECTION demandée vers ' $url ', temporaire=$temporaire",0,'erreur');
			return;
		}

		if(!$temporaire) {
			header("Status: 301 Moved Permanently", false, 301);
		}
		else
		header("Status: 307 Moved Temporarily", false, 307);

		header("Location: $url");
		exit();
	}
	static function erreur404() {

		if(EST_EFROGG)
			trace("header HTTP/1.0 404 Not Found");
		else {
			header("HTTP/1.0 404 Not Found");
			$mod = Cmodule::get_module(CLIENT);
			echo $mod -> file_get_contents_html('404.html');
			exit;
		}
	}

	static function lien_menu_lateral($lien,$str) {
		return "<div class='site_elem_menu' onclick=\"window.location.href='$lien'\"><a href='$lien'>$str</a></div>";
	}
	static function separateur_menu_lateral($str) {
		return "<div class='site_elem_menu_sep' >$str&nbsp;</div>";
	}

	static function bouton_action_JS_dessus($action,$str) {
		return "<a href='javascript:void(0);' onclick=\"javascript:ajax_to_div_contenu('$action','dessus',{})\" >$str</a>";

		/*$retour='<form action=\"/actions_ajax.php\" target=\"frame_ajax\">
		 <input type="hidden" name="action" value="'.$action.'">
		 <!-- =convert_uuencode("utilisateurs.identification");  -->
		 <input type="submit" value="identification">
		 </form>';
		 return $str;*/
	}

	static function bouton_action_JS_dessus_print($action,$str) {
		return "<a href='javascript:void(0);' onclick=\"javascript:ajax_to_div_contenu('$action','print_dessus',{},null,true)\" >$str</a>";
	}

	static function bouton_action_JS_popup($action,$str,$variables=NULL,$type='image',$target='_blank') {
		$retour="<form action='/switch_ajax.php' method='POST' target='$target'>";


		if(empty($variables))$variables = array();
		foreach($variables as $k=>$v) {
			$retour.="<input type='hidden' name='$k' value='".str_replace("'","\\'",$v)."'>\r\n";
		}
		$retour.="<input type='hidden' name='action' value='$action'>\r\n";
		if($type == 'image') {
			$retour.="<input type='image' src='$str'>";
		} else {
			$retour.="<input type='submit' value='$str'>";

		}
		$retour.="</form>";
		return $retour;
		//"<a href='javascript:void(0);' onclick=\"javascript:ajax_to_popup('$action',$str_vars,null,true)\" >$str</a>";
	}

	static function bouton_action_JS($action,$str,$variables=NULL,$onclick="") {
		ifNULL($variables,array());
		$vars=array();
		foreach($variables as $k=>$v) {
			$v=str_replace("'","\\'",$v);
			$vars[]=$k.":'$v'";
		}
		$str_vars="{".implode(",",$vars)."}";
		return "<a href='javascript:void(0);' onclick=\"$onclick;
		action_ajax('$action',$str_vars,true)\" >$str</a>";
	}

	/**
	 *
	 * @param $action
	 * @param $variables = array("id_elem",$id_elem)
	 * @param $variables_form = array("onsubmit"=>"...")
	 * @return unknown_type
	 */
	static function bouton_action_image($action,$image,$variables=NULL,$method="POST", $param_supp="", $alt_title="") {
		ifNULL($variables,array());
		//ifNULL($variables_form,array());

		$retour='<form action="" method="'.$method.'" '.$param_supp.'>';
		foreach($variables as $name=>$value) {
			$retour.='<input type="hidden" name="'.$name.'" value="'.$value.'" />';
		}
		$retour.='<input type="hidden" name="action" value="'.$action.'" />
		<input type="image" src="'.$image.'" alt="'.$alt_title.'" title="'.$alt_title.'" />
	</form>';
		return $retour;

	}

	static function pages_html_basic($rep_depart = '') {
//		if(CModule::module_existe('mobile'))
//		{
//			if(CSite::$site_en_cours['type_site'] == 'mobile')
//			{
////				$rep_depart = Cmodule_mobile::getPathMobile().$rep_depart;
////				echo "laaaa? $rep_depart";
//			}
//		}
		include_once 'includes/general/str_url.inc.php';
		$url=$_SERVER["REQUEST_URI"];

		$detail= parse_url($url); // explode("?",$url);
		$path= $detail['path']; //array_shift($detail);
		$params=$detail['query']; //"?".implode("?",$detail);
		/*
		 * if(isset(self::$metasPage["description"])) $res_page["description"]= self::$metasPage["description"];
		 if(isset(self::$metasPage["mots_cles"])) $res_page["mots_cles"]= self::$metasPage["mots_cles"];
		 if(isset(self::$metasPage["titre"])) $res_page["titre"]= self::$metasPage["titre"];
		 */

		//		$conditionMajContenuRech = false;
		//		if (Cmodule::module_existe("recherche")) {
		//			$rechOn = true;
		//			$conditionMajContenuRech = (!CRecherche::pageBasic_IsIndexValid($path) || CRecherche::pageBasic_recuperePage($path) === false);
		//		}
		//		else $rechOn = false;


		$detail_complet = split_fichier($path);
		if ($detail_complet['fichier'] == '') {
			$detail_complet['chemin']=rtrim($detail_complet['chemin'],"/")."/";
			$path = $detail_complet['chemin'].'index.htm';
		}

		$extension = get_extension($path);
		$fichier_contenu=change_extension($path,"contenu.$extension");
		$fichier_meta=change_extension($path,"meta.php");

		$mod=Cmodule::get_module(CLIENT);
		if($mod->file_exists($fichier_meta)) {
			include_once $mod->file_get_path($rep_depart.$fichier_meta);
			CSite::setMetaPage($meta);

			//			if ($rechOn) {
			//
			//				if ($conditionMajContenuRech) {
			//					if(isset($meta["description"])) CRecherche::pageBasic_AjouteContenuToIndex($path, $meta["description"]);
			//					if(isset($meta["mots_cles"])) CRecherche::pageBasic_AjouteContenuToIndex($path, $meta["mots_cles"]);
			//					if(isset($meta["titre"])) CRecherche::pageBasic_AjouteContenuToIndex($path, $meta["titre"]);
			//				}
			//			}
		}
//				echo "$rep_depart$fichier_contenu";
		$retour = $mod->file_get_contents_html("$rep_depart$fichier_contenu");
		if(!$retour) {
			CSitemap::efface_url_en_cours_sitemap();
			CSite::erreur404();
		}

		//		if ($rechOn && $conditionMajContenuRech) {
		//			CRecherche::pageBasic_AjouteContenuToIndex($path, $retour);
		//		}

		return $retour;
	}

	public static function insere_fichier($url)
	{
		return file_get_contents($url);
	}

	public static function creeCarousel($nom_table, $nom_mod_client, $titre_liste, $nom_liste = 'carousel', $taille_image=1200)
	{
		include_once 'modules/listes/classes/CListes.class.php';

		CListes::add_liste2($nom_liste,$nom_table,$titre_liste,"éléments d'un carousel",'element',$nom_mod_client.'.contenu', $nom_liste.'/');
		CListes::add_champ_liste($nom_liste,'titre','VARCHAR(255)','titre','titre','titre');
		CListes::add_champ_liste($nom_liste,'description','TEXT','description','description','description',NULL,NULL,NULL,'longtext');
		CListes::add_champ_liste($nom_liste,'position','SMALLINT','position','position','position');
		CListes::add_champ_liste($nom_liste,'lien','VARCHAR(255)','lien','lien','lien déclenché par le clic');
		CListes::add_champ_liste($nom_liste,'target_lien',"ENUM('_blank', '_self')",'target_lien','target_lien','target du lien, _blank ou _self');
		CListes::add_champ_liste($nom_liste, "image", "VARCHAR(255)","image", "image", "image", "(.*)", NULL, NULL,"image",NULL,"image|CROPMAX|100|100");
		CListes::add_description_image($nom_liste,"image",$taille_image,$taille_image,"MAX","id_auto","#TITRE#","id_auto",8);
	}

	static function setMetaPage($metas) {
		self::$metasPage = $metas;
	}
}

?>