(function() {
	tinymce.create('tinymce.plugins.GestdocsPlugin', {
		init : function(ed, url) {
			ed.addCommand('mceGestdocs', function() {
				ed.windowManager.open({
					file : '/ajax.php?action=gestdocs.CFSAdmin_gestdocs.afficheContenuTinyMCE&isTinyMCE=true&idEditor='+ed.id,
					width : 800 + parseInt(ed.getLang('gestdocs.delta_width', 0)),
					height : 600 + parseInt(ed.getLang('gestdocs.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});

			ed.addButton('gestdocs', {
				title : 'Gestionnaire de documents',
				cmd : 'mceGestdocs',
				image : url + '/img/gestDocs.png'
			});

			ed.onNodeChange.add(function(ed, cm, n) {
				cm.setActive('gestdocs', n.nodeName == 'IMG');
			});
		},

		createControl : function(n, cm) {
			return null;
		},

		getInfo : function() {
			return {
				longname : 'GestDocs Plugin',
				author : '[E-Frogg] - Leo',
				authorurl : 'http://www.e-frogg.com',
				infourl : 'http://www.e-frogg.com',
				version : "1.0"
			};
		}
	});

	tinymce.PluginManager.add('gestdocs', tinymce.plugins.GestdocsPlugin);
})();