<?php

class CMail {

	private $message_lu = "";

	private $destinataires;
	private $sujet="-- sans titre --";


	private $pieces_jointes;
	private $mime = false;

	public $destinataires_separes=true;
	private $utf8=false;

	private $html_texte = false;

	private $from="";

	public function CMail($msg="") {
		$this->destinataires=array();
		$this->pieces_jointes=array();
		$this->ajoute_message($msg);
	}

	public function ajoute_message($msg="") {
		$this->message_lu .= $msg;
	}

	public function ajoute_destinataire($to) {
		if(!in_array($to,$this->destinataires))
		$this->destinataires[]=$to;
	}



	/*
	 *
	 * setters
	 *
	 */
	public function set_sujet($sujet) {
		$this->sujet = $sujet;
	}
	public function set_html_texte($vf) {
		$this->html_texte=$vf;
	}
	public function set_utf8($vf) {
		$this->utf8=$vf;
	}
	public function set_from($from) {
		$this->from=$from;
	}
	public function set_destinataires_separes($vf) {
		$this->destinataires_separes=$vf;
	}
	public function vide_destinataires() {
		$this->destinataires=array();
	}
	public function vide_message() {
		$this->message_lu = '';
	}




	public function envoie($to="") {
		if($to!="") {
			$this->ajoute_destinataire($to);
		}

		$header=$this->get_header();
		$corps=$this->get_corps();
		if($this->destinataires_separes) {
			foreach($this->destinataires as $to) {
				$this->maile($to,$this->sujet,$corps,$header);
			}
		} else {
			$liste_to=implode(", ",$this->destinataires);
			$this->maile($liste_to,$this->sujet,$corps,$header);
		}

	}



	public function maile($to,$sujet,$corps,$header) {
		
		if (!$this->html_texte)
		$corps = wordwrap($corps, 70);
		
		mail($to,$sujet,$corps,$header);
	}
	public function ajoute_fichier_from_file($nom_fichier,$url,$encoding="base64") {
		$extension=substr($url,strrpos($url,".")+1);
		//echo $extension;
		switch(strtoupper($extension)) {
			case "JPG":
				$type="image/jpeg";
				break;
		}
		$this->ajoute_piece_jointe($nom_fichier,$type,file_get_contents($url),$encoding);
	}


	public function ajoute_fichier_texte($nom_fichier,$texte,$encoding="base64") {
		$this->ajoute_piece_jointe($nom_fichier,"text/plain",$texte,$encoding);
	}
	public function ajoute_piece_jointe($nom_fichier,$type,$contenu,$encoding="base64") {
		$this->pieces_jointes[]=array("nom_fichier"=>$nom_fichier,"type"=>$type,"contenu"=>$contenu,"encoding"=>$encoding);
		$this->mime=true;
	}
	private function get_corps() {
		if($this->mime) {
			return $this->get_corps_mime();
		} else {
			return $this->message_lu;
		}
	}

	private function get_corps_mime() {
		$retour="";

		// le message a lire
		$retour.="
--==mimepart0001==
".$this->get_header_contenu()."
Content-Transfer-Encoding: 7bit

".$this->message_lu;

		// les pieces jointes
		//$this->pieces_jointes[]=array("nom_fichier"=>$nom_fichier,"type"=>$type,"contenu"=>$contenu,"encoding"=>$encoding);
		foreach($this->pieces_jointes as $pj) {
			$encoding=$this->get_titre_encoding_pj($pj["encoding"]);
			$str_pj="
--==mimepart0001==
Content-Type: {$pj[type]}; name=\"{$pj[nom_fichier]}\";
Content-Transfer-Encoding: ".$encoding."
Content-Disposition: attachment

".$this->get_contenu_encoding_pj($encoding,$pj["contenu"]);
				
			$retour.=$str_pj;
		}
		return $retour;
	}

	private function get_header() {
		$from = '';
		if ($this->from != '') $from = "From: ".$this->from."\n";
		if($this->mime) {
			$mime ="MIME-Version: 1.0\r\n
Content-Type: multipart/mixed; boundary=\"==mimepart0001==\";". "\n";
			return $from.$mime;
		} else {
			//echo $this->get_header_contenu().$from;
			return $from.$this->get_header_contenu();
		}
	}
	private function get_header_contenu() {
		$forme_texte=($this->html_texte?"html":"plain");
		return "Content-Type: text/$forme_texte; charset=\"".$this->get_encoding()."\"". "\n";
	}

	private function get_encoding() {
		if($this->utf8) {
			return "UTF-8";
		} else {
			return "ISO-8859-1";
		}
	}

	private function get_titre_encoding_pj($str_encoding) {
		switch($str_encoding) {
			case "base64":
			// tous ceux acceptés
				return $str_encoding;
		}
		// par défaut
		return "base64";
	}
	private function get_contenu_encoding_pj($str_encoding,$contenu) {
		switch($str_encoding) {
			// tous ceux acceptés
			case "base64":
				return base64_encode($contenu);
				break;
		}
		return "erreur";
	}
	/**
	 *
	 * @param $to
	 * @param $sujet
	 * @param $message
	 * @param $encoding = "iso" | "utf"
	 * @return unknown_type
	 */
	static public function envoie_email($to,$sujet,$message,$utf=false) {
		$tmp_email=new CMail($message);
		$tmp_email->utf8=$utf;
		$tmp_email->set_sujet($sujet);
		$tmp_email->envoie($to);
		//mail($to,$sujet,$message,$header);
	}

}

/*
 
 //CMail::envoie_email("raph@e-frogg.com","coucou","message",false);
$mail1=new CMail();
$mail1->ajoute_destinataire("raph@e-frogg.com");
$mail1->ajoute_destinataire("teq444@gmail.com");
$mail1->ajoute_destinataire("lila@e-frogg.fr");
$mail1->ajoute_destinataire("teq4@msn.com");

//$mail1->destinataires_separes=false;

$mail1->ajoute_message("coucou lé petits ");
$mail1->ajoute_message("<b>a toi</b>");

$mail1->set_sujet("mon sujet");

$mail1->set_html_texte(true);
$mail1->set_destinataires_separes(false);


$mail1->set_utf8(true);

$mail1->ajoute_fichier_texte("toto.txt","oui oui");

$mail1->ajoute_fichier_from_file("imag2e.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image1.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image3.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image4.jpg","_old/image.jpg");

$mail1->envoie();
*/
/*
 $header="MIME-Version: 1.0
 Content-Type: multipart/mixed; boundary=\"==mimepart0001==\";
 Content-Transfer-Encoding: 7bit";

 $msg="C'est un message MIME, si vous voyez ce texte, il n'y a plus d'espoir pour vous ...

 --==mimepart0001==
 Content-Type: text/plain; charset=\"iso-8859-1\"
 Content-Transfer-Encoding: 7bit

 Voici un email text avec un fichier joint, encod� en base64.
 /hth

 --==mimepart0001==
 Content-Type: text/plain; name=\"whatever.txt\";
 Content-Transfer-Encoding: base64
 Content-Disposition: attachment

 ".base64_encode("le contenu texte")."

 --==mimepart0001==--";

 echo"coucou";
 mail("raph@e-frogg.com","coucou",$msg,$header);
 */
?>