<?php
class SvcCarte
{
	function SvcCarte ()
	{
		BDDconnect_utf8();
	}

	/*
	 * CONCERTS
	 */
	
	function loadVillesConcerts ()
	{
		$q = "SELECT DISTINCT GV.insee, GV.nom, departement AS dep, GV.latitude AS lat, GV.longitude AS lon, population AS pop, CRTS.nb_concerts
			  FROM geoloc__ville AS GV, soun__concert,
			  	(SELECT insee, count( * ) AS nb_concerts
				FROM soun__concert, geoloc__ville
				WHERE geoloc__ville.id_auto= soun__concert.id_ville GROUP BY geoloc__ville.insee) AS CRTS
			  WHERE GV.id = soun__concert.id_ville
			  AND GV.insee = CRTS.insee";

		if ($r = ifReq($q))
		{
			return $r;
		}
		else echo $q;
	}
	
	/*
	 * ARTISTES
	 */
	
	function loadVillesArtistes ()
	{
		$q = "SELECT DISTINCT GV.insee, GV.nom, departement AS dep, GV.latitude AS lat, GV.longitude AS lon, population AS pop, ARTS.nb_artistes
			  FROM geoloc__ville AS GV, usr__utilisateurs,
			  	(SELECT insee, count( * ) AS nb_artistes
				FROM usr__utilisateurs, geoloc__ville
				WHERE geoloc__ville.id_auto= usr__utilisateurs.id_ville AND groupe = 'artiste' GROUP BY geoloc__ville.insee) AS ARTS
			  WHERE GV.id = usr__utilisateurs.id_ville
			  AND GV.insee = ARTS.insee
			  AND groupe = 'artiste'";

		if ($r = ifReq($q))
		{
			return $r;
		}
		else echo $q;
	}
	
	/*
	 * PROS
	 */
	
	function loadVillesPros ()
	{
		$q = "SELECT DISTINCT GV.insee, GV.nom, departement AS dep, GV.latitude AS lat, GV.longitude AS lon, population AS pop, PROS.nb_pros
			  FROM geoloc__ville AS GV, usr__utilisateurs,
			  	(SELECT insee, count( * ) AS nb_pros
				FROM usr__utilisateurs, geoloc__ville
				WHERE geoloc__ville.id_auto= usr__utilisateurs.id_ville AND groupe='pro' GROUP BY geoloc__ville.insee) AS PROS
			  WHERE GV.id = usr__utilisateurs.id_ville
			  AND GV.insee = PROS.insee
			  AND groupe = 'pro'";

		if ($r = ifReq($q))
		{
			return $r;
		}
		else echo $q;
	}
	
	/**
	 * toutes les villes contenant au moins un concert, un artiste ou un pro
	 * @return unknown_type
	 */
	function loadVilles()
	{
		$q = "SELECT insee, nom, latitude, longitude, pop, SUM( nb_c ) AS nb_concert, SUM( nb_a ) AS nb_artiste, SUM( nb_p ) AS nb_pro
			FROM (
			
			SELECT DISTINCT geoloc__ville.insee, geoloc__ville.nom, geoloc__ville.latitude, geoloc__ville.longitude, population as pop, count( * ) AS nb_c, 0 AS nb_a, 0 AS nb_p
			FROM geoloc__ville, soun__concert
			WHERE id = id_ville
			AND visible = 1
			AND date_concert >= NOW()
			GROUP BY geoloc__ville.insee, geoloc__ville.nom
			
			UNION
			
			SELECT DISTINCT geoloc__ville.insee, geoloc__ville.nom, geoloc__ville.latitude, geoloc__ville.longitude, population as pop, 0 AS nb_c, count( * ) AS nb_a, 0 AS nb_p
			FROM geoloc__ville, usr__utilisateurs
			WHERE id = id_ville
			AND groupe = 'artiste'
			AND actif = 1
			GROUP BY geoloc__ville.insee, geoloc__ville.nom
			
			UNION
			
			SELECT DISTINCT geoloc__ville.insee, geoloc__ville.nom, geoloc__ville.latitude, geoloc__ville.longitude, population as pop, 0 AS nb_c, 0 AS nb_a, count( * ) AS nb_p
			FROM geoloc__ville, usr__utilisateurs
			WHERE id = id_ville
			AND groupe = 'pro'
			AND actif = 1
			GROUP BY geoloc__ville.insee, geoloc__ville.nom
			) AS NB
			
			GROUP BY insee, nom";
		
		if ($r = ifReq($q))
		{
			return $r;
		}
		else echo $q;
	}
	
	function loadDetails()
	{
		$resultat = array();
		
		$q = "SELECT id_utilisateur, pseudo, avatar, latitude, longitude
			FROM usr__utilisateurs, usr__donnees_pro
			WHERE id_utilisateur = id_auto
			AND actif = 1 AND groupe = 'pro'
			AND adresse IS NOT NULL AND adresse != ''
			AND latitude != 0  AND longitude != 0";
		
		if ($r = ifReq($q))
		{
			$i=0;
			while ($pro = mysql_fetch_assoc($r))
			{
				$resultat[$i] = $pro;
				
				$q2 = "SELECT *
						FROM soun__concert
						WHERE id_salle = $pro[id_utilisateur]
						AND visible = 1";
				
				if ($r2 = ifReq($q2))
				{
					$resultat[$i]['concerts'] = array();
					while ($concert = mysql_fetch_assoc($r2)) $resultat[$i]['concerts'][] = $concert;
				}
				++$i;
			}
			return $resultat;
		}
		else echo $q;
	}
}

?>