<?php
require_once 'bdd.class.php';
require_once 'Identification.class.php';



class Live{

	public $idUser;
	public $idTache;
	public $date_debut;
	public $date_fin;
	public $duree;
	public $pauses = array();
	public $commentaire = "";
	public $status = 200;
	public $id_date;


	public function __construct($idTache,$date){
		require_once("classes/Identification.class.php");
		$this->idUser =	 	Identification::getId();
		$this->idTache = 	$idTache;
		$this->date_debut = $date;
// 		$this->date_debut = "2012-04-01 16:00:00";
// 		$this->id_date = date('r');
		Tache::sauver($this->idTache);
		$live = serialize($this);
		$idUser = Identification::getId();
		$sql = "INSERT INTO `wrk_live`(`id_user`, `live`) VALUES ('$idUser',('$live')) ON DUPLICATE KEY UPDATE live = ('$live')";

		bdd::exec($sql);
	}
	
	public static function saveNewLive($liveObj, $idUser = null) {
		$serializedLive = serialize($liveObj);
		$idUser = (is_null($idUser)) ? Identification::getId() : $idUser;
		$req = "
			INSERT INTO `wrk_live` 
				(`id_user`, `live`) 
			VALUE 
				($idUser, ('$serializedLive')) 
			ON DUPLICATE KEY UPDATE live = ('$serializedLive')";
		return bdd :: exec($req);
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return Live
	 */
	public static function getInstance(){
		$idUser = Identification::getId();
		$r = bdd::getResult("SELECT live FROM `wrk_live` WHERE id_user='$idUser'");
		//var_dump($r);
		if(!$r) return false;
		return unserialize($r['live']);
	}
	
	protected function bdd_save(){
		
		$live =  serialize($this);
		$idUser = Identification::getId();
		bdd::exec("UPDATE `wrk_live` SET `live`='$live' WHERE `id_user`='$idUser' ");
	}

	public function save(){
		$this -> getDuree();
		$commentaire = str_replace('££','\'',$this -> commentaire);
		Travail::add($this->idUser, $this->idTache, $this->duree, $this->duree, substr($this->date_fin,0,10), $commentaire);
		
		// Sauvegarde des tickets du live
		if(isset($this -> tickets)) {
			Ticket :: associerLiveTicketsATravail(Travail :: $id_travail, $this -> tickets);
		}
		
		$this->delete();
	}
	
	public function getDuree($dateFin = '' ,$dateDebut = '') {
		if($dateDebut == '') 	$dateDebut = $this -> date_debut;
		if($dateFin == '') 		$dateFin = $this -> date_fin;
		
		$duree_secondes = strtotime($dateFin) - strtotime($dateDebut);
		$duree_secondes -= (array_sum($this -> pauses)) * 60;
		$duree_heures = $duree_secondes/3600;
		

		$this->duree = max(round($duree_heures*2), 1)/2;
		
		return $this->duree;
	}
	
	protected function update($text, $pauses){
		$this->commentaire = str_replace("\\n","\n",$text);
		$this->pauses = $pauses;
		$this->bdd_save();
	}
	
	protected function delete(){
		$idUser = Identification::getId();
		bdd::exec("DELETE FROM `wrk_live` WHERE id_user='$idUser'");
	}
	
	public static function get(){
		if(self::getInstance()===false){
			$obj = (object) array("status"=>404);
			return json_encode($obj);
		}
		
		$live = clone(self::getInstance());
		$live -> commentaire = str_replace('££','\'',$live -> commentaire);
		return json_encode($live);

	}
	
	
	public static function start($idTache,$date){
		//Si il existe, on le sauve
		if($live = self::getInstance()){
			$live->date_fin = date("Y-m-D H:i:s");
			$live->save();
			echo "/!\ Ancien travail sauvé auto -";
		}
		
		new Live($idTache, $date);
		
		return true;
	}
	
	public static function stop($date, $pause=array(),$action=null){
		if(!($live = self::getInstance())) return false;
		
		$live->date_fin = $date;
		$live->save();
		//$live->bdd_save();
		
		return true;
	}
	
	public static function follow($text, $pauses){
		if(!($live = self::getInstance())) return false;
		
		$live->update($text, json_decode($pauses, true));
		
		return true;
	}
}
