<?php
	////include_once 'modules/gestdocs/classes/CFSAdmin_gestdocs.class.php';//auto	
	class CListeFichiers
	{
	/**
	 * Tableau de tous les dossiers enfants
	 */
		private $tabDossiers;
	
	/**
	 * Tableau de tous les fichiers enfants
	 */
		private $tabFichiers;
		
		private $evite = array("Thumbs.db",".","..","...","index.htm","redim",".svn");
		
		public function __construct()
		{
			$this -> tabDossiers = array();
			$this -> tabFichiers = array();
		}
		
	/**
	 * Récupere la liste des dossiers / fichiers du chemin passé en paramètre 
	 * et les stocke dans les variables membres
	 * 
	 * @param $path - Chemin du dossier à lister
	 */
		public function recupereListe($path)
		{
			if(is_dir($path))
			{
				if ($dh = @opendir($path))
				{
					while (($file = readdir($dh)) !== false)
					{
						if (!in_array($file,$this->evite))
						{
							if(is_dir($path.$file))
								$this -> tabDossiers[] = $file;
							else
								$this -> addNewFichier($file,$path);
						}
					}
					closedir($dh);
				} 
			}
		}
		
	/**
	 * Permet d'ajouter un fichier au tableau membre, en récuperant l'extension
	 * 
	 * @param $nomFichier - Nom du fichier
	 * @param $path - Chemin (defaut : '')
	 */
		public function addNewFichier($nomFichier,$path = '')
		{
			$split = split_fichier($nomFichier);
			$tab = explode('.',$nomFichier);
			$tab = array_reverse($tab);
			$newTab['nomlong'] = $split["fichier"];
			$newTab['extension'] = $split["extension"];
			
			$newTab['imageredim'] = CFSAdmin_gestdocs::getLienImageRedimensionne($this -> getCheminPretRedimensionne($path,$nomFichier), 51, 50, 'CROPMAX');
			$newTab['imageredim'] .= '?refresh='.md5(uniqid(rand(), true));
			$newTab['nomcourt'] = $split["fichier_base"];
				
			$this -> tabFichiers[] = $newTab;
		}
	/*
	 * Renvoi le chemin d'une image prete à etre redimensionnée
	 */
		public function getCheminPretRedimensionne($path, $file)
		{
			$chem = str_replace('//','/',$path);
			$tabChem = explode('/',$chem);
			$copy = false;
			foreach($tabChem as $unElem)
			{
				if($unElem == '__gestdocs' or $copy)
				{
					$retour .= '/'.$unElem;
					$copy = true;
				}
			}
			return $retour.$file;
		}
		public function getTabListeFichier()
		{
			return $this -> tabFichiers;
		}
		public function getTabListeDossier()
		{
			return $this -> tabDossiers;
		}
		
		
	/**
	 * 
	 * Test si le dossier passer en parametre est vide
	 */
		public function testSiDossierVide($dir)
		{
			$dir = str_replace('//','/',$dir);
			$dir = opendir($dir);
       		$estVide = true;
      		while(($entry = readdir($dir)) !== false)
      		{
				if($entry != '.' && $entry != '..' && $entry != 'redim' && $entry != 'index.htm')
				{
					$estVide = false;
					break;
				}
			}
			closedir($dir);
			return $estVide;
		}
		
	/*
	 * Renvoi le path tmp d'un fichier transferé par formulaire HTML 
	 * $nomChampFormu : string = attribut name de l'input file du formulaire
	 */
		public function uploadImage($nomChampFormu)
		{
			if(isset($_FILES[$nomChampFormu]))
			{
				switch($_FILES[$nomChampFormu]['error'])
				{
					case UPLOAD_ERR_OK:
						return $_FILES[$nomChampFormu]['tmp_name'];
					break;
					default:
						throw new Exception('NONUPLOAD');
					break;
					
				}
			}
		}
	}
?>