CREATE FUNCTION getTradAOL(v_id_champs INT, v_id_boutique INT) RETURNS TEXT CHARACTER SET utf8  DETERMINISTIC
BEGIN
  DECLARE retour TEXT DEFAULT '';
  DECLARE separateur VARCHAR(2) DEFAULT '';
  DECLARE v_texte TEXT;
  DECLARE done SMALLINT;
  DECLARE cur CURSOR FOR SELECT texte FROM shop_ml_traductions  AS t
        LEFT JOIN shop_ml_langues AS l ON l.id=t.id_langue
        WHERE t.id_boutique=v_id_boutique AND id_champs=v_id_champs AND texte!=''
        ORDER BY id_AOL;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;
  
  
  
  OPEN cur;
  REPEAT
    FETCH cur INTO v_texte;
    IF ISNULL(done) THEN
        SET retour = CONCAT(retour,separateur,v_texte);
        SET separateur='||';
    END IF;
    
  UNTIL done END REPEAT;
  
	RETURN retour;


END;