<?php
require_once("includes/modules/Cmodule.class.php");
class Cmodule_pages_annexes extends Cmodule {
	var $nom = "pages annexes";
	var  $identifiant = "pages_annexes" ;
	var $modules_dependants=array("arborescence");
	function Cmodule_pages_annexes() {
		parent::Cmodule();
		require_once("includes/general/structure.inc.php");
		shop_get_id_structure_articles(); // calcule une fois pour toutes l'id_structure du marchand
		
	}
	
	
	function __install_options() {
		bdd_ajoute_option4("MENU_pagesannexes","Pages","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Pages");
		
		bdd_ajoute_option4("FLV_ACCES_annexes","FlashVars accès page annexe", "Référencement", "texte", "", "Format des données passées au falsh pour un accès direct à une page annexe");
		bdd_ajoute_option3("ANX_SWF_chemin","Chemin des swf des pages annexes","Pages annexes","texte","","Chemin du dossier où sont stockés des swf des pages annexes");
		bdd_ajoute_option4("ANX_recup_comm","envoi des commentaires au flash", "Pages annexes", "booleen", "", "Récupération des commentaires des pages annexes pour les envoyer au flash");

		bdd_ajoute_option4("REF_liste_annexes","référencer les pages annexes", "Référencement.pages annexes", "booleen", "", "Intégration des pages annexes dans l'arborescence du menu latéral",0,1);
		bdd_ajoute_option4("REF_chemin_annexes","chemin pages annexes", "Référencement.pages annexes", "texte", "", "nom du dossier contenant l'accès aux pages annexes\n\npas de '/' !!",1,1);
		
	}
	
	
	/**
	 * données a l'identification sur l'admin...
	 *
	 */
	function login_admin() {
	}
	/**
	 * données initiales pour la boutique
	 *
	 */
	function init_site() {
		
	}
	function switch_admin($action) {
		global $id_boutique,$repIncludes,$id_structure_page;
		include_once("includes/admin/actions_bdd/bdd_fonctions.inc.php");
		$id_structure_page= bdd_get_structure($id_boutique,"page");
		switch($action) {
			//
			//	Pages annexes
			//
			case md5("pages_annexes.recup"):
				if(droit_acces($id_boutique,"pages annexes")) {
					require_once($this->include_fonctions);
					PAGES_recup($id_boutique);
				} else {
					print("&err=1&txtErr=Vous n'avez pas les droits pour acc�der � cette fonctionnalit�&");
				}
				exit(); // on a fini ce qu'on avait a faire
			break;
			case md5("pages_annexes.recup_personnalisation"):
				if(droit_acces($id_boutique,"pages annexes")) {
					require_once($repIncludes."actions_ML/fonctions_ML.inc.php");
					require_once($this->include_fonctions);
					include "includes/general/parse_request_ici.php"; // récupère tout le _GET et _POST en variables locales
					
					PAGES_recup_perso($id_boutique, $id_structure_page, $id_elem, $nom);
				} else {
					print("&err=1&txtErr=Vous n'avez pas les droits pour acc�der � cette fonctionnalit�&");
				}
				exit(); // on a fini ce qu'on avait a faire
			break;
			case md5("pages_annexes.sauve_personnalisation"):
				if(droit_acces($id_boutique,"pages annexes")) {
					insereStat("action","admin",$idUser,"pages_annexes.sauve_personnalisation");
					require_once($repIncludes."actions_ML/fonctions_ML.inc.php");
					require_once($this->include_fonctions);
					include "includes/general/parse_request_ici.php"; // récupère tout le _GET et _POST en variables locales
					PAGES_sauve_perso($id_boutique, $id_structure_page, $id_elem, $textes_nom, $nom, $fichier, $textes_commentaire, $commentaire, $mots_cles, $textes_mots_cles, $description, $textes_description, $acces_direct, $reference, $force_html);
				} else {
					print("&err=1&txtErr=Vous n'avez pas les droits pour acc�der � cette fonctionnalit�&");
				}
				exit(); // on a fini ce qu'on avait a faire
			break;
		}
	}
	
	function detaille_chemin(&$chemin_detaille,&$dossiers,&$fichier,&$params) {
		if($dossiers[0]==CST_REF_chemin_annexes) {
			$chemin_detaille["type_page"]="annexe";
			array_shift($dossiers);
			if(count($dossiers)>0) $chemin_detaille["PAGES_ANNEXES"]=$this->detaille_chemin_annexes(implode("/",$dossiers)."/".$fichier);
			else $chemin_detaille["PAGES_ANNEXES"]=$this->detaille_chemin_annexes($fichier);
		}
	}
	
	
	function detaille_chemin_annexes($v_chemin) {
		global $id_struct_page,$id_boutique,$id_langue,$id_langue_defaut,$code_langue;
		if(!isset($id_struct_page)) {
			if($res_struct_pages=testReq2("SELECT id FROM shop_structures WHERE id_boutique=$id_boutique AND type='page'")) {
				$id_struct_page=$res_struct_pages["id"];
			} else {
				return false;
			}
		}
		//FIXME: les langues !!!
		if(!isset($chemin_detaille_annexes)) {
			$chemin_en_cours=$v_chemin;
			$chemin_en_cours=array_shift(explode(".php",$chemin_en_cours));
			$chemin_detaille_annexes=array();
			$chemin_detaille_annexes["pages"]=array();
			$id_cat_parent=0; // on part de la racine
			$split_chemin=explode("/",$chemin_en_cours);	// aubade/printemps-ete-2007/villa-caraibes
			$type_page="rien";
			$cherche_categorie=true;
			$chemin_complet="/".CST_REF_chemin_annexes;
			$trouve_un=false;
			while($cherche_categorie AND (count($split_chemin)>0)) {
				
				if(($split_chemin[0]=="lo-fi") || ($split_chemin[0]==CST_REF_chemin_annexes)) {
					array_shift($split_chemin);
				} else {
					$nom_cherche=str_replace("-","%",$split_chemin[0]);
					// 1 cherche par le nom_referencement person de la cat (ML)
					$req="SELECT s.* FROM shop_struct_elems AS s
										LEFT JOIN shop_pages_annexes AS p ON p.id_elem=s.id
										WHERE s.actif=1 AND s.id_parent=$id_cat_parent AND s.id_structure=$id_struct_page AND titre_to_lien(get_traduction(p.nom,$id_boutique,$id_langue)) LIKE '$nom_cherche' COLLATE utf8_unicode_ci";
					if(!$res=testReq2($req)) {
						//2 cherche par la structure de l'arborescence
						$req="SELECT * FROM shop_struct_elems WHERE actif=1 AND id_parent=$id_cat_parent AND id_structure=$id_struct_page AND nom LIKE '$nom_cherche'";
					}
					if($res=testReq2($req)) {
						$trouve_un=true;
						$chemin_detaille_annexes["pages"][]=array("res"=>$res);
						
						$id_cat_parent=$res["id"];
						$chemin_complet.="/".$split_chemin[0];
						array_shift($split_chemin);
					}  else {
						$cherche_categorie=false;
					}
				}
			}
			if($trouve_un) {
				$chemin_complet.=".php";
			} else {
				$chemin_complet="/";
			}
			// on a trouvé la page finale
			$res_last_page=$chemin_detaille_annexes["pages"][count($chemin_detaille_annexes["pages"])-1]["res"];
			if($res_page=testReq2("SELECT get_traduction(nom,$id_boutique,$id_langue) AS nom,
								get_traduction(commentaire,$id_boutique,$id_langue) AS commentaire, 
								fichier 
								FROM shop_pages_annexes WHERE id_elem=$res_last_page[id] AND id_structure=$id_struct_page")) {
				$chemin_detaille_annexes["res_page"]=$res_page;					
			}
			$chemin_detaille_annexes["res_elem"]=$res_last_page;					
			$chemin_detaille_annexes["chemin_complet"]=$chemin_complet;
		}
		return $chemin_detaille_annexes;
	}

	function get_arborescence_html($id_parent=0,$nom_classe="menu_anx",$chemin="/CST_REF_chemin_annexes") {
		$retour="";
		if(!CST_REF_liste_annexes) return $retour;
		if($chemin=="/CST_REF_chemin_annexes") $chemin="/".CST_REF_chemin_annexes;
		
		require_once("includes/html/url.inc.php");
		global $id_structure,$id_boutique,$id_langue,$id_structure_page;
		
		$ajout_langue=get_url_langue();
		if($query=ifReq("SELECT get_traduction(p.nom,$id_boutique,$id_langue) AS nom_ml, se.* FROM shop_struct_elems AS se
							LEFT JOIN shop_pages_annexes AS p ON se.id=p.id_elem AND p.id_structure=$id_structure_page WHERE id_parent=$id_parent AND actif=1 AND se.id_structure=$id_structure_page ORDER BY position ASC")) {
			if(mysql_num_rows($query)>0) {
				$retour=($id_parent==0?"":"<ul>");
				while($res=mysql_fetch_array($query)) {
				
					$retour.="<li>";
					if(strlen($res["nom_ml"])>0) {
						$nom_page=$res["nom_ml"];
					} else {
						$nom_page=$res["nom"];
					}
					$lien_page=titreToLien($nom_page);
					if($res["type"]=="separateur") {
						$retour.="<span><a href='javascript:void()'>";
					} else {
						$retour.=" <a href='".lien_absolu($ajout_langue.$chemin."/".$lien_page.".php")."' target='_top'>";
					}
	
					$retour.=$nom_page."</a>";
					if($res["type"]=="separateur") {
						$retour.="</span>";
					} 
					
					
					if($res["type"]=="raccourci") {
						$retour.=$this->get_arborescence_html($res["id_cible"],$nom_classe,$chemin."/".$lien_page);
					} else if($res["type"]=="dossier") {
						$retour.=$this->get_arborescence_html($res["id"],$nom_classe,$chemin."/".$lien_page);
					} 
					$retour.="</li>";
				}
				/*if($id_parent==0) {
					// on rajoute les reclassements
					$retour.="<li><span><a href='javascript:void()'>reclassements</a></span></li><li><a href='#'>coucou</a></li>";
				}*/
				$retour.=($id_parent==0?"":"</ul>");
				//$retour.="</ul>";
			}
			
		}
		return $retour;
		
	}
	function get_arborescence_array($id_parent=0,$profondeur=0,$chemin="/CST_REF_chemin_annexes") {
		$retour=array();
		if(!CST_REF_liste_annexes) return $retour;
		
		if($chemin=="/CST_REF_chemin_annexes") $chemin="/".CST_REF_chemin_annexes;
		
		require_once("includes/html/url.inc.php");
		global $id_structure_page,$id_boutique,$id_langue;
		$ajout_langue=get_url_langue();
		if($query=ifReq("SELECT get_traduction(p.nom,$id_boutique,$id_langue) AS nom_ml, se.* FROM shop_struct_elems AS se
							LEFT JOIN shop_pages_annexes AS p ON se.id=p.id_elem AND p.id_structure=$id_structure_page WHERE id_parent=$id_parent AND actif=1 AND se.id_structure=$id_structure_page ORDER BY position ASC")) {
	
			if(mysql_num_rows($query)>0) {
				while($res=mysql_fetch_array($query)) {
					
					if(strlen($res["nom_ml"])>0) {
						$nom_page=$res["nom_ml"];
					} else {
						$nom_page=$res["nom"];
					}
					$lien_page=titreToLien($nom_page);
					$lien=($res["type"]=="separateur")?"":$ajout_langue.$chemin."/".$lien_page.".php";
					
					
					$elem=array("lien"=>$lien,"titre"=>$res["nom"],"id"=>$res["id"]);
					array_push($retour,$elem);
					if($res["type"]=="raccourci") {
						$retour=array_merge($retour,$this->get_arborescence_array($res["id_cible"],$profondeur+1,$chemin."/".$lien_page));
					} else if($res["type"]=="dossier") {
						$retour=array_merge($retour,$this->get_arborescence_array($res["id"],$profondeur+1,$chemin."/".$lien_page));
					} 
				}
				if($id_parent==0) {
					// on rajoute les reclassements
	//				$retour.="<li><span><a href='javascript:void()'>reclassements</a></span></li><li><a href='#'>coucou</a></li>";
				}
			}
			
		}
		return $retour;
	}
	function switch_site($action) {
	}
}
?>