<?php
////include_once 'modules/gestdocs/classes/CListeFichiers.class.php';//auto
////include_once 'modules/base/classes/CImages.class.php';//auto
////include_once 'modules/site/classes/pages/CPageHTML.class.php';//auto

class CGestDocs extends CPageHTML
{
	/*
	 * Répertoire de base des documents sans le / à la fin
	 */
	private $repBase;
	
	/*
	 * Répertoire dans lequel on se trouve
	 */
	private $repCourant;
	
	/*
	 * Objet pour lister le repertoire
	 */
	private $oListeFichiers;
	
	/*
	 * Tableau des extensions pour le preview des images
	 */
	private $tabExtensionImages = array('png','jpg','jpeg','gif');

	/*
	 * Chemin reel de la racine
	 */
	private $base_real_path;
	
	
	public function __construct()
	{
		/*if(!usr_a_droit_generique("gestdocs"))
			return false;*/
	/*** TODO: INSTALL ***/
/*		usr_ajoute_groupe('admin','super',false);
		usr_ajoute_groupe('user','admin',false);
		
		usr_ajoute_droit('gestDocs','le droit de supprimer une image');
		usr_set_droit_generique('gestDocs',1,null,'admin',null, null, true, true, true, true);
		usr_set_droit_generique('gestDocs',1,null,'user',null, null, true, true, false, false);
*/	
	/*** UTILISATION ***/
/*		usr_a_droit_generique('gestDocs',null,'0');
		usr_get_droit('liste',usr_get_id_droit_generique('supprimerImage'));
*/		

		
		$this -> repBase = REP_CLIENT.'www/__gestdocs';
		$this -> repCourant = '/';
		$this -> base_real_path = str_replace("/","\\",realpath (".")."/".$this -> repBase);
		$this -> oListeFichiers = new CListeFichiers();
		
		$chem = $this -> repBase.$this -> repCourant.'/'.$nomElement;
		$real_path = realpath($chem);
		
	// On test si l'on doit changer le chemin courant
		if(!empty($_REQUEST['rep']))
			if(strpos($this -> base_real_path,realpath($_REQUEST['rep'])) === false)
				$this -> repCourant = $_REQUEST['rep'];
				
	// On test si l'on doit creer un nouveau dossier	
		if(!empty($_REQUEST['newDossier']))
			$this -> creerRepertoire($_REQUEST['newDossier']);
			
	// On test si l'on doit supprimer un dossier
		if(!empty($_REQUEST['suppDossier']))
			if(!$this -> supprimerRepertoire($_REQUEST['suppDossier']))
			{
				CMessages::ajoute_message('Impossible de supprimer un dossier qui n\'est pas vide!');
				
			}
			else CMessages::ajoute_message('Suppression réussie');
	
	// On test si l'on doit uploader une image
		if(!empty($_FILES['inputAjouteFichier']['name']))
		{	
			try
			{
				$tmp_name = $this -> oListeFichiers -> uploadImage('inputAjouteFichier');
				$extension = get_extension($_FILES['inputAjouteFichier']['name']);
				CImages::redimensionne_fichier($tmp_name,'MAX',LARGEUR_GESTDOC,HAUTEUR_GESTDOC,$this -> repBase.$this -> repCourant.'/'.$_FILES['inputAjouteFichier']['name'],IMAGE_QUALITE_STOCKAGE,$extension);		
			//redimensionne($image_origine,$typ,$largeurFinale,$hauteurFinale,$fichierSortie,$largeurImage,$hauteurImage,$format,$qualite=IMAGE_QUALITE_STOCKAGE)
			
			}
			catch(Exception $e)
			{
				switch($e -> getMessage())
				{
					case 'NONIMAGE':
						CMessages::ajoute_message('Le fichier n\'est pas une image!');
					break;
					case 'NONUPLOAD':
						CMessages::ajoute_message('Erreur lors du tranfert du fichier!');
					break;
				}
			}
		}
		
	// On test si l'on doit supprimer un fichier
		if(!empty($_REQUEST['suppFichier']))
			$this -> supprimerFichier($_REQUEST['suppFichier']);
	}
	public function getListeFichiers()
	{
		if(usr_a_droit_generique("gestdocs"))
		{
			$this -> oListeFichiers -> recupereListe($this -> repBase.$this -> repCourant.'/');
			//print_rr($this -> oListeFichiers -> getTabListeFichier());
			return $this -> oListeFichiers -> getTabListeFichier();
		}
		else
			return array();
	}
	public function getContenu()
	{
		if(usr_a_droit_generique("gestdocs"))
		{
			$html = $this -> messageErreur;
			$html .= '<h1>Repertoire en cour : '.$this -> repCourant.'</h1>';
			$this -> oListeFichiers -> recupereListe($this -> repBase.$this -> repCourant.'/');
				
			//print_rr($this -> oListeFichiers -> getTabListeFichier());
			$html .= '<table style="border: 0px; width: 600px; float: left;">';
			if($this -> repCourant != '/')
			$html .= $this -> getLigneDossierHtml('..', 'doss');
				
			foreach($this -> oListeFichiers -> getTabListeDossier() as $unDossier)
				$html .= $this -> getLigneDossierHtml($unDossier, 'doss');
	
			foreach($this -> oListeFichiers -> getTabListeFichier() as $unFichier)
				$html .= $this -> getLigneHtml($unFichier['nomlong'], $unFichier['extension']);
			
			$html .= '</table>';
			$html .= '<div id="divImagePreview" style="float: right"></div>';
			$html .= '<br style="clear:both" /><br /><br /><form action="documents.php?rep='.$this -> repCourant.'" method="post">';
			$html .= '<label>Créer un dossier </label><input type="text" name="newDossier" value="" />';
			$html .= '<input type="submit" value="Ajouter" />';
			$html .= '</form>';
			$html .= '<br /><form action="documents.php?rep='.$this -> repCourant.'" method="post" enctype="multipart/form-data">';
			$html .= '<label>Ajouter un fichier : </label><input type="file" name="inputAjouteFichier" value="" />';
			$html .= '<input type="submit" value="Uploader" />';
			$html .= '</form>';
			
			return $html;
		}
		else
			return '';
	}
	
	public function fsAdminCgestDocs()
	{
		if(usr_a_droit_generique("gestdocs"))
		{
			$html = $this -> messageErreur;
			$html .= '<h1>Repertoire en cours : '.$this -> repCourant.'</h1><input type="hidden" id="chemCourant" value="'.$this -> repCourant.'" />';
			$this -> oListeFichiers -> recupereListe($this -> repBase.$this -> repCourant.'/');
				
			//print_rr($this -> oListeFichiers -> getTabListeFichier());
			$html .= '<table style="border: 0px; width: 300px; float: left;">';
				
			foreach($this -> oListeFichiers -> getTabListeFichier() as $unFichier)
				$html .= $this -> getLigneHtmlFSAdmin($unFichier['nomLong'], $unFichier['extension']);
			
			$html .= '</table>';
			$html .= '<div id="divImagePreview" style="float: right"></div>';
			$html .= '<br style="clear:both" /><br /><br /><form action="documents.php?rep='.$this -> repCourant.'" method="post">';
			$html .= '<label>Créer un dossier </label><input type="text" id="newDossierGestDocs" value="" />';
			$html .= '<input type="submit" value="Ajouter" />';
			$html .= '</form>';
			$html .= '<br /><form action="documents.php?rep='.$this -> repCourant.'" method="post" enctype="multipart/form-data">';
			$html .= '<label>Ajouter un fichier : </label><input type="file" name="inputAjouteFichier" value="" />';
			$html .= '<input type="submit" value="Uploader" />';
			$html .= '</form>';
			
			return $html;
		}
		else
			return '';
	}
/*
 * Ligne en HTML d'un dossier
 */
	private function getLigneDossierHtml($nomElement, $typeElement)
	{
		$chem = $this -> repBase.$this -> repCourant.'/'.$nomElement;
		$real_path = realpath ($chem);
		// if trouve else erreur !!!
		
		$new_path = str_replace($this->base_real_path,"",$real_path);
		//echo "'$new_path;'";
		$new_path = str_replace("\\","/",$new_path);
		$html = '<tr>';
		$html .= '<td style="float: left;"><a href="documents.php?rep='.$new_path.'"><img src="/images/gestdocs/'.strtolower($typeElement).'.png" width="32" height="32"/></a></td>';
		$html .= '<td style="float: left;margin-top: 7px;"><a href="documents.php?rep='.$new_path.'">';
		$html .= $nomElement;
		$html .= '</a></td>';
		$html .= '<td>';
		if($nomElement != '..')
			$html .= '<a onclick="if(!confirm(\'Etes vous sur de vouloir supprimer cet élement ?\')) return false;" href="documents.php?rep='.$this -> getRepertoireCourant().'&suppDossier='.$nomElement.'"><img src="/images/gestdocs/supprimer.png" width="24" height="24"/></a>';
		$html .= '</td>';
		$html .= '</tr>';
		
		return $html;
	}
/*
 * Ligne en HTML d'un fichier
 */
	private function getLigneHtml($nomElement, $typeElement)
	{
		if(in_array(strtolower($typeElement),$this -> tabExtensionImages))
			$lien = '<a class="lienImage" href="#" onclick="return afficheImage(\'/__gestdocs'.$this -> repCourant.'/'.$nomElement.'\');" lienImage="/__gestdocs'.$this -> repCourant.'/'.$nomElement.'">';
		else
			$lien = '<a href="#">';
			
		$html = '<tr>';
		$html .= '<td style="float: left;">'.$lien.'<img src="/images/gestdocs/'.strtolower($typeElement).'.png" width="32" height="32"/></a></td>';
		$html .= '<td style="float: left;margin-top: 7px;">'.$lien;
		$html .= $nomElement;
		$html .= '</a></td>';
		$html .= '<td>';
		$html .= '<a onclick="if(!confirm(\'Etes vous sur de vouloir supprimer cet élement ?\')) return false;" href="documents.php?rep='.$this -> getRepertoireCourant().'&suppFichier='.$nomElement.'"><img src="/images/gestdocs/supprimer.png" width="24" height="24"/></a>';
		$html .= '</td>';
		$html .= '</tr>';
		return $html;
	}
/*
 * Ligne en HTML d'un fichier pr le FSAdmin
 */
	private function getLigneHtmlFSAdmin($nomElement, $typeElement)
	{
		if(in_array(strtolower($typeElement),$this -> tabExtensionImages))
			$lien = '<a class="lienImage" href="#" urlFichier="'.$nomElement.'">';
		else
			$lien = '<a href="#" urlFichier="">';
			
		$html = '<tr>';
		$html .= '<td style="float: left;">'.$lien.'<img src="/images/gestdocs/'.strtolower($typeElement).'.png" width="32" height="32"/></a></td>';
		$html .= '<td style="float: left;margin-top: 7px;">'.$lien;
		$html .= $nomElement;
		$html .= '</a></td>';
		$html .= '<td>';
		$html .= '<a class="lienSupp" nomFichier="'.$nomElement.'" href="#"><img src="/images/gestdocs/supprimer.png" width="24" height="24"/></a>';
		$html .= '</td>';
		$html .= '</tr>';
		return $html;
	}
/*
 * Renvoi le repertoire que l'on est en train de parcourir
 */
	public function getRepertoireCourant()
	{
		return $this -> repCourant;
	}
	
	
/*
 * Créer un dossier dans le répertoire courant
 */
	public function creerRepertoire($dossier)
	{
		$id_droit=usr_get_id_droit_generique("gestdocs");
		$droit = usr_get_droit_generique($id_droit);
		if($droit["modifier"] || $droit["ajouter"])
			creeRepSiExistePas($this -> repBase.$this -> repCourant.$dossier."/");
		else 
			echo CMessages::ajoute_message("pas le droit de créer un dossier");
	}
/*
 * Supprime un dossier dans le répertoire courant
 */
	public function supprimerRepertoire($dossier)
	{
		$id_droit=usr_get_id_droit_generique("gestdocs");
		$droit = usr_get_droit_generique($id_droit);
		if(!$droit["supprimer"])
			return false;
		
		$file = str_replace('//','/',$this -> repBase.$this -> repCourant.$dossier);
		if($this -> oListeFichiers -> testSiDossierVide($file))
		{
			if (file_exists($file.'index.htm')) {
				unlink($file.'index.htm');
			}
			rmdir($file);
			return true;
			
		}
		else
		{
			echo CMessages::ajoute_message('Impossible de supprimer un dossier qui n\'est pas vide');
			return false;
		}
	}
/*
 * Supprime un fichier dans le repertoire courant
 */
	public function supprimerFichier($nomFichier)
	{
		$id_droit=usr_get_id_droit_generique("gestdocs");
		$droit = usr_get_droit_generique($id_droit);
		
		if(!$droit["supprimer"])
			return false;
			
		if(is_file($this -> repBase.$this -> repCourant.'/'.$nomFichier))
			unlink($this -> repBase.$this -> repCourant.'/'.$nomFichier);
	}
}
?>