<?php

class Rech_Maintenance {

	private $indexeur;
	public function Rech_Maintenance() {

		$this->indexeur=new Rech_Indexeur();

	}

	public function desinstallation() {
		SQL_admin::efface_table(RECH_TABLE_MOT_CLE);
		SQL_admin::efface_table(RECH_TABLE_MOT_CLE_PAGE);
		SQL_admin::efface_table(RECH_TABLE_PAGE);
		SQL_admin::efface_table(RECH_TABLE_TYPE_PAGE);
		SQL_admin::efface_table(RECH_TABLE_EXCEPTION);
		SQL_admin::efface_table(RECH_TABLE_EXPRESSION);
		SQL_admin::efface_table(RECH_TABLE_LEVENSHTEIN);
		SQL_admin::efface_table(RECH_TABLE_TYPE_SPEC);
		SQL_admin::efface_table(RECH_TABLE_SPEC_VAL);
		SQL_admin::efface_table(RECH_TABLE_SPIDER_LOCK);
	}
	public function reset_all() {
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_MOT_CLE);
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_MOT_CLE_PAGE);
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_PAGE);
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_TYPE_PAGE);
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_LEVENSHTEIN);
		//ifReq("DELETE FROM `".RECH_BASE.RECH_TABLE_LEVENSHTEIN."` WHERE est_manuel=0");
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_TYPE_SPEC);
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_SPEC_VAL);
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_EXCEPTION);
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_EXPRESSION);
		ifReq("TRUNCATE TABLE ".RECH_BASE.RECH_TABLE_SPIDER_LOCK);
	}

	public function installation() {
		if(!defined("RECH_INCLUDE_PATH")) echo ("Attention , config_recherche.inc.php non inclu");
		include_once RECH_INCLUDE_PATH.'installation/creation_tables.inc.php';
		SQL_admin::create_table(RECH_TABLE_MOT_CLE,$table_creation["mot_cle"]);
		SQL_admin::create_table(RECH_TABLE_MOT_CLE_PAGE,$table_creation["mot_cle_page"]);
		SQL_admin::create_table(RECH_TABLE_PAGE,$table_creation["page"]);
		SQL_admin::create_table(RECH_TABLE_TYPE_PAGE,$table_creation["type_page"]);
		SQL_admin::create_table(RECH_TABLE_EXCEPTION,$table_creation["exception"]);
		//SQL_admin::create_table(RECH_TABLE_SPIDER,$table_creation["spider"]);
		SQL_admin::create_table(RECH_TABLE_EXPRESSION,$table_creation["expression"]);
		SQL_admin::create_table(RECH_TABLE_LEVENSHTEIN,$table_creation["levenshtein"]);
		SQL_admin::create_table(RECH_TABLE_TYPE_SPEC,$table_creation["type_spec"]);
		SQL_admin::create_table(RECH_TABLE_SPEC_VAL,$table_creation["spec_val"]);
		SQL_admin::create_table(RECH_TABLE_SPIDER_LOCK,$table_creation["spider_lock"]);

		//SQL_admin::cree_function("LEVENSHTEIN",$procedure_creation["LEVENSHTEIN"]);
		//SQL_admin::cree_function("LEVENSHTEIN_RATIO",$procedure_creation["LEVENSHTEIN_RATIO"]);
		SQL_admin::cree_procedure("rech_maj_poids_total",$procedure_creation["rech_maj_poids_total"]);
		SQL_admin::cree_procedure("rech_reset_index_page_type",$procedure_creation["rech_reset_index_page_type"]);
		SQL_admin::cree_procedure("rech_reset_index_page",$procedure_creation["rech_reset_index_page"]);
		SQL_admin::cree_procedure("rech_reset_index_mot",$procedure_creation["rech_reset_index_mot"]);

		SQL_admin::cree_procedure("rech_reset_page_type",$procedure_creation["rech_reset_page_type"]);
		SQL_admin::cree_procedure("rech_ajout_page",$procedure_creation["rech_ajout_page"]);
		SQL_admin::cree_procedure("rech_ajout_page_type",$procedure_creation["rech_ajout_page_type"]);
		SQL_admin::cree_procedure("rech_efface_page_type",$procedure_creation["rech_efface_page_type"]);
		
		SQL_admin::cree_procedure("rech_reset_specs_page_type",$procedure_creation["rech_reset_specs_page_type"]);
		SQL_admin::cree_procedure("rech_reset_specs_page",$procedure_creation["rech_reset_specs_page"]);

		SQL_admin::ajoute_colonne(RECH_TABLE_LEVENSHTEIN,"est_manuel","TINYINT(4)","NOT NULL","AFTER ratio","DEFAULT 0");
		SQL_admin::ajoute_colonne(RECH_TABLE_LEVENSHTEIN,"date_validite","DATETIME","NOT NULL","AFTER est_manuel","DEFAULT 0");
		SQL_admin::ajoute_colonne(RECH_TABLE_LEVENSHTEIN,"nb","INT","NOT NULL","AFTER ratio","DEFAULT 1");

		SQL_admin::ajoute_colonne(RECH_TABLE_EXPRESSION,"remplace_lisible","VARCHAR(255)","NOT NULL");

		SQL_admin::set_index(RECH_TABLE_LEVENSHTEIN,"est_manuel","INDEX");
		SQL_admin::set_index(RECH_TABLE_LEVENSHTEIN,"date_validite","INDEX");
		SQL_admin::set_index(RECH_TABLE_LEVENSHTEIN,"nb","INDEX");
		SQL_admin::set_index(RECH_TABLE_LEVENSHTEIN,"ratio","INDEX");
		
		SQL_admin::ajoute_colonne(RECH_TABLE_TYPE_SPEC,"integree","TINYINT(1)","NOT NULL","AFTER type_val","DEFAULT 0");

		SQL_admin::out();

		$this->installation_types_pages();


	}

	public function installation_types_pages() {
		$this->installation_types_specs();
	}

	public function installation_types_specs() {
		if($liste_types=mysql_fetch_all(ifReq("SELECT * FROM ".RECH_BASE.RECH_TABLE_TYPE_PAGE))) {
//			include_once RECH_INCLUDE_PATH.'Rech_Indexeur.class.php';
			$indexeur = new Rech_Indexeur();
			foreach($liste_types as $un_type) {
				$page=$indexeur->get_classe_page($un_type["id_type_page"],-1);
				$page->installation_types_specs();
			}
		}
	}
	/**
	 * crée la liste complète des pages du site UBALDI.com
	 * @param $set_valide
	 * @return unknown_type
	 */
	public function creation_liste_pages($set_valide = NULL) {
//		include_once RECH_INCLUDE_PATH.'Rech_Indexeur.class.php';
		$indexeur = new Rech_Indexeur();
//		include_once RECH_INCLUDE_PATH.'Rech_Spider.class.php';
		$spider = new Rech_Spider();
		if($liste_types=mysql_fetch_all(ifReq("SELECT * FROM ".RECH_BASE.RECH_TABLE_TYPE_PAGE))) {
			foreach($liste_types as $un_type) {
				$page=$indexeur->get_classe_page($un_type["id_type_page"],-1);
				$liste_id = $page->get_liste_id_page_type();
				foreach($liste_id as $i=>$id) {
					$spider->ajoute_page($page->identifiant_type,$id,$set_valide); // complete l'index
					//		$spider->ajoute_page("article",$id,0); // complete l'index et reinitialise
					//RealTimeProgression::setProgression($i/count($liste_id));
				}
			}
		}
		//
//		include_once RECH_INCLUDE_PATH.'Rech_Spider.class.php';

	}

	public static function parle($str,$verbosite="") {
		if($verbosite == "html") SQL_admin::trace($str);
		else if($verbosite == "cron") echo "$str<br>";
	}

	public function nettoie_levenshtein($verbosite="") {
		Rech_Maintenance::parle("Nettoyage levenshtein",$verbosite);
		if(ifreq("DELETE FROM ".RECH_BASE.RECH_TABLE_LEVENSHTEIN." WHERE est_manuel=0 AND date_validite<NOW()")) {
			Rech_Maintenance::parle(mysql_affected_rows()." champs effacés",$verbosite);
		} else {
			Rech_Maintenance::parle("Erreur sql : ".mysql_error(),$verbosite);
		}
		Rech_Maintenance::parle("",$verbosite);
	}

	public function mise_a_jour_liste_pages($verbosite="") {
//		include_once RECH_INCLUDE_PATH.'Rech_Indexeur.class.php';
		$indexeur = new Rech_Indexeur();
//		include_once RECH_INCLUDE_PATH.'Rech_Spider.class.php';
		$spider = new Rech_Spider();

		Rech_Maintenance::parle("Mise a jour de la liste des pages",$verbosite);

		if($liste_types=mysql_fetch_all(ifReq("SELECT * FROM ".RECH_BASE.RECH_TABLE_TYPE_PAGE))) {
			foreach($liste_types as $un_type) {
				$page=$indexeur->get_classe_page($un_type["id_type_page"],-1);
				$liste_id = $page->get_liste_id_page_type();

				Rech_Maintenance::parle("type '$un_type[identifiant]'",$verbosite);

				// pages en trop dans l'index
				$liste_existantes=mysql_fetch_column(ifReq("SELECT id_page_type FROM ".RECH_BASE.RECH_TABLE_PAGE." p WHERE id_type_page = ".$un_type["id_type_page"]),"id_page_type");
				if(empty($liste_existantes)) $liste_existantes = array();

				$pages_en_trop = array_diff($liste_existantes,$liste_id);
				$pages_manquantes = array_diff($liste_id,$liste_existantes);

				foreach($pages_en_trop as $id_page_type) {
					$spider->supprime_page_index($un_type["id_type_page"],$id_page_type);
					Rech_Maintenance::parle("supprime page type $un_type[id_type_page] - page $id_page_type",$verbosite);
				}
				foreach($pages_manquantes as $id_page_type) {
					$spider->ajoute_page($page->identifiant_type,$id_page_type); // complete l'index
					Rech_Maintenance::parle("ajoute page type $page->identifiant_type - page $id_page_type",$verbosite);
				}
				Rech_Maintenance::parle("Liste des pages a jour",$verbosite);


				/*foreach($liste_id as $i=>$id) {
					$spider->ajoute_page($page->identifiant_type,$id,$set_valide); // complete l'index
					//		$spider->ajoute_page("article",$id,0); // complete l'index et reinitialise
					//RealTimeProgression::setProgression($i/count($liste_id));
					}*/
			}
		}
		Rech_Maintenance::parle("",$verbosite);
	}

	/**
	 * nettoyage des mots qui n'ont pas de page associée, et qui n'ont pas de fils
	 * @return rien
	 */
	public function nettoyage_mots_orphelins($verbosite="") {
		$req="DELETE ".RECH_BASE."mc  FROM ".RECH_BASE.RECH_TABLE_MOT_CLE." mc
LEFT JOIN ".RECH_BASE.RECH_TABLE_MOT_CLE." mc2 ON mc2.id_mot_parent=mc.id_mot_cle
LEFT JOIN ".RECH_BASE.RECH_TABLE_MOT_CLE_PAGE." mcp ON mc.id_mot_cle=mcp.id_mot_cle
WHERE mc.id_mot_parent IS NULL AND mc.poids_total = 0
AND mcp.id_page IS NULL
AND mc2.id_mot_cle IS NULL";
		if($req=ifReq($req)) {
				
			Rech_Maintenance::parle("champs effacés : ".mysql_affected_rows2(),$verbosite);
		} else {
			Rech_Maintenance::parle("erreur requete ".mysql_error(),$verbosite);
		}
	}

	/**
	 * ajoute une exception au "dictionnaire d'exceptions"
	 * @param $mot
	 * @param $inclusion : 0 = mot exclu , 1 = mot inclu
	 * @return Boolean : le résultat de l'insertion
	 */
	public function ajoute_exception($mot,$inclusion) {
		if(strlen($mot)==0) return;
		SQL_admin::insert(RECH_TABLE_EXCEPTION,array("mot"=>$mot,"inclusion"=>$inclusion),"mot");
	}

	public function ajoute_exceptions($str_mots,$inclusion) {
		$mots_normal=Rech_Parseur::normalise_exceptions(Rech_Parseur::normalise_chaine($str_mots));
		if(strlen($mots_normal)==0 && strlen($str_mots)>0)
		$mots_normal=Rech_Parseur::normalise_chaine($str_mots);
		if(strlen($mots_normal)==0) {
			return;
		}
		$split=explode(" ",$mots_normal);
		foreach($split as $mot)
		$this->ajoute_exception($mot,$inclusion);
	}

	public function efface_exception_id($id_exception) {
		SQL_admin::delete(RECH_TABLE_EXCEPTION,array("id_exception"=>$id_exception),"id_exception");

	}
	public function efface_exception($mot) {
		SQL_admin::delete(RECH_TABLE_EXCEPTION,array("mot"=>$mot),"mot");
	}

	public function modifie_exception_id($id_exception,$nouveau_mot) {
		SQL_admin::update(RECH_TABLE_EXCEPTION,array("id_exception"=>$id_exception,"mot"=>$nouveau_mot),"id_exception");
	}

	/*
	 *
	 *
	 *
	 */



	public function ajoute_expression_simple($cherche,$type_mot_supp=0,$mots_supplementaires="") {
		$cherche=Rech_Parseur::normalise_chaine($cherche);
		$raccourci=str_replace(" ","",$cherche);

		$remplace_index=$raccourci;
		$remplace_recherche=$raccourci;
		if($type_mot_supp!=0 && $mots_supplementaires=="") {
			$mots_supplementaires = str_replace(" ",",",Rech_Parseur::normalise_exceptions($cherche));
		}
		$mots_supplementaires=implode(" ",explode(",",str_replace(" ","",$mots_supplementaires)));
		if($type_mot_supp==MOT_SUPPL_INDEX) $remplace_index.=" $mots_supplementaires";
		if($type_mot_supp==MOT_SUPPL_RECHERCHE) $remplace_recherche.=" $mots_supplementaires";
		$est_nouvelle_expression = $this->ajoute_expression($cherche,$remplace_index,$remplace_recherche);
		$mots_separes = array_unique(array_merge(explode(" ",$remplace_index),explode(" ",$remplace_recherche)));
		foreach($mots_separes as $mot_unique) {
			if(!Rech_Parseur::mot_est_valide($mot_unique)) {
				$this->ajoute_exception($mot_unique,true);
			}
			if($est_nouvelle_expression) $this->index_reset_mots($mot_unique);
			$this->indexeur->insereMotSimple($mot_unique);
		}
	}

	public function ajoute_expression_unite($unite,$unite_pleine) {
		if(!Rech_Parseur::mot_est_valide($unite_pleine)) $this->ajoute_exception($unite_pleine,1);
		$this->ajoute_expression("([0-9]+)([ ]?)$unite","\$1$unite_pleine \$1","\$1$unite_pleine");
	}
	/**
	 *
	 * @param $cherche : "tv"
	 * @param $remplace : "téléviseur"
	 * @param $supplementaire
	 * @return unknown_type
	 */
	public function ajoute_dictionnaire($cherche,$remplace,$supplementaire=0) {
//		include_once RECH_INCLUDE_PATH.'Rech_Parseur.class.php';
		Rech_Parseur::init_parseur();
		// remplace caracs spéciaux par espaces,
		/*$cherche=Rech_Parseur::normalise_exceptions(Rech_Parseur::normalise_chaine($cherche));
		 $remplace=str_replace(" ","",Rech_Parseur::normalise_exceptions(Rech_Parseur::normalise_chaine($remplace)));*/

		$cherche=Rech_Parseur::normalise_chaine($cherche);
		$cherche = trim($cherche);
		$mots_separes = explode(" ",$cherche);
		if(count($mots_separes)>1) {
			$mots_separes = array_merge($mots_separes,explode(" ",$cherche));
			$remplace_index=str_replace(" ","",$cherche).($supplementaire==MOT_SUPPL_INDEX?" ".$cherche:"");
			$this->ajoute_expression($cherche,$remplace_index,str_replace(" ","",$cherche));
			//$cherche = str_replace(" ","",$cherche);
		}
		$mots_separes = array_unique($mots_separes);
		foreach($mots_separes as $mot_unique) {

			if(!Rech_Parseur::mot_est_valide($mot_unique)) $this->ajoute_exception($mot_unique,1);
			$this->indexeur->insereMotSimple($mot_unique);
		}
		$cplx_cherche = Rech_Parseur::mot_to_complexe(Rech_Parseur::normalise_chaine($cherche));
		$id_mot_cherche = $this->indexeur->insereMot($cplx_cherche,NULL,$supplementaire);

		$this->modifie_dictionnaire_id($id_mot_cherche,$remplace,$supplementaire);

	}

	public function modifie_dictionnaire_id($id_mot_cle,$remplace,$supplementaire=0) {
//		include_once RECH_INCLUDE_PATH.'Rech_Parseur.class.php';
		Rech_Parseur::init_parseur();
		$remplace=Rech_Parseur::normalise_chaine($remplace);
		$remplace = trim($remplace);
		$mots_separes = explode(" ",$remplace);
		if(count($mots_separes)>1) {
			$this->ajoute_expression($remplace,str_replace(" ","",$remplace));
			//$remplace = str_replace(" ","",$remplace);
		}
		$mots_separes = array_unique($mots_separes);
		foreach($mots_separes as $mot_unique) {

			if(!Rech_Parseur::mot_est_valide($mot_unique)) $this->ajoute_exception($mot_unique,1);
			$this->indexeur->insereMotSimple($mot_unique);
		}



		$cplx_remplace = Rech_Parseur::mot_to_complexe(Rech_Parseur::normalise_chaine($remplace));

		$id_mot_remplace = $this->indexeur->insereMot($cplx_remplace);

		SQL_admin::update(RECH_TABLE_MOT_CLE,array("id_mot_cle"=>$id_mot_cle,"id_mot_parent"=>$id_mot_remplace),"id_mot_cle");
		if(mysql_affected_rows()>0) {
			SQL_admin::trace("ok, mise a jout $id_mot_cle -> $remplace ");
		}
	}

	public function efface_dictionnaire($id_mot_cle) {
		SQL_admin::update(RECH_TABLE_MOT_CLE,array("id_mot_cle"=>$id_mot_cle,"id_mot_parent"=>"NULL"),"id_mot_cle");
	}




	/*
	 *
	 * index
	 *
	 */
	public static function index_reset_page_type($nom_type_page,$id_page_type) {
		if($res_type = Rech_Maintenance::get_type_page($nom_type_page)) {
			Rech_Maintenance::index_reset_page_id_type	($res_type["id_type_page"],$id_page_type);
		}
	}

	public static function index_reset_page_id_type($id_type_page,$id_page_type) {
//		echo("CALL ".RECH_BASE."rech_reset_index_page_type($id_type_page,$id_page_type)");
		ifReq("CALL ".RECH_BASE."rech_reset_index_page_type($id_type_page,$id_page_type)",true);
		//if(mysql_affected_rows()>0) {
		SQL_admin::trace(mysql_affected_rows()." page réinitialisées");
		//}
	}
	public static function index_reset_page($id_page) {
		ifReq("CALL ".RECH_BASE."rech_reset_index_page($id_page)");
		//if(mysql_affected_rows()>0) {
		SQL_admin::trace(mysql_affected_rows()." page réinitialisées");
		//}
	}

	public static function index_reset_mots($mots) {
		$mots=str_replace(","," ",$mots);
		$tab_mots=explode(" ",$mots);
		foreach($tab_mots as $mot) {
			ifReq("CALL ".RECH_BASE."rech_reset_index_mot('$mot')");
			//if(mysql_affected_rows()>0) {
			SQL_admin::trace("$mot : ".mysql_affected_rows()." page réinitialisées");
			//}
		}


	}

	/*
	 * expressions
	 */

	/**
	 * 100 hz => 100hz
	 * @param $cherche : "/([0-9]+) (cm)/"
	 * @param $remplace : "\$1\$2" ou "\$1cm"
	 * @return unknown_type
	 */
	public function ajoute_expression($cherche,$remplace_index,$remplace_recherche=NULL) {
		if($remplace_recherche === NULL) $remplace_recherche = $remplace_index;


		if($this->expression_est_valide($cherche,$remplace_index) && $this->expression_est_valide($cherche,$remplace_recherche)) {
			if(SQL_admin::insert(RECH_TABLE_EXPRESSION,array("cherche"=>$cherche,"remplace_index"=>$remplace_index,"remplace_recherche"=>$remplace_recherche),"cherche")) {
				$this->reset_index_mots_expression($cherche);
			}
		}
		return false;

	}

	private function reset_index_mots_expression($str_mots) {
		if(!preg_match("/([][()+?.])/i",$str_mots)) {
			$this->index_reset_mots($str_mots);
		}
	}
	public function expression_est_valide($exp,$remplace) {
		$string=preg_replace('§'.$exp.'§',$remplace.' ',"la chaine de test");

		if(strlen($string)>0) {
			return true;
		} else {
			SQL_admin::trace("<b>Rech_Maintenance::ajoute_expression Erreur</b><br>$exp => $remplace ",  "error");
			return false;
		}
	}

	public function efface_expression($cherche) {
		SQL_admin::delete(RECH_TABLE_EXPRESSION,array("cherche"=>$cherche),"cherche");
	}

	public function index_reset_expression($id_expression,$colonne="*") {
		if($res=testReq3("SELECT remplace_index,remplace_recherche FROM ".RECH_BASE.RECH_TABLE_EXPRESSION." WHERE id_expression = $id_expression")) {
			if($colonne=="*") {
				foreach($res as $valeur) {
					$this->reset_index_mots_expression($valeur);
				}
			} else {
				$valeur=$res[$colonne];
				$this->reset_index_mots_expression($valeur);

			}
		}
	}


	public static function maj_poids_total() {
		ifReq("CALL recherche.rech_maj_poids_total()");
	}

	public static function recalcule_ratio_levenshtein_memorises($AND="") {
		// a faire régulièrement,
		Rech_Maintenance::maj_poids_total();
		$champ_levenshtein = CHAMP_LEVENSHTEIN;

		$req="SELECT l.mot AS mot_flou,ratio,
			IFNULL(mc2.$champ_levenshtein,mc.$champ_levenshtein) AS $champ_levenshtein, 
			mc.poids_total+IFNULL(mc2.poids_total,0) AS poids_total
		FROM ".RECH_BASE.RECH_TABLE_LEVENSHTEIN." l
		LEFT JOIN ".RECH_BASE.RECH_TABLE_MOT_CLE." mc ON l.id_mot_cle=mc.id_mot_cle
		LEFT JOIN ".RECH_BASE.RECH_TABLE_MOT_CLE." mc2 ON mc.id_mot_parent=mc2.id_mot_cle
		WHERE est_manuel=0 $AND";
		$liste_levenshtein = mysql_fetch_all(ifReq($req));
		//$mot_cmplx=Rech_Parseur::mot_to_complexe()
		//
		foreach($liste_levenshtein as $un_lev) {
			$ratio_final = Rech_Parseur::calcule_ratio_levenshtein($un_lev["mot_flou"],$un_lev["mot"],$un_lev["poids_total"]);
			if($ratio_final != $un_lev["ratio"]) {
				ifReq("UPDATE ".RECH_BASE.RECH_TABLE_LEVENSHTEIN." SET ratio=$ratio_final  WHERE mot='$un_lev[mot_flou]'");
			}
		}
		//exit;
	}


	public static function recalcule_levenshtein_mot($mot) {
		Rech_Maintenance::recalcule_levenshtein_memorises("AND mot='$mot'");
	}

	public static function recalcule_levenshtein_memorises($AND="") {
		// a faire régulièrement,
		Rech_Maintenance::maj_poids_total();
		$champ_levenshtein = CHAMP_LEVENSHTEIN;
		$liste_tous_mots=mysql_fetch_all(ifreq("SELECT id_mot_cle,$champ_levenshtein, poids_total FROM ".RECH_BASE.RECH_TABLE_MOT_CLE." WHERE is_numeric=0 AND id_mot_parent IS NULL"));

		$req="SELECT mot,ratio FROM ".RECH_BASE.RECH_TABLE_LEVENSHTEIN." WHERE est_manuel=0 $AND";
		$liste_levenshtein = mysql_fetch_all(ifReq($req));
		//$mot_cmplx=Rech_Parseur::mot_to_complexe()
		//
		foreach($liste_levenshtein as $un_lev) {
			$lng=strlen($un_lev["mot"]);
			$old_ratio=$un_lev["ratio"];

			$lng_min=floor($lng*(1-POURCENT_LONGUEUR_LEVENSHTEIN));
			$lng_max=ceil($lng*(1+POURCENT_LONGUEUR_LEVENSHTEIN));

			foreach($liste_tous_mots AS $un_mot_cle) {
				$mot_cle = $un_mot_cle[$champ_levenshtein];
				$lng_mot=strlen($mot_cle);
				if($lng_mot<=$lng_max && $lng_mot>=$lng_min ) {
					$ratio_final = Rech_Parseur::calcule_ratio_levenshtein($un_lev["mot"],$un_mot_cle[$champ_levenshtein],$un_mot_cle["poids_total"]);
					//	echo "<br>$un_lev[mot],$un_mot_cle[$champ_levenshtein] = $ratio_final / $old_ratio";
					if($ratio_final > $old_ratio ) {
						$old_ratio=$ratio_final;
						ifReq("UPDATE ".RECH_BASE.RECH_TABLE_LEVENSHTEIN." SET ratio=$ratio_final , id_mot_cle = $un_mot_cle[id_mot_cle] WHERE mot='$un_lev[mot]'");
					}
				}
			}
			if($old_ratio==-1) {
				// pas mieux que rien !
				ifReq("UPDATE ".RECH_BASE.RECH_TABLE_LEVENSHTEIN." SET ratio=-1 , id_mot_cle = -1 WHERE mot='$un_lev[mot]'");
			}
		}
		//exit;
	}


	/**
	 *
	 * @param $identifiant
	 * @param $class_path
	 * @param $class_name
	 * @param $full_text
	 * @return unknown_type
	 */
	public function ajoute_type_page($identifiant,$class_path,$class_name,$full_text) {
		include_once $class_path;
		$class = new $class_name(0);
		if($class->identifiant_type != $identifiant) die("l'identifiant ($ this -> identifiant_type) de la classe doit etre le même que celui fourni");
		SQL_admin::insert(RECH_TABLE_TYPE_PAGE,array("identifiant"=>$identifiant,"class_path"=>$class_path,"class_name"=>$class_name,"full_text"=>$full_text),"identifiant");
	}
	public static function get_type_page($identifiant) {
		return testReq3("SELECT * FROM ".RECH_BASE.RECH_TABLE_TYPE_PAGE." WHERE identifiant = '$identifiant'");
	}

	public function efface_type_page($identifiant) {
		SQL_admin::delete(RECH_TABLE_TYPE_PAGE,array("identifiant"=>$identifiant),"identifiant");
	}

	public function ajoute_type_spec($identifiant_type_spec,$type_donnee,$identifiant_type_page,$frequence=NULL) {
		if($res_type_page=testReq2("SELECT id_type_page FROM ".RECH_BASE.RECH_TABLE_TYPE_PAGE." WHERE identifiant='$identifiant_type_page'")) {
			$id_type_page = $res_type_page[0];
			SQL_admin::insert(RECH_TABLE_TYPE_SPEC,array("identifiant"=>$identifiant_type_spec,"id_type_page"=>$id_type_page,"frequence"=>$frequence,"type_val"=>$type_donnee),"identifiant");
		} else {
			SQL_admin::trace(mysql_error());
		}
	}
	/*public function efface_type_spec($identifiant) {
		if($res_type_spec=testReq2("SELECT id_type_page FROM ".RECH_BASE.RECH_TABLE_TYPE_SPEC." WHERE identifiant='$identifiant'")) {
		// la spec existe
		// delete les valeurs correspondantes
		ifReq("DELETE FROM ".RECH_BASE.RECH_TABLE_SPEC_VAL." WHERE id_type_spec = ".$res_type_spec[0]);
		}
		SQL_admin::delete(RECH_TABLE_TYPE_SPEC,array("identifiant"=>$identifiant),"identifiant");
		}*/

	/*
	 *
	 * surveillance
	 *
	 */

	public static function get_liste_mots_plus_utilises($nb=100) {
		return mysql_fetch_all(ifReq("SELECT mc.id_mot_cle,mc.mot,mc.metaphone,mc.racine, count(*) as nb
			FROM ".RECH_BASE.RECH_TABLE_MOT_CLE_PAGE." mcp 
			LEFT JOIN ".RECH_BASE.RECH_TABLE_MOT_CLE." mc ON mcp.id_mot_cle = mc.id_mot_cle 
			WHERE mc.id_mot_parent IS NULL
			GROUP BY mc.id_mot_cle 
			ORDER BY nb desc LIMIT 0,$nb"));
	}
}
?>