<?php
//include_once 'modules/gestdocs/classes/CListeFichiers.class.php';//auto

class CGestionMiniatures
{
	public $cheminBase = "";

	/**
	 * Renvoi le MD5 du contenu d'un fichier
	 */

	public function getMD5Fichier($fichier)
	{
		return md5(file_get_contents($fichier));
	}
	/**
	 * Renvoi le MD5 stocké sur le disque
	 */
	public function getOldMD5Fichier($fichier)
	{
		$split = split_fichier($fichier);
		$path = $this->cheminBase.$split["chemin"].'/redim/'.$split['fichier'].'.md5';
		if(file_exists($path)){
			return file_get_contents($path);
		}
		else
		return '';
			
	}
	/*
	 * Stocke le MD5 de l'image dans le dossier redim
	 */
	public function saveMD5Image($nomImage)
	{
		$split = split_fichier($nomImage);
		$path = $split["chemin"].'/redim/'.$split['fichier'].'.md5';
		creeRepSiExistePas($path);
		file_put_contents($path,$this -> getMD5Fichier($nomImage));
	}

	/*
	 * Supprime complètement toutes les miniatures d'un fichier
	 */
	public function supprimeMiniature($nomFichier, $suppMD5 = false)
	{
		$split = split_fichier($nomFichier);
		
		//TODO: virer ce test et faire marcher sans gestdocs
		if (Cmodule::module_existe("gestdocs")) {
			$listeF = new CListeFichiers();
		
			$path = $split["chemin"].'/redim/';
			$listeF -> recupereListe($path);
			$tabFichier = $listeF -> getTabListeFichier();
			foreach($tabFichier as $unFichier) {
	
				$exp = "#((.*)_([0-9]{1,4})_([0-9]{1,4})_(MAX|CROPMAX|EXACT|NO)_([0-9a-f]{5}).(JPG|PNG|GIF))#i";
				$est_redim = preg_match($exp,$unFichier['nomlong'],$detail_redim);
				$est_la = (strpos($unFichier['nomlong'],$split['fichier_base']) === 0);
	
				if($est_la && $est_redim and is_file($path.$unFichier['nomlong']))
				unlink($path.$unFichier['nomlong']);
	
			}
			if($suppMD5)
			if(is_file($path.$split['fichier'].'.md5'))
			unlink($path.$split['fichier'].'.md5');
		}
	}
	/*
	 * Compare qu'il n'y a pas eu de changement entre les images et nettoie si oui
	 */
	public function nettoieMiniaturesFichier($nomFichier)
	{
		$old_md5=$this -> getOldMD5Fichier($nomFichier);
		if($this -> getMD5Fichier($nomFichier) != $old_md5)
		{
			// Suppression des miniatures
			//if($old_md5 != "")
			$this -> supprimeMiniature($nomFichier);

			// Sauvegarde du nouveau MD5
			$this -> saveMD5Image($nomFichier);

			return true;
		}
		else
		{
			//			$this -> saveMD5Image($nomFichier);
			return false;
		}
	}

	/*
	 * Nettoyer les miniatures d'un dossier
	 */
	public function nettoieMiniaturesDossier($chemin, $recursif = false)
	{
		$petitChem = $chemin;
		$chemin = str_replace('//','/',$this->cheminBase.$chemin);
		$listeF = new CListeFichiers();
		$listeF -> recupereListe($chemin);
		if($recursif)
		{
			$tabDossier = $listeF -> getTabListeDossier();
			foreach($tabDossier as $unDossier)
			{
				$this -> nettoieMiniaturesDossier($petitChem.$unDossier.'/', true);
			}
		}
			
		$tabFichier = $listeF -> getTabListeFichier();
		foreach($tabFichier as $unFichier)
		{
			$this -> nettoieMiniaturesFichier($chemin.$unFichier['nomlong']);
		}
	}

	/*
	 * Vidage total des dossiers redim ( suppression COMPLETE du contenu du repertoire )
	 */
	public function nettoyageTotalDossiersRedim($path)
	{
		$petitPath = $path;
		$path = $this->cheminBase.$path;
		if(is_dir($path))
		if($dh = @opendir($path))
		{
			while (($file = readdir($dh)) !== false)
			if (is_dir($path.$file) and $file != '.' and $file != '..')
			{
				if($file == 'redim')
				{
					$dt = @opendir($path.$file);
					while (($files = readdir($dt)) !== false)
					if(is_file($path.$file.'/'.$files))
					unlink($path.$file.'/'.$files);
				}
				else
				$this -> nettoyageTotalDossiersRedim($petitPath.$file.'/');
			}
			closedir($dh);
		}
	}
}

?>