<?php

class ITSEC_Malware {

	function run() {
		add_action( 'ithemes_sync_register_verbs', array( $this, 'register_sync_verbs' ) );
		add_filter( 'itsec-filter-itsec-get-everything-verbs', array( $this, 'register_sync_get_everything_verbs' ) );

		add_filter( 'itsec_logger_displays', array( $this, 'itsec_logger_displays' ) );
		add_filter( 'itsec_logger_modules', array( $this, 'itsec_logger_modules' ) );
		add_filter( 'itsec_logger_filter_malware_data_column_details', array( $this, 'filter_logger_data_column_details' ), 10, 2 );
	}

	/**
	 * Register verbs for Sync.
	 *
	 * @since 3.6.0
	 *
	 * @param Ithemes_Sync_API $api Sync API object.
	 */
	public function register_sync_verbs( $api ) {
		$api->register( 'itsec-do-malware-scan', 'Ithemes_Sync_Verb_ITSEC_Malware_Do_Scan', dirname( __FILE__ ) . '/sync-verbs/itsec-do-malware-scan.php' );
		$api->register( 'itsec-get-malware-scan-log', 'Ithemes_Sync_Verb_ITSEC_Get_Malware_Scan_Log', dirname( __FILE__ ) . '/sync-verbs/itsec-get-malware-scan-log.php' );
	}

	/**
	 * Filter to add verbs to the response for the itsec-get-everything verb.
	 *
	 * @since 3.6.0
	 *
	 * @param  array Array of verbs.
	 *
	 * @return array Array of verbs.
	 */
	public function register_sync_get_everything_verbs( $verbs ) {
		$verbs['malware'][] = 'itsec-get-malware-scan-log';

		return $verbs;
	}

	/**
	 * Register malware for logger
	 *
	 * @since 4.4
	 *
	 * @param  array $logger_modules array of logger modules
	 *
	 * @return array                   array of logger modules
	 */
	public function itsec_logger_modules( $logger_modules ) {
		$logger_modules['malware'] = array(
			'type'     => 'malware',
			'function' => __( 'Malware Scan', 'better-wp-security' ),
		);

		return $logger_modules;

	}

	/**
	 * Array of metaboxes for the logs screen
	 *
	 * @since 4.4
	 *
	 * @param array $displays metabox array
	 *
	 * @return array metabox array
	 */
	public function itsec_logger_displays( $displays ) {
		$displays[] = array(
			'module'   => 'malware',
			'title'    => __( 'Malware Scan', 'better-wp-security' ),
			'callback' => array( $this, 'logs_metabox_content' )
		);

		return $displays;
	}

	/**
	 * Render the settings metabox
	 *
	 * @return void
	 */
	public function logs_metabox_content() {

		if ( ! class_exists( 'ITSEC_Malware_Log' ) ) {
			require( dirname( __FILE__ ) . '/class-itsec-malware-log.php' );
		}

		$log_display = new ITSEC_Malware_Log();

		$log_display->prepare_items();
		$log_display->display();

	}

	public function filter_logger_data_column_details( $details, $data ) {
		if ( is_wp_error( $data ) || ( ! empty( $data ) && ! empty( $data['SCAN']['SITE'] ) ) ) {
			// Results for Sucuri scans.

			require_once( dirname( __FILE__ ) . '/class-itsec-malware-scan-results-template.php' );

			$details = "<div class='itsec-malware-scan-results-wrapper'>\n";
			$details .= ITSEC_Malware_Scan_Results_Template::get_html( $data, true );
			$details .= "</div>\n";
		}

		return $details;
	}

}
