<?php

/**
 * remplace tous les blocs #BALISE de $str définis dans $arr
 * @param $str = '#NOM# #PRENOM#'
 * @param $arr = ("nom"=>..., "prenom"=>...)
 * @return string
 */
function remplace_tous_blocs($str,$arr=NULL,$pfx="#") {
	ifNULL($arr,array());
	$replace=array();
	$srch=array();
	if(is_array($arr) && count($arr)>0)
	foreach ($arr as $key=>$val) {
		$srch[]=$pfx.strtoupper($key)."#";
		$replace[]=$val;
	}

	//		print_r($arr);
	$patern="($pfx([*a-z0-9A-Z_-]*),([^#]*)#)";
	if(preg_match($patern,$str)) {
		$GLOBALS["tmp_arr"] = $arr;
		$str=preg_replace_callback($patern,"remplace_var_params",$str);
	}
	//	print_rr($srch);
	//	print_rr($replace);
	//	echo $str.'=><br/>';
	//	echo str_replace($srch,$replace,$str).'<br/>';
	return str_replace($srch,$replace,$str);
}

function remplace_var_params($match) {
	//		print_r($match);
	$tmp_arr = $GLOBALS["tmp_arr"] ;

	$params=explode(",",$match[2]);
	$var = strtolower($match[1]);



	//	echo "var : $var", print_rr($params), '<br/>';
	// protextion si pas la donnée
	//	if(!isset($tmp_arr[$var])) return $match[0];
	
	if(is_array($tmp_arr) && !array_key_exists($var,$tmp_arr)) {
		return $match[0];
	}
	else if (!isset($tmp_arr[$var])) return $match[0];

	$texte = $tmp_arr[$var]; // /!> attention minuscules ds les data
	while($nom_fn = array_shift($params)) {


		switch($nom_fn) {
			case "longueur":
				$long = array_shift($params);
				$fin = array_shift($params);
				if (strlen($texte) > $long) $texte=substr($texte,0,$long).$fin;
				break;
			case "si_vide":
				$val = array_shift($params);
				if ($texte == '' || isNULL($texte)) $texte = $val;
				break;
			case "si_vide_sinon":
				$cas_vide = array_shift($params);
				$cas_pas_vide = array_shift($params);
				if ($texte == '' || isNULL($texte)) $texte = str_replace('$VARIABLE$',$texte,$cas_vide);
				else $texte = str_replace('$VARIABLE$',$texte,$cas_pas_vide);
				break;
			case "si":
				$si = array_shift($params);
				$alors = array_shift($params);
				if ($texte == $si) $texte = $alors;
				break;
			case "si_sinon":
				$cond = array_shift($params);
				$si = array_shift($params);
				$sinon = array_shift($params);
				if ($texte == $cond) $texte = str_replace('$VARIABLE$',$texte,$si);
				else $texte = str_replace('$VARIABLE$',$texte,$sinon);
				//if ($texte == $si) $texte = $alors;
				break;
			case "no_html":
				$texte = strip_tags($texte);
				break;
			case "no_retour":
				$texte = str_replace("\n", '', $texte);
				$texte = str_replace("\r", '', $texte);
				break;
			case "no_guill":
				$texte = str_replace('"', '', $texte);
				break;
			case "no_apost":
				$texte = str_replace("'", '', $texte);
				break;
		}
	}
	return $texte;
}

/*function remplace_tous_blocs_html_entities($str,$arr=NULL,$pfx="#") {
 ifNULL($arr,array());
 $srch=array();
 $replace=array();
 foreach ($arr as $key=>$val) {
 $srch[]=$pfx.strtoupper($key)."#";
 $replace[]=htmlentities($val);
 }
 return str_replace($srch,$replace,$str);
 }*/
/**
 * idem remplace_tous_blocs mais avec un tableau de tableau (mysql_fetch_all)
 * @param $str
 * @param $arr = [0=>[id=>1,nom=>2...],[1=>[....], .. ]
 * @param $pfx
 * @return unknown_type
 */
function remplace_tous_blocs_multiples($str,$arr,$pfx="#",$nb=999999) {
	$retour = "";
	//	echo "is_array($arr) ".count($arr);
	if(is_array($arr) && count($arr)>0) {
		//		echo "oui";
		foreach($arr as $un_arr) {
			//			echo 'la';
			if($nb--<=0) break;
			$retour .= remplace_tous_blocs($str,$un_arr,$pfx);
		}
	}
	//	echo "non";
	return $retour;
}

/**
 *
 * @param $str
 * @param $arr_fn = ("sup100"=>sup100($param_fn), "vieux"=>function($param_fn))
 * @param $param_fn (le tableau de la ligne des données de la base)
 * @param $pfx
 * @return unknown_type
 */
function remplace_tous_blocs_fn($str,$arr_fn=NULL,$params_fn,$pfx="#") {

	ifNULL($arr_fn,array());
	$srch=array();
	$replace=array();

	foreach ($arr_fn as $key=>$fn) {

		$srch[]=$pfx.strtoupper($key)."#";
		if(is_array($fn)) {
			$classe=$fn[0];
			$replace[]=$debut.$classe->{$fn[1]}($params_fn[0],$params_fn[1], $key);
		} else if(function_exists($fn))
		$replace[]=$debut.$fn($params_fn[0],$params_fn[1], $key);
		else
		$replace[]=$debut.$fn;
	}
	return str_replace($srch,$replace,$str);
}
/**
 * recherche un bloc [#BLOC] #ID# #NOM2# [/BLOC], et le multiplie par le nombre d'éléments du tableau,
 * en remplaçant les variables id, nom
 * @param unknown_type $str
 * @param unknown_type $balise
 * @param unknown_type $donnees [0=>[id=>1,nom=>2...],[1=>[....], .. ]
 */
function remplace_tous_elements_multiples($str,$balise,$donnees,$pfx="#",$nb=999999) {
	$un_bloc = recherche_element_par_balise($str,$balise);
	$blocs = remplace_tous_blocs_multiples($un_bloc,$donnees,$pfx,$nb);
	return remplace_element_par_balise($str,$balise,$blocs);
}

function recherche_tous_element_par_balise($str,$balise) {
	$start=0;
	$retour=array();
	while(($trouve = recherche_element_par_balise($str,$balise,$start))!="") {
		$retour[]=$trouve;
	}
	return $retour;
}

function recherche_element_par_balise($str,$balise,&$startIndex=0) {
	$long_balise=strlen($balise);
	$posDeb=strpos($str,"[#$balise]",$startIndex);
	$posFin=strpos($str,"[/#$balise]",$posDeb);
	$startIndex=$posFin;
	//	$avant=substr($str,0,$posDeb);
	//	$apres=substr($str,$posFin+$long_balise+4);// $ligne = l'�lem a dupliquer
	if($posDeb!==false && $posFin!==false) {
		$ligne=substr($str,$posDeb+$long_balise+3,$posFin-$posDeb-$long_balise-3);
		return $ligne;
	} else {
		return "";
	}
}


function remplace_element_par_balise($str,$balise,$remplacer) {
	$long_balise=strlen($balise);
	$posDeb=strpos($str,"[#$balise]");
	$posFin=strpos($str,"[/#$balise]");
	if($posDeb!==false && $posFin!==false) {
		//	return ereg_replace("[[]#$balise](.*)[[]/#$balise]",$remplacer,$str);
		$avant=substr($str,0,$posDeb);
		$apres=substr($str,$posFin+$long_balise+4);// $ligne = l'�lem a dupliquer
		//$ligne=substr($str,$posDeb+$long_balise+3,$posFin-$posDeb-$long_balise-3);
		return $avant.$remplacer.$apres;
	}else {
		return $str;
	}
}


function affiche_element_simple_par_balise($str,$balise,$affiche=true,$str_recherche=false,$str_replace=false) {
	$bloc=$affiche?recherche_element_par_balise($str,$balise):"";
	if($str_recherche && $str_replace) {
		$bloc=str_replace($str_recherche,$str_replace,$bloc);
	}
	return remplace_element_par_balise($str,$balise,$bloc);
}
function cache_element_simple_par_balise($str,$balise,$cache=true) {
	return affiche_element_simple_par_balise($str,$balise,!$cache);
}


function affiche_element_par_balise($str,$balise,$affiche=true,$str_recherche=false,$str_replace=false) {
	return affiche_element_multiple_par_balise($str,$balise,$affiche,$str_recherche,$str_replace);
}
function cache_element_par_balise($str,$balise,$cache=true) {
	return affiche_element_par_balise($str,$balise,!$cache);
}


function affiche_element_multiple_par_balise($str,$balise,$affiche=true,$str_recherche=false,$str_replace=false) {
	$remplace=($str_recherche && $str_replace && $affiche);
	while($bloc=recherche_element_par_balise($str,$balise)) {
		if($remplace) {
			$bloc=str_replace($str_recherche,$str_replace,$bloc);
		}
		$str=remplace_element_par_balise($str,$balise,$affiche?$bloc:"");
	}
	return $str;
}
function cache_element_multiple_par_balise($str,$balise,$cache=true,$str_recherche=false,$str_replace=false) {
	return affiche_element_multiple_par_balise($str,$balise,!$cache,$str_recherche,$str_replace);
}
?>