<?php
CListes::add_liste2("pubs_clients","pubs__clients","liste des clients","table des clients des pubs du site","client","Pubs",NULL);
CListes::add_champ_liste("pubs_clients", "identifiant", "VARCHAR(255)", "identifiant", "identifiant", "identifiant du client", "(+*)", '1');
CListes::add_champ_liste("pubs_clients", "mail", "VARCHAR(255)", "mail", "mail", "mail de contact du client", "(+*)", '1');
CListes::add_cle_unique('pubs_clients', 'ID_CLIENTS_UNIQUE', "identifiant");

CListes::add_liste2("pubs_campagne","pubs__campagne","liste des campagnes pub","table des campagnes pub du site","campagne","Pubs",NULL);
CListes::set_champ_liste_etranger("pubs_campagne","id_client","pubs__clients","id_auto","#IDENTIFIANT#");
CListes::add_champ_liste("pubs_campagne", "identifiant", "VARCHAR(255)", "identifiant", "identifiant", "identifiant de la campagne", "(+*)", '1');
CListes::add_champ_liste("pubs_campagne", "date_deb", "DATE", "date_deb", "date_deb", "date debut de campagne", "(.*)", '2',"NULL DEFAULT NULL");
CListes::add_champ_liste("pubs_campagne", "date_fin", "DATE", "date_fin", "date_fin", "date fin de campagne", "(.*)", '3',"NULL DEFAULT NULL");
CListes::add_champ_liste("pubs_campagne", "actif", "BOOL", "actif", "actif", "campagne pub active ou non", "(.+)", '4', NULL, 'checkbox');
CListes::add_cle_unique('pubs_campagne', 'ID_CAMPAGNES_UNIQUE', "identifiant");

CListes::add_liste2("pubs_emplacement","pubs__emplacement","liste des emplacements de pub du site","table des emplacements de pub du site","emplacement","Pubs",NULL);
CListes::add_champ_liste("pubs_emplacement", "identifiant", "VARCHAR(100)", "identifiant", "identifiant", "identifiant de emplacement sur le site", "(.*)", '1');
CListes::add_champ_liste("pubs_emplacement", "largeur", "SMALLINT", "largeur", "largeur", "largeur de la zone", "(.*)", '2');
CListes::add_champ_liste("pubs_emplacement", "hauteur", "SMALLINT", "hauteur", "hauteur", "hauteur de la zone", "(.*)", '3');
CListes::add_champ_liste("pubs_emplacement", "type_redim", "VARCHAR(40)", "type_redim", "type_redim", "type de redim pour les images", "(.*)", '4');

CListes::add_liste2("pubs_fichiers","pubs__fichiers","liste des fichiers pub du site","table des fichiers pub du site","pub","Pubs",'ads/');
CListes::add_champ_liste("pubs_fichiers", "identifiant", "VARCHAR(100)", "identifiant", "identifiant", "identifiant de emplacement sur le site", "(.*)", '1');
CListes::set_champ_liste_etranger("pubs_fichiers","id_emplacement","pubs__emplacement","identifiant","#IDENTIFIANT#");
CListes::add_champ_liste_etranger("pubs_fichiers","id_client","pubs__clients","id_auto","#IDENTIFIANT#");
CListes::add_champ_liste_etranger("pubs_fichiers","id_campagne","pubs__campagne","id_auto","#IDENTIFIANT#");
CListes::add_champ_liste("pubs_fichiers", "image", "VARCHAR(100)", "image si pub image", "image si pub image", "image si pub image", "(.*)", '2',"NULL DEFAULT NULL", 'image', NULL, 'image|CROPMAX|80|80');
CListes::add_description_image("pubs_fichiers","image","1000","1000","MAX","id_auto","#ID_AUTO#","id_emplacement",0);
CListes::add_champ_liste("pubs_fichiers", "lien", "VARCHAR(255)", "lien", "lien", "lien lors du clic sur la pub ", "(.*)",'4',"NULL DEFAULT NULL");
CListes::drop_champ_liste('pubs_fichiers', 'img_lien');
CListes::add_champ_liste("pubs_fichiers", "swf", "VARCHAR(255)", "swf", "swf", "swf si pub flash", "(.*)",'4',"NULL DEFAULT NULL","file",null);
CListes::add_description_upload("pubs_fichiers","swf","id_auto","#ID_AUTO#","id_emplacement",0,CListes::$TYPE_FLASH,0,0,0,"",0);
CListes::add_champ_liste("pubs_fichiers", "date_deb", "DATE", "date_deb", "date_deb", "date debut de publication", "(.*)", '5',"NULL DEFAULT NULL");
CListes::add_champ_liste("pubs_fichiers", "date_fin", "DATE", "date_fin", "date_fin", "date fin de publication", "(.*)", '6',"NULL DEFAULT NULL");
CListes::add_champ_liste("pubs_fichiers", "actif", "BOOL", "actif", "actif", "fichier pub actif ou non", "(.+)", '7', NULL, 'checkbox');
CListes::add_champ_liste("pubs_fichiers", "nb_vue", "INT", "nb_vue", "nb_vue", "nombre de visualisation de la pub", "(.*)", '8', NULL, 'hidden');
CListes::add_champ_liste("pubs_fichiers", "nb_clic", "INT", "nb_clic", "nb_clic", "nombre de clic sur la pub", "(.*)", '9', NULL, 'hidden');
CListes::add_champ_liste("pubs_fichiers", "type_pub", "ENUM('img', 'swf')", "type_pub", "type_pub", "type de la pub", "(.*)", '10');
CListes::add_cle_unique('pubs_fichiers', 'ID_PUBS_UNIQUE', "identifiant");

CListes::set_valeurs_defaut("pubs_fichiers",array("nb_vue"=>0,"nb_clic"=>0));

//Insertion des stats de SOUN
CListes::insere('type_stats', array('table_upd'=>'pubs__fichiers', 'colonne_upd'=>'nb_vue', 'colonne_where'=>'id_auto', 'identifiant'=>'PUB_VUE', 'type'=>'CPT'), 'identifiant');
CListes::insere('type_stats', array('table_upd'=>'pubs__fichiers', 'colonne_upd'=>'nb_clic', 'colonne_where'=>'id_auto', 'identifiant'=>'PUB_CLIC', 'type'=>'CPT'), 'identifiant');

?>