<?php

class CStringUtils
{
	public static function dateFormatFr($date, $sep= '/')
	{
		//echo '!!!'.$date;
		$expl = explode(' ', $date); echo '!!!'.$expl[0];
		$expl = explode('-', $expl[0]);
		return  $expl[2] . $sep . $expl[1] . $sep . $expl[0];   
	}
	
	public static function dateHeureFormatFr($date, $sep_date = '/', $sep_heure = ':', $display_secondes = false)
	{
		//2009-02-25 17:01:26
		$str = '';
		$expl = explode('-', $date);
		$annee_mois = $expl[1] . $sep_date . $expl[0];		
		$expl = explode(' ', $expl[2]); //expl[2] = 25 17:01:26
		$str = $expl[0] . $sep_date . $annee_mois;
		$expl = explode(':', $expl[1]); //expl[1] = 17:01:26
		$str .= ' ' . $expl[0] . $sep_heure . $expl[1];
		if ($display_secondes) $str .= $sep_heure . $expl[2];
		return $str;   
	}
	
	
	private static $tab_mois_fr = array('Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre');
	private static $tab_jours_fr = array('Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
	
	public static function nomJourFrFromSqlDate($date_sql)
	{
		$expl = explode('-', $date_sql);
		$jour = date('w', mktime(1,0,0,intval($expl[1]), intval($expl[2]), intval($expl[0])));
		return self::nomJourFrFromNumJourSemaine($jour);
	}
	
	public static function nomJourEnFromSqlDate($date_sql)
	{
		$expl = explode('-', $date_sql);
		$jour = date('l', mktime(1,0,0,intval($expl[1]), intval($expl[2]), intval($expl[0])));
		return $jour;
	}
	
	private static function nomJourFrFromNumJourSemaine($num_jour)
	{
		return self::$tab_jours_fr[intval($num_jour)];
	}
	
	public static function dateJourFrFormatFr($date, $sep_date = ' ', $affiche_mois = false, $affiche_annee = false)
	{
		$expl = explode('-', $date);
		$retour = self::nomJourFrFromSqlDate($date).$sep_date.$expl[2];
		
		if ($affiche_mois) $retour .= $sep_date.self::nomMoisFrFromNumMois($expl[1]);
		if ($affiche_annee) $retour .= $sep_date.$expl[0];
		return $retour;
	}
	
	public static function dateJourEnFormatEn($date, $sep_date = ' ')
	{
		$expl = explode('-', $date);
		return date('l jS', mktime(1,0,0,intval($expl[1]), intval($expl[2]), intval($expl[0])));
	}
	
	public static function nomMoisFrFromSqlDate($date_sql)
	{
		$expl = explode('-', $date);
		return self::nomMoisFrFromNumMois($expl[1]);
	}
	
	public static function nomMoisEnFromSqlDate($date_sql)
	{
		$expl = explode('-', $date_sql);
		return date('F', mktime(1,0,0,intval($expl[1]), intval($expl[2]), intval($expl[0])));
	}
	
	public static function nomMoisFrFromNumMois($num_mois)
	{
		return self::$tab_mois_fr[intval($num_mois) -1];
	}
	
	public static function nomMoisEnFromNumMois($num_mois)
	{
		return date('F', mktime(1,0,0,$num_mois, 1, 2000));
	}
	
	public static function dateMoisFrFormatFr($date, $sep_date = ' ', $affiche_annee = true)
	{
		$expl = explode('-', $date);
		if ($affiche_annee) return $expl[2].$sep_date.self::nomMoisFrFromNumMois($expl[1]).$sep_date.$expl[0];
		else return $expl[2].$sep_date.self::nomMoisFrFromNumMois($expl[1]);
	}
	
	public static function metaDescription($texte)
	{
		$texte = strip_tags($texte);
		
		if (strlen($texte) > 400) $texte = substr($texte,0,400).'...';
		
		return html_entity_decode($texte, null, 'UTF-8');
	}
	
	public static function strip_tags_content($text, $tags = '', $invert = false) {
	
		  preg_match_all('/<(.+?)[\s]*\/?[\s]*>/si', trim($tags), $tags);
		  $tags = array_unique($tags[1]);
		   
		  if(is_array($tags) AND count($tags) > 0) {
		    if($invert == false) {
		      return preg_replace('@<(?!(?:'. implode('|', $tags) .')\b)(\w+)\b.*?>.*?</\1>@si', '', $text);
		    }
		    else {
		      return preg_replace('@<('. implode('|', $tags) .')\b.*?>.*?</\1>@si', '', $text);
		    }
		  }
		  elseif($invert == false) {
		    return preg_replace('@<(\w+)\b.*?>.*?</\1>@si', '', $text);
		  }
		  return $text;
	}
}

?>