<?php

class QueryBuilder{
	
	const TYPE_SELECT = "SELECT ";
	const TYPE_UPDATE = "UPDATE ";
	const TYPE_INSERT = "INSERT INTO";
	const TYPE_DELETE = "DELETE ";
	
	private $type = TYPE_SELECT;
	
	static $conn = null;
	public $table = "";
	public $class = "";
        
	public $displayQuery = false;
	
	public $sql = "";
	
	private $sqlPart = array(
		'select' => array(), 
		'from' => array(), 
		'notin' => "", 
		'join' => array(), 
		'where' => array(), 
		'orderBy' => array(),
		'groupBy' => "", 
		'limit' => array(), 
	);
	
	private $params = array();
	
	
	public function __construct($table){
                $this->class = ucfirst($table);
		$this->table = strtolower($table);
                
	}
	
	public function setConn($conn){
		self::$conn = $conn;
	}
	
	
	
	public function select(){
		
		if(func_num_args() == 0){
			$this->sqlPart['select'][] = '*';
		}
		else if(func_num_args() == 1 && is_array(func_get_arg(0))){
			$fieldsTab = func_get_arg(0);
			foreach($fieldsTab as $f ){
				$this->sqlPart['select'][] = $f;
			}
		}
		else if(func_num_args() >= 1 && !is_array(func_get_arg(0))){
			for($i = 0; $i < func_num_args(); $i++){
				$this->sqlPart['select'][] = func_get_arg($i);
			}
		}
		
//		print_r_html($this->sqlPart['select']);
//		if(empty($fields)){
//		}
//		else if(!is_array($fields)){
//			$this->sqlPart['select'] = $fields;			
//		}
		
		return $this;
	}
	
	public function from($table){

		if(func_num_args() == 1){
			$this->sqlPart['from'] = $table;
		}
		else if(func_num_args() > 1){
			for($i = 0; $i < func_num_args(); $i++){
				$args = func_get_arg($i);
				$this->sqlPart['from'][] = $args[0];
			}
		}
		return $this;
	}
	
	public function join($join){
		//TODO: gestion jointure à modifier
		
		$this->sqlPart['join'][] = $join;
		
		
		return $this;
	}
	
	public function notIn($sql){
		$this->sqlPart['notin'] = $sql;
		
		return $this;
	}
	
	public function where($condition){
		$this->sqlPart['where'][] = $condition;
		
		if(func_num_args() > 1){
			for($i = 1; $i < func_num_args(); $i++){
				$args = func_get_arg($i);
				$this->params[] = $args;
			}
		}
		return $this;
	}
	
	public function andWhere($condition){
		$this->sqlPart['where'][] = $condition;
		
		if(func_num_args() > 1){
			for($i = 1; $i < func_num_args(); $i++){
				$args = func_get_arg($i);
				$this->params[] = $args;
			}
		}
		
		return $this;
	}
	
	public function orderBy($field, $opt = 'ASC'){
		
		$orderBy[0] = $field;
		$orderBy[1] = $opt;
		
		$this->sqlPart['orderBy'] = $orderBy;
		
		return $this;
	}
	
	public function groupBy($str){
		$this->sqlPart['groupBy'] = $str;

		return $this;
	}
	
	public function limit(){
		
		if(func_num_args() == 2){
			$this->sqlPart['limit'][0] = func_get_arg(0);
			$this->sqlPart['limit'][1] = func_get_arg(1);
		}
		else if(func_num_args() == 1){
			$this->sqlPart['limit'][0] = 0;
			$this->sqlPart['limit'][1] = func_get_arg(0);
		}
		
		return $this;
	}
	
	public function executeQuery($queryObject = 'group'){
		
//		print_r_html($this->sqlPart['where']);
//		print_r_html($this->params);
		
		$query = 'SELECT ';
		
		if(!empty($this->sqlPart['select'])){
			$i = 1;
			$max_fields = count($this->sqlPart['select']);
			foreach($this->sqlPart['select'] as $fields){
				$query .= ' '.$fields.' ';
				if($max_fields > 1 && $i < $max_fields){
					$query .= ',';
				}
				$i++;
			}
		}
		
		if(is_array($this->sqlPart['from'])){
			$query .= " FROM ";
			$i = 1;
			$max_from = count($this->sqlPart['from']);
			foreach($this->sqlPart['from'] as $from){
				$query .= ' '.$from.' ';
				if($max_fields > 1 && $i < $max_fields){
					$query .= ',';
				}
				$i++;
			}
		}
		else{
			$query .= " FROM ".$this->sqlPart['from']." ";
		}
		
		if(!empty($this->sqlPart['join'])){
			foreach($this->sqlPart['join'] as $join){
				$query .= ' '.$join.' ';
			}
		}
		
		if($this->sqlPart['notin'] != "")
			$query .= 'NOT IN ('.$this->sqlPart['notin'].') ';
		
		if(!empty($this->sqlPart['where']))
			$query .= " WHERE " . implode(' AND ', $this->sqlPart['where']);
		
		if($this->sqlPart['groupBy'] != "")	
			$query .= ' GROUP BY '. $this->sqlPart['groupBy'];
		
		if(!empty($this->sqlPart['orderBy']))	
			$query .= ' ORDER BY '.$this->sqlPart['orderBy'][0].' '. $this->sqlPart['orderBy'][1];
		
		if(!empty($this->sqlPart['limit']))	
			$query .= ' LIMIT '.$this->sqlPart['limit'][0].','.$this->sqlPart['limit'][1];
		
			
			if($this->displayQuery){
				echo $query.'<br/>';
				print_r_html($this->params);
			}
//		$this->query = $query;	
//		$this->sql = $sql;
//		$this->params = $params;
		
//		if($this->sql != "")
//			$query = $this->sql;
			
		$req = self::$conn->prepare($query);
		$req->execute($this->params);
		
//		$result = $req->fetchALL(PDO::FETCH_CLASS, $this->table);
		
		
		if($queryObject === 'group'){
			$result = $req->fetchALL(PDO::FETCH_CLASS, $this->class);
		}
		else if($queryObject === 'object'){
			$result = $req->fetchObject($this->table);
		}
		
		return $result;
		
	}
	
	
	
}


?>