<?php


abstract class Model{
	
	private $table;
	private $fields;
	
	private $sql;
	private $params;
	
	protected $lastId = null;
	
	private static $instance = NULL;
	
	public function __construct($table){
		$this->table = $table;
		self::getConnect();
	}
	
	private static function dbConnect(){
		self::$instance = new PDO(BDD_TYPE.':dbname='.BDD_NAME.';host='.BDD_HOST,BDD_USER ,BDD_PASS);
		self::$instance->query("SET NAMES 'utf8'");
		self::$instance->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	
	public static function getConnect()
	{
		if(is_null(self::$instance)){
			self::dbConnect();
		}

		QueryBuilder::$conn = self::$instance;
		return self::$instance;  
	}
	
	/* PLUS UTILISEE ********************************************* */
	public function select($fields = '*',$cond = NULL, $options = NULL, $returnOne = false){
		if(is_array($fields)){
			$fields = implode(',',$fields);
		}
		
		$sql = "SELECT ". $fields;
		$sql .= " FROM ". $this->table;
		
		$params = array();
		if(is_array($cond)){
			$sql .= " WHERE ";

			$i = 0;
			foreach($cond as $key => $value){
				$sql .= ($i != 0)? ' AND ' : '';
				$sql .= $key . ' = ? ';
				array_push($params,$value);
			}
		}
		
		if(is_array($options)){
			foreach($options as $opt){
				$sql .= ' '.$opt.' ';
			}
		}
		
//		echo $sql;
//		print_r_html($params);
//		$this->sql = $sql;
//		$this->params = $params;
		
		$req = self::$instance->prepare($sql);
		$req->execute($params);
		
//		print_r_html($result[0]);
		
		if($returnOne == false) {
			$result = $req->fetchALL(PDO::FETCH_CLASS, $this->table);
		}
		else{
			$result = $req->fetchObject($this->table);
		}
		
		return $result;
	}
	
	
	public function findAll($cond = NULL){
		$q = new QueryBuilder($this->table);
		$q->select()
		  ->from($this->table);
		  
		if($cond != null){
			$q->orderBy($cond[0],$cond[1]);
		} 
		
		$result = $q->executeQuery();	
			
		return $result;
	}
	
	public function findBy($field,$value = null){
		$q = new QueryBuilder($this->table);
		$q->select()
		  ->from($this->table);
		  
		if(!is_array($field) && $value != null){  
		  $q ->where($field. " = ?", $value);
		}  
		else if(is_array($field)){
			foreach($field as $f => $v){
				$q->where($f. "  = ?", $v);
			}
		}
		else{
			exit("Problème de paramètre dans findBy : ".$this->table);
		}	
		
//		$q->displayQuery = true;
		
		$result = $q->executeQuery();	

		return $result;
	}
	
	public function findOneBy($field,$value = NULL,$cond = NULL){
		$q = new QueryBuilder($this->table);
		$q->select()
		  ->from($this->table);
		  
		if(!is_array($field) && $value != NULL){  
		  $q ->where($field. " = ?", $value);
		}  
		else if(is_array($field)){
			foreach($field as $f => $v){
				$q->where($f. "  = ?", $v);
			}
		}
		else{
			exit("Problème de paramètre dans findOneBy : ". $this->table);
		} 
		  
		if($cond != null){
			$q->orderBy($cond[0],$cond[1]);
		}  
	
//		$q->displayQuery = true;
		
		$r =  $q->executeQuery('object');	
		
		
		
		return $r ;
		
//		TODO: voir pour renvoyer quand même un object vide quand pas d'object
//		$param = array($field => $value);
//		if($cond != null)$cond = array($cond);
//		return $this->select('*',$param,$cond,true);
	}
	
	public function findAllForForm($id,$name,$cond =null){
		$q = new QueryBuilder($this->table);
		$q->select($id,$name)
		  ->from($this->table);
		  
		if($cond != null){
			foreach($cond as $k => $v){
				$q->where($k .' = ? ', $v);
			}
		}  
		
		$obj = $q->executeQuery();

//		print_r_html($obj);
		
		$select['0'] = '--';
		foreach($obj as $s_obj){
			$select[$s_obj->$id] = $s_obj->$name;
		}
		
//		print_r_html($select);
		
		return $select;
	}
	
	public function getLastInsertId(){
//		return self::$instance->lastInsertId();
		return $this->lastId;
	}
	
	public function merge($a,$b)
	{
		return (object)array_merge((array)$a,(array)$b);
	}
	
	
	protected function preSave(){
		
	}
	
	public function save(){
		$this->preSave();
		
		$req = self::$instance->prepare("SHOW COLUMNS FROM ".$this->table);
		
		if($req->execute()){
			$row = $req->fetchAll();
			 
			foreach($row as $key => $array){
				foreach($array as $inner_key => $value){
					if($inner_key === 'Field'){
						if(!is_int($inner_key)){
							$this->fields[] = $value;
						}
					}
				}
			}
		}
		
		$set = array();
		$param = array();
		foreach($this->fields as $key => $field){
			if(!is_null($this->$field)){
				$str = " ".$field." = ? ";
				array_push($set,$str);
				array_push($param, $this->$field);
			}
			
		}
		
//		print_r($fields);
//		print_r($this->columns_names);
		
		//UPDATE
		if($this->id != null){
			$sql = 'UPDATE '. $this->table . ' SET ';
			$sql .= implode($set, ", ");
			$sql .= 'WHERE id = ?';
			array_push($param,$this->id);
		}
		//INSERT IN
		else{
			$sql = 'INSERT INTO '. $this->table . ' SET ';
			$sql .= implode($set, ", ");
		}
		
		$req = self::$instance->prepare($sql);
		$req->execute($param);
		
		$this->lastId = self::$instance->lastInsertId();
		
		return true;
	}
	
	public function delete($cond = null){
		$sql = 'DELETE FROM '.$this->table. ' WHERE ';
		
		if(!empty($cond)){
			$i = 0;
			foreach($cond as $k => $v){
				if($i != 0)
					$sql .= ' AND ';
				$sql .= $k .' = '. $v;
			}
		}
		else{
			$sql .= $this->table.'.id = '.$this->id;
		}
		
//		echo $sql;
		
		$req = self::$instance->prepare($sql);
		$req->execute();
		
	}
	
}




