<?php
class Relances extends Model{
	
	public $id;
	public $num;
	public $date;
	
	/*
	 * 
	 * 
	 * Valeur : 'p'->prÃªte Ã  Ãªtre envoyé, 'e'->envoyée, 't'->terminée, facturée
	 */
	public $etat = 'p';
	public $tva = 19.6;
	public $duree_valid = 1;
	public $total;
	public $titre;
	public $id_client;
	public $id_intitule_entete;
	public $id_facturations_h;

	public $total_tva;
	public $total_ttc;
	
	public $intitule_entete = array();
	public $facturation = array();
	public $elems = array();
	public $hebergements = array();
	
	public $joinRelancesHebergements = array();
	
	
	
	public function __construct(){
		parent::__construct('relances');
	}
	
	public function __toString(){
		return $this->titre;
	}
	
	public function preSave(){
		if($this->id == "")
			$this->date = date('Y-m-d H:i:s');
		
		if($this->id == ""){
			$cpt = new Cpt_relances();
			$cpt_mois = $cpt->findOneBy('mois',date('Y-m'));
			
			if(!empty($cpt_mois)){
				$cpt_mois->save();
				$compteur = $cpt_mois->cpt;
			}
			else{
				$cpt->mois = date('Y-m');
				$cpt->cpt = 0;
				$cpt->save();
				$compteur = $cpt->cpt;
			}
			
			$nb = strlen($compteur);
			$num = "";
			for($i = 0; $i < 3-$nb; $i++){
				$num .= '0';
			}
			
			$num = 'HR'.date('ym').$num.$compteur;
			$this->num = $num;
		}	
			
	}
	
	public function getClient(){
		$c = new Clients();
		$c = $c->findOneBy('id',$this->id_client);

		return $c;
	}
	
	public function getIntituleEntete(){
		$int_ent = new Intitule_entete();
		$int_ent = $int_ent->findOneBy('id',$this->id_intitule_entete);
		
		$this->intitule_entete = $int_ent;
		
		return $int_ent;
	}
	
	public function getJoinRelancesHebergements(){
		if(empty($this->joinRelancesHebergements)){
			$join = new Join_Relances_Hebergements();
			$join = $join ->findBy('id_relances', $this->id);
			
			$this->joinRelancesHebergements = $join;
			
		}
		
		return $this->joinRelancesHebergements;
	}
	
	public function getFacturation(){
		if(empty($this->facturation)){
			$fact = new Facturations_h();
			$fact = $fact->findOneBy('id',$this->id_facturations_h);

			$this->facturation = $fact;
			
			return $fact;
		}
		else{
			return $this->facturation;
		}
	}
	
	public function getJoursRestants(){
		
		$this->getHebergements();
		
		$jours_restants = 10000;
		
		foreach($this->hebergements as  $h){
			if($h->jours_restants < $jours_restants)
				$jours_restants = $h->jours_restants;
		}
		
		return $jours_restants;
	}
	
	public function getTotaux($heb = null){
		
		$i = 0;
		$titre = '';
		$total = 0;
		$total_tva = 0;
		$total_ttc = 0;
		$min_jours_restants = 10000;
		
		if($heb == null || empty($heb)){
			$heb = $this->getHebergements();
		}
		
		$elems = $this->getElems();
				
		foreach($elems as $e){
			$duree = 1;
			$hh = array();
			foreach($heb as $h){
				if($e->designation == $h->designation){
					$hh = $h;
					break;
				}	
			}
			
			if($e->puht != 0){
				if($i != 0) $titre .= ' / ';
				$titre .= $e->designation;
			}
			
			if(!is_null($e->puht) && !is_null($e->qte)){
				$total = $total + ($e->puht * $e->qte);
			}
			else{
				$total = $total +  ($hh->montant_ht * $hh->qte);
			}
				
			

			if(isset($e->jours_restants) && $e->jours_restants < $min_jours_restants)
				$min_jours_restants = $e->jours_restants;	
				
			$i++;
		}
		$total_tva = $total * ($this->tva / 100);
		
		$total_ttc = $total + $total_tva;	
		
		$this->titre = $titre;
		$this->total = $total;
		
		$relance->jours_restants = $min_jours_restants;
		
//		$total_tva = $this->total *( $this->tva / 100);
//		$total_ttc = $this->total + $total_tva;
		
		$this->total_tva = round($total_tva,2); 
		$this->total_ttc = round($total_ttc,2); 
		
//		print_r_html($this);
		
		return $this;
	}
	
	public function getHebergements(){
		if(empty($this->hebergements)){
			$q =  new QueryBuilder('Hebergements');
			
			$q->select('H.*, (to_days(H.date_valid)-to_days(curdate())) as jours_restants')
				->from("hebergements H")
				->join("INNER JOIN join_relances_hebergements J ON J.id_hebergements = H.id")
				->join("INNER JOIN relances R ON R.id = J.id_relances")
				->where('R.id = ? ', $this->id);
				
			$r = $q->executeQuery();	
			
			$this->hebergements = $r;
			return $r;
		}
		else{
			return $this->hebergements;
		}
	}
	
	public function getElems(){
		if(empty($this->elems)){
			$q = new QueryBuilder('Elems');
			$q->select('E.*')
				->from('elems E')
				->where('E.id_relances = ? ', $this->id);
				
//			$q->displayQuery = true;	
				
			$r = $q->executeQuery();

			$this->elems = $r;
				
			return $r;
		}
		else{
			return $this->elems;
		}
	}
	
	public function addElems(){
		// RENOUVELLEMENT DE VOS SERVICES
		// Hébergement								2		60			120
		//     du 03/11/2010 au 03/11/2011
		// sacsmary.com	(*)							2		15			30
		//		du.................
		//
		// a défaut de réglement dans les 30 jours qui suivent la réception de la présente le service sera stoppé
		//  
		//
		// (*) les valeurs sont ajustées pour aligner les  dates d'anniversaire de vos services
			

		$i = 0;
//		$date_min = time() + (60*60*24*365);
		
//		foreach($this->getHebergements() as $h){
//			if(strtotime($h->date_valid) < $date_min )
//				$date_min = strtotime($h->date_valid);
//		}
		$this -> addElem("RENOUVELLEMENT DE VOS SERVICES");
		
		if($this->duree_valid == 1 || $this->duree_valid == 0) $txt_duree =  $this->duree_valid.' an';
		else $txt_duree =  $this->duree_valid.' ans';
		$this -> addElem('pour une durée de '.$txt_duree);
		
		$this -> addElem('');
			
		$alignement = false;
		foreach($this->getHebergements() as $h){
			$elem = new Elems();
			$elem->designation = $h->designation;
		
		
			
			//Recalcul du ratio pour chaque elems
//			$annee = 60*60*24*365;
//			$int_date = strtotime($h->date_valid);
//			$date_ecart = $int_date - $date_min;
			
//			$ratio = ($annee - $date_ecart) / $annee;
//			$h->qte = $ratio;

			$this->getJoinRelancesHebergements();
			
			foreach($this->joinRelancesHebergements as $j){
				if($j->id_hebergements == $h->id)
					$h->qte = $j->qte;
			}
			
			$elem->qte = $h->qte + ($this->duree_valid - 1);
			$alignementElem = ($elem->qte != round($elem->qte));
			if($alignementElem)	{
				$alignement=true;
				$elem->designation .=" (*)";
			}
			
			$elem->puht = $h->montant_ht;
			$elem->id_relances = $this->id;
			$elem->save();

			$date_int_valid = strtotime($h->date_valid) + (60 * 60 * 24 * 365 * $elem->qte);
			
			$this->elems[] = $elem;
			$this -> addElem("       du ".date('d / m / Y',strtotime($h->date_valid))." au ".date('d / m / Y',$date_int_valid));
			
			
			
			
			
//			if(strtotime($h->date_valid) < $date_min )
//				$date_min = strtotime($h->date_valid);
			
			$i++;
		}
		
		/*/////////////////*/

		
		if($alignement)	{
			$this -> addElem('');
			$this -> addElem('');
			$this -> addElem("(*) les valeurs sont ajustées pour aligner les  dates d'anniversaire de vos services");
			}
		$this -> addElem('');
		$this -> addElem('');
		$this -> addElem('');
		if($i>1) {
			$this -> addElem('a défaut de réglement avant le '.date('d / m / Y',strtotime($h->date_valid)).' les services seront stoppés');
		} else {
			$this -> addElem('a défaut de réglement avant le '.date('d / m / Y',strtotime($h->date_valid)).' le service sera stoppé');
		}
		//
			// a défaut de réglement dans les 30 jours qui suivent la réception de la présente le service sera stoppé
			//  
			//
			// (*) les valeurs sont ajustées pour aligner les  dates d'anniversaire de vos services
			
			



		
		$date = date('d-m-Y', $date_int_valid);		
		//$this -> addElem('Validité jusqu\'au '. $date); 
		
		
		return $this->elems;
	}
	
	public function addElem($designation,$qte=0,$puht=0) {
		$elem = new Elems();
		$elem->designation = $designation;
		$elem->qte = $qte;
		$elem->puht = $puht;
		$elem->id_relances = $this->id;
		$elem->save();
	
		$this->elems[] = $elem;
	}
	
	public function JoinWithHebergement($pHebergements = null, $addToHebergement = false){
//		print_r_html($pHebergements);
		
		if(is_array($pHebergements) || $pHebergements == null){
			//Si il est null, on va chercher tous les hébergements
			if($pHebergements == null){
				if(empty($this->hebergements)){
					$client = new Clients();
					$client = $this->getClient();
	//				print_r_html($client);
					
					$hebergements = $client->getHebergements();
					$this->hebergements = $hebergements;
				}
				else{
					$hebergements = $this->hebergements;
				}
			}
			//Si le param est un tableau d'hébergements
			else{
				$hebergements = $pHebergements;
				if($addToHebergement)
					$this->hebergements = $hebergements;
			}
			
//			print_r_html($hebergements);
			
			foreach($hebergements as $h){
				$join = new Join_Relances_Hebergements();
				$join->id_relances = $this->id;
				$join->id_hebergements = $h->id;
				$join->qte = $h->qte;
				
//				print_r_html($join);
				
				$join->save();
			}
			
			return $hebergements;
		}
		//Si le param est juste un ID
		else if($pHebergements != null){
			$pHebergements = intval($pHebergements);
			
			$join = new Join_Relances_Hebergements();
			$join->id_relances = $this->id;
			$join->id_hebergements = $pHebergements;
			$join->qte = 1;
			
			$join->save();
		}
		else{
			exit('ProblÃ¨me de paramÃ¨tre pour la function JoinWithHebergement : '.$pHebergements);
		}
		
		return;
	}
	
	public function createPDF(){
		include_once(RACINE_INCLUDE.'includes/gen_facture.inc.php');
		
		$client = $this->getClient();
		
		$pdf = gen_facture("relance",$this->id,$client->login,$client->pass);
		
		$pdf->Output(RACINE_INCLUDE.'web/pdf/relances/'.$this->num.'.pdf','F');
		
//		header('Content-type: application/pdf');
//		echo $pdf;
		return $pdf;
	}
	
	
	
}

?>