<?php
header('Content-Type: text/html; charset=utf-8');

require_once('includes/Config.inc.php');
require_once('includes/Functions.inc.php');

function __autoload($class_name){
	require_once("classes/$class_name.class.php");
}

bdd::connect();
if(!Identification::isIdentifie()) exit("identification nécessaire");

switch($_REQUEST["action"]) {
	case 'supervision':
		$json = array();
		//$json['params'] = $_REQUEST;
		$json['scope'] = array("range"=>"all");

		global $sql_select_travaux,$sql_select_dateRange,$sql_select_dateRange2;
		// 		En global pour être dispo dans les functions generate_stats_*

		$stats_user_function = "generate_stats_general";

		$idUser = mysql_real_escape_string($_REQUEST["idUser"]);
		$_SESSION['supervision_user'] = $idUser;

		$idClient = mysql_real_escape_string($_REQUEST["idClient"]);
		$_SESSION['supervision_client'] = $idClient;

		$idLot = mysql_real_escape_string($_REQUEST["idLot"]);
		$_SESSION['supervision_lot'] = $idLot;


		$sql_select_travaux = $sql_select_dateRange = dateRange($_SESSION['dateRange'], $_SESSION['debutDateRange']);
// 		$sql_select_dateRange = dateRange($_SESSION['dateRange'], $_SESSION['debutDateRange']);
		$sql_select_dateRange2 = dateRange2($_SESSION['dateRange'], $_SESSION['debutDateRange']);
		$str_select = "Affichage des travaux";

		if(isset($idUser) && $idUser>0) {

			$selectedUser = bdd :: getResult("SELECT * FROM wrk_users WHERE id = '$idUser' AND actif=1");

			$sql_select_travaux .= " AND tr.id_user = '".$idUser."'";
			$str_select .= " de ".$selectedUser["nom"];

		}


		if(isset($idClient) && $idClient>0) {

			$selectedClient = new Client($idClient);

			$sql_select_travaux .= " AND lt.id_client = '".$idClient."'";
			$str_select.=", client ".$selectedClient->nom;

			$stats_user_function = "generate_stats_client";
			
			$json['scope'] = array("range"=>"client");
		}

		if(isset($idLot) && $idLot>0) {

			$selectedLot = new Lot($idLot);
			$selectedLot->detailleLot();
			
			$sql_select_travaux .= " AND lt.id = '".$idLot."'";
			$str_select.=", lot ".$selectedLot->nom;

			$stats_user_function = "generate_stats_lot";
			
			$json['scope'] = array("range"=>"lot");
			$json['scope']['data'] = $selectedLot;
		}

		if(mysql_real_escape_string($_REQUEST["byUser"])=="true") {
			$stats_user_function = "generate_stats_lot";
			$str_select ="Répartition par utilisateur";
		}

		$sql = "SELECT tr .date,
					tr.id AS travail_id,   
					u.id AS user_id, 
					u.nom AS user_nom, 
					ta.nom AS tache_nom, 
					lt.nom AS lot_nom, 
					cl.nom AS client_nom, 
					u.couleur AS user_couleur,  
					cl.couleur AS client_couleur, 
					tr.commentaire AS travail_comment, 
					tr.duree AS travail_duree,
					round(tr.duree_facture* ta.coef_facturation,2) AS travail_duree_facture, 
					u.email AS user_email,
					u.id as user_id,
					ta.id as tache_id 
				FROM wrk_travail tr
				LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
				LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
				LEFT JOIN wrk_clients cl ON lt.id_client = cl.id 
				LEFT JOIN wrk_users u ON tr.id_user = u.id 
				WHERE $sql_select_travaux 			 
				ORDER BY tr.date DESC, u.id, tr.id DESC";

		//exit($sql);
		$dates = array();
		// 		$travail_container = array();
		// 		$tc_key = "";
		// 		$old_tc_key = "";
		$metaDuree = 0;
		$metaDureeFacture = 0;
		$dates[$req_date['date']]['travaux_container']=array();

		$req_dates = bdd::getResults($sql);
		foreach($req_dates as $req_date){

			if(!isset($dates[$req_date['date']]['duree']))
			$dates[$req_date['date']]['duree'] = 0;

			$dates[$req_date['date']]['duree'] += $req_date['travail_duree'];
			$dates[$req_date['date']]['duree_facture'] += $req_date['travail_duree_facture'];

			$metaDuree += $req_date['travail_duree'];
			$metaDureeFacture += $req_date['travail_duree_facture'];

			$travail= array();
			$travail['id'] = 			$req_date['travail_id'];
			$travail['comment'] = 		htmlentities(utf8_decode($req_date['travail_comment']));
			$travail['comment'] = preg_replace("/ticket#([0-9]+)/i","<a class='ticket' href='?page=ticket&num=$1' target='_detailTicket' >ticket #$1</a>",$travail['comment'] );
			$travail['duree'] = 		$req_date['travail_duree'];
			$travail['duree_facture'] = 		$req_date['travail_duree_facture'];

			$tc_key = $req_date['user_id']."_". $req_date['tache_id'];

			$dates[$req_date['date']]['travaux_container'][$tc_key]['travaux'][] = $travail;
			$travail_container = &$dates[$req_date['date']]['travaux_container'][$tc_key];
			$travail_container['sum_duree'] += floatval($req_date['travail_duree']);
			$travail_container['sum_duree_facture'] += floatval($req_date['travail_duree_facture']);

			if(!array_key_exists("user_nom",$travail_container)) {
				$travail_container['user_id'] =			$req_date['user_id'];
				$travail_container['user_nom'] =		$req_date['user_nom'];
				$travail_container['client_nom'] = 		$req_date['client_nom'];
				$travail_container['lot_nom'] = 		$req_date['lot_nom'];
				$travail_container['tache_nom'] = 		$req_date['tache_nom'];
				$travail_container['user_color'] = 		$req_date['user_couleur'];
				$travail_container['client_color'] = 	$req_date['client_couleur'];
				$travail_container['grav'] = 			md5( strtolower( trim( $req_date['user_email']) ) );
			}

		}
		// Bug inconnu de la first ligne vide donc... on supprime
			$keys = array_keys($dates);
			unset($dates[$keys[0]]);
			
			
		$json['metatab'] = $dates;


		/*
		 * Finish des stats
		*/

		global $req_stat;

		/**
		 *
		 * Statistiques du travail global par client
		 *
		 */
		function generate_stats_general(){

			global $sql_select_travaux,$sql_select_dateRange,$sql_select_dateRange2;
			global $req_stat;

			/*
			 * Génération du graphique
			*/

			$stats = array();
			$r = "
			SELECT tmp_date.date_travail,IFNULL(tmp_travail.duree_travail,0) as duree_travail,cl.nom,cl.couleur 
			FROM (
				SELECT curdate()-interval (@t:=@t+1) DAY AS date_travail 
					FROM wrk_travail  tr
					WHERE curdate()-interval @t DAY >= $sql_select_dateRange2
					ORDER BY date_travail   
				) AS tmp_date
			INNER JOIN (
				select distinct(lt.id_client ) as id_client
					FROM wrk_travail tr
					LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
					LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
					LEFT JOIN wrk_users u ON tr.id_user = u.id 
					WHERE $sql_select_travaux 
				) AS tmp_clients
			LEFT JOIN (
				select tr.date,lt.id_client,SUM(duree) AS duree_travail, count(*) AS nb_travails
					FROM wrk_travail tr
					LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
					LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
					LEFT JOIN wrk_users u ON tr.id_user = u.id 
					WHERE $sql_select_travaux
					GROUP BY tr.date,lt.id_client 
				) AS tmp_travail 
				ON tmp_date.date_travail = tmp_travail.date AND tmp_clients.id_client=tmp_travail.id_client
			LEFT JOIN wrk_clients cl ON cl.id = tmp_clients.id_client
			ORDER BY date_travail,  cl.id";
	
			//echo $r;
			$req_stat = $r;
			$statsdata = array();
// exit($r);
			$statsoptions = array();
			$statsoptions['vAxis_title'] = "heures";
			$statsoptions['hAxis_title'] = "dates";
			$statsoptions['title'] = "Répartition des travaux par client";
			$statsoptions['colors'] = array();

			bdd::exec("SET @t=0");
			$req_dates = bdd::getResults($r);

			$statsdata[0] = array();
			$statsdata[0][] = "Clients";
			$active_date = "";
			$i=0;
			foreach($req_dates as $req_date){
				if($active_date != $req_date['date_travail']){
					$i++;
					$active_date = $req_date['date_travail'];
					$statsdata[$i] = array();
					$statsdata[$i][] = $req_date['date_travail'];
				}

				if(!in_array($req_date['nom'], $statsdata[0])){
					$statsdata[0][] = $req_date['nom'];
					$statsoptions['colors'][] = ($req_date['couleur']=="") ? "#AAA" : $req_date['couleur'];
				}

				$statsdata[$i][] = floatval($req_date['duree_travail']);
			}

			$statsoptions['colors'] = json_encode($statsoptions['colors']);

			$stats['data'] = json_encode($statsdata);


			/*
			 * Génération du camenbert (dev, pas encore passé dans tablean Json)
			*/
			/*
			 $r="
			SELECT cl.nom,IFNULL(SUM(tmp_travail.duree_travail),0) as duree_travail,cl.couleur
			FROM (
			select tr.date AS date_travail
			FROM wrk_travail tr
			LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
			LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
			LEFT JOIN wrk_users u ON tr.id_user = u.id
			WHERE $sql_select_dateRange
			GROUP BY tr.date
			ORDER BY tr.date
			) AS tmp_date
			INNER JOIN (
			select distinct(lt.id_client ) as id_client
			FROM wrk_travail tr
			LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
			LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
			LEFT JOIN wrk_users u ON tr.id_user = u.id
			) AS tmp_clients
			LEFT JOIN (
			select tr.date,lt.id_client,SUM(duree) AS duree_travail, count(*) AS nb_travails
			FROM wrk_travail tr
			LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
			LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
			LEFT JOIN wrk_users u ON tr.id_user = u.id
			GROUP BY tr.date,lt.id_client
			) AS tmp_travail
			ON tmp_date.date_travail = tmp_travail.date AND tmp_clients.id_client=tmp_travail.id_client
			LEFT JOIN wrk_clients cl ON cl.id = tmp_clients.id_client
			GROUP BY tmp_clients.id_client
			ORDER BY duree_travail DESC
			";

			$statsdata_pie = array();
			$pie_colors = array();

			foreach(bdd::getResults($r) as $l){
			$statsdata_pie[] = array($l['nom'],$l['duree_travail']);
			$pie_colors[] = $l['couleur'];
			}


			$stats['pie_data'] = $statsdata_pie;
			$statsoptions['pie_columns'] = array(array('string','Client'),array('number','Heures travaillées'));
			$statsoptions['pie_color'] = json_encode($pie_colors);
			*/
			$stats['options'] = $statsoptions;

			return $stats;

		}
		// 		End Function generate_stats_general()

		/**
		 *
		 * Statistique d'un client par lot
		 *
		 */
		function generate_stats_client(){

			global $sql_select_travaux,$sql_select_dateRange,$sql_select_dateRange2;
			global $req_stat;


			/*
			 * Génération du graphique
			*/
			$stats = array();
			$r = "
			SELECT tmp_date.date_travail,tmp_lots.nom_lot as nom,IFNULL(tmp_travail.sum_travail,0) as duree_travail
			FROM (
				SELECT curdate()-interval (@t:=@t+1) DAY AS date_travail 
					FROM wrk_travail  tr
					WHERE curdate()-interval @t DAY >= $sql_select_dateRange2
					ORDER BY date_travail   
				) AS tmp_date
			INNER JOIN (
				select lt.id as id_lot, lt.nom as nom_lot
					FROM wrk_travail tr
					LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
					LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
					LEFT JOIN wrk_users u ON tr.id_user = u.id 
					WHERE  $sql_select_travaux
			) AS tmp_lots
			ON 1
			LEFT JOIN (
				select SUM(tr.duree) as sum_travail, lt.id as id_lot, tr.date as date_travail
					FROM wrk_travail tr
					LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
					LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
					LEFT JOIN wrk_users u ON tr.id_user = u.id 
					WHERE  $sql_select_travaux
					GROUP BY lt.id, tr.date 
			) as tmp_travail
			ON tmp_date.date_travail = tmp_travail.date_travail AND tmp_lots.id_lot=tmp_travail.id_lot
			
			GROUP BY tmp_date.date_travail, tmp_lots.id_lot
			ORDER BY tmp_date.date_travail,tmp_lots.id_lot";

			//echo $r;
			$req_stat = $r;

			$statsdata = array();

			$statsoptions = array();
			$statsoptions['vAxis_title'] = "heures";
			$statsoptions['hAxis_title'] = "dates";
			$statsoptions['title'] = "Répartition des travaux par lot";
			
			bdd::exec("SET @t=0");
			$req_dates = bdd::getResults($r);

			$statsdata[0] = array();
			$statsdata[0][] = "Lots";
			$active_date = "";
			$i=0;
			foreach($req_dates as $req_date){
				if($active_date != $req_date['date_travail']){
					$i++;
					$active_date = $req_date['date_travail'];
					$statsdata[$i] = array();
					$statsdata[$i][] = $req_date['date_travail'];
				}

				if(!in_array($req_date['nom'], $statsdata[0])){
					$statsdata[0][] = $req_date['nom'];
				}

				$statsdata[$i][] = floatval($req_date['duree_travail']);
			}

			$stats['options'] = $statsoptions;
			$stats['data'] = json_encode($statsdata);

			/*
			 * Génération du camenbert
			*/



			return $stats;
		}
		// 		End Function generate_stats_client()


		/**
		 *
		 * Statisitiques d'un lot par user
		 *
		 */
		function generate_stats_lot(){

			global $sql_select_travaux,$sql_select_dateRange,$sql_select_dateRange2;
			global $req_stat;

			$stats = array();
			$r = "
					SELECT tmp_date.date_travail, tmp_users.*,IFNULL(tmp_travail.sum_travail,0) as duree_travail
					FROM (
						SELECT curdate()-interval (@t:=@t+1) DAY AS date_travail 
						FROM wrk_travail  tr
						WHERE curdate()-interval @t DAY >= $sql_select_dateRange2
						ORDER BY date_travail   
					) AS tmp_date
					INNER JOIN (
						select DISTINCT(u.nom), u.couleur, u.id 
							FROM wrk_travail tr
							LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
							LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
							LEFT JOIN wrk_users u ON tr.id_user = u.id 
							WHERE $sql_select_travaux
					) as tmp_users
					LEFT JOIN (
						select SUM(tr.duree) as sum_travail, tr.date as date_travail, u.nom as user_nom, u.id as user_id
							FROM wrk_travail tr
							LEFT JOIN wrk_taches ta ON tr.id_tache = ta.id
							LEFT JOIN wrk_lots lt ON ta.id_lot = lt.id
							LEFT JOIN wrk_users u ON tr.id_user = u.id 
							WHERE $sql_select_travaux
							GROUP BY tr.date,u.id
					) as tmp_travail
					ON tmp_travail.date_travail = tmp_date.date_travail AND tmp_travail.user_id = tmp_users.id
					ORDER BY tmp_date.date_travail,tmp_users.id";

			$req_stat = $r;

			$statsdata = array();

			$statsoptions = array();
			$statsoptions['vAxis_title'] = "heures";
			$statsoptions['hAxis_title'] = "dates";
			$statsoptions['title'] = "Répartition par utilisateur";

			bdd::exec("SET @t=0");
			$req_dates = bdd::getResults($r);

			$statsdata[0] = array();
			$statsdata[0][] = "Lots";
			$active_date = "";
			$i=0;
			foreach($req_dates as $req_date){
				if($active_date != $req_date['date_travail']){
					$i++;
					$active_date = $req_date['date_travail'];
					$statsdata[$i] = array();
					$statsdata[$i][] = $req_date['date_travail'];
				}

				if(!in_array($req_date['nom'], $statsdata[0])){
					$statsdata[0][] = $req_date['nom'];
					$statsoptions['colors'][] = ($req_date['couleur']=="") ? "#AAA" : $req_date['couleur'];
				}

				$statsdata[$i][] = floatval($req_date['duree_travail']);
			}
			$statsoptions['colors'] = json_encode($statsoptions['colors']);
			$stats['options'] = $statsoptions;
			$stats['data'] = json_encode($statsdata);

			$stats["requete"]=$req_stat;
			return $stats;
		}
		// 		End Function generate_stats_lot()

		$json['stats'] = call_user_func($stats_user_function);
		// 			-> generate_stats_general() ou generate_stats_client()
		/*
		 * Meta data
		*/

		$metadata = array();
		$metadata['duree'] = $metaDuree;
		$metadata['duree_facture'] = $metaDureeFacture;
		$metadata['user_id'] = Identification::getId();
		$metadata['user_admin'] = Identification::aDroit("administration");

		$json['metadata'] = $metadata;

		// 		$json['sql'] = $sql;
		// 		$json['select'] = $sql_select_travaux;
		$json['filters'] = $str_select;

		// 		$json['req_stat'] = $req_stat;

		echo json_encode($json);
		// 		echo "<pre>".print_r($json,true)."</pre>";
		break;



	case 'getLots':
		$json = array();
		$json['request'] = $_REQUEST;
		$idUser = Identification::getId();

		$idClient = HTMLSPECIALCHARS($_REQUEST['idClient']);
		$sql_lots = bdd::getResults("SELECT lt.id FROM wrk_lots lt
										LEFT JOIN wrk_last_use lu ON lu.id_lot = lt.id AND lu.id_user='$idUser'
										WHERE lt.id_client='$idClient'  
										ORDER BY lu.date_use DESC");

		$idLotSelected = HTMLSPECIALCHARS($_REQUEST['idLotSelected']);
		if($idLotSelected=="none"){
			$idLotSelected = $sql_lots[0]['id'];
		}

		$sql_taches = bdd::getResults("SELECT ta.id FROM wrk_taches ta
										LEFT JOIN wrk_last_use lu ON lu.id_tache = ta.id AND lu.id_user='$idUser'
										WHERE ta.id_lot='$idLotSelected'
										ORDER BY lu.date_use DESC");

		$idTache = HTMLSPECIALCHARS($_REQUEST['idTache']);
		if($idTache=="none"){
			$idTache = $sql_taches[0]['id'];
		}

		$selectedLot = new Lot($idLotSelected);
		$selectedLot -> detailleLot();
		$taches = array();
		foreach($sql_taches as $reqTache){
			$tache =  new Tache($reqTache['id']);
			if($reqTache['id']==$idTache) $tache -> selected = "selected";
			$taches[] = $tache;
		}
		$selectedLot->taches = $taches;
		$json['selectedLot'] = $selectedLot;

		$lots = array();
		foreach($sql_lots as $reqLot){
			$lot =  new Lot($reqLot['id']);
			if($reqLot['id']==$idLotSelected) $lot -> selected = "selected";
			$lots[] = $lot;
		}
		$json['lots'] = $lots;


		echo json_encode($json);
		break;
	case 'live_getLots':
		$idUser = (isset($_REQUEST['idUser'])?$_REQUEST['idUser']:Identification::getId());
		$idClient = mysql_real_escape_string($_REQUEST['idClient']);
		$lots = bdd::getResults("SELECT tt.id as id,tt.nom as nom FROM wrk_lots tt LEFT JOIN wrk_last_use lu ON lu.id_user='$idUser' AND lu.id_lot=tt.id WHERE tt.id_client='$idClient' ORDER BY lu.date_use DESC");
		foreach($lots as $lot)
			echo "<option value='".$lot['id']."'>".$lot['nom']."</option>";
		break;
	case 'live_getTaches':
// 		$idUser = Identification::getId();
		$idUser = (isset($_REQUEST['idUser'])?$_REQUEST['idUser']:Identification::getId());
		$idLot = mysql_real_escape_string($_REQUEST['idLot']);
		$taches = bdd::getResults("SELECT tt.id as id,tt.nom as nom FROM wrk_taches tt LEFT JOIN wrk_last_use lu ON lu.id_user='$idUser' AND lu.id_tache=tt.id WHERE tt.id_lot='$idLot' ORDER BY lu.date_use DESC");
		foreach($taches as $tache)
			echo "<option value='".$tache['id']."'>".$tache['nom']."</option>";
		break;
	case 'live_getTt':
		$idUser = (isset($_REQUEST['idUser'])?$_REQUEST['idUser']:Identification::getId());
		$tts = bdd::getResults("SELECT tt.id as id,tt.nom as nom FROM wrk_type_taches tt LEFT JOIN wrk_last_use lu ON lu.id_user='$idUser' AND lu.id_type_tache=tt.id ORDER BY lu.date_use DESC");
		foreach($tts as $tt)
			echo "<option value='".$tt['id']."'>".$tt['nom']."</option>";
		break;
	case 'live_start':
		// $idTache , $user, $heure
		/**
		 * Params : $idTache, $heure
		 * 
		 */
		$tache = mysql_real_escape_string($_REQUEST['tache']);
		$heure = mysql_real_escape_string($_REQUEST['heure']);
		if(Live::start($tache, $heure))
			echo "Live commencée";
		else 
			echo "erreur";
		break;
	case 'live_update':
		/**
		 * 
		 * Param $text
		 */
		$text = str_replace('\'','££',$_REQUEST['text']);

		$pauses = $_REQUEST['pauses'];

		
		if(Live::follow($text, $pauses))
			echo "Updaté avec succès !";
		else
			echo "Erreur d'update";
		
		break;
	case 'live_stop':
		/**
		 * Params $user, $heure
		 * Optionnal Params $pause 'newTache'
		 */
		
		$date = mysql_real_escape_string($_REQUEST['date']);
		if(Live::stop($date))
			echo 'Arreté avec succès';
		else
			echo "Arret impossible";
		break;
	case 'live_get':
	
		echo Live::get();
		
		break;
	case 'live_getHTML':
		$a = print_r($_SESSION['live'],true);
		echo $a."<br><br>".date('r');
		break;
	case 'clearSess':
		$_SESSION = array();
		break;
	/* Action pour Gestion Ticket */
	case 'ajaxGetTplUserTickets':
		$_SESSION['last_user_id_ticket'] = $_REQUEST['idUser'];
		$_SESSION['idPrioriteFiltreTickets'] = $_REQUEST['idPrioriteFiltreTickets'];
		$_SESSION['idClientFiltreTickets'] = $_REQUEST['idClient'];
		$_SESSION['tabIdStatuts'] = ($_REQUEST['submitStatutAuto']) ? Ticket :: getInfosStatutAuto($_REQUEST['indexStatutAuto'], 'tab-lvls') : $_REQUEST['tabIdStatuts'];
		
		echo TicketModel::getTplUserTickets();
		break;
	case 'ticketsAjout_getClients':
		$_SESSION['last_user_id_ajout_ticket'] = $_REQUEST['idUser'];
		$clients = bdd::getResults("
			SELECT c.id, c.nom FROM wrk_clients c
				LEFT JOIN wrk_last_use AS lu 
					ON c.id = lu.id_client AND lu.id_user = $_REQUEST[idUser]
			WHERE actif = 1 
			ORDER BY lu.date_use DESC");
		foreach($clients as $client)
			echo "<option value='$client[id]'>".$client[nom]."</option>";
		break;
	case 'ajaxUpdateStatutTicket':
		$idUser = Identification :: getId();
		
		Ticket :: changeTicketStatut($_REQUEST['idTicket'], $_REQUEST['idStatut'], true);
		
		$_SESSION['last_user_id_ticket'] = (isset($_SESSION['last_user_id_ticket'])) ? $_SESSION['last_user_id_ticket'] : $idUser;
		
		echo TicketModel::getTplUserTickets();

		break;
	case 'ajaxStartTicket':
		$live = Live :: getInstance();
		$idUser = Identification :: getId();
		$tabInfosTicket = Ticket :: getTicketInfos($_REQUEST['idTicket']);
		
		// Cas où on lance un ticket d'une tache différente que celle en cours.
		if(($live != false && $tabInfosTicket['id_tache'] != $live -> idTache) && $_REQUEST['demarrerNouveauTravail']) {
// 			Sauvegarde du travail
			$now = date('Y-m-d H:i:s');
			$tabLiveTickets = $live -> tickets;	// Récupération des tickets avant la destruction du live par la méthode stop()
			if(Live :: stop($now)) {
				$idTravail = Travail :: $id_travail;
				if(Live :: start($tabInfosTicket['id_tache'], $now)) {
// 					Lie Ticket->Travail
					$retAssoc = Ticket :: associerLiveTicketsATravail($idTravail, $tabLiveTickets);
					// On récupère le nouveau Live
					$live = Live :: getInstance();
				}
			}
		}
		
		$idStatutEnCours = Ticket :: STATUT_TICKET_EN_COURS;
		if($live == false)
			$live = new Live($tabInfosTicket['id_tache'], date('Y-m-d H:i:s'));
		
		$live -> ticket_en_cours = $_REQUEST['idTicket'];
		
		// Si le ticket que l'on a choisit n'est pas déjà dans le tableau de tickets du live
		// on rajoute les différents textes du ticket au commentaire du Live.
		//if(!in_array($_REQUEST['idTicket'], $live -> tickets)) {
		if(!empty($live -> commentaire)) $live -> commentaire .= "\n";
		$commLive = "- Ticket#$_REQUEST[idTicket] -> Titre: ".$tabInfosTicket['titre']."\n";
		$commLive = str_replace('\'', '££', $commLive);
		$live -> commentaire .= $commLive;
		//}
		
		// Si le ticket en cours n'est pas nul, que la tâche en cours est la même que celle du ticket et 
		// que le live n'a pas déjà le ticket_en_cours dans son tableau de tickets, on le rajoute.
		if(!is_null($live -> ticket_en_cours) && $live -> idTache == $tabInfosTicket['id_tache'] && !in_array($live -> ticket_en_cours, $live -> tickets)) {
			$live -> tickets[] = $live -> ticket_en_cours;
		}
		
		Live :: saveNewLive($live);
		Ticket :: changeTicketStatut($_REQUEST['idTicket'], $idStatutEnCours);
// 		Ticket :: changeTicketAssignedUser($_REQUEST['idTicket'], Identification :: getId());
		
		// On mémorise le changement de statut
		$txtOuvertureLog = '<span class="lbl-champs-change">Ouverture</span> du ticket';
		Ticket :: saveNewTicketLog($_REQUEST['idTicket'], $idUser, $txtOuvertureLog);
		
		// On détermine si on est dans la notif ou bien sur le site.
		if($_REQUEST['typeTplEstNotif'] == 'true') {
			echo TicketModel :: getTplNotifTickets();
		} else {
			echo TicketModel :: getTplUserTickets();
		}
		
		break;
	case 'ajaxStopTicket':
		$live = Live :: getInstance();
		$idUser = Identification :: getId();
		$idTicket = $_REQUEST['idTicket'];
		$infosTicket = Ticket :: getTicketInfosCompletes($idTicket);
		$idStatutFerme = Ticket :: STATUT_TICKET_RESOLU;
		
		if($live != false) {
			
			if(isset($live -> ticket_en_cours) && $live -> ticket_en_cours == $idTicket) {
				unset($live -> ticket_en_cours);
				// On rajoute le ticket en cours à tous les tickets
				// seulement si il n'y est pas déjà.
				if(!in_array($idTicket, $live -> tickets)) {
					$live -> tickets[] = $idTicket;
				}
			}
			
			Ticket :: changeTicketStatut($idTicket, $idStatutFerme);
			
			// On mémorise le changement de statut
			$txtFermetureLog = '<span class="lbl-champs-change">Fermeture</span> du ticket';
			Ticket :: saveNewTicketLog($idTicket, $idUser, $txtFermetureLog);
			
			Live :: saveNewLive($live);

			// On détermine si on est dans la notif ou bien sur le site.
			if($_REQUEST['typeTplEstNotif'] == 'true') {
				echo TicketModel :: getTplNotifTickets();
			} else {
				echo TicketModel :: getTplUserTickets();
			}
		}
		break;
	case 'ajaxPauseTicket':
		$live = Live :: getInstance();
		$idUser = Identification :: getId();
		
		if($live != false) {
			if(isset($live -> ticket_en_cours) && $live -> ticket_en_cours == $_REQUEST['idTicket']) {
				unset($live -> ticket_en_cours);
				// On rajoute le ticket en cours à tous les tickets
				// seulement si il n'y est pas déjà.
				if(!in_array($_REQUEST['idTicket'], $live -> tickets)) {
					$live -> tickets[] = $_REQUEST['idTicket'];
				}
			}
			
// 			$idStatutPause = '??';
// 			Ticket :: changeTicketStatut($_REQUEST['idTicket'], $idStatutPause);
			Live :: saveNewLive($live);
			
			// On mémorise le changement de statut
			$txtPauseLog = '<span class="lbl-champs-change">Mise en pause</span> du ticket';
			$retPauseLog = Ticket :: saveNewTicketLog($_REQUEST['idTicket'], $idUser, $txtPauseLog);
			
			// On détermine si on est dans la notif ou bien sur le site.
			if($_REQUEST['typeTplEstNotif'] == 'true') {
				echo TicketModel :: getTplNotifTickets();
			} else {
				echo TicketModel :: getTplUserTickets();
			}
		}
		break;
	case 'updateBtnLive':
		echo LiveModel :: getLiveBtn();
		break;
	case 'updateStatutCheckboxWithAutoStatut':
		echo TicketModel :: getStatutsCheckbox(Ticket :: getInfosStatutAuto($_REQUEST['indexStatutAuto'], 'tab-lvls'));
		break;
	default:
		echo "action inconnue";
}










