<?php
 
include_once("includes/html/classes/Cpage_html.class.php");
class Cpage_html_sitemap extends Cpage_html {
	
	function Cpage_html_sitemap() {
		
		parent::Cpage_html();
		$this->ajoute_CSS("sitemap.css");
	}
	//
	function get_optim() {
		$this->nom_optim="page_html";
		$this->id_optim="";
		$this->params_optim="sitemap";
		$this->duree_optim="1 HOUR";
		$this->niv_optim=2;
		return true;
	}
	
	function estUrlAttendue() {
		return true;
	}
	function getUrlAttendue() {
		return $this->static_getUrl();
	}
	
	function getKeywords() {
		return "page des annuaires partenaires";
	}
	function getDescription() {
		return "";
	}
	function getTitre() {
		return $this->static_getTitre();
	}
	function getContenuPage() {
		$contenu=file_get_contents_boutique("html_fichiers/sitemap.contenu.htm");
		
		include_once("includes/html/arborescence.inc.php");
		$liste=get_arborescence_puces(0,"sitemap");
		$contenu=str_replace("#LISTE",$liste,$contenu);
		return $contenu;
	}
	//
	
	static function static_getTitre() {
		include_once("includes/commun/traductions.inc.php");
		global $titreSite;
		return $titreSite." - ".recupereTexte("html_plan_du_site") ;
	}
	static function static_getUrl() {
		global $code_langue;
		switch($code_langue) {
			case "fr":
				return "/plan-du-site.htm";
			break;
			case "en":
				return "/sitemap.htm";
			break;
		}
		
	}
}
?>