<?php
require_once("includes/general/optim_php.inc.php");
include_once("includes/commun/options_commun.inc.php");
// gestion de toutes les url !
/////////////////////////
// URL des articles
/////////////////////////
// fonctions � utiliser : 
// 
// get_lien_article_from_id($id);
// get_lien_article_from_ref($ref);
//get_lien_article_from_res($res_article);
//
require_once("includes/general/str_url.inc.php");

function get_chemin_from_lien($lien) {
	// reture le fichier
	$retour=explode("/",$lien);
	array_pop($retour);
	return implode("/",$retour)."/";
}
function get_lien_article_from_id($id) {
	return get_lien_article_from("id",$id);
}
function get_lien_article_from_ref($ref) {
	return get_lien_article_from("reference",$ref);
}
//
function get_lien_article_from($champ,$val) {
	global $id_boutique,$id_structure;
	// renvoie http://localhost/aubade/les-collections-de-l-hiver-2006/couchant/string-aubade-couchant1--couchant1.php
	if($res=testReq2("SELECT * FROM shop_articles WHERE $champ=$val AND id_structure=$id_structure")) {
		return get_lien_article_from_res($res);
	}
}
function get_lien_article_from_res($res_article,$fiche_complete=false) {
	require_once("includes/html/marques.inc.php");
	require_once("includes/html/types.inc.php");
	require_once("includes/commun/options_commun.inc.php");

	$chemin=get_chemin_article_from_res($res_article);
	if($chemin===false) {
		return "/";
	}
	$type=type_get_nom_from_id($res_article["id_type"]);
	if($fiche_complete) {
		$nom=($res_article["nom"]);
	} else {
		require_once("includes/commun/traductions.inc.php");
		$nom=trad_get_from_id($res_article["nom"]);
	}
	$ref=str_replace("&","_",$res_article["reference"]);
	if(get_option("GES_marques")) {
		$marque=marque_get_nom_from_id($res_article["id_marque"]);
		$base_url=str_replace_option(array("type","marque","nom","ref"),array($type,$marque,$nom,$ref),"REF_article_format_url");
		$chemin.=titreToLien($base_url)."--".refToLien($ref).".php";
	} else {
		$base_url=str_replace_option(array("type","marque","nom","ref"),array($type,"",$nom,$ref),"REF_article_format_url");
		$chemin.=titreToLien($base_url)."--".refToLien($ref).".php";
	}
	return $chemin;
}
function get_id_famille_article_visible($res_article) {
	//print("get_id_famille_article_visible ");
	//print_rr($res_article);
	// cherche l'article dans sa famille principale, 
	//puis si on ne la trouve pas, on va prendre la famille ou on le trouve en raccourci qui est en ligne
	global $id_structure;
	$id_elem=$res_article["id_elem"];
	if(!$res=testReq2("SELECT id FROM shop_struct_elems WHERE id_structure=$id_structure AND id=$id_elem AND actif_parentee=1")) {
		if($res=testReq2("SELECT s.id FROM shop_articles_virtuels AS v
							LEFT JOIN shop_struct_elems AS s ON s.id=v.id_elem AND s.id_structure=$id_structure 
							WHERE v.id_structure=$id_structure AND v.id_article_cible=".$res_article["id"]." AND s.actif=1 AND s.actif_parentee=1")) {
			// on a trouv� l'article dans sa famille principale
			$id_elem=$res["id"];

		} else {
			return false;
		}
	}
	return $id_elem;
}
function get_chemin_article_from_res($res_article) {
	
	if(($id_elem=get_id_famille_article_visible($res_article))===false) {
		return false;
	}
	return get_chemin_famille_from_id($id_elem);
}
// familles
function get_lien_famille_from_id($id_elem) {
	global $id_structure;
	if($res_famille=testReq2("SELECT * FROM shop_struct_elems WHERE id=$id_elem AND id_structure=$id_structure")) {
		return get_lien_famille_from_res($res_famille);
	}
	return "/";
}
function get_lien_famille_from_res($res_famille) {
	$retour=get_chemin_famille_from_res($res_famille);
	$retour.=titreToLien(remplace_chemin_famille_from_res($res_famille["nom"],$res_famille)).".php";
	return $retour;
}
function remplace_nom_famille_from_res(&$nom,$res_famille) {
	include_once("includes/html/categories.inc.php");
	$nom=cat_get_nom_from_res_struct_elem($res_famille);
	return $nom;
}
function remplace_chemin_famille_from_res(&$nom,$res_famille) {
	include_once("includes/html/categories.inc.php");
	$nom=cat_get_chemin_from_res_struct_elem($res_famille);
	return $nom;
}
function get_chemin_famille_from_id($id_elem) {
	$retour=get_optim_php_ML("get_chemin_famille_from_id",$id_elem);
	if($retour!==false) {
		return $retour;
	}
	global $id_structure;
	if($res_famille=testReq2("SELECT * FROM shop_struct_elems WHERE id=$id_elem AND id_structure=$id_structure")) {
		$retour=get_chemin_famille_from_res($res_famille);
	}
	set_optim_php_ML("get_chemin_famille_from_id",$id_elem,$retour);
	return $retour;
}
function get_chemin_famille_from_res($res_famille) {
	
	remplace_chemin_famille_from_res($res_famille["nom"],$res_famille);
	if($res_famille["id_parent"]!=0) {
		// on n'est pas en racine
		$retour=get_chemin_famille_from_id($res_famille["id_parent"]);
	} else {
		$retour=get_url_langue()."/";
		if(BOUTIQUE_REP_RACINE!="") {
			$retour.=BOUTIQUE_REP_RACINE."/";
		} 
	}
	
	$retour.=titreToLien($res_famille["nom"])."/";
	
		
	return $retour;
}


/**
 * calcule si oui ou non on doit rajouter /fr, /en en début d'URL
 * 
 * @return '/fr' , '/en' ou '' ...
 * 
 * @author raph
 * 
 * @version 1
 * 
 *
 */
function get_url_langue() {
	global $chemin_detaille,$langue_defaut;
	if(isset($chemin_detaille["langue"]["drapeau"])) {
		if(get_option("REF_rep_langue_obligatoire") || ($chemin_detaille["langue"]["drapeau"]!=$langue_defaut)) {
			return "/".$chemin_detaille["langue"]["drapeau"];
		} else {
			return "";
		}
	}else {
		if(get_option("REF_rep_langue_obligatoire")) {
			return "/".$langue_defaut;
		} else {
			return "";
		}
	}

}
function url_get_drapeaux() {
	global $id_boutique;
	return mysql_fetch_column(ifReq("SELECT * FROM shop_ml_langues WHERE id_boutique=$id_boutique AND active=1"),"drapeau");
}
function urlToML($url,$drapeau="") {
	global $chemin_detaille,$langue_defaut;
	// on repere si l'url contient deja un drapeau
//	echo "<br>_____  $url";
	$liste_drapeaux=url_get_drapeaux();
	$url=trim($url,"/");
	$split=explode("/",$url);
	$premier_rep=array_shift($split);
	$trouve=false;
	foreach($liste_drapeaux as $drapeau_tmp) {
		if($drapeau_tmp==$premier_rep) {
			$trouve=true;
			$url=implode("/",$split);
		}
	}
//	echo "-> $url";
	/*if($drapeau=="")
		$drapeau=$langue_defaut;*/

	//change_langue_tempo_drapeau($drapeau);
//	echo " - ".get_url_langue()." - ";
	$retour=get_url_langue()."/".$url;
	//retour_langue_tempo();
	
//	echo "<br>=====> $retour";
	return $retour;

}
function change_langue_tempo_drapeau($drapeau) {
	if($res=testReq2("SELECT * FROM shop_ml_langues WHERE drapeau='$drapeau'")){
		change_langue_tempo($res);
		return true;
	}
	return false;
}
function change_langue_tempo($res_langue) {
	global $chemin_detaille, $langue, $id_langue,$langue_modifiee_tempo,$code_langue;
	if(!$langue_modifiee_tempo) {
		// on sauve la langue init
		global $old_res_langue, $old_id_langue,$old_code_langue;
		$old_res_langue=$chemin_detaille["langue"];
		$old_id_langue=$id_langue;
		$old_code_langue=$code_langue;
	}
	$chemin_detaille["langue"]=$res_langue;
	$id_langue=$res_langue["id"];
	$code_langue=$res_langue["drapeau"];
	$langue_modifiee_tempo=true;
}
function retour_langue_tempo() {
	global $langue_modifiee_tempo;
	if($langue_modifiee_tempo) {
		global $old_res_langue, $old_id_langue, $old_code_langue,$chemin_detaille, $langue, $id_langue,$code_langue;
		$chemin_detaille["langue"]=$old_res_langue;
		$id_langue=$old_id_langue;
		$code_langue=$old_code_langue;
		$langue_modifiee_tempo=false;
	}
}
function get_liens_langues_page_en_cours($classe_page) {
	global $page_en_cours,$langue_defaut;
// renvoie les liens vers les autres lanques de la m�me page
	global $id_boutique,$chemin_detaille;
	$retour="<br>";
	if($query=ifReq("SELECT * FROM shop_ml_langues WHERE id_boutique=$id_boutique AND active=1")) {
		if(mysql_num_rows($query)>1) {
			while($res=mysql_fetch_array($query)) {
				// change la langue en cours
				change_langue_tempo($res);
				$retour.=" <a href=\"".lien_absolu($classe_page->getUrlAttendue())."\" target=\"_top\">".$classe_page->getTitre()."</a>";
			}
			//remet la langue
			retour_langue_tempo();
		}
	} 
return $retour;
}

function lien_absolu($lien) {
	if(strpos($lien,HTTP)===0) {
		return $lien.(MODE_LOFI===true?"?lofi":"");	
	}
	return HTTP.$lien.(MODE_LOFI===true?"?lofi":"");	

}
?>