<?php
CLog::__install();

bdd_cree_table("lis__listes","CREATE TABLE `lis__listes` (
`id_auto` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`identifiant` VARCHAR( 255 ) NOT NULL ,
`table` VARCHAR( 255 ) NOT NULL ,
`table_lien` VARCHAR( 255 ) NOT NULL ,
`champ_lien` VARCHAR( 255 ) NOT NULL ,
`champ_lien_associe` VARCHAR( 255 ) NOT NULL ,
`titre` VARCHAR( 255 ) CHARACTER SET utf8 NOT NULL ,
`commentaire` VARCHAR( 255 ) CHARACTER SET utf8 NOT NULL ,
`titre_element` VARCHAR( 255 ) CHARACTER SET utf8 NOT NULL ,
UNIQUE (
`identifiant`
)
) ENGINE = MYISAM ");

CListes::add_liste2("listes","lis__listes","description des listes","cette table permet de définir les infos des listes","Liste","FSE.listes");
CListes::add_champ_liste('listes','fn_insert', 'VARCHAR(255)','fonction_insert', 'fonction_insert', 'fonction lors de insert(module.classe.fonction)');
CListes::add_champ_liste('listes','fn_update', 'VARCHAR(255)','fonction_update', 'fonction_update', 'fonction lors de update(module.classe.fonction)');
CListes::add_champ_liste('listes','fn_delete', 'VARCHAR(255)','fonction_delete', 'fonction_delete', 'fonction lors de delete(module.classe.fonction)');
CListes::add_champ_liste('listes','administrable', 'TINYINT','administrable', 'administrable', 'si la liste est administrable (fsadmin)');
CListes::add_champ_liste('listes','titre_elem_admin', 'VARCHAR(255)','titre_elem_admin', 'titre_elem_admin', 'titre a base de #VARIABLES# pour le fsadmin');
CListes::add_champ_liste('listes','class_affichage_admin', 'VARCHAR(255)','class_affichage_admin', 'class_affichage_admin', 'classe du type daffichage utilise dans ladmin client');
CListes::add_champ_liste('listes','use_auto_actif', 'BOOL','use_auto_actif', 'use_auto_actif', 'si la liste integre le champ elem_actif par defaut');
CListes::add_champ_liste('listes','use_auto_pos', 'BOOL','use_auto_pos', 'use_auto_pos', 'si la liste integre le champ elem_pos par defaut');
CListes::set_valeurs_defaut('listes', array('titre_elem_admin'=>'#TITRE#'));


bdd_cree_table("lis__descriptions_champs","CREATE TABLE `lis__descriptions_champs` (
`id_auto` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`identifiant_liste` VARCHAR( 255 ) NOT NULL ,
`nom_colonne` VARCHAR( 255 ) NOT NULL ,
`position` SMALLINT DEFAULT 0 NOT NULL ,
`intitule_colonne` VARCHAR( 255 )  CHARACTER SET utf8 NOT NULL ,
`libelle` VARCHAR( 255 )  CHARACTER SET utf8 NOT NULL ,
`description` VARCHAR( 255 )  CHARACTER SET utf8 NOT NULL ,
`regexp_validation` VARCHAR( 255 ) NOT NULL ,
UNIQUE colonne (`identifiant_liste`,`nom_colonne`)
) ENGINE = MYISAM ");

CListes::add_liste2("description_champs","lis__descriptions_champs","description des champs des listes","cette table permet de définir les infos des champs","Champ","FSE.listes");



bdd_cree_table("lis__evenements_liste","CREATE TABLE IF NOT EXISTS `lis__evenements_liste` (
  `id_auto` int(11) NOT NULL AUTO_INCREMENT,
  `identifiant_evenement` varchar(255) DEFAULT NULL,
  `identifiant_liste` varchar(255) NOT NULL,
  `nom_evenement` varchar(255) NOT NULL,
  `fonction` varchar(255) DEFAULT NULL,
  `fonction_php` text CHARACTER SET utf8,
  PRIMARY KEY (`id_auto`),
  KEY `identifiant_liste` (`identifiant_liste`),
  KEY `nom_evenement` (`nom_evenement`),
  KEY `identifiant_evenement` (`identifiant_evenement`)
) ENGINE=MyISAM   ");

bdd_cree_table("lis__evenements_types","CREATE TABLE `lis__evenements_types` (
`id_auto` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`nom_evenement` VARCHAR( 255 ) ,
`parametres_fonction` VARCHAR( 1000 ) NOT NULL ,
`description` TEXT DEFAULT NULL,
UNIQUE `nom_evenement` (`nom_evenement`)
) ENGINE = MYISAM ");

//include_once 'modules/listes/classes/CEvenement_liste.class.php';//auto
CEvenement_liste::ajoute_type_evenement("ajout.valeurs_defaut","\$valeurs_defaut",
	"Définition ou modification des valeurs par défaut
	@param \$valeurs_defaut : valeurs par défaut à modifier
	@returns \$valeurs_defaut modifié");


CEvenement_liste::ajoute_type_evenement("ajout.envoi_mail","\$valeurs_inserees",
	"envoi des valeurs inserees par mail
	@param \$valeurs_inserees : valeurs inserees (valeurs du REQUEST)");
CEvenement_liste::ajoute_type_evenement("modif.envoi_mail","\$valeurs_inserees",
	"envoi des valeurs inserees par mail
	@param \$valeurs_inserees : valeurs inserees (valeurs du REQUEST)");

CEvenement_liste::ajoute_type_evenement("ajout.traitement_formulaire","",
	"effectue un traitement sur le formulaire en cours.
	la fonction genere du javascript sur le formulaire.
	dans ce javascript on appelera une autre fonction dans le request qui fournira le retour.");




//echo "!!!".CEvenement_liste::evenement_exists("utilisateurs","ajout_set_valeurs_defaut")."!!!";
//print_rr(CEvenement_liste::get_evenements("utilisateurs","ajout_set_valeurs_defaut"));
//print_rr(CEvenement_liste::execute_evenements("utilisateurs","ajout_set_valeurs_defaut",array("coucou",1,2,3),3));
//print_rr(CEvenement_liste::execute_evenement("utilisateurs","ajout_set_valeurs_defaut",array("789")));

include_once 'modules/site/fonctions_config.inc.php';
//cree_config("MAIL_QD_MODIF_LISTE", 'bool', '', 'si on envoie un mail lors de la modification dune liste');
cree_config("ADR_MAIL_QD_MODIF", 'string', '', 'adresse mail a utiliser lors dune modif');

CListes::add_liste2("description_uploads","lis__desc_uploads","description des uploads des listes","cette table permet de définir de quelle manière les fichiers uploladés seront stockées sur le serveur, et présentées aux internautes ...","description upload","FSE.listes");
CListes::set_champ_liste_etranger("description_uploads","id_liste","lis__listes","identifiant","#IDENTIFIANT#");
CListes::add_champ_liste("description_uploads","nom_colonne","VARCHAR(50)","colonne","nom colonne","nom de la colonne dans la table","(.*)");
CListes::add_cle_unique("description_uploads","colonne","id_liste,nom_colonne");

CListes::add_champ_liste("description_uploads","url_colonne_path","VARCHAR(255)","chemin url","colonne chemin url","colonne de la table servant à générer l'url publique de l'image ","(.*)");
CListes::add_champ_liste("description_uploads","serv_colonne_path","VARCHAR(255)","chemin serveur","colonne chemin serveur","colonne de la table servant à générer l'url sur le serveur de l'image ","(.*)");
CListes::add_champ_liste("description_uploads","serv_longueur_path","TINYINT(4)","longueur serveur","longueur chemin serveur","longueur du chemin (avant découpe) sur le serveur","([0-9]+)");
CListes::add_champ_liste("description_uploads","nom_fichier","VARCHAR(255)","nom fichier","nom du fichier","chaine permettant de déterminer le nom du fichier lors de l'upload (#IDENTIFIANT# #_ID_AUTO# => 'eternal twilght 2015.jpg')","(.*)");
CListes::add_champ_liste("description_uploads","accept","VARCHAR(255)","accept","fichiers acceptés","expressino régulière des fichiers acceptés ('(gif|jpg)' ou '(.*)' etc...","(.*)");
CListes::add_champ_liste("description_uploads","poids","SMALLINT(4)","poids maxi","poids maxi (Ko)","poids maximum du fichier (en Ko). 0 = pas de limite sinon celle du serveur","([0-9]*)");
CListes::add_champ_liste("description_uploads","incremente","TINYINT(1)","incremente","incremente","incremente le nom du fichier si l'image existe déjà","(0|1)",NULL,NULL,"checkbox",NULL,"checkbox");
CListes::add_champ_liste("description_uploads","largeur","SMALLINT(4)","largeur","largeur","largeur (uniquement pour les images)","([0-9]*)");
CListes::add_champ_liste("description_uploads","hauteur","SMALLINT(4)","hauteur","hauteur","hauteur (uniquement pour les images)","([0-9]*)");
CListes::add_champ_liste("description_uploads","redim","ENUM('NO','MAX','CROPMAX','EXACT','CROPMAXHORIZONTAL','CROPMAXVERTICAL','PIXELSMAX')","redim","type de redimensionnement","type de redimensionnement de l'image principale, stockée sur le serveur (uniquement pour les images)","(.*)");
CListes::add_champ_liste("description_uploads","secure","TINYINT(1)","secure","fichier sécurisé","un fichier sécurisé ne pourra pas être atteint par une url publique","0|1");
CListes::dropListe("description_images");

//bdd_change_colonne("lis__desc_imgs","largeur","SMALLINT(4)");
//bdd_change_colonne("lis__desc_imgs","hauteur","SMALLINT(4)");
CListes::set_valeurs_defaut("description_uploads",array("incremente"=>1,"accept"=>CListes::$TYPE_TOUS,"poids"=>"0","largeur"=>"1024","hauteur"=>"768","redim"=>"MAX","nom_colonne"=>"champ","serv_colonne_path"=>"id_auto","url_colonne_path"=>"#ID_AUTO#","nom_fichier"=>"#IDENTIFIANT#"));

//CListes::insere("description_images",array("liste"=>"","colonne"=>"","largeur"=>"1280","hauteur"=>"1024"),"liste='' AND colonne=''");

// description des clés étrangères multiples
CListes::add_liste2("tables_etrangeres","lis__desc_tables_etrangeres","clés étrangères multiples, par table intermédiaire","Cette liste permet de créer les relations entre 2 listes, par l'intermédiaire d'une table à multiples clés étrangères","table étrangere","FSE.listes");
// la liste pour laquelle on décrit la clé étrangère


CListes::set_champ_liste_etranger("tables_etrangeres","id_liste","lis__listes","identifiant","#IDENTIFIANT#");
// la liste qui sert de lien avec une autre table
CListes::add_champ_liste_etranger("tables_etrangeres","liste_etrangere","lis__listes","identifiant","#IDENTIFIANT#");
CListes::add_champ_liste("tables_etrangeres","position","SMALLINT(4)","position","position","permet de définir l'ordre des étapes","([0-9]*)");
CListes::add_champ_liste("tables_etrangeres","affichage_element","ENUM('','direct','liste')","affichage_element","affichage_element","permet de définir l'affichage de l'elem dans le form complexe des etapes","(.*)");

CListes::add_champ_liste("tables_etrangeres","table_lien","VARCHAR(255)","table_lien","table_lien","la table etrangere associee","(.*)");
CListes::add_champ_liste("tables_etrangeres","champ_lien","VARCHAR(255)","champ_lien","champ_lien","le champ de la table associe a la table etrangere","(.*)");
CListes::add_champ_liste("tables_etrangeres","champ_lien_associe","VARCHAR(255)","champ_lien_associe","champ_lien_associe","le champ de la table etrangere relie au champ de la table","(.*)");
CListes::add_champ_liste("tables_etrangeres","titre_associe","VARCHAR(255)","titre_associe","titre_associe","affichage a base de #variables# pour afficher la valeur de lelem etranger","(.*)");
CListes::add_champ_liste("tables_etrangeres","where_associe","VARCHAR(255)","where_associe","where_associe","where supplementaire lors de la jointure de la table et la table etrangere","(.*)");
CListes::add_champ_liste("tables_etrangeres","donnees_fixes_table_etr","VARCHAR(255)","donnees_fixes_table_etr","donnees_fixes_table_etr","donnees json pr l'insertion dans la table liaison","(.*)");

CListes::add_liste2('images_defaut',"lis__images_defaut","liste des images par defaut qd une image demandée nexiste pas",'', 'image',"FSE.listes",'images_defaut/');
CListes::add_champ_liste('images_defaut', 'identifiant', 'VARCHAR(255)','identifiant','identifiant', 'identifiant de la liste qui possede des images');
CListes::add_champ_liste('images_defaut', 'image', 'VARCHAR(255)','image','image', 'url image',NULL, NULL, NULL,"image",NULL,"image|CROPMAX|50|50");
CListes::add_description_image('images_defaut', 'image',300,300,'MAX', 'identifiant','#IDENTIFIANT#','identifiant',0);

//CListes::dropListe("lis_type_affichage");
CListes::add_liste2("lis_type_affichage","lis__type_affichage","types d'affichages des listes","types d'affichages des différentes listes","type affichage","FSE.listes");
CListes::add_champ_liste2("lis_type_affichage","identifiant","VARCHAR(50)");
//CListes::drop_champ_liste("lis_type_affichage","dossier","VARCHAR(500)");
CListes::add_champ_liste2("lis_type_affichage","fichier","VARCHAR(500)");
CListes::add_champ_liste2("lis_type_affichage","classe","VARCHAR(50)");
CListes::add_champ_liste2("lis_type_affichage","parametres","VARCHAR(500)");
CListes::add_champ_liste("lis_type_affichage","type_site","ENUM('standard','mobile') DEFAULT 'standard'","type_site","Type de site","Type de site (mobile ou standard)","(.*)",2,"NOT NULL");
CListes::add_cle_unique("lis_type_affichage","idx_identifiant", "identifiant, type_site");


CListes::add_liste2("lis_filtre_simple","lis__filtre_simple","description des filtres simples des listes","cette table permet de définir des filtres appliquables sur les listes","filtre simple","FSE.listes");
CListes::add_champ_liste("lis_filtre_simple","id_liste","VARCHAR(255)",'id_liste', 'id_liste', 'nom de la liste possédant le filtre');
CListes::add_champ_liste("lis_filtre_simple","id_filtre","VARCHAR(255)",'id_filtre', 'id_filtre', 'nom fu filtre');
CListes::add_champ_liste("lis_filtre_simple","where","TEXT",'where', 'where', 'une condition where avec un #VAL# ou pas, qui applique le filtre à la requète de SELECT');
CListes::add_champ_liste("lis_filtre_simple","titre","VARCHAR(255)",'titre', 'titre', 'un titre supplémentaire, décrivant leffet du filtre, avec des #VAR# venant du select_titre');
CListes::add_champ_liste("lis_filtre_simple","select_titre","TEXT",'select_titre', 'select_titre', 'le SELECT pour récupérer les #VAR# utilisées dans le titre');
CListes::add_champ_liste("lis_filtre_simple","select_distinct","TEXT",'select_distinct', 'select_distinct', 'le SELECT permettant de récupérer toutes les valeurs possibles du filtre');
CListes::add_champ_liste("lis_filtre_simple","use_variable","BOOL",'use_variable', 'use_variable', 'si le filtre possede une valeur variable a repérer ou non');


?>