<?php
require_once("modules/Cmodule.class.php");
class Cmodule_mobile extends Cmodule {
	var $nom = "module mobile";
	var $identifiant = "mobile" ;
	var $modules_dependants=array("base");
	private static $sousDomaine = 'm';
	private static $pathFichiersMobiles = 'm';
	
	public static $url_page_mobile = "";
	public static $url_page_normal = "";

	protected function __init() {
		$typeNav = self::get_type_navigateur();
		// repérage version mobile et domaine
		preg_match("/^(".self::$sousDomaine."[.])?(.+)/",$_SERVER["HTTP_HOST"],$result);
		$domaine = $result[2];

		if (CSite::get_type_site() != $typeNav) {
			// si le type ne correspond pas
			$memeSiteReferer = preg_match("/$domaine/",$_SERVER["HTTP_REFERER"]);
			//	echo "<br>meme site : $memeSiteReferer<br>";
			//	echo "<br>domaine : $domaine<br>";
			if(!$memeSiteReferer) {
				// et qu'on vient d'un site externe
				// $result
				//	[0] => m.localhost
				//	[1] => m.
				//	[2] => localhost
				if(strlen($result[1])) {
					//	echo "<br>redirige normal";
					$redirectURL = "http://$domaine".$_SERVER["REQUEST_URI"];
				} else {
					//	echo "redirige mobile";
					$redirectURL = "http://".self::$sousDomaine.".$domaine".$_SERVER["REQUEST_URI"];
				}
				CSite::redirige($redirectURL,true);
			}
		}
		// variables à réutiliser pour swich de version (intégrer dans le pied de page ?)
		self::$url_page_mobile = "http://".self::$sousDomaine.".$domaine".$_SERVER["REQUEST_URI"]; // http://m.locahlost/....
		self::$url_page_normal = "http://$domaine".$_SERVER["REQUEST_URI"]; // http://m.locahlost/....

		// TODO : virer !
//		echo "<br><a href='".self::$url_page_mobile."'>version mobile</a>";
//		echo "<br><a href='".self::$url_page_normal."'>version normale</a>";
	}
	
	public static function getUrlPageMobile() { return self::$url_page_mobile; }
	public static function getUrlPageStandard() { return self::$url_page_normal; }

	public static function get_type_navigateur() {
		if (preg_match("/(android|ip(hone|ad|od))/i", $_SERVER['HTTP_USER_AGENT']))
		return 'mobile';
		else return 'standard';
	}
	//GET type_navigateur (USER_AGENT)



	/**
	 * Permet d'utiliser les pages sur ma version mobile.
	 *
	 * NECESSITE :
	 * 	"mobile/modeles/NOMCLIENT_mobile.modele.htm"
	 *  "mobile/modeles/html_NOMCLIENT.rootmodele.htm"
	 *  "css/NOMCLIENT_mobile.css"
	 *
	 * @param string $nomClient
	 */
	public static function installePagesMobilesPourClient($nomClient)
	{
		$nomClient = strtoupper($nomClient);
		site_definit_modele_page($nomClient."_mobile",$nomClient,"mobile/modeles/".$nomClient."_mobile.modele.htm","$nomClient/$nomClient_mobile.css",10,"mobile/modeles/html_$nomClient.rootmodele.htm");
		site_definit_page("accueil_mobile","/",$nomClient,NULL, $nomClient."_mobile","site.CSite.pages_html_basic",'mobile',NULL,NULL,NULL,0);
	}
	public static function getIdSiteMobile()
	{
		if($res = testReq3("SELECT id_auto FROM site__sites WHERE detection = '^".self :: $sousDomaine.".'"))
		{
			return $res['id_auto'];
		}
		else
		{
			trace_erreur('CModule_mobile :: getIdSiteMobile  [Sous domaine pour mobile introuvable!]');
		}
	}
	public static function definitSousDomaine($sousDom)
	{
		self :: $sousDomaine = $sousDom;
	}
	public static function definitCheminFichiersMobile($path)
	{
		self :: $pathFichiersMobiles = $path;
	}
	public static function installSiteSousDomaine()
	{
		CListes::insere_update("site_sites",array("detection"=>"^".self :: $sousDomaine.".","priorite"=>10,"titre"=>"Site Mobile Par Defaut","defaut"=>1,"actif"=>1,"identifiant"=>"page_mobile","type_site" => "mobile"),"identifiant='page_mobile'");
	}

	public static function getPathMobile()
	{
		if(CSite::$site_en_cours['type_site'] == 'mobile')
		return self :: $pathFichiersMobiles.'/';
			
		return '';
	}
}
?>