<?php
require_once("modules/Cmodule.class.php");
class Cmodule_super_admin extends Cmodule implements Imodule{
	var $nom = "module super admin";
	var $identifiant = "super_admin" ;
	var $modules_dependants=array("site","base");
	
	function __installe_pages() {
		include_once 'modules/site/fonctions_site.inc.php';
		site_definit_droit_page("super","","/super_admin/identification.php");
		site_definit_page("super.accueil","/super_admin(/(accueil.php)?)?","super_admin",NULL,"basic_admin","*.file_get_contents","superadmin/maintenance.htm","super","/super_admin/identification.php");
		site_definit_page("super.identification","/super_admin/identification.php","super_admin","superadmin/identification.htm","basic_admin");
		site_definit_page("super.import","/super_admin/importation_bdd.php","super_admin","superadmin/importation_bdd.php","basic_admin",NULL,NULL,"super");
		site_definit_page("super.listes","/super_admin/listes.php","super_admin",NULL,"basic_admin","super_admin.CSuperadmin.gestion_liste",NULL,"super");
		site_definit_page("super.edit_listes","/super_admin/edit_liste.php","super_admin",NULL,"basic_admin","super_admin.CSuperadmin.edit_liste",NULL,"super");
		CListes::update("site_pages",array("titre"=>"administration de listes"),"masque='/super_admin/listes.php'");
		CListes::update("site_pages",array("titre"=>"modification de listes"),"masque='/super_admin/edit_liste.php'");
		CListes::update("site_pages",array("titre"=>"identification"),"masque='/super_admin/identification.php'");
		site_definit_page("super.wiki","/super_admin/wiki.php","super_admin","wiki/wiki.html","basic_admin",NULL,NULL,"super");
		site_definit_page("super.backup","(.*)/backup.php","super_admin","../../base/www/html_fichiers/cbackup.super_admin.tpl.html","basic_admin");
		
	}
	
	function __get_JS_files() {
		CSite::ajouteJS('super_admin/noconflit.js',14);
		return array();
//		return array("super_admin/tiny_mce/jquery.tinymce.js");
//		return array('super_admin/tiny_mce/tiny_mce.js',"super_admin/tiny_mce/jquery.tinymce.js");
	}
	
	
	function liste_menus_lateral(){
		$retour = '';
		if(usr_a_droit_generique("cBackup.utilisation") || usr_est_super_admin()){
			$retour.=CSite::lien_menu_lateral("backup.php", "<img src='/images/listes/icones/actions/save.png' height='28' width='28' />Sauvegarde");
		}
	
		if(usr_est_super_admin()) {
			$retour.=CSite::separateur_menu_lateral("");
			$retour.=CSite::lien_menu_lateral("/super_admin/accueil.php","Super admin");
			
			//$retour.=CSite::lien_menu_lateral("/super_admin/importation_bdd.php","Importation BDD");
			$retour.=CSite::separateur_menu_lateral("");
			if(Cmodule::module_existe("listes"))
				$retour.=CSite::lien_menu_lateral("/super_admin/listes.php","Gestion des listes");
			$retour.=CSite::lien_menu_lateral("/super_admin/wiki.php","Wiki");

		}
		return $retour;
	}
	function switch_action($action,$module) {
		switch($action) {
			case "installe_pages":
				Cmodule::dispatch_fonction("__installe_pages");
				break;
			case "maj_bdd":
				if(usr_est_super_admin()) {
					Cmodule::dispatch_fonction("__install");
					CMessages::ajoute_message("ok, mise a jour efectuée");
					return true;
				}
				CMessages::ajoute_message("Vous n'avez pas les droits requis");
				return false;
				break;
			case "export_bdd_xml":
				if(usr_est_super_admin()) {
					//include_once 'modules/listes/classes/CListesXMLExport.class.php';//auto
					$exporteur=new CListesXMLExport();
					$exporteur->exporte();
				}
				break;
		}
	}
	


}
?>