<?php
class CMultilingueMaintenance {


	public static function setChampMultilingue($table,$champ) {
		CListes::insere("ml_champ",array("nom_table"=>$table,"champ"=>$champ),"nom_table,champ");
		$langues = CMultilingue::getListeLangues();
		foreach($langues as $langue) {
			self::dupliqueChampTable($table,$champ,$langue);
		}
	}
	public static function setChampMultilingueListe($identifiant_liste,$champ) {
		if($liste = CListes::get_liste($identifiant_liste)) {
			self::setChampMultilingue($liste["table"],$champ);
		}
	}

	public static function ajouteLangue($identifiant_langue,$nom) {
		$identifiant_langue = strtolower($identifiant_langue);
		CListes::insere("ml_langue",array("identifiant"=>$identifiant_langue,"nom"=>$nom),"identifiant");
		// parcourir ts les champs ML des tabmes ML
		//self::recreeTablesVuesLangue($identifiant_langue);
	}


	public static function recreeTablesVues() {
		$langues = CMultilingue::getListeLangues();
		foreach($langues as $langue) {
			self::recreeTablesVuesLangue($langue);
		}
	}
	public static function recreeTablesVuesLangue($identifiant_langue) {
		$tablesML = CMultilingue::getListeTablesML();
		foreach($tablesML as $table) {
			self::dropTableVue($table,$identifiant_langue);
			self::ajouteTableVue($table,$identifiant_langue);
		}
	}
	public static function recreeTablesVuesTable($table) {
		$langues = CMultilingue::getListeLangues();
			
		foreach($langues as $identifiant_langue) {
			self::dropTableVue($table,$identifiant_langue);
			self::ajouteTableVue($table,$identifiant_langue);
		}
	}

	public static function dropLangue($identifiant) {
		echo "TODO : dropLangue";
	}

	public function dupliqueChampTable($table,$champ,$langue) {
		if($langue == CMultilingue::$langue_defaut) return;
		$langue = strtolower($langue);
		$champ_ML = $champ.'_'.$langue;
		if(!testReq3("SHOW FULL COLUMNS FROM `$table` WHERE Field='$champ_ML'")) {
			if($res=testReq3("SHOW FULL COLUMNS FROM `$table` WHERE Field='$champ'",false)) {
				$type=$res["Type"];
				$null=($res["Null"]=="NO"?'NOT NULL':'');
				$default=($res["Default"]=="NULL"?'DEFAULT NULL':"DEFAULT '$res[Default]'");
				$requete="ALTER TABLE $table ADD `$champ_ML` $type $null $default AFTER `$champ`";
				Crapport::begin_bloc("Ajoute colonne multilingue $table.$champ : $langue");
				echo "<br>$requete";
				if(ifReq($requete)) {
					Crapport::trace("ok",1,"vert");
					if(ifReq("UPDATE $table SET `$champ_ML` = CONCAT('-$langue- ',`$champ`)")) {
						Crapport::trace("valeurs défaut insérées",1,"vert");
					} else {
					Crapport::trace("erreur insertion valeurs : ".mysql_error(),1,"erreur");
						
					}
					//					echo $requete."<br>";
				} else {
					Crapport::trace("erreur : ".mysql_error(),1,"erreur");
				}
				Crapport::end_bloc();
			} else {
				echo "<br>".mysql_error();
			}
		} else {
			// existe deja
		}
	}

	public static function dropTableVue($table,$langue) {
		$table_ML = 'view__'.$table.'_'.$langue;
		$retour = false;
		// non, car peut planter, si la vue est cassée
//		if(mysql_query("DESC `$table_ML`" )) {
			Crapport::begin_bloc("Suppression de la vue $table_ML",1,"important");
			if(ifReq("DROP VIEW IF EXISTS `$table_ML` ")) {
				$table_existe=false;
				Crapport::trace("ok",1,"vert");
				$retour = true;
			} else {
				Crapport::trace("erreur : ".mysql_error(),1,"erreur");
			}
			Crapport::end_bloc();
//		} else {
//				Crapport::trace("erreur : ".mysql_error(),1,"erreur");
//		}
		return $retour;
	}
	public static function ajouteTableVue($table,$langue) {
//		echo "<br>------------------$table,$langue--------------<br>";
		$langue = strtolower($langue);
		$table_ML = 'view__'.$table.'_'.$langue;

		$liste_langues = CMultilingue::getListeLangues();
		$liste_champs_ML = CMultilingue::getListeChampsML($table);
		$liste_evite = array();
		foreach($liste_champs_ML as $champ) {
			foreach($liste_langues as $une_langue) {
				$liste_evite[]=$champ."_".$une_langue;
			}
		}
		if(mysql_query("DESC `$table_ML`" )) {
			$table_existe = true;
			//			if(isset($_REQUEST["maj_langues"])) {
			//			if(self::dropTableVue($table,$langue)) {
			//				$table_existe = false;
			//			}
			//}
		}

		if(!$table_existe) {
			$liste_champs = mysql_fetch_column(ifReq("DESC `$table`"),"Field");
			$liste_champs_finale = array();
			foreach($liste_champs as $champ) {
				if(!in_array($champ,$liste_evite)){
					if($langue != CMultilingue::$langue_defaut && in_array($champ,$liste_champs_ML))
					$liste_champs_finale[]=$champ."_$langue AS `$champ`";
					else
					$liste_champs_finale[]='`'.$champ.'`';
				}
			}
			Crapport::begin_bloc("Création de la vue $table_ML");
			$requete = "CREATE VIEW `$table_ML` AS SELECT ".implode(",",$liste_champs_finale)." FROM `$table`";
//			echo $requete;
			if(ifReq($requete)) {
				Crapport::trace($requete);
				Crapport::trace("ok",1,"vert");
			} else {
				Crapport::trace("erreur : ".mysql_error(),1,"erreur");
			}
			Crapport::end_bloc();
		}
	}

}

?>