<?php


class ControllerClients extends Controller{
	
	public function __construct($request, $action){
		parent::__construct($request,$action);
	}
	
	public function executeIndex($request){
		
		if($request->getGetParameters('recherche') != ''){
			$recherche = $request->getGetParameters('recherche');
			
			$q = new QueryBuilder('clients');
			
			
			$q->select('C.*, (to_days(H.date_valid)-to_days(curdate())) as jours_restants')
			->from('clients C')
				->join('LEFT JOIN hebergements H ON H.id_client = C.id')
				->where('(C.nom LIKE CONCAT("%", ?, "%") OR C.adresse LIKE CONCAT("%", ?, "%") OR C.ville LIKE CONCAT("%", ?, "%"))',$recherche,$recherche,$recherche)
                                ->andWhere('H.actif = ?',1)
				->orderBy('jours_restants','ASC')
				->groupBy('C.id');
				
				
//			$q->displayQuery = true;	
				
			$result = $q->executeQuery();	
		}
		else{
			$q = new QueryBuilder('clients');
			
			$q->select('C.*, (to_days(H.date_valid)-to_days(curdate())) as jours_restants')
				->from('clients C')
				->join('INNER JOIN hebergements H ON H.id_client = C.id')
	//			->where('C.id = H.id_client')
                                ->where('H.actif = ?',1)
				->orderBy('jours_restants','ASC')
				->groupBy('C.id');
			
	//		$q->displayQuery = true;
				
			$clients = $q->executeQuery();	
			
			
			$p = new QueryBuilder('clients');
			
			$p->select()
				->from('clients C')
				->where('C.id NOT IN(SELECT C.id FROM clients C INNER JOIN hebergements H ON H.id_client = C.id GROUP BY C.id)')
				->orderBy('C.nom')
                                ->groupBy('C.id');
			
	//		$p->displayQuery = true;	
				
			$clientsNotH = 	$p->executeQuery();	
			
			$result = array('clients' => $clients, 'clientsNotH' => $clientsNotH);
		}
		
		return $result;
	}
	
	public function executeShow($request){
		$client = new Clients();
		$client = $client->findOneBy('id',$request->getGetParameters('id'));
		
		return $client;
	}
	
	public function executeNew($request){
		$clientForm = new ClientForm();
 		$form = $clientForm->getForm();
		
		if($form->isValid($_POST)){
			$client = new Clients();
			
			$elements = $form->getElement();
			foreach($elements as $obj){
				$name = $obj->getName();
				$client->$name = $_POST[$obj->getName()];
			}
			
			$client->save();
                        
                        $this->redirect(url_for('clients'));
		}
		else{
			$form->pre($_POST);
		}
		
		return $form;
	}
	

	
	public function executeEdit($request){
		$client = new Clients();
		$client = $client->findOneBy('id',$request->getGetParameters('id'));
		
//		print_r_html($client);
		
		$clientForm = new ClientForm($client);
 		$form = $clientForm->getForm();
		
		$form->preObject($client);
		
		if($form->isSubmitted()){
			if($form->isValid($_POST)){
				$elements = $form->getElement();
				foreach($elements as $obj){
					$name = $obj->getName();
					$client->$name = $_POST[$obj->getName()];
				}
				
				$client->save();
				$form->preObject($client);
				$this->nextAction('show');
			}
			else{
				$form->pre($_POST);
			}
		}
		
		$return = array($form, $client);
		
 		return $return;
	}
	
	
	public function executeRelancer($request){
		
		$client = new Clients();
		$client = $client->findOneBy('id',$request->getPostParameters('id_client'));
		
		$id_hebergement = $request->getPostParameters('id_hebergement');
		
		$hebergement = new Hebergements();
		$hebergement = $hebergement->findOneBy('id',$id_hebergement);
		$hebergement->duree = $request->getPostParameters('duree');
		
		$client->createRelance($hebergement);
		
		$request->setGetParameters(array('id'=> $request->getPostParameters('id_client')));
		$this->nextAction('show');
		
		$this->redirect(url_for('clients','show',array('id'=>$client->id)));
		
		return;
	}
	
	public function executeSendFacture($request){
		$client = new Clients();
		$client = $client->findOneBy('id',$request->getPostParameters('id_client'));
		
		if(!is_null($request->getPostParameters('id_facture'))){
			$id = $request->getPostParameters('id_facture');
			$facture = new Facturations_h() ;
			$facture = $facture -> findOneBy('id',$id);
			
			if(!empty($facture)) {
				$client ->  sendFacture($facture);
			}
			
		}
		else{
			new Alert("parametre manquant");
			
		}
		
		$request->setGetParameters(array('id'=> $request->getPostParameters('id_client')));
		$this->nextAction('show');
		new Alert("Facture envoyée au client");
	}
	
	public function executeSendFactureCompta($request){
		$client = new Clients();
		$client = $client->findOneBy('id',$request->getPostParameters('id_client'));
		
		if(!is_null($request->getPostParameters('id_facture'))){
			$id = $request->getPostParameters('id_facture');
			$facture = new Facturations_h() ;
			$facture = $facture -> findOneBy('id',$id);
			
			if(!empty($facture)) {
				$client ->  sendFactureCompta($facture);
			}
			
		}
		else{
			new Alert("parametre manquant");
			
		}
		
		$request->setGetParameters(array('id'=> $request->getPostParameters('id_client')));
		$this->nextAction('show');
		new Alert("Facture envoyée à la compta");
	}
	public function executeSendRelance($request){
		
		$client = new Clients();
		$client = $client->findOneBy('id',$request->getPostParameters('id_client'));
		
		if(!is_null($request->getPostParameters('id_relance'))){
			$id = $request->getPostParameters('id_relance');
			$relances = $client->getRelancesPourEnvoi($id);
		}
		else{
			new Alert("parametre manquant");
			//return false;
		}
		
//		print_r_html($relances);
                  //  echo 'pas là';
		if(!empty($relances)){
                    //    echo 'zougagazblex<br/>';
			$client->sendRelance($relances);
		}
		else{
			new Alert('Aucune relance à envoyer pour ce client');
		} 
		
		$request->setGetParameters(array('id'=> $request->getPostParameters('id_client')));
		$this->nextAction('show');
		
//		$this->redirect(url_for('clients','show',array('id'=>$client->id)));
		
		return;
	}
	
	public function executeSupprRelance($request){
		$client = new Clients();
		$client = $client->findOneBy('id',$request->getPostParameters('id_client'));
		
		if(!empty($client)){
			$relance = new Relances();
			$relance = $relance->findOneBy('id',$request->getPostParameters('id_relance'));
			
			if(!empty($relance)){
				$join = new Join_Relances_Hebergements();
				$join->delete(array('id_relances' => $relance->id));
				$relance->hebergements = array();
				
				$elems = new Elems();
				$elems->delete(array('id_relances' => $relance->id));
				$relance->elems = array();
				
				
				$relance->delete(array('id' => $relance->id));	
				
				$this->redirect(url_for('clients','show', array('id' => $client->id)));
			}
			else{
				new Alert('Pas de relance correspondante');
			}
		}
		else{
			new Alert('Pas de client correspondant');
		}
		
		$request->setGetParameters(array('id'=> $request->getPostParameters('id_client')));
		$this->nextAction('show');

		return;
	}
	
	public function executePaiement($request){
		$client = new Clients();
		$client = $client->findOneBy('id',$request->getGetParameters('id_client'));
		
		
		$relance = new Relances();
		$relance = $relance->findOneBy('id',$request->getGetParameters('id_relance'));
		
//		print_r_html($relance);
		
		//Si une relance, et id_client relance et client correspondent
		if(!empty($relance) && $client->id == $relance->id_client){		
		
			$relance->getElems();
			
//			print_r_html($relance);
			
			/* Création d'une facture */
			$fact = new Facturations_h();
			$fact->relance = $relance;
			$fact->tva = $relance->tva;
			$fact->elems = $relance->elems;
			$fact->duree_valid = $relance->duree_valid;
			$fact->getTotaux();
			// var_dump($fact);
			$factForm = new PaiementForm($fact);
	 		$form = $factForm->getForm();
	 		
			$form->preObject($fact);
				
			if(is_null($relance->id_facturations_h)){
				if($form->isValid($_POST)){
					$elements = $form->getElement();
					
					foreach($elements as $obj){
						$name = $obj->getName();
						$fact->$name = $_POST[$obj->getName()];
					}
					
					$client->addFacturation($relance,$fact);
		
	//				$request->setGetParameters(array('id'=> $request->getGetParameters('id_client')));
	//				$this->nextAction('show');
	
					$this->redirect(url_for('clients','show',array('id' => $client->id)));
				}
				else{
					$form->pre($_POST);
				}
			}
			else{
				new Alert('Impossible de régénérer une facturation pour cette relance')	;
			}
			
			$return = array($form, $client);
	 		return $return;
		}
		else{
			new Alert('Pas de paiement possible');
		}
		
		return;
	}
	
	/*
	public function executePaiement($request){
		$relance = new Relances();
		$relance = $relance->findOneBy('id', $request->getGetParameters('id_relance'));
		
		if(!empty($relance)){
			$old_fact = $relance->getFacturation();
	
			if($old_fact->etat == 'p' || $old_fact->etat == 'r' || $old_fact->etat == 'r'){
				if($request->getGetParameters('id_facture') == $old_fact->id){
					if($request->getGetParameters('id_client') == $old_fact->id_client){
					
						$facture = new Facturations_h();
						
						$facture->etat = 'p';
						$facture->titre = $old_fact->titre;
						$facture->id_intitule_entete = 4;
						$facture->id_client = $old_fact->id_client;
						
						$next_echeance_int = time() + 60 * 60 * 24 * 365;
						$facture->date_valid = date('Y-m-d',$next_echeance_int);
						
						$facture->total = $old_fac->total;
						$facture->save();
						
						$facture->id = $facture->getLastInsertId();
						
						echo '<h4>Nouvelle facture</h4>';
						print_r_html($facture);
						
						echo 'Avant la joiture<br/>';
						
						//Créer les jointures avec les hébergements				
						$facture->JoinWithHebergement($old_fact->getHebergements);
						echo 'Après la joiture<br/>';
						
						$facture->addElems();					
						
						//Test si le total à changer
						if($facture->total != $old_fac->total){
							new Alert("Le prix des hébergements a évolué depuis la dernière facture");
							$facture->save();
						}
						
						$old_fact->etat = 't';
						$old_fact->save();
						
						
						$relance->etat = 'e';
						$relance->save();
						
		
						echo '<h4>La nouvelle facture</h4>';
						print_r_html($facture);							
											
						
						new Alert('Le paiement a bien été enregistré, nouvelle échéance de paiement : '.$facture->date_valid );
										
					}
					else{
						new Alert('Cette facture ne correspond pas à ce client');
					}
				}
				else{
					new Alert('Problème de sécurité, relance et facture ne correspondent pas');
				}
			}
			else{
				new Alert('Cette facture a déjà été payée !');
			}
		}
		else{
			new Alert('Aucune relance ne correspond');
		}

		
		$request->setGetParameters(array('id'=> $request->getGetParameters('id_client')));
		$this->nextAction('show');
	}
	
	*/
	
	
	
	
	
}