<?php


//include_once "modules/svncheckout/classes/webdav_client.class.php";//auto
//include_once 'includes/general/RealTimeProgression.class.php';//auto

class SvnCheckout {
	public $host="";
	public $protocol=1.1;
	public $user="";
	public $pass="";
	public $port=80;
	public $initial_path="/";

	private $revision_actuelle;
	private $client;

	private $fichiers;
	private $dossiers;
	private $reste_a_explorer=0;
	private $nb_explores=0;
	private $checkout_path="";
	private $svn_src_path="";
	public static $password="nosé";
	private $testMode=true;
	private $validateur;
	private $rapport;
	private $max_revision;

	public function setMaskExclusions($defaut)
	{
		$this -> validateur = new CExclusionManager($defaut);

		$this -> maskExclusion = $defaut;
	}
	public function open() {
		$this->client=new webdav_client();
		$this->client->set_server($this->host);
		$this->client->set_port($this->port);
		$this->client->set_protocol($this->protocol);
		$this->client->set_user($this->user);
		$this->client->set_pass($this->pass);
		//		$this->client->_get_mode_advanced = false;

		$this->client->open($this->initial_path);
		$this->client->check_webdav();

	}
	public function out() {
		return $this->rapport->out("SVN CHECKOUT",false,false,false,0,2);
	}
	public function checkout($path,$path_to,$revision_actu=0,$password="no_pass") {
		//		RealTimeProgression::outInit();
		$this->testMode=(SVNCHECKOUT_INTERDIT===true || (self::$password!=$password));

		$this->revision_actuelle=$revision_actu;
		$this->checkout_path=$path_to;
		$path_src=$this->initial_path.$path;
		$this->svn_src_path=$path_src;
		$this->vide_arborescence();

		if($this->testMode) $this->rapport->Add_trace("MODE TEST",1,"vert");
		else $this->rapport->Add_trace("MODE REEL",1,"rouge");
		$this->decouvre_arborescence($path_src);
		$this->compare_fichiers();
		$this->rapport->Add_trace("REVISION $this->max_revision");
		//		$dir = $this->client->ls($path_src);
		//		foreach($dir as $e) {
		//			echo "<br>==>".$e['href'];
		//		}
	}
	public function get_max_revision() {
		return $this->max_revision;
	}
	public function get_test_mode() {
		return $this->testMode;
	}
	private function vide_arborescence() {
		$this->rapport = new Crapport();
		//	$this->rapport->sortie_direct = false;
		$this->fichiers=array();
		$this->dossiers=array();
		$this->reste_a_explorer=0;
		$this->nb_explores=0;
	}

	private function decouvre_arborescence($path) {
		//		RealTimeProgression::print_div("<br>découverte révisions >= $this->revision_actuelle<br>$path<br>".count($this->dossiers)." dossiers<br>".count($this->fichiers)." fichiers<br>");
		$dir = $this->client->ls($path);
		if(is_array($dir)) {
			$this->reste_a_explorer+=count($dir);
			foreach($dir as $e) {
				$e["href"]=urldecode($e["href"]);
				//				if(count($this->fichiers)>=3) return;
				$this->nb_explores++;
				if($path == $e["href"]) continue;
				$because = "";
				$pathFromRacine = str_replace(rtrim($this->svn_src_path,"/"),"",$e["href"]);
				//				echo "<br>$pathFromRacine";;
				//				ob_flush();
				if(!$this -> validateur -> isValid($pathFromRacine,$because)) {
					$this->rapport->Add_trace("exclude $pathFromRacine because $because",1,"rouge");
					//					$this->rapport->out("",false,true);
					continue;
				}
				//				RealTimeProgression::setProgression($this->nb_explores/$this->reste_a_explorer);
				$revision_fichier=$e["dav::multistatus_dav::response_dav::propstat_dav::prop_dav::version-name_"];
				$this->max_revision = max($this->max_revision,$revision_fichier);
				if($revision_fichier>=$this->revision_actuelle) {
					//					$ts = $this->client->iso8601totime($e['creationdate']);
					//					$date = date('d.m.Y H:i:s',$ts);
					//					echo  "<br>".$e['resourcetype']." = ". $e["href"]."($date) V $revision_fichier";
					//					print_rr($e);
					//					exit;
					if( $e['resourcetype']=="collection") {

						$this->dossiers[]=$e;
						$this->decouvre_arborescence($e["href"]);
							
					} else {
						$this->fichiers[]=$e;
					}
				} else {
					$this->log($e["href"]." : révision $revision_fichier<=$this->revision_actuelle");
				}

			}
		} else {
			$this->rapport->Add_trace("dir : $dir");
		}

	}

	public function compare_fichiers () {
		for($i=0;$i<count($this->fichiers);$i++) {

			$e=$this->fichiers[$i];
			//			RealTimeProgression::setProgression(($i+1)/count($this->fichiers));
			//												print_rr($e);
			//												exit;

			$file_path=$this->checkout_path.str_replace($this->svn_src_path,"",$e["href"]);
			$fichier_compare="";
			$version_en_ligne = $e["dav::multistatus_dav::response_dav::propstat_dav::prop_dav::version-name_"];
			$this->rapport->Add_trace("fichier $e[href] (v. $version_en_ligne)",2);
			$sauve=false;
			$raison="";
			$existe=false;
			$md5_enligne=$e["dav::multistatus_dav::response_dav::propstat_dav::prop_http://subversion.tigris.org/xmlns/dav/:md5-checksum_"];
			$md5 = null;
			// insert into ... on duplicate key update md5=VALUES(md5)
			// insert ignore into
			// replace into

			if(!file_exists($file_path)) {
				$sauve=true;
				$raison.="+";
			} else {
				$raison.="_";
				$existe=true;
				$taille=filesize($file_path);
				$contenu_actu=file_get_contents($file_path);
				$md5=md5($contenu_actu);
				if($taille != $e["getcontentlength"]) {
					$sauve=true;
					$raison.="s";
				} else {
					$raison.="_";
				}
				if($md5 !=$md5_enligne) {

					$sauve=true;
					$raison.="c";
					//					print_rr($e);
				} else {
					$raison.="_";
				}
				$str="$taille != ".$e["getcontentlength"]." --- ".$md5." != ".$e["dav::multistatus_dav::response_dav::propstat_dav::prop_http://subversion.tigris.org/xmlns/dav/:md5-checksum_"];
			}

			$saved = false;
			if($sauve) {
				
				$recup=($existe && isset($_REQUEST["check_contenus"])) || !$this->testMode;
//				$recup= !$this->testMode;
				if($recup) {
					$this->client->get($e['href'],$contenu);
					$nb_re=0;
					$md5_recu = md5($contenu);
					$liste_md5=array();
					while($md5_recu != $md5_enligne && $nb_re < 10) {
						$this->rapport->Add_trace("contenu recu invalide ($md5_recu != $md5_enligne) - $nb_re",3,"bleu");
						if(!in_array($md5_recu,$liste_md5)) {
							$liste_md5[]=$md5_recu;
						}
						$nb_re++;
						//						RealTimeProgression::print_div("<br>$md5_recu != $md5_enligne mal telechargé, re ($nb_re)");
						$this->client->close();
						$this->client->_reopen();
						$this->client->get($e['href'],$contenu);
						$md5_recu = md5($contenu);
					}
					if($nb_re >=10) {
						$this->client->set_debug("raph");
						$this->client->close();
						$this->client->_reopen();
						$this->client->get($e['href'],$contenu);
						$this->rapport->Add_trace($e['href']."<br>contenu recu invalide ($md5_recu != $md5_enligne)  - $nb_re",1,"erreur");
						$this->client->set_debug(false);
						//					exit;
					}
				}
				if($existe) {
					$taille_recu = strlen($contenu);
					//					echo "$md5_recu <=> $md5";
					if($md5_recu != $md5) {
						$this->rapport->Add_trace("revérification md5 reception => valide",3,"bleu");
						$sauve=true;
						$raison.="c";
						//						$ext=get_extension($file_path);
						//						$n=0;
						//						while(file_exists(change_extension($file_path,"old$n.$ext"))) {
						//							$n++;
						//						}
						//						rename($file_path,change_extension($file_path,"old$n.$ext"));

					}else {
						$sauve=false;
						$raison.="_";
					}
					if($sauve && $existe && strpos($e["getcontenttype"],"text/xml")!==false) {
						$this->rapport->Add_trace("differences $e[href] : <br>".self::arr_diff( explode("\n",$contenu_actu),  explode("\n",$contenu) ));
					}
				}else {
					$raison.="_";
				}


				if($sauve) {
					$this->rapport->Add_trace("$raison ---> $e[href] ",1,"bleu");
					
					if(isset($_REQUEST["forceCheckout"])) $forceCheckout = in_array(ltrim($file_path,"/"),$_REQUEST["forceCheckout"]);
					else $forceCheckout = false;
					
					if(ComparateurMD5ServeurSvn::fichierIsCheckoutable($file_path) || $forceCheckout) {
						if($forceCheckout) {
							$this->rapport->Add_trace("ECRITURE FORCEE<br>
							<div><input class='forceCheckout' type = 'checkbox' name='forceCheckout[]' value='$file_path' checked='checked'>$file_path</div>",1,"erreur");
						}
						if($this->testMode) {
							$this->rapport->Add_trace("non effectué[TEST]",2,"vert");
						} else {
							$this->sauveFichierEnBase($file_path, $md5_enligne, $version_en_ligne);
							$saved = true;
							//sauvegardeFichierServeurHistorique($);
							creeRepSiExistePas($file_path,false);
							file_put_contents($file_path,$contenu);
							$this->rapport->Add_trace("effectué [ECRIT]",1,"vert");
						}
					} else {
						$this->rapport->Add_trace("non effectué car MODIFIÉ direct sur le serveur depuis le dernier checkout<br>
							Voulez-vous écraser les modifs ?? <div><input class='forceCheckout' type = 'checkbox' name='forceCheckout[]' value='$file_path'>$file_path</div>",2,"erreur");
					}
				}

			}
			if (!$saved && !is_null($md5)) {
				$this->sauveFichierEnBase($file_path, $md5,0, true);
			}
			//			RealTimeProgression::print_div($this->rapport->out("",false,false,false,0,1));
		}
	}

	private function sauveFichierEnBase($fichier_path, $md5, $version, $only_if_not_exists = false) {
		$fichier_path=ltrim($fichier_path,"/");
		if ($only_if_not_exists) {
			return ifReq("INSERT IGNORE INTO `svn__image_serveur` SET `fichier` = '$fichier_path', `version` = $version, `md5` = '$md5'");
		}
		else {
			ifReq("INSERT INTO `svn__image_serveur_histo` (`fichier`, `md5`, `version`)
					SELECT `fichier`, `md5`, `version` FROM `svn__image_serveur` WHERE `fichier` = '$fichier_path'");

			return ifReq("INSERT INTO `svn__image_serveur` SET `fichier` = '$fichier_path', `version` = $version, `md5` = '$md5'
				ON DUPLICATE KEY UPDATE version=VALUES(version),md5=VALUES(md5)");
		}
	}

	private function log($str) {
		//			echo "<br>".$str;
	}
	public static function arr_diff( $f1 , $f2 , $show_equal = 0 )
	{

		$c1         = 0 ;                   # current line of left
		$c2         = 0 ;                   # current line of right
		$max1       = count( $f1 ) ;        # maximal lines of left
		$max2       = count( $f2 ) ;        # maximal lines of right
		$outcount   = 0;                    # output counter
		$hit1       = "" ;                  # hit in left
		$hit2       = "" ;                  # hit in right

		while (
		$c1 < $max1                 # have next line in left
		and
		$c2 < $max2                 # have next line in right
		and
		($stop++) < 1000            # don-t have more then 1000 ( loop-stopper )
		and
		$outcount < 20              # output count is less then 20
		)
		{
			/**
			 *   is the trimmed line of the current left and current right line
			 *   the same ? then this is a hit (no difference)
			 */
			if ( trim( $f1[$c1] ) == trim ( $f2[$c2])  )
			{
				/**
				 *   add to output-string, if "show_equal" is enabled
				 */
				$out    .= ($show_equal==1)
				?  self::formatline ( ($c1) , ($c2), "=", $f1[ $c1 ] )
				: "" ;
				/**
				 *   increase the out-putcounter, if "show_equal" is enabled
				 *   this ist more for demonstration purpose
				 */
				if ( $show_equal == 1 )
				{
					$outcount++ ;
				}

				/**
				 *   move the current-pointer in the left and right side
				 */
				$c1 ++;
				$c2 ++;
			}

			/**
			 *   the current lines are different so we search in parallel
			 *   on each side for the next matching pair, we walk on both
			 *   sided at the same time comparing with the current-lines
			 *   this should be most probable to find the next matching pair
			 *   we only search in a distance of 10 lines, because then it
			 *   is not the same function most of the time. other algos
			 *   would be very complicated, to detect 'real' block movements.
			 */
			else
			{

				$b      = "" ;
				$s1     = 0  ;      # search on left
				$s2     = 0  ;      # search on right
				$found  = 0  ;      # flag, found a matching pair
				$b1     = "" ;
				$b2     = "" ;
				$fstop  = 0  ;      # distance of maximum search

				#fast search in on both sides for next match.
				while (
				$found == 0             # search until we find a pair
				and
				( $c1 + $s1 <= $max1 )  # and we are inside of the left lines
				and
				( $c2 + $s2 <= $max2 )  # and we are inside of the right lines
				and
				$fstop++  < 10          # and the distance is lower than 10 lines
				)
				{

					/**
					 *   test the left side for a hit
					 *
					 *   comparing current line with the searching line on the left
					 *   b1 is a buffer, which collects the line which not match, to
					 *   show the differences later, if one line hits, this buffer will
					 *   be used, else it will be discarded later
					 */
					#hit
					if ( trim( $f1[$c1+$s1] ) == trim( $f2[$c2] )  )
					{
						$found  = 1   ;     # set flag to stop further search
						$s2     = 0   ;     # reset right side search-pointer
						$c2--         ;     # move back the current right, so next loop hits
						$b      = $b1 ;     # set b=output (b)uffer
					}
					#no hit: move on
					else
					{
						/**
						 *   prevent finding a line again, which would show wrong results
						 *
						 *   add the current line to leftbuffer, if this will be the hit
						 */
						if ( $hit1[ ($c1 + $s1) . "_" . ($c2) ] != 1 )
						{
							/**
							 *   add current search-line to diffence-buffer
							 */
							$b1  .= self::formatline( ($c1 + $s1) , ($c2), "-", $f1[ $c1+$s1 ] );

							/**
							 *   mark this line as 'searched' to prevent doubles.
							 */
							$hit1[ ($c1 + $s1) . "_" . $c2 ] = 1 ;
						}
					}



					/**
					 *   test the right side for a hit
					 *
					 *   comparing current line with the searching line on the right
					 */
					if ( trim ( $f1[$c1] ) == trim ( $f2[$c2+$s2])  )
					{
						$found  = 1   ;     # flag to stop search
						$s1     = 0   ;     # reset pointer for search
						$c1--         ;     # move current line back, so we hit next loop
						$b      = $b2 ;     # get the buffered difference
					}
					else
					{
						/**
						 *   prevent to find line again
						 */
						if ( $hit2[ ($c1) . "_" . ( $c2 + $s2) ] != 1 )
						{
							/**
							 *   add current searchline to buffer
							 */
							$b2   .= self::formatline ( ($c1) , ($c2 + $s2), "+", $f2[ $c2+$s2 ] );

							/**
							 *   mark current line to prevent double-hits
							 */
							$hit2[ ($c1) . "_" . ($c2 + $s2) ] = 1;
						}

					}

					/**
					 *   search in bigger distance
					 *
					 *   increase the search-pointers (satelites) and try again
					 */
					$s1++ ;     # increase left  search-pointer
					$s2++ ;     # increase right search-pointer
				}

				/**
				 *   add line as different on both arrays (no match found)
				 */
				if ( $found == 0 )
				{
					$b  .= self::formatline ( ($c1) , ($c2), "-", $f1[ $c1 ] );
					$b  .= self::formatline ( ($c1) , ($c2), "+", $f2[ $c2 ] );
				}

				/**
				 *   add current buffer to outputstring
				 */
				$out        .= $b;
				$outcount++ ;       #increase outcounter

				$c1++  ;    #move currentline forward
				$c2++  ;    #move currentline forward

				/**
				 *   comment the lines are tested quite fast, because
				 *   the current line always moves forward
				 */

			} /*endif*/

		}/*endwhile*/

		return $out;

	}/*end func*/

	/**
	 *   callback function to format the diffence-lines with your 'style'
	 */
	public static function formatline( $nr1, $nr2, $stat, &$value )  #change to $value if problems
	{
		if ( trim( $value ) == "" )
		{
			return "";
		}

		switch ( $stat )
		{
			case "=":
				return $nr1. " : $nr2 : = ".htmlentities( $value )  ."<br>";
				break;

			case "+":
				return $nr1. " : $nr2 : + <font color='blue' >".htmlentities( $value )  ."</font><br>";
				break;

			case "-":
				return $nr1. " : $nr2 : - <font color='red' >".htmlentities( $value )  ."</font><br>";
				break;
		}

	}
}




?>