<?php

$table_creation["type_page"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `id_type_page` INT NOT NULL AUTO_INCREMENT ,
  `identifiant` VARCHAR(45) NOT NULL ,
  `class_path` VARCHAR(255) NOT NULL ,
  `class_name` VARCHAR(45) NOT NULL ,
  `full_text` TINYINT(1) UNSIGNED NOT NULL COMMENT 'a garder en un champ, ou d�couper en plusieurs. Permet de d�finir si on stocke le contenu de la page, etc ...' ,
  PRIMARY KEY (`id_type_page`) ,
  UNIQUE INDEX `identifiant` (`identifiant` ASC) )
ENGINE = MyISAM";

$table_creation["page"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `id_page` INT NOT NULL AUTO_INCREMENT ,
  `id_type_page` INT NULL ,
  `id_page_type` VARCHAR(45) NULL ,
  `indexee` TINYINT(1) NOT NULL DEFAULT 0,
  `date_index` DATETIME NULL ,
  `index_valide` TINYINT(1) NOT NULL DEFAULT 0,

  
  `url` VARCHAR(45) NULL ,
  `full_texte` VARCHAR(45) NULL ,
  `md5sum` VARCHAR(32) NULL ,
  `size` VARCHAR(45) NULL ,
  `visible` VARCHAR(45) NULL ,
  `level` VARCHAR(45) NULL ,
  PRIMARY KEY (`id_page`),
  INDEX indexee(`indexee`),
  INDEX id_type_page(`id_type_page`),
  INDEX id_page_type(`id_page_type`),
  INDEX index_valide(`index_valide`)
  )
ENGINE = MyISAM
COMMENT = 'liste des �l�ments ind�x�s (articles , pages, etc ...) qui sortiront dans les r�sultats'";


$table_creation["exception"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `id_exception` INT NOT NULL AUTO_INCREMENT,
  `mot` VARCHAR(45) NULL ,
  `inclusion` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`id_exception`) )
ENGINE = MyISAM
COMMENT = 'Mots a inclure ou exclure, lors de l\'indexation / recherche\n'";


$table_creation["mot_cle"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `id_mot_cle` INT NOT NULL AUTO_INCREMENT ,
  `mot` VARCHAR(100) NOT NULL ,
  `racine` VARCHAR(20) NOT NULL ,
  `metaphone` VARCHAR(20) NOT NULL ,
  `phonex` float NOT NULL ,
  `id_mot_parent` INT NULL ,
  `mot_supplementaire` TINYINT NOT NULL DEFAULT 0 ,
  `poids_total` int(1) NOT NULL DEFAULT 0 ,
  `is_numeric` TINYINT(1) NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`id_mot_cle`),
  INDEX (`id_mot_parent`),
  INDEX (`is_numeric`),
  INDEX (`poids_total`),
  INDEX (`metaphone`),
  INDEX (`racine`),
  INDEX (`mot`),
  INDEX (`mot_supplementaire`)
   )
ENGINE = MyISAM";

$table_creation["mot_cle_page"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `id_mot_cle` INT NOT NULL ,
  `id_page` INT NOT NULL ,
  `poids` INT NULL ,
  PRIMARY KEY (`id_mot_cle`, `id_page`),
  INDEX (`id_mot_cle`),
  INDEX (`id_page`)
 )
ENGINE = MyISAM
COMMENT = 'table qui regroupe tous les mots cl�s index�s existants sur le site\n\nCette table sera \'d�coup�e\' en 16 tables plus petites, 0 � F afin de r�partir la charge. On prendra la 1ere lettre du MD5 du mot cl�'";


//ALTER TABLE `marchand`.`rech__mot_cle_page` ADD INDEX `id_mot_cle`(`id_mot_cle`),
// ADD INDEX `id_page`(`id_page`);
//
//ALTER TABLE `marchand`.`rech__spec_val` ADD INDEX `id_page`(`id_page`);

/*$table_creation["spider"]="CREATE  TABLE IF NOT EXISTS `#TABLE` (
  `id_spider` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `id_type_page` INT UNSIGNED NOT NULL ,
  `id_elem` VARCHAR(45) NOT NULL ,
  `date_demande` DATETIME NOT NULL ,
  `prorite` TINYINT UNSIGNED NOT NULL ,
  PRIMARY KEY (`id_spider`) ,
  INDEX `priorite` (`prorite` ASC)
  )
ENGINE = MyISAM";*/

$table_creation["expression"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `id_expression` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `cherche` VARCHAR(45) NOT NULL ,
  `remplace_index` VARCHAR(255) NOT NULL ,
  `remplace_recherche` VARCHAR(255) NOT NULL ,
  PRIMARY KEY (`id_expression`)
  )
ENGINE = MyISAM";

$table_creation["levenshtein"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `mot` VARCHAR(45) NOT NULL ,
  `id_mot_cle` INT UNSIGNED NOT NULL ,
  `ratio` MEDIUMINT NOT NULL ,
  PRIMARY KEY (`mot`)
  )
ENGINE = MyISAM";

$table_creation["type_spec"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `id_type_spec` INT NOT NULL AUTO_INCREMENT,
  `identifiant` VARCHAR(45) NOT NULL ,
  `id_type_page` INT NOT NULL,
  `frequence` VARCHAR(15) DEFAULT NULL ,
  `type_val` ENUM('int','float','varchar') NOT NULL DEFAULT 'int',
  PRIMARY KEY (`id_type_spec`),
  INDEX `identifiant` (`identifiant`),
  INDEX `id_type_page` (`id_type_page`),
  INDEX `frequence` (`frequence`)
 )
ENGINE = MyISAM
COMMENT = 'les donn�es a classer'";

$table_creation["spec_val"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `id_type_spec` INT NOT NULL,
  `id_page` INT NOT NULL,
  `valeur_int` INT DEFAULT NULL ,
  `valeur_float` float DEFAULT NULL ,
  `valeur_varchar` VARCHAR(255) DEFAULT NULL ,
  `validite` DATETIME DEFAULT NULL,
  PRIMARY KEY (`id_type_spec`,`id_page`),
  INDEX `valeur_int` (`valeur_int`),
  INDEX `valeur_float` (`valeur_float`),
  INDEX `valeur_varchar` (`valeur_varchar`),
  INDEX `validite` (`validite`),
  INDEX (`id_page`)
 )
ENGINE = MyISAM
COMMENT = 'les donn�es class�es'";

$table_creation["spider_lock"]="CREATE  TABLE IF NOT EXISTS ".RECH_BASE."`#TABLE` (
  `date_lock` DATETIME NOT NULL )
ENGINE = MyISAM
COMMENT = 'les donn�es class�es'";


/*
$procedure_creation["LEVENSHTEIN"]="CREATE FUNCTION LEVENSHTEIN (s1 VARCHAR(255), s2 VARCHAR(255))
  RETURNS INT
    DETERMINISTIC
      BEGIN
        DECLARE s1_len, s2_len, i, j, c, c_temp, cost INT;
        DECLARE s1_char CHAR;
        DECLARE cv0, cv1 VARBINARY(256);
        SET s1_len = CHAR_LENGTH(s1), s2_len = CHAR_LENGTH(s2), cv1 = 0x00, j = 1, i = 1, c = 0;
        IF s1 = s2 THEN
          RETURN 0;
        ELSEIF s1_len = 0 THEN
          RETURN s2_len;
        ELSEIF s2_len = 0 THEN
          RETURN s1_len;
        ELSE
          WHILE j <= s2_len DO
            SET cv1 = CONCAT(cv1, UNHEX(HEX(j))), j = j + 1;
          END WHILE;
          WHILE i <= s1_len DO
            SET s1_char = SUBSTRING(s1, i, 1), c = i, cv0 = UNHEX(HEX(i)), j = 1;
            WHILE j <= s2_len DO
                SET c = c + 1;
                IF s1_char = SUBSTRING(s2, j, 1) THEN SET cost = 0; ELSE SET cost = 1; END IF;
                SET c_temp = CONV(HEX(SUBSTRING(cv1, j, 1)), 16, 10) + cost;
                IF c > c_temp THEN SET c = c_temp; END IF;
                SET c_temp = CONV(HEX(SUBSTRING(cv1, j+1, 1)), 16, 10) + 1;
                IF c > c_temp THEN SET c = c_temp; END IF;
                SET cv0 = CONCAT(cv0, UNHEX(HEX(c))), j = j + 1;
            END WHILE;
            SET cv1 = cv0, i = i + 1;
          END WHILE;
        END IF;
        RETURN c;
      END";

$procedure_creation["LEVENSHTEIN_RATIO"]="CREATE FUNCTION LEVENSHTEIN_RATIO (s1 VARCHAR(255), s2 VARCHAR(255))
  RETURNS INT
    DETERMINISTIC
      BEGIN
        DECLARE s1_len, s2_len, max_len INT;
        SET s1_len = LENGTH(s1), s2_len = LENGTH(s2);
        IF s1_len > s2_len THEN SET max_len = s1_len; ELSE SET max_len = s2_len; END IF;
        RETURN ROUND((1 - LEVENSHTEIN(s1, s2) / max_len) * 100);
      END";
*/
$procedure_creation["rech_maj_poids_total"]="CREATE PROCEDURE ".RECH_BASE."rech_maj_poids_total ()
      BEGIN
      UPDATE ".RECH_TABLE_MOT_CLE." mc, 
		(SELECT id_mot_cle,SUM(poids) as poids_total FROM ".RECH_TABLE_MOT_CLE_PAGE." mcp GROUP BY id_mot_cle ) as tmp 
 		SET mc.poids_total=  tmp.poids_total
		WHERE  tmp.id_mot_cle = mc.id_mot_cle AND tmp.poids_total != mc.poids_total;
      END";
//        UPDATE ".RECH_TABLE_MOT_CLE." mc SET poids_total = (SELECT SUM(poids) FROM ".RECH_TABLE_MOT_CLE_PAGE." mcp WHERE mcp.id_mot_cle = mc.id_mot_cle );


/*
 * index
 */
$procedure_creation["rech_reset_index_page_type"]="CREATE PROCEDURE ".RECH_BASE."rech_reset_index_page_type (v_id_type_page INT,v_id_page_type VARCHAR(255))
      BEGIN
        UPDATE ".RECH_TABLE_PAGE." mc SET index_valide = 0 WHERE id_type_page=v_id_type_page AND id_page_type=v_id_page_type;
      END";

$procedure_creation["rech_reset_index_page"]="CREATE PROCEDURE ".RECH_BASE."rech_reset_index_page (v_id_page int)
      BEGIN
        UPDATE ".RECH_TABLE_PAGE." mc SET index_valide = 0 WHERE id_page=v_id_page;
      END";

$procedure_creation["rech_reset_index_mot"]="CREATE PROCEDURE ".RECH_BASE."rech_reset_index_mot (v_mot VARCHAR(255))
      BEGIN
      UPDATE ".RECH_TABLE_PAGE." p, ".RECH_TABLE_MOT_CLE_PAGE." mcp, ".RECH_TABLE_MOT_CLE." mc
		SET p.index_valide = 0
		WHERE mcp.id_page = p.id_page AND mc.id_mot_cle = mcp.id_mot_cle
		AND mc.mot=v_mot;
 
      END";


$procedure_creation["rech_ajout_page_type"]="CREATE PROCEDURE ".RECH_BASE."rech_ajout_page_type (v_identifiant_type VARCHAR(255),v_id_page_type VARCHAR(255))
      BEGIN
      DECLARE v_id_type_page INT;
      SELECT id_type_page INTO v_id_type_page FROM ".RECH_TABLE_TYPE_PAGE." WHERE identifiant = v_identifiant_type;
      CALL rech_ajout_page(v_id_type_page,v_id_page_type);
      END";

$procedure_creation["rech_ajout_page"]="CREATE PROCEDURE ".RECH_BASE."rech_ajout_page (v_id_type_page INT,v_id_page_type VARCHAR(255))
      BEGIN
      INSERT INTO ".RECH_TABLE_PAGE." SET id_type_page = v_id_type_page, id_page_type = v_id_page_type
      	ON DUPLICATE KEY UPDATE index_valide=0;
      END";

$procedure_creation["rech_reset_page_type"]="CREATE PROCEDURE ".RECH_BASE."rech_reset_page_type (v_identifiant_type VARCHAR(255),v_id_page_type VARCHAR(255))
      BEGIN
      DECLARE v_id_type_page INT;
      SELECT id_type_page INTO v_id_type_page FROM ".RECH_TABLE_TYPE_PAGE." WHERE identifiant = v_identifiant_type;
      UPDATE ".RECH_TABLE_PAGE." SET index_valide = 0 WHERE id_type_page = v_id_type_page AND (id_page_type LIKE v_id_page_type OR v_id_page_type IS NULL);
      END";

$procedure_creation["rech_efface_page_type"]="CREATE PROCEDURE ".RECH_BASE."rech_efface_page_type (v_identifiant_type VARCHAR(255),v_id_page_type VARCHAR(255))
      BEGIN
      DECLARE v_id_type_page INT;
      SELECT id_type_page INTO v_id_type_page FROM ".RECH_TABLE_TYPE_PAGE." WHERE identifiant = v_identifiant_type;
      DELETE FROM ".RECH_TABLE_PAGE." WHERE  id_type_page = v_id_type_page AND (id_page_type LIKE v_id_page_type OR v_id_page_type IS NULL);
      END";


$procedure_creation["rech_reset_specs_page_type"]="CREATE PROCEDURE ".RECH_BASE."rech_reset_specs_page_type (v_identifiant_type_spec VARCHAR(255), v_identifiant_type_page VARCHAR(255),v_id_page_type VARCHAR(255))
      BEGIN
      	/*
      	reinitialise les specs d'un article d'un type de page et d'un type de specs
      	*/
		UPDATE `".RECH_TABLE_SPEC_VAL."` sv, ".RECH_TABLE_PAGE." p , ".RECH_TABLE_TYPE_PAGE." tp, ".RECH_TABLE_TYPE_SPEC." ts
		SET sv.validite=NOW()
		WHERE tp.identifiant=v_identifiant_type_page 
		AND ts.identifiant=v_identifiant_type_spec 
		AND p.id_page_type=v_id_page_type
		AND p.id_type_page=tp.id_type_page 
		AND sv.id_page = p.id_page
		AND sv.id_type_spec =ts.id_type_spec;

      END";

$procedure_creation["rech_reset_specs_page"]="CREATE PROCEDURE ".RECH_BASE."rech_reset_specs_page (v_identifiant_type_page VARCHAR(255),v_id_page_type VARCHAR(255))
      BEGIN
      	/*
      	reinitialise toutes les specs d'une page
      	*/
		UPDATE `".RECH_TABLE_SPEC_VAL."` sv, ".RECH_TABLE_PAGE." p , ".RECH_TABLE_TYPE_PAGE." tp
		SET sv.validite=NOW()
		WHERE tp.identifiant=v_identifiant_type_page 
		AND p.id_page_type=v_id_page_type
		AND p.id_type_page=tp.id_type_page 
		AND sv.id_page = p.id_page;

      END";


// procedure reset_spec(nom_spec,id_article = null) => validite = 0
// procedure maj_spec(nom_spec,id_article,valeur)
?>