<?php

class CPageReferencable {

	private $url;
	private $titre;
	private $row_page;
	
	private $nb_heures_valides;
	
	private $index_valide;
	private $page_has_contenu_in_index;
	private $contenus = array();

	public function CPageReferencable($url, $titre, $heures_validites = 48) {
		$this->url = $url;
		$this->titre = $titre;
		$this->nb_heures_valides = $heures_validites;
		
		$this->row_page = CRecherche::pageBasic_RecuperePage($url);

		$this->index_valide = CRecherche::pageBasic_IsIndexValid($url, $this->row_page);
		$this->page_has_contenu_in_index = CRecherche::pageBasic_HasContenuIndexable($url, $this->row_page);
	}

	public function mustIndex() {
//		echo 'index_valide?:'.$this->index_valide.'<br/>';
//		echo 'page_has_contenu_in_index?:'.$this->page_has_contenu_in_index.'<br/>';
		return !$this->index_valide || !$this->page_has_contenu_in_index;
	}

	public function addContenuReferencable($contenu, $poids = 1000, $coeff = 0.02) {
		$this->contenus[] = array('contenu'=>$contenu, 'poids'=>$poids, 'coeff'=>$coeff);
	}

	public function saveContenuReferencable() {

		if ($this->mustIndex()) {
//			echo 'must index !<br/>';
			CRecherche::pageBasic_AjoutePageToIndex($this->url, $this->titre, $this->nb_heures_valides);
			CRecherche::pageBasic_SupprimeContenuIndexable($this->url, $this->row_page);
			$cnt = count($this->contenus);
//			echo 'ajout de '.$cnt.' elems de contenu !<br/>';
			for ($i = 0; $i < $cnt; $i++) {
				$contenu = $this->contenus[$i];
				//				echo "<br>indexe ".strlen($contenu);
				CRecherche::pageBasic_AjouteContenuToIndex($this->url, $contenu['contenu'], $contenu['poids'], $contenu['coeff'], $this->row_page);
			}
		}
		CRecherche::pageBasic_UpdateValiditeUrl($this->url);
	}



}

?>