<?php
class Tpl {
	private $file = null;
	private $vars = array();
	private $assignedOb = null;

	public function __construct($tplFile) {
		$this -> file = $tplFile;
	}

	public function assign($var,$val) {
		$this -> vars[$var] = $val;
	}

	public function __get($var) {
		if(array_key_exists($var, $this -> vars)) return $this -> vars[$var];
		return '';
	}

	public function render() {
		include $this -> file;
	}

	public function renderBloc($bloc,$id,$pfx="#") {
		$data = $this -> $id;
		if(empty($data)) return "";
		return $this -> renderBlocData($bloc,$data,$pfx);
	}
	
	public function multiplieBloc($bloc,$id,$pfx="#") {
		$datas = $this -> $id;
		if(!is_array($datas)) return "";
		$retour = "";
		foreach($datas as $data)
		$retour .= $this -> renderBlocData($bloc,$data,$pfx);
		return $retour;
	}

	public static function renderBlocData($bloc,$data,$pfx="#") {
		$src = array();
		$repl = array();
		foreach($data as $i => $v) {
			$src[]=$pfx.strtoupper($i)."#";
			$repl[]=$v;
		}
		return str_replace($src,$repl,$bloc);
	}



	public function ob_start($assignVar) {
		$this -> assignedOb = $assignVar;
		ob_start(array($this,"ob_end_handler"));

	}

	public function ob_end()  {
		ob_end_flush();
	}
	public function ob_end_handler($str)  {
		
		$this -> assign($this -> assignedOb, $str);
	}
	public function ob_end_flush()  {
		if(is_null($this -> assignedOb)) {
			echo "ob_end_flush error : not started";
			return;
		}
		$this -> ob_end();
		echo $this -> render();
	}
}

function shutdown()
{
	while(count(ob_list_handlers())) ob_end_flush();

	$a=error_get_last();
	if(!is_null($a)) print_r($a);

}
register_shutdown_function('shutdown');
