<?php
class TicketModel {
	
	/**
	 * Permet de générer facilement un select en fournissant un tableau de données ainsi que le libellé du champs 
	 * où il faut récupérer la value et le libellé du champs pour le texte à afficher.
	 * @param Array $datas
	 * @param unknown $dataNameFieldAct
	 * @param unknown $dataNameFieldDisplay
	 * @param String $idToCompare
	 * @return string
	 */
	public static function getOptionsAndSelected($datas, $dataNameFieldAct, $dataNameFieldDisplay, $idToCompare = '') {
		$optionsSelectClient = '';
		$selected = '';
		
		foreach($datas as &$data) {
			if($idToCompare != '' && $data[$dataNameFieldAct] == $idToCompare)
				$selected = " selected='selected'";
			
			$optionsSelectClient .= "<option value='$data[$dataNameFieldAct]'$selected>$data[$dataNameFieldDisplay]</option>";
			$selected = '';
		}
		
		return $optionsSelectClient;
	}
	
	public static function getBtnStatutsAuto($indexBtnActif = '') {
		$tplBtnsStatutAuto = "";
		foreach(Ticket :: $tabStatutsAuto as $statutAuto) {
			$tplBtnsStatutAuto .= "
				<input style='background: ".Ticket :: getInfosStatutAuto($statutAuto['index-statut-auto'], 'color').";' class='btn-statut-auto slow-transition-300' data-id-statut-auto='".$statutAuto['index-statut-auto']."' type='button' name='submitStatutAuto' value='".$statutAuto['txt-statut-auto']."' />";
		}
		
		if(count(Ticket :: $tabStatutsAuto) > 0) {
			$tplBtnsStatutAuto .= "
				<script>
					$('.btn-statut-auto').bind('click', function() {
						var indexStatutAutoChoosen = $(this).attr('data-id-statut-auto');
						$.ajax({
							type : 'POST',
							url : 'ajax.php',
							dataType : 'html',
							data : {
								action: 'ajaxGetTplUserTickets',
								idUser: $('#tickets-user-select').val(),
								idClient: $('#tickets-client-select').val(),
								idPrioriteFiltreTickets: $('#tickets-prio-select').val(),
								indexStatutAuto: indexStatutAutoChoosen,
								submitStatutAuto: true
							}
						}).done(function(html) {
							$('#content-user-tickets').empty().append(html);
							
							$.ajax({
								type : 'POST',
								url : 'ajax.php',
								dataType : 'html',
								data : {
									action: 'updateStatutCheckboxWithAutoStatut',
									indexStatutAuto: indexStatutAutoChoosen
								}
							}).done(function(html) {
								$('#content-check-statut').empty().append(html);
							}).fail(function(jqXHR, textStatus) {
								alert('<h1>Erreur Ajax : '+textStatus+'<h1>');
							});
							
						}).fail(function(jqXHR, textStatus) {
							alert('<h1>Erreur Ajax : '+textStatus+'<h1>');
						});
					});
				</script>";
		}
		
		return $tplBtnsStatutAuto;
	}
	
	public static function getStatutsCheckbox($tabAlreadyChecked = array()) {
		$tplCheckbox = "";
		foreach(Ticket :: $tabStatuts as $statut) {
			$checked = (in_array($statut['lvl-statut'], $tabAlreadyChecked)) ? "checked = 'checked' " : "";
			
			$tplCheckbox .= "
				<label for='id-statut-".$statut['lvl-statut']."'>".$statut['txt-statut']."</label>
				<input id='id-statut-".$statut['lvl-statut']."' name='idStatutFiltreTickets' type='checkbox' value='".$statut['lvl-statut']."' $checked/>";
		}
		
		return $tplCheckbox;
	}
	
	public static function getTplNotifTickets() {
		$live = Live :: getInstance();
		$tplNotifTickets = "
		<div id='main-content-notif-tickets'>";
		
		if($live != false && isset($live -> ticket_en_cours)) {
			$tabInfosTicketEnCours = Ticket :: getTicketInfos($live -> ticket_en_cours);
			$tplNotifTickets .= "
			<div id='content-ticket-en-cours'>
				<h2>Ticket en cours :</h2>
				<div id='infos-ticket-cours' class='ticket-en-cours'>
					<div>
						<span class='indic-ticket'>Titre:</span>
						<span class='lbl-titre-ticket-cours'>$tabInfosTicketEnCours[titre]</span>
					</div>
					<div>
						<span class='indic-ticket'>Commentaire:</span>
						<span>$tabInfosTicketEnCours[commentaire]</span>
					</div>
					<span class='btn-manage-ticket' id='arreter-ticket-cours'>
						".self :: getBtnStopTicket($live -> ticket_en_cours)."
					</span>
					<span class='btn-manage-ticket' id='pause-ticket-cours'>
						".self :: getBtnPauseTicket($live -> ticket_en_cours)."
					</span>
				</div>
			</div>";
		}
		
		
		$userId = Identification :: getId();
		$tabPrioritesAAfficher = Ticket :: getInfosStatutAuto(Ticket :: STATUT_AUTO_TODO, 'tab-lvls');
		$tabTicketsClients = Ticket :: getUserTicketsOrderedByClientId($userId, true, "w_tickets.statut IN ('".implode("', '", $tabPrioritesAAfficher)."')");
		$nbTicketAfficher = 5;
		if(count($tabTicketsClients) > 0) {
			$tplNotifTickets .= "
			<h2>Tickets</h2>";
			foreach($tabTicketsClients as $tabTickets) {
				
				$tplNotifTickets .= "
				<div class='content-tickets-client'>
					<h3>$tabTickets[nom_client]</h3>
					<ul>";
				
				foreach($tabTickets['tickets_client'] as $ticket) {
					$classTicketEnCours = ($live -> ticket_en_cours == $ticket['id']) ? "ticket-en-cours": "";
					$tplNotifTickets .= "
					<li class='$classTicketEnCours'>
						<span class='id-ticket'>
							<span class='indic-ticket'>ID Ticket: </span>
							#$ticket[id]
						</span>
						<span class='titre-ticket'>
							<span class='indic-ticket'>Titre: </span>
							$ticket[titre]
						</span>
						<span class='content-prio-stat'>
							<span class='priorite-ticket'>
								<span class='indic-ticket'>Priorité: </span>
								<span class='lbl-prio-ticket'>
									<span style='background-color: ".Ticket :: getInfosPriorite($ticket['priorite'], 'color').";'>".Ticket :: getTxtPriorite($ticket['priorite'])."</span>
								</span>
							</span>
							<span class='statut-ticket'>".Ticket :: getTxtStatut($ticket['statut'])."</span>
						</span>";
					if($live -> ticket_en_cours != $ticket['id']) {
						$tplNotifTickets .= "
						<span class='btn-manage-ticket demarrer-ticket'>
							".self :: getBtnStartTicket($ticket[id], ($live != false && ($ticket['id_tache'] != $live -> idTache)))."
						</span>";
					}
					$tplNotifTickets .= "
						<div class='clear'></div>
					</li>";
				}
				
				$tplNotifTickets .= "
					</ul>
				</div>";
			}
		}
		$tplNotifTickets .= 
			self :: getScriptStartTicket(isset($live -> ticket_en_cours), '#main-content-notif-tickets .start-ticket')."
		</div>";
		
		return $tplNotifTickets;
	}
	
	public static function getTplUserTickets() {
		$live = Live :: getInstance();
		$userId 				= (isset($_SESSION['last_user_id_ticket'])) ? $_SESSION['last_user_id_ticket'] : Identification :: getId();
		$idClientSelect 		= (isset($_SESSION['idClientFiltreTickets'])) ? $_SESSION['idClientFiltreTickets'] : 'all';
		$idPrioriteSelect 		= (isset($_SESSION['idPrioriteFiltreTickets'])) ? $_SESSION['idPrioriteFiltreTickets'] : 'all';
		$tabIdStatutSelected 	= (isset($_SESSION['tabIdStatuts'])) ? $_SESSION['tabIdStatuts'] : Ticket :: getInfosStatutAuto(Ticket :: STATUT_AUTO_TODO, 'tab-lvls');
		
		$piecesWhere = array();
		if(!is_null($idPrioriteSelect) && $idPrioriteSelect != 'all') $piecesWhere[] = "w_tickets.priorite = $idPrioriteSelect";
		if(!is_null($idClientSelect) && $idClientSelect != 'all') $piecesWhere[] = "w_clients.id = $idClientSelect";
		if(is_array($tabIdStatutSelected) && count($tabIdStatutSelected) > 0) $piecesWhere[] = "w_tickets.statut IN ('".implode("', '", $tabIdStatutSelected)."') ";
		$additionnalWhere = implode(' AND ', $piecesWhere);
		
		$tabUserTickets = Ticket :: getUserTicketsOrderedByClientId($userId, true, $additionnalWhere);
		$finalTpl = '';
		
		foreach($tabUserTickets as $userClientTickets) {
			$finalTpl .= "
				<div id='content-etape-statut-ticket'></div>
				<div class='content-un-client'>
					<h2 style='color: $userClientTickets[couleur_client];'>$userClientTickets[nom_client]</h2>
					<table>
						<tr class='entete-tableau'>
							<th class='entete-id'>ID</th>
							<th class='entete-titre'>Titre</th>
							<th class='entete-lot-tache'>Lot / Tâche</th>
							<th class='entete-assigne'>Assigné à</th>
							<th class='entete-priorite'>Priorité</th>
							<th class='entete-statut'>Statut</th>
							<th class='entete-actions'>Actions</th>
						</tr>";
			
			$indiceTicket = 0;
			if(count($userClientTickets['tickets_client']) > 0) {
				foreach($userClientTickets['tickets_client'] as &$userTickets) {
					$classLigneTab = ($indiceTicket % 2) ? 'dusky' : '';
					$classTicketEnLive = (isset($live -> ticket_en_cours) && $live -> ticket_en_cours == $userTickets['id']) ? "onAir" : "";
					$classLotFacture = $userTickets['lot_comptabilise']?"lot-comptabilise":"";
					
					
					
					$finalTpl .= "
						<tr class='content-un-ticket $classLigneTab $classTicketEnLive $classLotFacture'>
							<td class='id-ticket'>".self :: getBtnInfosTicket($userTickets['id'], "#$userTickets[id]")."</td>
							<td class='titre-ticket'>".self :: getBtnInfosTicket($userTickets['id'], $userTickets['titre'])."</td>
							<td class='lot-tache-ticket'>$userTickets[nom_lot] / $userTickets[nom_tache]</td>
							<td class='user-assigne-ticket' style='color: $userTickets[couleur_user_attribue];'>$userTickets[nom_user_attribue]</td>
							<td class='priorite-ticket'><span style='background-color: ".Ticket :: getInfosPriorite($userTickets['priorite'], 'color').";'>".Ticket :: getTxtPriorite($userTickets['priorite'])."</span></td>
							<td class='statut-ticket'>
								<form method='post'>
									<select id='select-statut-$userTickets[id]'>
									".TicketModel::getOptionsAndSelected(Ticket :: $tabStatuts, 'lvl-statut', 'txt-statut', $userTickets['statut'])."
									</select>
								</form>
								<script>
								$('#select-statut-$userTickets[id]').change(function(){
									if(confirm('Êtes vous sûr de vouloir passer ce ticket à \"'+$('option:selected', $(this)).text()+'\" ?')) {
										$.ajax({
											type : 'POST',
											url : 'ajax.php',
											dataType : 'html',
											data : {
												action: 'ajaxUpdateStatutTicket',
												idTicket: $userTickets[id],
												idTache: $userTickets[id_tache],
												idStatut: $('#select-statut-$userTickets[id]').val()
											}
										}).done(function(html) {
											$('#content-user-tickets').empty().append(html);
										}).fail(function(jqXHR, textStatus) {
											alert('<h1>Erreur Ajax : '+textStatus+'<h1>');
										});
									} else {
										$('#select-statut-$userTickets[id]').val('$userTickets[statut]');
									}
								});
								</script>
							</td>
							<td>";
							if($userTickets["lot_comptabilise"]) {
								$finalTpl .= "<a href='?page=modifierTicket&num=$userTickets[id]'>modifier</a>";
							} else {
								if(isset($live -> ticket_en_cours) && $live -> ticket_en_cours == $userTickets['id']) {
									$finalTpl .= "
									<div id='main-content-manage-ticket'>
										<span class='btn-manage-ticket btn-stop-ticket'>
											".self :: getBtnStopTicket($userTickets['id'], false)."
										</span>
										<span class='btn-manage-ticket btn-pause-ticket'>
											".self :: getBtnPauseTicket($userTickets['id'], false)."
										</span>
										<div class='clear'></div>
									</div>";
								} else {
									$finalTpl .= "
									<div class='main-content-start-ticket'>
										<span class='btn-manage-ticket btn-start-ticket'>
											".self :: getBtnStartTicket($userTickets['id'], ($live != false && ($userTickets['id_tache'] != $live -> idTache)))."
										</span>
										<div class='clear'></div>
									</div>";
								}
							}
							$finalTpl .= "
							</td>
						</tr>";
					$indiceTicket++;
				}
			}
			$finalTpl .= "
					</table>
				</div>";
		}
		
		$finalTpl .= self :: getScriptStartTicket(isset($live -> ticket_en_cours), '.start-ticket', false);
		
		return $finalTpl;
	}
	
	public static function getBtnStartTicket($idTicket, $changementDeTache) {
		return "
		<a href='#' class='start-ticket' 
			data-ticket-id='$idTicket' 
				data-changing-task='".($changementDeTache)."'>
			Démarrer Ticket
		</a>";
	}
	
	public static function getBtnModifyTicket($idTicket) {
		return "
		<a href='?page=modifierTicket&num=$idTicket'>Modifier Ticket</a>";
	}
	
	public static function getBtnInfosTicket($idTicket, $txtBtn = 'Informations Ticket') {
		return "<a href='?page=ticket&num=$idTicket'>$txtBtn</a>";
	}
	
	public static function getBtnPauseTicket($idTicket, $tplNotif = true) {
		return "
		<a href='#' id='pause-ticket'>Pause ticket en cours</a>
		<script>
		$('#pause-ticket').click(function() {
			var tplNotif = ".(($tplNotif == false) ? 'false' : 'true').";
			
			$.ajax({
				type : 'POST',
				url : 'ajax.php',
				dataType : 'html',
				data : {
					action: 'ajaxPauseTicket',
					typeTplEstNotif: tplNotif,
					idTicket: $idTicket
				}
			}).done(function(html) {
				if(tplNotif) var mainNoeudContent = '#main-content-notif-tickets';
				else var mainNoeudContent = '#content-user-tickets';
				
				$(mainNoeudContent).empty().append(html);
				
			}).fail(function(jqXHR, textStatus) {
				alert('<h1>Erreur Ajax : '+textStatus+'<h1>');
			});
			
			return false;
		});
		</script>";
	}
	
	public static function getBtnStopTicket($idTicket, $tplNotif = true) {
		return "
		<a href='#' id='stop-ticket'>Fermer ticket en cours</a>
		<script>
		$('#stop-ticket').click(function() {
			var tplNotif = ".(($tplNotif == false) ? 'false' : 'true').";
			
			$.ajax({
				type : 'POST',
				url : 'ajax.php',
				dataType : 'html',
				data : {
					action: 'ajaxStopTicket',
					typeTplEstNotif: tplNotif,
					idTicket: $idTicket
				}
			}).done(function(html) {
				if(tplNotif) var mainNoeudContent = '#main-content-notif-tickets';
				else var mainNoeudContent = '#content-user-tickets';
				
				$(mainNoeudContent).empty().append(html);
				
			}).fail(function(jqXHR, textStatus) {
				alert('<h1>Erreur Ajax : '+textStatus+'<h1>');
			});
			
			return false;
		});
		</script>";
	}
	
	public static function getScriptStartTicket($isTicketEnCours, $jQNodeBtnStart, $tplNotif = true) {
		return "
		<script>
			$('$jQNodeBtnStart').bind('click', function() {
				var confirmNewStart = $(this).attr('data-changing-task');
				var retourConfirm = true;
				var stopTravailEnCours = false;
				var tplNotif = ".(($tplNotif == false) ? 'false' : 'true').";
				
				if(confirmNewStart == true) {
					retourConfirm = confirm('Ce ticket est dans une autre tâche, ".(($isTicketEnCours) ? 'et le ticket en cours sera lié à cette tâche,' : '')." êtes-vous sûr ?');
					stopTravailEnCours = retourConfirm;
				} else {
					retourConfirm = confirm('Voulez-vous vraiment commencer ce ticket ?');
				}
				
				if(retourConfirm) {
					$.ajax({
						type : 'POST',
						url : 'ajax.php',
						dataType : 'html',
						data : {
							action: 'ajaxStartTicket',
							idTicket: $(this).attr('data-ticket-id'),
							typeTplEstNotif: tplNotif,
							demarrerNouveauTravail: stopTravailEnCours
						}
					}).done(function(html) {
						// console.info(html);
						if(tplNotif) var mainNoeudContent = '#main-content-notif-tickets';
						else var mainNoeudContent = '#content-user-tickets';
						
						$(mainNoeudContent).empty().append(html);
						
						if(!tplNotif) {
							$.ajax({
								type : 'POST',
								url : 'ajax.php',
								dataType : 'html',
								data : {
									action: 'updateBtnLive'
								}
							}).done(function(html) {
								$('#main-btn-live-content').empty().append(html);
							}).fail(function(jqXHR, textStatus) {
								alert('<h1>Erreur Ajax : '+textStatus+'<h1>');
							});
						}
						
					}).fail(function(jqXHR, textStatus) {
						alert('<h1>Erreur Ajax : '+textStatus+'<h1>');
					});
				}
				return false;
			});
		</script>";
	}
}